/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.jta.RemoteClientUserTransactionFactory;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public final class RemoteClientUserTransaction
implements UserTransaction,
Externalizable,
Referenceable {
    private static final Logger LOGGER = LoggerFactory.createLogger(RemoteClientUserTransaction.class);
    static final int DEFAULT_TIMEOUT = 30;
    private transient UserTransactionServer txmgrServer;
    private transient TransactionManager txmgr;
    private transient Hashtable<Thread, String> threadToTidMap;
    private int timeout;
    private String userTransactionServerLookupName;
    private String initialContextFactory;
    private String providerUrl;
    private boolean imported;

    public RemoteClientUserTransaction() {
        this.threadToTidMap = new Hashtable();
        this.timeout = 30;
        this.imported = false;
    }

    public RemoteClientUserTransaction(String userTransactionServerLookupName, ConfigProperties configProperties) {
        this(userTransactionServerLookupName, configProperties.getProperty("java.naming.factory.initial"), configProperties.getProperty("java.naming.provider.url"));
    }

    public RemoteClientUserTransaction(String name, String initialContextFactory, String providerUrl) {
        this.initialContextFactory = initialContextFactory;
        this.providerUrl = providerUrl;
        this.userTransactionServerLookupName = name;
        this.threadToTidMap = new Hashtable();
        this.timeout = 30;
        this.imported = false;
    }

    private String getNotFoundMessage() {
        String errorMsg = "Name not found: " + this.userTransactionServerLookupName + "\nPlease check that: \n\t-server property com.atomikos.icatch.client_demarcation is set to true \n   -server property com.atomikos.icatch.rmi_export_class is correct \n\t-server property java.naming.factory.initial is " + this.initialContextFactory + "\n\t-server property java.naming.provider.url is " + this.providerUrl + "\n\t-the naming service is running on port " + this.providerUrl + "\n\t-the transaction server is running";
        return errorMsg;
    }

    private boolean checkSetup() {
        this.txmgr = TransactionManagerImp.getTransactionManager();
        if (this.txmgr == null) {
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.initialContextFactory);
                env.put("java.naming.provider.url", this.providerUrl);
                InitialContext ctx = new InitialContext(env);
                this.txmgrServer = (UserTransactionServer)PortableRemoteObject.narrow((Object)ctx.lookup(this.userTransactionServerLookupName), UserTransactionServer.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(this.getNotFoundMessage());
            }
            if (this.txmgrServer == null) {
                throw new RuntimeException(this.getNotFoundMessage());
            }
        }
        return this.txmgr != null;
    }

    private synchronized void setThreadMapping(String tid) {
        Thread thread = Thread.currentThread();
        this.threadToTidMap.put(thread, tid);
    }

    private synchronized String removeThreadMapping() {
        Thread thread = Thread.currentThread();
        return this.threadToTidMap.remove(thread);
    }

    private synchronized String getThreadMapping() {
        Thread thread = Thread.currentThread();
        return this.threadToTidMap.get(thread);
    }

    public void begin() throws NotSupportedException, SystemException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr.begin();
        } else {
            String tid = this.getThreadMapping();
            if (tid != null) {
                throw new NotSupportedException("Nested transaction not allowed here");
            }
            try {
                tid = this.txmgrServer.begin(this.timeout);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
            this.setThreadMapping(tid);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr.commit();
        } else {
            if (this.imported) {
                throw new SecurityException("Commit not allowed: not creator");
            }
            String tid = this.removeThreadMapping();
            if (tid == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer.commit(tid);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
        }
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr.rollback();
        } else {
            if (this.imported) {
                throw new SecurityException("Rollback not allowed: not creator");
            }
            String tid = this.removeThreadMapping();
            if (tid == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer.rollback(tid);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr.setRollbackOnly();
        } else {
            String tid = this.getThreadMapping();
            if (tid == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer.setRollbackOnly(tid);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
        }
    }

    public int getStatus() throws SystemException {
        int ret = 6;
        boolean local = this.checkSetup();
        if (local) {
            ret = this.txmgr.getStatus();
        } else {
            String tid = this.getThreadMapping();
            if (tid != null) {
                try {
                    ret = this.txmgrServer.getStatus(tid);
                }
                catch (RemoteException re) {
                    throw new SystemException(re.getMessage());
                }
            }
        }
        return ret;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.timeout = seconds;
    }

    public String toString() {
        String ret = null;
        boolean local = this.checkSetup();
        if (local) {
            Transaction tx = null;
            try {
                tx = this.txmgr.getTransaction();
            }
            catch (SystemException e) {
                String msg = "Error getting transaction";
                LOGGER.logWarning(msg, (Throwable)e);
            }
            if (tx != null) {
                ret = tx.toString();
            }
        }
        if (ret == null) {
            ret = this.getThreadMapping();
        }
        return ret;
    }

    @Override
    public Reference getReference() throws NamingException {
        StringRefAddr nameRef = new StringRefAddr("ServerName", this.userTransactionServerLookupName);
        StringRefAddr urlRef = new StringRefAddr("ProviderUrl", this.providerUrl);
        StringRefAddr factRef = new StringRefAddr("ContextFactory", this.initialContextFactory);
        StringRefAddr timeoutRef = new StringRefAddr("Timeout", new Integer(this.timeout).toString());
        Reference ref = new Reference(this.getClass().getName(), new StringRefAddr("name", "RemoteClientUserTransaction"), RemoteClientUserTransactionFactory.class.getName(), null);
        ref.add(nameRef);
        ref.add(urlRef);
        ref.add(factRef);
        ref.add(timeoutRef);
        return ref;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String tid = this.getThreadMapping();
        out.writeObject(tid);
        out.writeObject(this.userTransactionServerLookupName);
        out.writeObject(this.initialContextFactory);
        out.writeObject(this.providerUrl);
        out.writeInt(this.timeout);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String tid = (String)in.readObject();
        if (tid != null) {
            this.setThreadMapping(tid);
            this.imported = true;
        }
        this.userTransactionServerLookupName = (String)in.readObject();
        this.initialContextFactory = (String)in.readObject();
        this.providerUrl = (String)in.readObject();
        this.timeout = in.readInt();
    }
}

