/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.metaphor.scoremodel;

import com.blazesoft.metaphor.scoremodel.NdReasonCalculator;
import com.blazesoft.metaphor.scoremodel.NdReasonCode;
import com.blazesoft.metaphor.scoremodel.NdReasonSource;
import com.blazesoft.metaphor.scoremodel.NdReasonSourceItem;
import com.blazesoft.metaphor.scoremodel.NdScoreModelReasonCalculationOptions;
import com.blazesoft.metaphor.scoremodel.NdScoredCharacteristic;
import com.blazesoft.metaphor.scoremodel.NdStrings;
import com.blazesoft.objects.base.NdVisibleSupportJavaClass;
import com.blazesoft.util.NdUnavailableValueException;
import com.blazesoft.util.NdWrappedValueException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NdScoreModelReturnInfo
implements NdReasonSource,
NdVisibleSupportJavaClass,
Serializable,
PropertyChangeListener {
    public static final String MAPPED_CLASS_NAME = "NdScoreModelReturnInfo";
    private NdScoredCharacteristic[] WjHBgcE = null;
    private String WjHBgcF = "";
    private double WjHBgcG;
    private double WjHBgcH = this.WjHBgcG = 0.0;
    private int WjHBgcI = 0;
    private int WjHCztS = 0;
    private boolean WjHCztT = false;
    private NdReasonCalculator WjHBgcJ;
    private NdScoreModelReasonCalculationOptions WjHBgcM = new NdScoreModelReasonCalculationOptions();
    private NdReasonCode[] WjHBSQE = null;
    private NdReasonCode[] WjHBSQF = null;
    static final long serialVersionUID = -481091668016731316L;
    private transient PropertyChangeSupport WjHCmbA;

    public NdScoreModelReturnInfo() {
        this.WjHDLJW();
        this.addPropertyChangeListener(this);
        this.WjHBgcJ = null;
    }

    protected void finalize() throws Throwable {
        this.removePropertyChangeListener(this);
        this.WjHCmbA = null;
        super.finalize();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.WjHCmbA.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.WjHCmbA.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        try {
            if (string.equals("scoredCharacteristics") || string.equals("options") || string.equals("characteristicCount")) {
                this.WjHBgcP();
                this.getScore();
                this.getUnexpectedCount();
                this.getTopReasons();
            } else if (string.equals("initialScore")) {
                this.getScore();
                this.getUnexpectedCount();
            } else if (string.equals("topReasons")) {
                this.getTopReasons();
            }
        }
        catch (NdUnavailableValueException ndUnavailableValueException) {
            // empty catch block
        }
    }

    public NdReasonSourceItem[] getReasonSourceItems() {
        return this.getScoredCharacteristics();
    }

    public NdScoreModelReasonCalculationOptions getOptions() {
        return this.WjHBgcM;
    }

    public synchronized void setOptions(NdScoreModelReasonCalculationOptions ndScoreModelReasonCalculationOptions) {
        NdScoreModelReasonCalculationOptions ndScoreModelReasonCalculationOptions2 = this.WjHBgcM;
        this.WjHBgcM = ndScoreModelReasonCalculationOptions;
        if (ndScoreModelReasonCalculationOptions2 != ndScoreModelReasonCalculationOptions) {
            this.WjHCmbA.firePropertyChange("options", ndScoreModelReasonCalculationOptions2, ndScoreModelReasonCalculationOptions);
        }
    }

    public NdScoredCharacteristic[] getScoredCharacteristics() {
        return this.WjHBgcE;
    }

    public synchronized void setScoredCharacteristics(NdScoredCharacteristic[] ndScoredCharacteristicArray) {
        NdScoredCharacteristic[] ndScoredCharacteristicArray2 = this.WjHBgcE;
        this.WjHBgcE = ndScoredCharacteristicArray;
        if (ndScoredCharacteristicArray2 != ndScoredCharacteristicArray) {
            this.WjHCmbA.firePropertyChange("scoredCharacteristics", ndScoredCharacteristicArray2, ndScoredCharacteristicArray);
        }
    }

    public int getCharacteristicCount() {
        if (this.WjHBgcE != null && this.WjHBgcE.length < this.WjHCztS) {
            throw new IllegalArgumentException(NdStrings.WjHBfrI("ErrorCharacteristicCountTooBig", new Integer(this.WjHCztS), new Integer(this.WjHBgcE.length)));
        }
        if (!(this.WjHCztS != 0 || this.WjHCztT && this.getScoreModelName() != null && this.getScoreModelName().length() != 0)) {
            int n = this.WjHBgcE == null ? 0 : this.WjHBgcE.length;
            this.setCharacteristicCount(n);
            return n;
        }
        return this.WjHCztS;
    }

    public void setCharacteristicCount(int n) {
        this.WjHCztT = true;
        if (n < 0) {
            throw new IllegalArgumentException(NdStrings.WjHBfrF("ErrorCharacteristicCountLessThanOne"));
        }
        int n2 = this.WjHCztS;
        this.WjHCztS = n;
        if (this.WjHBgcE != null && this.WjHBgcE.length > n && n < n2) {
            this.WjHBgcE[n].WjHCzvZ();
        }
        this.WjHBgcP();
        if (n2 != this.WjHCztS) {
            this.WjHCmbA.firePropertyChange("characteristicCount", new Integer(n2), new Integer(n));
        }
    }

    public int getUnexpectedCount() throws NdUnavailableValueException {
        this.WjHBSQI(this.WjHBgcE);
        return this.WjHBgcI;
    }

    public double getScore() throws NdUnavailableValueException {
        this.WjHBSQI(this.WjHBgcE);
        return this.WjHBgcH;
    }

    public NdReasonCode[] getTopReasons() throws NdUnavailableValueException {
        if (this.WjHBSQE == null) {
            this.WjHBSQE = this.WjHBSQG(this.WjHBgcE, this.WjHBgcM, this.WjHBSQF);
        }
        return this.WjHBSQE;
    }

    public synchronized void setTopReasons(NdReasonCode[] ndReasonCodeArray) {
        NdReasonCode[] ndReasonCodeArray2 = this.WjHBSQF;
        this.WjHBSQF = ndReasonCodeArray;
        if (ndReasonCodeArray2 != ndReasonCodeArray) {
            this.WjHCmbA.firePropertyChange("topReasons", ndReasonCodeArray2, ndReasonCodeArray);
        }
    }

    public String getScoreModelName() {
        return this.WjHBgcF;
    }

    public void setScoreModelName(String string) {
        this.WjHBgcF = string;
    }

    public double getInitialScore() {
        return this.WjHBgcG;
    }

    public synchronized void setInitialScore(double d) {
        double d2 = this.WjHBgcG;
        this.WjHBgcG = d;
        if (d2 != d) {
            this.WjHCmbA.firePropertyChange("initialScore", new Double(d2), new Double(d));
        }
    }

    public NdReasonCode[] calculateReasons() throws NdUnavailableValueException {
        return this.calculateReasons(this.getScoredCharacteristics(), this.getOptions());
    }

    public NdReasonCode[] calculateReasons(NdScoreModelReasonCalculationOptions ndScoreModelReasonCalculationOptions) throws NdUnavailableValueException {
        this.setOptions(ndScoreModelReasonCalculationOptions);
        return this.calculateReasons(this.getScoredCharacteristics(), ndScoreModelReasonCalculationOptions);
    }

    public synchronized NdReasonCode[] calculateReasons(NdScoredCharacteristic[] ndScoredCharacteristicArray, NdScoreModelReasonCalculationOptions ndScoreModelReasonCalculationOptions) throws NdUnavailableValueException {
        NdReasonCode[] ndReasonCodeArray = this.WjHBSQE;
        this.setScoredCharacteristics(ndScoredCharacteristicArray);
        this.WjHBSQE = this.WjHBSQG(ndScoredCharacteristicArray, ndScoreModelReasonCalculationOptions, this.WjHBSQF);
        if (ndReasonCodeArray != this.WjHBSQE) {
            this.WjHCmbA.firePropertyChange("topReasons", ndReasonCodeArray, this.WjHBSQE);
        }
        this.WjHBSQI(ndScoredCharacteristicArray);
        return this.WjHBSQE;
    }

    private NdReasonCode[] WjHBSQG(NdScoredCharacteristic[] ndScoredCharacteristicArray, NdScoreModelReasonCalculationOptions ndScoreModelReasonCalculationOptions, NdReasonCode[] ndReasonCodeArray) {
        if (ndScoredCharacteristicArray == null || ndScoreModelReasonCalculationOptions == null || ndScoredCharacteristicArray.length == 0) {
            return null;
        }
        if (this.WjHBgcJ == null) {
            this.WjHBgcJ = new NdReasonCalculator();
            this.WjHBgcJ.initReasonSource(this);
        }
        this.WjHCmcB(ndScoredCharacteristicArray, ndScoreModelReasonCalculationOptions);
        return this.WjHBgcJ.calculateReasons(ndScoreModelReasonCalculationOptions, ndReasonCodeArray);
    }

    public void addReason(NdReasonCode ndReasonCode, double d) {
        NdScoredCharacteristic[] ndScoredCharacteristicArray = new NdScoredCharacteristic[this.WjHBgcE.length + 1];
        System.arraycopy(this.WjHBgcE, 0, ndScoredCharacteristicArray, 0, this.WjHBgcE.length);
        NdScoredCharacteristic ndScoredCharacteristic = new NdScoredCharacteristic();
        ndScoredCharacteristic.setReasonCode(ndReasonCode);
        ndScoredCharacteristic.setWeight(d);
        ndScoredCharacteristic.setWeightToBeCalculated(false);
        ndScoredCharacteristicArray[this.WjHBgcE.length] = ndScoredCharacteristic;
        this.WjHBgcE = ndScoredCharacteristicArray;
        if (this.WjHBgcJ != null) {
            this.WjHBgcJ.initReasonSource(this);
        }
    }

    private void WjHBSQI(NdScoredCharacteristic[] ndScoredCharacteristicArray) {
        if (ndScoredCharacteristicArray == null || ndScoredCharacteristicArray.length == 0) {
            return;
        }
        double d = this.WjHBgcH;
        int n = this.WjHBgcI;
        this.WjHBgcH = this.WjHBgcG;
        this.WjHBgcI = 0;
        for (int i = 0; i < this.getCharacteristicCount(); ++i) {
            this.WjHBgcH += ndScoredCharacteristicArray[i].getPartialScore();
            if (!ndScoredCharacteristicArray[i].isUnexpected()) continue;
            ++this.WjHBgcI;
        }
        if (d != this.WjHBgcH) {
            this.WjHCmbA.firePropertyChange("score", new Double(d), new Double(this.WjHBgcH));
        }
        if (n != this.WjHBgcI) {
            this.WjHCmbA.firePropertyChange("unexpectedCount", new Integer(n), new Integer(this.WjHBgcI));
        }
    }

    private void WjHCmcB(NdScoredCharacteristic[] ndScoredCharacteristicArray, NdScoreModelReasonCalculationOptions ndScoreModelReasonCalculationOptions) {
        int n = ndScoreModelReasonCalculationOptions.getDistanceComputationMethod();
        if (ndScoreModelReasonCalculationOptions.isAllowExpressions() && n == 2) {
            String string = NdStrings.WjHBfrH("ErrorMaxNotAllowedWithExpressions", new Integer(2));
            throw new NdWrappedValueException(new NdUnavailableValueException(string));
        }
        block5: for (int i = 0; i < this.WjHCztU(); ++i) {
            switch (n) {
                case 0: {
                    if (!ndScoredCharacteristicArray[i].isWeightToBeCalculated()) continue block5;
                    ndScoredCharacteristicArray[i].setWeight(ndScoredCharacteristicArray[i].getReason().getRank());
                    continue block5;
                }
                case 2: {
                    if (!ndScoredCharacteristicArray[i].isWeightToBeCalculated()) continue block5;
                    ndScoredCharacteristicArray[i].setWeight(ndScoredCharacteristicArray[i].getMaxBinScore() - ndScoredCharacteristicArray[i].getPartialScore());
                    continue block5;
                }
                case 1: {
                    if (!ndScoredCharacteristicArray[i].isWeightToBeCalculated()) continue block5;
                    ndScoredCharacteristicArray[i].setWeight(ndScoredCharacteristicArray[i].getBaselineScore() - ndScoredCharacteristicArray[i].getPartialScore());
                    continue block5;
                }
                default: {
                    String string = NdStrings.WjHBfrH("ErrorUnsupportedDistanceComputationMethod", new Integer(n));
                    throw new IllegalArgumentException(string);
                }
            }
        }
    }

    private void WjHBgcP() {
        this.WjHBgcJ = null;
        this.WjHBSQE = null;
    }

    private int WjHCztU() {
        if (this.WjHBgcJ == null) {
            return 0;
        }
        return this.WjHBgcJ.getReasonSourceItemCount();
    }

    private void WjHDLJW() {
        this.WjHCmbA = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.WjHDLJW();
        this.addPropertyChangeListener(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removePropertyChangeListener(this);
        objectOutputStream.defaultWriteObject();
    }
}

