/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.objects.java;

import com.blazesoft.objects.base.NdContextConstant;
import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.objects.java.NdCalendarValue;
import com.blazesoft.objects.java.NdStrings;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdComparable;
import com.blazesoft.util.NdObjectReader;
import com.blazesoft.util.NdObjectWriter;
import com.blazesoft.util.NdSerializable;
import com.blazesoft.util.NdSerializationException;
import com.blazesoft.util.NdSupportJavaClass;
import com.blazesoft.util.NdWrappedParseException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.Hashtable;

public final class NdDuration
extends NdCalendarValue
implements NdSupportJavaClass,
NdSerializable,
NdContextConstant,
Cloneable {
    private int WjHzrRL;
    private int WjHzrRM;
    private long WjHzrRN;
    private int WjHzrRO;
    static final long serialVersionUID = -8067801415968180323L;
    private static Hashtable WjHAfoO = new Hashtable();

    public NdDuration(NdObjectReader ndObjectReader) {
        super(ndObjectReader);
    }

    public void readObject(NdObjectReader ndObjectReader) throws IOException, NdSerializationException {
        super.readObject(ndObjectReader);
        this.WjHzrRO = ndObjectReader.getIntVal();
        this.WjHzrRN = ndObjectReader.getLongVal();
        this.WjHzrRM = ndObjectReader.getIntVal();
        this.WjHzrRL = ndObjectReader.getIntVal();
        ndObjectReader.getEnd();
    }

    public void writeObject(NdObjectWriter ndObjectWriter) throws IOException, NdSerializationException {
        super.writeObject(ndObjectWriter);
        ndObjectWriter.putIntVal(this.WjHzrRO);
        ndObjectWriter.putLongVal(this.WjHzrRN);
        ndObjectWriter.putIntVal(this.WjHzrRM);
        ndObjectWriter.putIntVal(this.WjHzrRL);
        ndObjectWriter.putEnd();
    }

    public NdDuration(NdCalendar ndCalendar, int n, int n2, long l, int n3) {
        super(ndCalendar);
        this.WjHzrRL = n;
        this.WjHzrRM = n2;
        this.WjHzrRN = l;
        this.WjHzrRO = n3;
        this.WjHzrRP();
    }

    public NdDuration(NdCalendar ndCalendar, int n, long l) {
        super(ndCalendar);
        switch (n) {
            case 1: {
                this.WjHzrRL = (int)l * 12;
                break;
            }
            case 2: {
                this.WjHzrRL = (int)l;
                break;
            }
            case 3: {
                this.WjHzrRM = (int)l * 7;
                break;
            }
            case 5: {
                this.WjHzrRM = (int)l;
                break;
            }
            case 10: {
                this.WjHzrRN = l * 3600000L;
                break;
            }
            case 12: {
                this.WjHzrRN = l * 60000L;
                break;
            }
            case 13: {
                this.WjHzrRN = l * 1000L;
                break;
            }
            case 14: {
                this.WjHzrRN = l;
                break;
            }
            case 15: {
                this.WjHzrRN = l / 1000L;
                this.WjHzrRO = (int)(l % 1000L * 1000L);
                break;
            }
            case 16: {
                this.WjHzrRN = l / 1000000L;
                this.WjHzrRO = (int)(l % 1000000L);
                break;
            }
            default: {
                throw NdBaseObject.internalError("bad unit");
            }
        }
    }

    private void WjHzrRP() {
        while (this.WjHzrRO < 0) {
            this.WjHzrRO += 1000000;
            --this.WjHzrRN;
        }
        while (this.WjHzrRO >= 1000000) {
            this.WjHzrRO -= 1000000;
            ++this.WjHzrRN;
        }
    }

    public int getMonths() {
        return this.WjHzrRL;
    }

    public int getDays() {
        return this.WjHzrRM;
    }

    public long getMilliseconds() {
        return this.WjHzrRN;
    }

    public int getExtraNanoseconds() {
        return this.WjHzrRO;
    }

    private String WjHzrRQ(int n, long l) {
        return "" + l + " " + this.getCalendar().getUnitName(n, l != 1L);
    }

    public String toString() {
        return this.WjHAdOF(" ", false);
    }

    public String toString(String string) {
        return this.WjHAdOF(string, false);
    }

    public String toSRL() {
        return this.WjHAdOF(" plus ", true);
    }

    private String WjHAdOF(String string, boolean bl) {
        String string2;
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.WjHzrRL != 0) {
            if (Math.abs(this.WjHzrRL) >= 12) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(1, this.WjHzrRL / 12));
                ++n;
            }
            if (this.WjHzrRL % 12 != 0) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(2, this.WjHzrRL % 12));
                ++n;
            }
        }
        if (this.WjHzrRM != 0) {
            stringBuffer.append(string);
            stringBuffer.append(this.WjHzrRQ(5, this.WjHzrRM));
            ++n;
        }
        if (this.WjHzrRN != 0L) {
            if (Math.abs(this.WjHzrRN) >= 3600000L) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(10, this.WjHzrRN / 3600000L));
                ++n;
            }
            if (Math.abs(this.WjHzrRN % 3600000L) >= 60000L) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(12, this.WjHzrRN % 3600000L / 60000L));
                ++n;
            }
            if (Math.abs(this.WjHzrRN % 60000L) >= 1000L) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(13, this.WjHzrRN % 60000L / 1000L));
                ++n;
            }
        }
        if ((l = this.WjHzrRN % 1000L * 1000000L + (long)this.WjHzrRO) != 0L) {
            if (Math.abs(l) >= 1000000L) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(14, l / 1000000L));
            }
            if (Math.abs(l % 1000000L) >= 1000L) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(15, l % 1000000L / 1000L));
                ++n;
            }
            if (l % 1000L != 0L) {
                stringBuffer.append(string);
                stringBuffer.append(this.WjHzrRQ(16, l % 1000L));
                ++n;
            }
        }
        String string3 = string2 = (string2 = stringBuffer.toString()).length() == 0 ? this.WjHzrRQ(13, 0L) : string2.substring(string.length());
        if (bl && n > 1) {
            string2 = "(" + string2 + ")";
        }
        return string2;
    }

    public NdDuration add(NdDuration ndDuration) {
        return new NdDuration(this.getCalendar(), this.WjHzrRL + ndDuration.WjHzrRL, this.WjHzrRM + ndDuration.WjHzrRM, this.WjHzrRN + ndDuration.WjHzrRN, this.WjHzrRO + ndDuration.WjHzrRO);
    }

    public NdDuration subtract(NdDuration ndDuration) {
        return new NdDuration(this.getCalendar(), this.WjHzrRL - ndDuration.WjHzrRL, this.WjHzrRM - ndDuration.WjHzrRM, this.WjHzrRN - ndDuration.WjHzrRN, this.WjHzrRO - ndDuration.WjHzrRO);
    }

    public NdDuration multiply(long l) {
        int n = (int)l;
        return new NdDuration(this.getCalendar(), n * this.WjHzrRL, n * this.WjHzrRM, l * this.WjHzrRN, n * this.WjHzrRO);
    }

    public NdDuration divide(long l) {
        int n = (int)l;
        int n2 = this.WjHzrRM + this.WjHzrRL % n * this.getCalendar().WjHzDhM();
        long l2 = this.WjHzrRN + (long)(this.WjHzrRM % n) * 86400000L;
        return new NdDuration(this.getCalendar(), this.WjHzrRL / n, (this.WjHzrRM + this.WjHzrRL % n * this.getCalendar().WjHzDhM()) / n, (this.WjHzrRN + (long)(n2 % n) * 86400000L) / (long)n, (int)((long)this.WjHzrRO + l2 % (long)n * 1000000L) / n);
    }

    public NdDuration invert() {
        return new NdDuration(this.getCalendar(), -this.WjHzrRL, -this.WjHzrRM, -this.WjHzrRN, -this.WjHzrRO);
    }

    public int compareTo(NdComparable ndComparable) {
        NdDuration ndDuration = (NdDuration)ndComparable;
        return this.compare(ndDuration, this.getCalendar().WjHzDgL(), this.getCalendar().WjHzDgL());
    }

    public int getConvertedDays() {
        NdCalendar ndCalendar = this.getCalendar();
        return this.WjHzrRL / 12 * ndCalendar.WjHzDgL() + this.WjHzrRL % 12 * ndCalendar.WjHzDhM() + this.WjHzrRM;
    }

    private long WjHzrRS() {
        return (long)this.getConvertedDays() * 86400000L + this.WjHzrRN;
    }

    public int compare(NdDuration ndDuration, int n, int n2) {
        long l;
        long l2 = this.WjHzrRS();
        if (l2 < (l = ndDuration.WjHzrRS())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return this.WjHzrRO - ndDuration.WjHzrRO;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NdDuration)) {
            return false;
        }
        NdDuration ndDuration = (NdDuration)object;
        return this.WjHzrRL == ndDuration.WjHzrRL && this.WjHzrRM == ndDuration.WjHzrRM && this.WjHzrRN == ndDuration.WjHzrRN && this.WjHzrRO == ndDuration.WjHzrRO;
    }

    public int hashCode() {
        return this.WjHzrRL ^ this.WjHzrRM ^ (int)this.WjHzrRN ^ this.WjHzrRO;
    }

    public static NdDuration getDurationFromISOString(NdCalendar ndCalendar, String string) throws ParseException {
        int n;
        int n2 = string.length();
        if (n2 < 3) {
            throw new ParseException(NdStrings.WjHzsiV("Length3"), 0);
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            n3 = 1;
        }
        if (string.charAt(n3) != 'P') {
            throw new ParseException(NdStrings.WjHzsiV("FirstOrSecondCharShouldBeP"), n3);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        double d = 0.0;
        char c = 'P';
        ++n3;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n2) {
            char c2;
            if ((c2 = string.charAt(n3++)) >= '0' && c2 <= '9' || c2 == '.' && (c == 'T' || c == 'Q')) {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 != 'T' && stringBuffer.length() == 0) {
                throw new ParseException(NdStrings.WjHzsiV("NumberOfCharsForNumericCharShouldBe"), n3);
            }
            char[] cArray = (char[])WjHAfoO.get(new String(new char[]{c}));
            if (cArray == null) {
                throw new ParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3);
            }
            int n7 = -1;
            for (int i = 0; i < cArray.length; ++i) {
                if (c2 != cArray[i]) continue;
                n7 = i;
                break;
            }
            if (n7 == -1) {
                throw new ParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3);
            }
            if (c2 == 'Y') {
                try {
                    n4 = Integer.parseInt(stringBuffer.toString());
                    c = c2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NdWrappedParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3, numberFormatException);
                }
            } else if ((c == 'P' || c == 'Y') && c2 == 'M') {
                try {
                    n5 = Integer.parseInt(stringBuffer.toString());
                    c = c2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NdWrappedParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3, numberFormatException);
                }
            } else if (c2 == 'D') {
                try {
                    n6 = Integer.parseInt(stringBuffer.toString());
                    c = c2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NdWrappedParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3, numberFormatException);
                }
            } else if (c2 == 'H') {
                try {
                    l = Long.parseLong(stringBuffer.toString());
                    c = c2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NdWrappedParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3, numberFormatException);
                }
            } else if ((c == 'T' || c == 'H') && c2 == 'M') {
                try {
                    l2 = Long.parseLong(stringBuffer.toString());
                    c = 'Q';
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NdWrappedParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3, numberFormatException);
                }
            } else if (c2 == 'S') {
                try {
                    String string2 = stringBuffer.toString();
                    n = string2.indexOf(46);
                    if (n < 0) {
                        l3 = Long.parseLong(string2);
                    } else {
                        String string3 = string2.substring(0, n);
                        l3 = Long.parseLong(string3);
                        String string4 = string2.substring(n);
                        d = new Double(string4);
                    }
                    c = c2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NdWrappedParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3, numberFormatException);
                }
            } else if (c2 == 'T') {
                c = c2;
            } else {
                throw new ParseException(NdStrings.WjHzsiX("FailedFormatError", string), n3);
            }
            stringBuffer.setLength(0);
        }
        if (c == 'T') {
            throw new ParseException(NdStrings.WjHzsiV("LastCharShouldnTBeT"), n3);
        }
        long l4 = Math.round(d * 1.0E9);
        if (bl) {
            n4 = -n4;
            n5 = -n5;
            n6 = -n6;
            l = -l;
            l2 = -l2;
            l3 = -l3;
            l4 = -l4;
        }
        long l5 = ((l * 60L + l2) * 60L + l3) * 1000L + l4 / 1000000L;
        n = (int)(l4 % 1000000L);
        return new NdDuration(ndCalendar, n5 += n4 * 12, n6, l5, n);
    }

    public String getISOString() {
        int n = 0;
        int n2 = this.WjHzrRL;
        int n3 = this.WjHzrRM;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = this.WjHzrRN;
        long l5 = this.WjHzrRN % 1000L * 1000000L + (long)this.WjHzrRO;
        boolean bl = false;
        if (n2 < 0 || n2 == 0 && n3 < 0 || n2 == 0 && n3 == 0 && l4 < 0L || n2 == 0 && n3 == 0 && l4 == 0L && l5 < 0L) {
            bl = true;
            n2 = -n2;
            n3 = -n3;
            l4 = -l4;
            l5 = -l5;
        }
        n = n2 / 12;
        n2 %= 12;
        l = l4 / 3600000L;
        l2 = l4 % 3600000L / 60000L;
        l3 = l4 % 60000L / 1000L;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("-");
        }
        stringBuffer.append('P');
        if (n != 0) {
            stringBuffer.append(n);
            stringBuffer.append('Y');
        }
        if (n2 != 0) {
            stringBuffer.append(n2);
            stringBuffer.append('M');
        }
        if (n3 != 0) {
            stringBuffer.append(n3);
            stringBuffer.append('D');
        }
        if (l != 0L || l2 != 0L || l3 != 0L || l5 != 0L) {
            stringBuffer.append('T');
            if (l != 0L) {
                stringBuffer.append(l);
                stringBuffer.append('H');
            }
            if (l2 != 0L) {
                stringBuffer.append(l2);
                stringBuffer.append('M');
            }
            if (l3 != 0L || l5 != 0L) {
                stringBuffer.append(l3);
                if (l5 != 0L) {
                    stringBuffer.append('.');
                    long l6 = l5;
                    long l7 = 100000000L;
                    for (int i = 0; i < 9; ++i) {
                        long l8 = l6 / l7;
                        stringBuffer.append(l8);
                        if ((l6 %= l7) == 0L) break;
                        l7 /= 10L;
                    }
                }
                stringBuffer.append('S');
            }
        } else if (n == 0 && n2 == 0 && n3 == 0) {
            stringBuffer.append("T0S");
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NdDotNETLib.defaultWriteObjectHelper(objectOutputStream, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NdDotNETLib.defaultReadObjectHelper(objectInputStream, this);
    }

    static {
        WjHAfoO.put("P", new char[]{'Y', 'M', 'D', 'T'});
        WjHAfoO.put("Y", new char[]{'M', 'D', 'T'});
        WjHAfoO.put("M", new char[]{'D', 'T'});
        WjHAfoO.put("D", new char[]{'T'});
        WjHAfoO.put("T", new char[]{'H', 'M', 'S'});
        WjHAfoO.put("H", new char[]{'M', 'S'});
        WjHAfoO.put("Q", new char[]{'S'});
        WjHAfoO.put("S", new char[0]);
    }
}

