/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.objects.java;

import com.blazesoft.objects.base.NdContextConstant;
import com.blazesoft.objects.base.NdContextConstantManager;
import com.blazesoft.objects.java.NdCurrency;
import com.blazesoft.objects.java.NdCurrencyManager;
import com.blazesoft.objects.java.NdJavaValueObject;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdComparable;
import com.blazesoft.util.NdObjectReader;
import com.blazesoft.util.NdObjectWriter;
import com.blazesoft.util.NdSerializable;
import com.blazesoft.util.NdSerializationException;
import com.blazesoft.util.NdSupportJavaClass;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NdMoneyAmount
implements NdComparable,
NdSupportJavaClass,
NdSerializable,
NdContextConstant,
Cloneable,
NdJavaValueObject {
    private BigDecimal WjHzxnM;
    private NdCurrency WjHzxnN;
    private int WjHzXPO;
    static final long serialVersionUID = -7491805521011600934L;
    private static final int WjHzxnO = 8;
    private static final int WjHzxnP = 4;

    public NdMoneyAmount(NdObjectReader ndObjectReader) {
    }

    public void readObject(NdObjectReader ndObjectReader) throws IOException, NdSerializationException {
        this.WjHzxnN = (NdCurrency)ndObjectReader.getSerializable();
        this.WjHzxnM = (BigDecimal)ndObjectReader.getJavaObject();
        ndObjectReader.getEnd();
    }

    public void writeObject(NdObjectWriter ndObjectWriter) throws IOException, NdSerializationException {
        ndObjectWriter.putSerializable(this.WjHzxnN);
        ndObjectWriter.putJavaObject(this.WjHzxnM);
        ndObjectWriter.putEnd();
    }

    private static BigDecimal WjHBnwQ(Number number) {
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Double ? new BigDecimal((Double)number) : (number instanceof Float ? new BigDecimal(((Float)number).doubleValue()) : BigDecimal.valueOf(number.longValue()))));
        return bigDecimal;
    }

    NdMoneyAmount(NdCurrency ndCurrency, Number number, int n) {
        this(ndCurrency, NdMoneyAmount.WjHBnwQ(number), n);
    }

    NdMoneyAmount(NdCurrency ndCurrency, BigDecimal bigDecimal, int n) {
        this.WjHzxnN = ndCurrency;
        this.WjHzxnM = bigDecimal;
        this.WjHzXPO = n < 0 ? this.WjHzxnN.getDecimalPrecision() : n;
        this.WjHzxnM = this.WjHzxnM.setScale(this.WjHzXPO, this.WjHzxnU().getRoundingMode());
    }

    NdMoneyAmount(NdCurrency ndCurrency, long l, int n) {
        this(ndCurrency, BigDecimal.valueOf(l), n);
    }

    NdMoneyAmount(NdCurrency ndCurrency, double d, int n) {
        this(ndCurrency, new BigDecimal(d), n);
    }

    NdMoneyAmount(NdCurrency ndCurrency, BigDecimal bigDecimal) {
        this.WjHzxnN = ndCurrency;
        this.WjHzxnM = bigDecimal;
        this.WjHzXPO = this.WjHzxnN.getDecimalPrecision();
    }

    public Object clone() throws CloneNotSupportedException {
        NdMoneyAmount ndMoneyAmount = (NdMoneyAmount)this.cloneForScriptContext();
        ndMoneyAmount.WjHzxnM = ndMoneyAmount.WjHzxnM.setScale(this.WjHzxnM.scale(), this.WjHzxnU().getRoundingMode());
        return ndMoneyAmount;
    }

    private static BigDecimal WjHBnxR(BigDecimal bigDecimal) {
        int n = bigDecimal.scale();
        BigDecimal bigDecimal2 = n != 0 ? new BigDecimal(bigDecimal.movePointRight(n).toBigInteger(), n) : new BigDecimal(bigDecimal.toBigInteger());
        return bigDecimal2;
    }

    public Object cloneForScriptContext() throws CloneNotSupportedException {
        NdMoneyAmount ndMoneyAmount = (NdMoneyAmount)super.clone();
        ndMoneyAmount.WjHzXPO = this.WjHzXPO;
        ndMoneyAmount.WjHzxnM = NdMoneyAmount.WjHBnxR(this.WjHzxnM);
        return ndMoneyAmount;
    }

    public void initialize(NdContextConstantManager ndContextConstantManager) {
        String string = this.WjHzxnN.getName();
        this.WjHzxnN = ndContextConstantManager.getCurrency(string);
        this.WjHzxnM = this.WjHzxnM.setScale(this.WjHzXPO, this.WjHzxnU().getRoundingMode());
    }

    public String toString(NdCurrencyManager ndCurrencyManager) {
        String string;
        String string2;
        int n = ndCurrencyManager.getFormatMode();
        if ((n & 2) == 2 && this.WjHzxnN.getSymbol() != '\u0000') {
            string2 = "" + this.WjHzxnN.getSymbol();
            string = "";
        } else {
            string2 = this.WjHzxnN.getName();
            string = " ";
        }
        String string3 = ndCurrencyManager.format(this.WjHzxnM);
        String string4 = "";
        String string5 = "";
        if ((n & 4) == 4 && this.WjHzxnM.signum() < 0) {
            string3 = string3.substring(1);
            string4 = "(";
            string5 = ")";
        }
        if ((n & 1) == 0) {
            return string4 + string2 + string + string3 + string5;
        }
        return string4 + string3 + string + string2 + string5;
    }

    public String toString() {
        return this.toString(this.WjHzxnU());
    }

    public boolean equals(Object object) {
        if (!(object instanceof NdMoneyAmount)) {
            return false;
        }
        NdMoneyAmount ndMoneyAmount = (NdMoneyAmount)object;
        return ndMoneyAmount.WjHzxnN.sameAs(this.WjHzxnN) && ndMoneyAmount.WjHzxnM.equals(this.WjHzxnM);
    }

    public int hashCode() {
        return this.WjHzxnM.hashCode() + this.WjHzxnN.hashCode();
    }

    public int compareTo(NdComparable ndComparable) {
        NdMoneyAmount ndMoneyAmount = (NdMoneyAmount)ndComparable;
        BigDecimal bigDecimal = this.WjHzxnS(ndMoneyAmount.WjHzxnN);
        BigDecimal bigDecimal2 = ndMoneyAmount.WjHzxnS(this.WjHzxnN);
        return bigDecimal.compareTo(bigDecimal2);
    }

    public NdCurrency getCurrency() {
        return this.WjHzxnN;
    }

    public NdCurrencyManager getCurrencyManager() {
        return this.WjHzxnN.getCurrencyManager();
    }

    public BigDecimal getDecimalValue() {
        return this.WjHzxnM;
    }

    public double getValue() {
        return this.WjHzxnM.doubleValue();
    }

    public int getDecimalPrecision() {
        return this.WjHzxnM.scale();
    }

    public NdMoneyAmount add(NdMoneyAmount ndMoneyAmount) {
        BigDecimal bigDecimal = this.WjHzxnQ(ndMoneyAmount);
        bigDecimal = this.WjHzxnM.add(bigDecimal);
        return new NdMoneyAmount(this.WjHzxnN, bigDecimal);
    }

    public NdMoneyAmount subtract(NdMoneyAmount ndMoneyAmount) {
        BigDecimal bigDecimal = this.WjHzxnQ(ndMoneyAmount);
        bigDecimal = this.WjHzxnM.subtract(bigDecimal);
        return new NdMoneyAmount(this.WjHzxnN, bigDecimal);
    }

    public NdMoneyAmount multiply(Number number) {
        return this.multiply(NdMoneyAmount.WjHBnwQ(number));
    }

    public NdMoneyAmount multiply(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.WjHzxnM.multiply(bigDecimal);
        if (bigDecimal2.scale() > this.WjHzxnM.scale()) {
            bigDecimal2 = bigDecimal2.setScale(this.WjHzxnT(), this.WjHzxnU().getRoundingMode());
        }
        return new NdMoneyAmount(this.WjHzxnN, bigDecimal2);
    }

    public NdMoneyAmount multiply(BigInteger bigInteger) {
        return this.multiply(new BigDecimal(bigInteger));
    }

    public NdMoneyAmount multiply(double d) {
        return this.multiply(new BigDecimal(d));
    }

    public NdMoneyAmount multiply(long l) {
        return this.multiply(BigDecimal.valueOf(l));
    }

    public NdMoneyAmount divide(Number number) {
        return this.divide(NdMoneyAmount.WjHBnwQ(number));
    }

    public NdMoneyAmount divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.WjHzxnM.divide(bigDecimal, this.WjHzxnT(), this.WjHzxnU().getRoundingMode());
        return new NdMoneyAmount(this.WjHzxnN, bigDecimal2);
    }

    public NdMoneyAmount divide(BigInteger bigInteger) {
        return this.divide(new BigDecimal(bigInteger));
    }

    public NdMoneyAmount divide(double d) {
        return this.divide(new BigDecimal(d));
    }

    public NdMoneyAmount divide(long l) {
        return this.divide(BigDecimal.valueOf(l));
    }

    public double divide(NdMoneyAmount ndMoneyAmount) {
        BigDecimal bigDecimal = this.WjHzxnS(ndMoneyAmount.WjHzxnN);
        BigDecimal bigDecimal2 = ndMoneyAmount.WjHzxnS(this.WjHzxnN);
        return bigDecimal.doubleValue() / bigDecimal2.doubleValue();
    }

    public NdMoneyAmount invert() {
        return new NdMoneyAmount(this.WjHzxnN, this.WjHzxnM.negate());
    }

    public NdMoneyAmount convertedTo(NdCurrency ndCurrency, int n) {
        return ndCurrency.sameAs(this.WjHzxnN) ? this.preciseAt(n) : new NdMoneyAmount(ndCurrency, this.WjHzxnR(ndCurrency, n));
    }

    public NdMoneyAmount convertedTo(NdCurrency ndCurrency) {
        return this.convertedTo(ndCurrency, ndCurrency.getDecimalPrecision());
    }

    public NdMoneyAmount preciseAt(int n) {
        return n == this.WjHzxnM.scale() ? this : new NdMoneyAmount(this.WjHzxnN, this.WjHzxnM.setScale(n, this.WjHzxnU().getRoundingMode()));
    }

    private BigDecimal WjHzxnQ(NdMoneyAmount ndMoneyAmount) {
        if (ndMoneyAmount.WjHzxnN.sameAs(this.WjHzxnN)) {
            return ndMoneyAmount.WjHzxnM;
        }
        return ndMoneyAmount.WjHzxnR(this.WjHzxnN, this.WjHzxnT());
    }

    private BigDecimal WjHzxnR(NdCurrency ndCurrency, int n) {
        BigDecimal bigDecimal = this.WjHzxnM;
        NdCurrency ndCurrency2 = this.WjHzxnN;
        NdBaseObject.advAssert(!ndCurrency.sameAs(ndCurrency2));
        NdCurrency ndCurrency3 = this.WjHzxnU().getMissingCurrency();
        if ((ndCurrency2.sameAs(ndCurrency3) || ndCurrency.sameAs(ndCurrency3)) && ndCurrency3.WjHzxKC() == null) {
            return bigDecimal.setScale(n, 4);
        }
        NdCurrency ndCurrency4 = this.WjHzxnU().getEuro();
        if (ndCurrency2.WjHzxKA() != null && !ndCurrency2.sameAs(ndCurrency4)) {
            bigDecimal = ndCurrency.sameAs(ndCurrency4) ? bigDecimal.divide(ndCurrency2.WjHzxKA(), n, 4) : bigDecimal.divide(ndCurrency2.WjHzxKA(), 8, 4);
            ndCurrency2 = ndCurrency4;
        }
        if (ndCurrency.WjHzxKA() != null) {
            if (!ndCurrency2.sameAs(ndCurrency4)) {
                bigDecimal = bigDecimal.multiply(ndCurrency2.WjHzxKD());
                bigDecimal = ndCurrency.sameAs(ndCurrency4) ? bigDecimal.divide(ndCurrency4.WjHzxKD(), n, 4) : bigDecimal.divide(ndCurrency4.WjHzxKD(), 8, 4);
            }
            if (!ndCurrency.sameAs(ndCurrency4)) {
                bigDecimal = bigDecimal.multiply(ndCurrency.WjHzxKA());
                bigDecimal = bigDecimal.setScale(n, 4);
            }
        } else {
            bigDecimal = bigDecimal.multiply(ndCurrency2.WjHzxKD());
            bigDecimal = bigDecimal.divide(ndCurrency.WjHzxKD(), n, 4);
        }
        NdBaseObject.advAssert(bigDecimal.scale() == n);
        return bigDecimal;
    }

    private BigDecimal WjHzxnS(NdCurrency ndCurrency) {
        if (this.WjHzxnN.sameAs(ndCurrency)) {
            return this.WjHzxnM;
        }
        BigDecimal bigDecimal = this.WjHzxnM;
        if (this.WjHzxnN.WjHzxKA() != null) {
            if (ndCurrency.WjHzxKA() != null) {
                return bigDecimal.multiply(ndCurrency.WjHzxKA());
            }
            bigDecimal = bigDecimal.multiply(this.WjHzxnU().getEuro().WjHzxKD());
        } else {
            bigDecimal = bigDecimal.multiply(this.WjHzxnN.WjHzxKD());
        }
        if (ndCurrency.WjHzxKA() != null) {
            bigDecimal = bigDecimal.multiply(ndCurrency.WjHzxKA());
        }
        return bigDecimal;
    }

    private int WjHzxnT() {
        return Math.max(this.WjHzxnM.scale(), this.WjHzxnN.getDecimalPrecision());
    }

    private NdCurrencyManager WjHzxnU() {
        return this.WjHzxnN.getCurrencyManager();
    }
}

