/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.objects.java;

import com.blazesoft.objects.base.NdContextConstant;
import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.objects.java.NdCalendarValue;
import com.blazesoft.objects.java.NdDuration;
import com.blazesoft.objects.java.NdInvalidDurationException;
import com.blazesoft.objects.java.NdStrings;
import com.blazesoft.objects.java.NdTimestamp;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdComparable;
import com.blazesoft.util.NdObjectReader;
import com.blazesoft.util.NdObjectWriter;
import com.blazesoft.util.NdSerializable;
import com.blazesoft.util.NdSerializationException;
import com.blazesoft.util.NdSupportJavaClass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class NdTime
extends NdCalendarValue
implements NdSupportJavaClass,
NdSerializable,
NdContextConstant {
    private long WjHzsAY;
    private int WjHzsBZ;
    private int WjHzsCA;
    private TimeZone WjHzsCB;
    private transient Date WjHBXpD;
    private transient Time WjHBXqE;
    private transient Date WjHBXrF;
    public static final int AM = 0;
    public static final int PM = 1;
    static final long serialVersionUID = 4371149534345012394L;
    static final long WjHzsCC = 1000L;
    static final long WjHzsCD = 60000L;
    static final long WjHzsCE = 3600000L;
    static final long WjHzsCF = 86400000L;
    private static final long WjHzsCG = 4611686018371200000L;

    public NdTime(NdObjectReader ndObjectReader) {
        super(ndObjectReader);
    }

    public void readObject(NdObjectReader ndObjectReader) throws IOException, NdSerializationException {
        super.readObject(ndObjectReader);
        this.WjHzsCB = (TimeZone)ndObjectReader.getJavaObject();
        this.WjHzsCA = ndObjectReader.getIntVal();
        this.WjHzsBZ = ndObjectReader.getIntVal();
        this.WjHzsAY = ndObjectReader.getLongVal();
        ndObjectReader.getEnd();
    }

    public void writeObject(NdObjectWriter ndObjectWriter) throws IOException, NdSerializationException {
        super.writeObject(ndObjectWriter);
        ndObjectWriter.putJavaObject(this.WjHzsCB);
        ndObjectWriter.putIntVal(this.WjHzsCA);
        ndObjectWriter.putIntVal(this.WjHzsBZ);
        ndObjectWriter.putLongVal(this.WjHzsAY);
        ndObjectWriter.putEnd();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NdDotNETLib.defaultWriteObjectHelper(objectOutputStream, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NdDotNETLib.defaultReadObjectHelper(objectInputStream, this);
    }

    NdTime(NdCalendar ndCalendar, Date date, TimeZone timeZone) {
        this(ndCalendar, date, timeZone, 0);
    }

    private static TimeZone WjHBXsG(NdCalendar ndCalendar, TimeZone timeZone, int n) {
        if (n != 0) {
            if (timeZone == null) {
                timeZone = ndCalendar.getDefaultTimeZone();
            }
            if (!timeZone.useDaylightTime()) {
                throw new IllegalArgumentException(NdStrings.WjHzsiY("InvalidDSTOffsetForTimeZone", Integer.toString(n), timeZone.getID()));
            }
        }
        return timeZone;
    }

    NdTime(NdCalendar ndCalendar, Date date, TimeZone timeZone, int n) {
        super(ndCalendar);
        NdCalendar.WjHBEkZ wjHBEkZ = ndCalendar.WjHBXEK(timeZone, date);
        this.WjHzsCA = wjHBEkZ.get(16);
        this.WjHzsAY = (long)(wjHBEkZ.get(11) * 3600000 + wjHBEkZ.get(12) * 60000 + wjHBEkZ.get(13) * 1000 + wjHBEkZ.get(14)) % 86400000L;
        this.WjHzsCB = NdTime.WjHBXsG(ndCalendar, timeZone, this.WjHzsCA);
        this.WjHzsBZ = n;
    }

    NdTime(NdCalendar ndCalendar, Date date, int n, TimeZone timeZone) {
        super(ndCalendar);
        this.WjHzsCB = NdTime.WjHBXsG(ndCalendar, timeZone, n);
        NdCalendar.WjHBEkZ wjHBEkZ = ndCalendar.WjHBXEK(timeZone, date);
        this.WjHzsAY = (long)(wjHBEkZ.get(11) * 3600000 + wjHBEkZ.get(12) * 60000 + wjHBEkZ.get(13) * 1000 + wjHBEkZ.get(14) + n) % 86400000L;
        this.WjHzsCA = n;
        this.WjHzsBZ = 0;
    }

    NdTime(NdCalendar ndCalendar, Date date, int n, TimeZone timeZone, int n2) {
        this(ndCalendar, date, n, timeZone);
        this.WjHzsBZ = n2;
    }

    public NdTime(NdCalendar ndCalendar, Date date) {
        this(ndCalendar, date, null, 0);
    }

    public NdTime(NdCalendar ndCalendar, Timestamp timestamp) {
        this(ndCalendar, (Date)timestamp, null, 0);
        this.WjHzsAY += (long)(timestamp.getNanos() / 1000000);
        this.WjHzsBZ = timestamp.getNanos() % 1000000;
    }

    public NdTime(NdCalendar ndCalendar, int n, int n2, int n3, int n4, int n5, TimeZone timeZone, int n6) {
        super(ndCalendar);
        this.WjHzsAY = (n * 3600 + n2 * 60 + n3) * 1000 + n4;
        this.WjHzsCB = NdTime.WjHBXsG(ndCalendar, timeZone, n6);
        this.WjHzsCA = n6;
        this.WjHzsBZ = n5;
        this.WjHzsCI();
    }

    NdTime(NdCalendar ndCalendar, long l, int n, TimeZone timeZone, int n2) {
        super(ndCalendar);
        this.WjHzsAY = l;
        this.WjHzsBZ = n;
        this.WjHzsCB = NdTime.WjHBXsG(ndCalendar, timeZone, n2);
        this.WjHzsCA = n2;
        this.WjHzsCH();
        this.WjHzsCI();
    }

    private void WjHzsCH() {
        if (this.WjHzsBZ < 0) {
            this.WjHzsBZ += 1000000;
            --this.WjHzsAY;
        } else if (this.WjHzsBZ >= 1000000) {
            this.WjHzsBZ -= 1000000;
            ++this.WjHzsAY;
        }
    }

    private void WjHzsCI() {
        NdBaseObject.advAssert(this.WjHzsBZ >= 0 && this.WjHzsBZ < 1000000);
    }

    public Object clone() throws CloneNotSupportedException {
        NdTime ndTime = (NdTime)super.clone();
        if (this.WjHzsCB != null) {
            ndTime.WjHzsCB = (TimeZone)this.WjHzsCB.clone();
        }
        if (this.WjHBXpD != null) {
            ndTime.WjHBXpD = new Date(this.WjHBXpD.getTime());
        }
        if (this.WjHBXqE != null) {
            ndTime.WjHBXqE = new Time(this.WjHBXqE.getTime());
        }
        if (this.WjHBXrF != null) {
            ndTime.WjHBXrF = new Date(this.WjHBXrF.getTime());
        }
        return ndTime;
    }

    public Object cloneForScriptContext() throws CloneNotSupportedException {
        NdTime ndTime = (NdTime)super.cloneForScriptContext();
        if (this.WjHzsCB != null) {
            ndTime.WjHzsCB = (TimeZone)this.WjHzsCB.clone();
        }
        if (this.WjHBXpD != null) {
            ndTime.WjHBXpD = new Date(this.WjHBXpD.getTime());
        }
        if (this.WjHBXqE != null) {
            ndTime.WjHBXqE = new Time(this.WjHBXqE.getTime());
        }
        if (this.WjHBXrF != null) {
            ndTime.WjHBXrF = new Date(this.WjHBXrF.getTime());
        }
        return ndTime;
    }

    private GregorianCalendar WjHzsCJ(boolean bl) {
        int n;
        NdCalendar ndCalendar = this.getCalendar();
        TimeZone timeZone = this.WjHzsCB;
        if (timeZone == null) {
            timeZone = ndCalendar.getDefaultTimeZone();
        }
        NdCalendar.WjHBEkZ wjHBEkZ = ndCalendar.WjHBEYO(timeZone);
        if (bl && timeZone.useDaylightTime()) {
            int n2;
            int n3;
            if (!timeZone.inDaylightTime(NdCalendar.WjHBXEH)) {
                n3 = 6;
                n2 = 0;
            } else {
                n3 = 0;
                n2 = 6;
            }
            n = this.WjHzsCA != 0 ? n3 : n2;
        } else {
            n = 0;
        }
        wjHBEkZ.set(1970, n, 1, this.getHour(), this.getMinute(), this.getSecond());
        wjHBEkZ.set(14, this.getMilliseconds());
        return wjHBEkZ;
    }

    private long WjHBXtH() {
        long l = this.WjHzsAY;
        TimeZone timeZone = this.WjHzsCB;
        if (timeZone == null) {
            timeZone = this.getCalendar().getDefaultTimeZone();
        }
        l -= (long)this.WjHzsCA;
        return l -= (long)timeZone.getRawOffset();
    }

    private Date WjHBXuI() {
        Date date = this.WjHBXrF;
        if (date == null) {
            this.WjHBXrF = date = this.WjHzsCJ(true).getTime();
        }
        return date;
    }

    private long WjHDMlB() {
        long l = this.WjHBXtH();
        int n = NdCalendar.getSystemTimeZoneJavaEpochOffset();
        long l2 = l + (long)n;
        if ((l2 %= 86400000L) < 0L) {
            l2 += 86400000L;
        }
        l = l2 - (long)n;
        return l;
    }

    public Date getJavaDate() {
        Date date = this.WjHBXpD;
        if (date == null) {
            long l = this.WjHDMlB();
            this.WjHBXpD = date = new Date(l);
        }
        return date;
    }

    public Time getJavaSqlTime() {
        Time time = this.WjHBXqE;
        if (time == null) {
            long l = this.WjHDMlB();
            this.WjHBXqE = time = new Time(l);
        }
        return time;
    }

    public NdTimestamp getDotNETTime() {
        long l = this.getJavaDate().getTime() + NdCalendar.WjHDNGY;
        return new NdTimestamp(this.getCalendar(), l, this.getExtraNanoseconds(), NdCalendar.getSystemTimeZone());
    }

    public NdTime inTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException(NdStrings.WjHzsiV("SpecifiedTimeZoneCannotBeNull"));
        }
        long l = this.WjHBXtH() + (long)timeZone.getRawOffset();
        return new NdTime(this.getCalendar(), l, this.WjHzsBZ, timeZone, 0);
    }

    public NdTime shiftToTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException(NdStrings.WjHzsiV("SpecifiedTimeZoneCannotBeNull"));
        }
        return new NdTime(this.getCalendar(), this.getHour(), this.getMinute(), this.getSecond(), this.getMilliseconds(), this.getExtraNanoseconds(), timeZone, 0);
    }

    public TimeZone getTimeZone() {
        return this.WjHzsCB;
    }

    long WjHzsCL() {
        return this.WjHzsAY;
    }

    public int getExtraNanoseconds() {
        return this.WjHzsBZ;
    }

    public int getDayOffset() {
        return (int)((this.WjHzsAY + 4611686018371200000L) / 86400000L - 53375995583L);
    }

    public int getHour() {
        return (int)((this.WjHzsAY + 4611686018371200000L) / 3600000L % 24L);
    }

    public int getMinute() {
        return (int)((this.WjHzsAY + 4611686018371200000L) / 60000L % 60L);
    }

    public int getSecond() {
        return (int)((this.WjHzsAY + 4611686018371200000L) / 1000L % 60L);
    }

    public int getMilliseconds() {
        return (int)((this.WjHzsAY + 4611686018371200000L) % 1000L);
    }

    public int getMicroseconds() {
        return this.getMilliseconds() * 1000 + this.WjHzsBZ / 1000;
    }

    public int getNanoseconds() {
        return this.getMilliseconds() * 1000000 + this.WjHzsBZ;
    }

    public int getAmPm() {
        return this.getHour() < 12 ? 0 : 1;
    }

    public int getAmPmHour() {
        int n = this.getHour() % 12;
        return n == 0 ? 12 : n;
    }

    public NdDuration getDaylightOffset() {
        return new NdDuration(this.getCalendar(), 0, 0, this.WjHzsCA, 0);
    }

    public boolean inDaylightSavings() {
        return this.WjHzsCA != 0;
    }

    int WjHzsCN() {
        return this.WjHzsCA;
    }

    private void WjHzsCO(NdDuration ndDuration) throws NdInvalidDurationException {
        if (ndDuration.getMonths() != 0 || ndDuration.getDays() != 0) {
            throw new NdInvalidDurationException(NdStrings.WjHzsiV("InvalidDurationForTimeArithmetics"));
        }
    }

    public NdTime add(NdDuration ndDuration) throws NdInvalidDurationException {
        this.WjHzsCO(ndDuration);
        long l = this.WjHzsAY + ndDuration.getMilliseconds();
        int n = this.WjHzsBZ + ndDuration.getExtraNanoseconds();
        return new NdTime(this.getCalendar(), l, n, this.WjHzsCB, this.WjHzsCA);
    }

    public NdTime subtract(NdDuration ndDuration) throws NdInvalidDurationException {
        this.WjHzsCO(ndDuration);
        long l = this.WjHzsAY - ndDuration.getMilliseconds();
        int n = this.WjHzsBZ - ndDuration.getExtraNanoseconds();
        return new NdTime(this.getCalendar(), l, n, this.WjHzsCB, this.WjHzsCA);
    }

    private long WjHzsCP(NdTime ndTime) {
        if (this.WjHzsCB == null || ndTime.WjHzsCB == null) {
            return this.WjHzsAY - ndTime.WjHzsAY;
        }
        if (ndTime.WjHzsCB != this.WjHzsCB) {
            return this.WjHBXtH() - ndTime.WjHBXtH();
        }
        return this.WjHzsAY - (long)this.WjHzsCA - (ndTime.WjHzsAY - (long)ndTime.WjHzsCA);
    }

    public NdDuration subtract(NdTime ndTime) {
        long l = this.WjHzsCP(ndTime);
        if (this.WjHzsBZ == ndTime.WjHzsBZ) {
            return new NdDuration(this.getCalendar(), 0, 0, l, 0);
        }
        NdTime ndTime2 = new NdTime(this.getCalendar(), l, this.WjHzsBZ - ndTime.WjHzsBZ, this.WjHzsCB, 0);
        return new NdDuration(this.getCalendar(), 0, 0, ndTime2.WjHzsAY, ndTime2.WjHzsBZ);
    }

    public NdTime stripTimeZone() {
        return new NdTime(this.getCalendar(), this.WjHzsAY, this.WjHzsBZ, null, 0);
    }

    public int compareTo(NdComparable ndComparable) {
        NdTime ndTime = (NdTime)ndComparable;
        long l = this.WjHzsCP(ndTime);
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        if (this.WjHzsBZ < ndTime.WjHzsBZ) {
            return -1;
        }
        if (this.WjHzsBZ > ndTime.WjHzsBZ) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NdTime)) {
            return false;
        }
        NdTime ndTime = (NdTime)object;
        if (this.WjHzsCB == null) {
            return this.WjHzsAY == ndTime.WjHzsAY && this.WjHzsBZ == ndTime.WjHzsBZ && this.WjHzsCA == ndTime.WjHzsCA && this.WjHzsCB == ndTime.WjHzsCB;
        }
        return this.WjHzsAY == ndTime.WjHzsAY && this.WjHzsBZ == ndTime.WjHzsBZ && this.WjHzsCA == ndTime.WjHzsCA && this.WjHzsCB.equals(ndTime.WjHzsCB);
    }

    public int hashCode() {
        return (int)this.WjHzsAY ^ this.WjHzsBZ ^ this.WjHzsCA;
    }

    public String toString() {
        DateFormat dateFormat = this.getCalendar().WjHzDlQ(this.WjHzsCB);
        String string = null;
        if (this.getNanoseconds() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(7);
            NdCalendar.safeFormat(dateFormat, this.WjHBXuI(), stringBuffer, fieldPosition);
            if (fieldPosition.getEndIndex() - fieldPosition.getBeginIndex() > 0) {
                BigDecimal bigDecimal = new BigDecimal((double)this.getNanoseconds());
                bigDecimal = bigDecimal.setScale(9, 5);
                bigDecimal = bigDecimal.movePointLeft(9);
                DecimalFormat decimalFormat = new DecimalFormat(".#########");
                String string2 = decimalFormat.format(bigDecimal.doubleValue());
                stringBuffer.insert(fieldPosition.getEndIndex(), string2);
            }
            string = stringBuffer.toString();
        } else {
            string = NdCalendar.safeFormat(dateFormat, this.WjHBXuI());
        }
        int n = this.getDayOffset();
        if (n != 0) {
            string = string + " (" + (n > 0 ? "+" + n : "" + n) + (Math.abs(n) > 1 ? " days" : " day") + ")";
        }
        return string;
    }

    public String format(String string) {
        return this.format(string, null);
    }

    public String format(String string, Locale locale) {
        return this.getCalendar().WjHzDnS(this.WjHBXuI(), string, this.WjHzsCB, locale);
    }

    public String format(int n) {
        return this.getCalendar().WjHzDoT(this.WjHBXuI(), DateFormat.getTimeInstance(n), this.WjHzsCB);
    }
}

