/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.objects.jdbc;

import com.blazesoft.objects.jdbc.NdDbConnectionInfo;
import com.blazesoft.objects.jdbc.NdDbConnectionPool;
import com.blazesoft.objects.jdbc.NdDbConnectionPoolProvider;
import com.blazesoft.objects.jdbc.NdDbDefConnectionPoolProvider;
import com.blazesoft.objects.jdbc.NdDbMapClassKey;
import com.blazesoft.objects.jdbc.NdDbMapConnectionKey;
import com.blazesoft.objects.jdbc.NdDbMapConnectionProvider;
import com.blazesoft.objects.jdbc.NdStrings;
import com.blazesoft.objects.jdbc.WjHzFYW;
import com.blazesoft.objects.jdbc.WjHzsPS;
import com.blazesoft.objects.jdbc.WjHzyBN;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class NdDbConnection {
    public static final int NODRIVER = -1;
    public static final int ORACLE = 0;
    public static final int SYBASE = 1;
    public static final int ODBC = 2;
    public static final int DB2 = 3;
    public static final int OTHERS = 9;
    private static String WjHzyJI = "DbConnection: ";
    private static Vector WjHzyKJ = new Vector();
    private static Vector WjHzyLK = new Vector();
    private NdDbConnectionInfo WjHzyML = null;
    private Connection WjHzyNM = null;
    private boolean WjHzyON = true;
    private int WjHzyRQ = 0;
    private int WjHzySR = -1;
    private boolean WjHzyTS = false;
    private NdDbConnectionPool WjHzyUT = null;

    NdDbConnection(NdDbConnectionPool ndDbConnectionPool, NdDbConnectionInfo ndDbConnectionInfo) {
        this.WjHzyUT = ndDbConnectionPool;
        this.WjHzyML = ndDbConnectionInfo;
        this.WjHzyNM = null;
        this.WjHzyON = true;
    }

    NdDbConnection(NdDbConnectionPool ndDbConnectionPool, NdDbConnectionInfo ndDbConnectionInfo, Connection connection) {
        this.WjHzyUT = ndDbConnectionPool;
        this.WjHzyML = ndDbConnectionInfo;
        this.WjHzyNM = connection;
        this.WjHzyON = false;
    }

    protected NdDbConnection(Connection connection) {
        this.WjHzyUT = null;
        this.WjHzyML = null;
        this.WjHzyNM = connection;
        this.WjHzyON = false;
    }

    public NdDbConnectionInfo getConnectionInfo() {
        return this.WjHzyML;
    }

    public NdDbConnectionPool getConnectionPool() {
        return this.WjHzyUT;
    }

    private static void WjHzyVU(SQLWarning sQLWarning) throws SQLException {
        String string = "\n" + NdStrings.WjHzGtU("Warning") + "\n\n";
        while (sQLWarning != null) {
            string = string + NdStrings.WjHzGtU("SQLState") + sQLWarning.getSQLState() + "\n";
            string = string + NdStrings.WjHzGtU("Message") + sQLWarning.getMessage() + "\n";
            string = string + NdStrings.WjHzGtU("ErrCode") + sQLWarning.getErrorCode() + "\n\n";
            sQLWarning = sQLWarning.getNextWarning();
        }
        NdDbConnection.log(string);
    }

    private void WjHzyXW() {
        try {
            Class.forName(this.WjHzyML.getDriverStr());
        }
        catch (Throwable throwable) {
            throw new WjHzsPS(NdStrings.WjHzGtX("CannotLoadDriver", this.WjHzyML.getDriverStr(), throwable));
        }
    }

    private void WjHzQFJ(NdDbMapConnectionKey ndDbMapConnectionKey) throws WjHzsPS {
        Connection connection = null;
        try {
            this.WjHzyXW();
            connection = NdDbConnection.WjHzQGK(ndDbMapConnectionKey, this.WjHzyML);
            if (connection == null) {
                Object object;
                Properties properties = this.WjHzyML.getProperties();
                if (properties != null) {
                    object = this.WjHzyML.getUserStr();
                    String string = this.WjHzyML.getPasswdStr();
                    if (object != null) {
                        ((Hashtable)properties).put("user", object);
                    }
                    if (string != null) {
                        ((Hashtable)properties).put("password", string);
                    }
                    connection = DriverManager.getConnection(this.WjHzyML.getDbUrlStr(), properties);
                } else {
                    connection = DriverManager.getConnection(this.WjHzyML.getDbUrlStr(), this.WjHzyML.getUserStr(), this.WjHzyML.getPasswdStr());
                }
                if (connection != null) {
                    if (this.WjHzyML.getAutoCommit() == 1) {
                        connection.setAutoCommit(true);
                    } else if (this.WjHzyML.getAutoCommit() == 0) {
                        connection.setAutoCommit(false);
                    }
                    if (this.WjHzyML.getTransactionMode() != -1) {
                        connection.setTransactionIsolation(this.WjHzyML.getTransactionMode());
                    }
                    if ((object = connection.getWarnings()) != null) {
                        NdDbConnection.WjHzyVU((SQLWarning)object);
                    }
                }
                this.WjHzyON = true;
                WjHzFYW.WjHzFYR(WjHzyJI + NdStrings.WjHzGtY("EstablishedDatabaseConnectionFor", this.WjHzyML.getDriverStr(), this.WjHzyML.getDbUrlStr(), this.WjHzyML.getUserStr()));
                WjHzFYW.WjHzFYR(WjHzyJI + "\t" + NdStrings.WjHzGtY("ConnectionAttributes", new Boolean(connection.getAutoCommit()), new Integer(connection.getTransactionIsolation()), new Boolean(connection.isReadOnly())));
            } else {
                this.WjHzyON = false;
            }
        }
        catch (Throwable throwable) {
            WjHzyBN.WjHzyBK(WjHzyJI + NdStrings.WjHzGtU("ProblemConnectingToDatabase"), throwable);
            throw new WjHzsPS(throwable);
        }
        this.WjHzyNM = connection;
    }

    public synchronized boolean openConnection(NdDbMapConnectionKey ndDbMapConnectionKey) throws WjHzsPS {
        boolean bl = true;
        ++this.WjHzyRQ;
        if (this.isConnectionClosed()) {
            this.WjHzQFJ(ndDbMapConnectionKey);
            this.WjHzyTS = true;
        }
        WjHzFYW.WjHzFYR(WjHzyJI + (bl ? NdStrings.WjHzGtU("Succeeded") : NdStrings.WjHzGtU("Failed")) + NdStrings.WjHzGtY("EstablishingConnectionForAnd", this.WjHzyML.getDriverStr(), this.WjHzyML.getDbUrlStr(), this.WjHzyML.getUserStr()));
        return bl;
    }

    public synchronized boolean openConnection() throws WjHzsPS {
        return this.openConnection(null);
    }

    public synchronized void closeConnection(boolean bl) throws WjHzsPS {
        block8: {
            --this.WjHzyRQ;
            if (this.WjHzyRQ < 0) {
                this.WjHzyRQ = 0;
            }
            if (this.WjHzyRQ == 0 && bl) {
                try {
                    if (!this.WjHzyTS) break block8;
                    this.WjHzyTS = false;
                    if (this.WjHzyON) {
                        if (this.WjHzyML.getAutoCommit() != 1) {
                            try {
                                this.WjHzyNM.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        this.WjHzyNM.close();
                        WjHzFYW.WjHzFYR(WjHzyJI + NdStrings.WjHzGtY("ClosedDatabaseConnectionFor", this.WjHzyML.getDriverStr(), this.WjHzyML.getDbUrlStr(), this.WjHzyML.getUserStr()));
                    }
                    this.WjHzyNM = null;
                }
                catch (Throwable throwable) {
                    WjHzyBN.WjHzyBJ(WjHzyJI + NdStrings.WjHzGtZ("ProblemClosingDatabaseConnectionFor", this.WjHzyML.getDriverStr(), this.WjHzyML.getDbUrlStr(), this.WjHzyML.getUserStr(), throwable));
                    throw new WjHzsPS(throwable);
                }
            }
        }
        WjHzFYW.WjHzFYR(WjHzyJI + NdStrings.WjHzGtY("ClosedConnectionFor", this.WjHzyML.getDriverStr(), this.WjHzyML.getDbUrlStr(), this.WjHzyML.getUserStr()));
    }

    public synchronized void closeConnection() throws WjHzsPS {
        this.closeConnection(true);
    }

    public synchronized void shutdownConnection() throws WjHzsPS {
        this.WjHzyRQ = 1;
        this.closeConnection(true);
    }

    public synchronized boolean isConnectionClosed() throws WjHzsPS {
        return !this.WjHzyTS;
    }

    public synchronized int getVendor() {
        if (this.WjHzySR == -1 && this.WjHzyNM != null) {
            try {
                String string;
                StringTokenizer stringTokenizer = new StringTokenizer(this.WjHzyNM.getMetaData().getDriverName());
                String string2 = stringTokenizer.nextToken().toUpperCase();
                this.WjHzySR = string2.equals("ORACLE") ? 0 : (string2.equals("JCONNECT") ? 1 : (string2.equals("JDBC-ODBC") ? 2 : (string2.indexOf("DB2") > 0 ? 3 : ((string = this.WjHzyNM.getMetaData().getDatabaseProductName()) != null && string.equalsIgnoreCase("oracle") ? 0 : 9))));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.WjHzySR;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.WjHzyNM.createStatement();
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.WjHzyNM.prepareStatement(string);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.WjHzyNM.prepareCall(string);
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        return this.WjHzyNM.nativeSQL(string);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.WjHzyNM.setAutoCommit(bl);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.WjHzyNM.getAutoCommit();
    }

    public synchronized void commit() throws SQLException {
        this.WjHzyNM.commit();
    }

    public synchronized void rollback() throws SQLException {
        this.WjHzyNM.rollback();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.WjHzyNM.getMetaData();
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.WjHzyNM.setReadOnly(bl);
    }

    public synchronized boolean isReadOnly() throws SQLException {
        return this.WjHzyNM.isReadOnly();
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.WjHzyNM.setCatalog(string);
    }

    public synchronized String getCatalog() throws SQLException {
        return this.WjHzyNM.getCatalog();
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.WjHzyNM.setTransactionIsolation(n);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.WjHzyNM.getTransactionIsolation();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.WjHzyNM.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.WjHzyNM.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        this.closeConnection();
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.isConnectionClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionProvider(NdDbMapConnectionProvider ndDbMapConnectionProvider) {
        Vector vector = WjHzyKJ;
        synchronized (vector) {
            WjHzyKJ.insertElementAt(ndDbMapConnectionProvider, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConnectionProvider(NdDbMapConnectionProvider ndDbMapConnectionProvider) {
        Vector vector = WjHzyKJ;
        synchronized (vector) {
            WjHzyKJ.removeElement(ndDbMapConnectionProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection WjHzQGK(NdDbMapConnectionKey ndDbMapConnectionKey, NdDbConnectionInfo ndDbConnectionInfo) {
        Connection connection = null;
        Vector vector = WjHzyKJ;
        synchronized (vector) {
            for (int i = 0; i < WjHzyKJ.size() && (connection = ((NdDbMapConnectionProvider)WjHzyKJ.elementAt(i)).getConnection(ndDbMapConnectionKey, ndDbConnectionInfo)) == null; ++i) {
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionPoolProvider(NdDbConnectionPoolProvider ndDbConnectionPoolProvider) {
        Vector vector = WjHzyLK;
        synchronized (vector) {
            WjHzyLK.insertElementAt(ndDbConnectionPoolProvider, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConnectionPoolProvider(NdDbConnectionPoolProvider ndDbConnectionPoolProvider) {
        Vector vector = WjHzyLK;
        synchronized (vector) {
            WjHzyLK.removeElement(ndDbConnectionPoolProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NdDbConnection WjHzzaZ(NdDbMapClassKey ndDbMapClassKey, NdDbConnectionInfo ndDbConnectionInfo) throws WjHzsPS {
        NdDbConnection ndDbConnection = null;
        Object[] objectArray = null;
        Vector vector = WjHzyLK;
        synchronized (vector) {
            objectArray = new NdDbConnectionPoolProvider[WjHzyLK.size()];
            WjHzyLK.copyInto(objectArray);
        }
        if (objectArray != null) {
            for (int i = 0; ndDbConnection == null && i < objectArray.length; ++i) {
                NdDbConnectionPool ndDbConnectionPool = objectArray[i].getConnectionPool(ndDbConnectionInfo);
                if (!ndDbConnectionPool.getConnectionInfo().equals(ndDbConnectionInfo)) continue;
                ndDbConnection = ndDbConnectionPool.checkOutConnection(ndDbMapClassKey);
            }
        }
        return ndDbConnection;
    }

    static void WjHzzbA(NdDbMapClassKey ndDbMapClassKey, NdDbConnection ndDbConnection) throws WjHzsPS {
        ndDbConnection.getConnectionPool().checkBackConnection(ndDbMapClassKey, ndDbConnection);
    }

    static void WjHzzbB(NdDbMapClassKey ndDbMapClassKey, NdDbConnection ndDbConnection) throws WjHzsPS {
        ndDbConnection.getConnectionPool().removeConnection(ndDbMapClassKey, ndDbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpConnectionPoolProviders() {
        Object[] objectArray = null;
        Vector vector = WjHzyLK;
        synchronized (vector) {
            objectArray = new NdDbConnectionPoolProvider[WjHzyLK.size()];
            WjHzyLK.copyInto(objectArray);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i].cleanUpPools();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConnectionPoolProviders() {
        Object[] objectArray = null;
        Vector vector = WjHzyLK;
        synchronized (vector) {
            objectArray = new NdDbConnectionPoolProvider[WjHzyLK.size()];
            WjHzyLK.copyInto(objectArray);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i].resetPools();
            }
        }
        WjHzyLK = new Vector();
    }

    public static void setLogStream(PrintStream printStream) {
        if (printStream != null) {
            DriverManager.setLogStream(printStream);
        } else {
            DriverManager.setLogStream(null);
        }
    }

    public static PrintStream getLogStream() {
        return DriverManager.getLogStream();
    }

    public static void log(String string) {
        DriverManager.println(string);
    }

    static {
        NdDbConnection.registerConnectionPoolProvider(new NdDbDefConnectionPoolProvider());
    }
}

