/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.objects.jdbc;

import com.blazesoft.objects.jdbc.NdDbConnection;
import com.blazesoft.objects.jdbc.NdDbConnectionInfo;
import com.blazesoft.objects.jdbc.NdDbConnectionPool;
import com.blazesoft.objects.jdbc.NdDbConnectionPoolProvider;
import com.blazesoft.objects.jdbc.NdDbMapClassKey;
import com.blazesoft.objects.jdbc.NdStrings;
import com.blazesoft.objects.jdbc.WjHzDvL;
import com.blazesoft.objects.jdbc.WjHzFYW;
import com.blazesoft.objects.jdbc.WjHzGtQ;
import com.blazesoft.objects.jdbc.WjHzHqZ;
import com.blazesoft.objects.jdbc.WjHzsPS;
import com.blazesoft.objects.jdbc.WjHzyBN;
import java.sql.Driver;
import java.util.Enumeration;
import java.util.Hashtable;

public class NdDbDefConnectionPool
implements NdDbConnectionPool {
    public static final int RELEASE_IMMEDIATELY = 0;
    public static final int RELEASE_ON_CLEAN_UP = 1;
    public static final int RELEASE_THRU_MANAGEMENT_THREAD = 2;
    private static String WjHzGuB = "DbDefConnectionPool: ";
    private Hashtable WjHzGvC = null;
    private NdDbConnectionInfo WjHzGwD;
    private Driver WjHzGxE = null;
    private static Hashtable WjHzGyF = null;
    private NdDbConnectionPoolProvider WjHzGzG = null;
    private WjHzDvL WjHzGAH;
    private long WjHzGBI;
    private int WjHzGCJ;

    protected NdDbDefConnectionPool(NdDbConnectionPoolProvider ndDbConnectionPoolProvider, NdDbConnectionInfo ndDbConnectionInfo) {
        this.WjHzGzG = ndDbConnectionPoolProvider;
        this.WjHzGvC = new Hashtable();
        this.WjHzGwD = ndDbConnectionInfo;
        this.WjHzGBI = 30000L;
        this.setConnectionReleaseStrategy(1);
    }

    public NdDbConnectionInfo getConnectionInfo() {
        return this.WjHzGwD;
    }

    public NdDbConnectionPoolProvider getConnectionPoolProvider() {
        return this.WjHzGzG;
    }

    public int getConnectionReleaseStrategy() {
        return this.WjHzGCJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReleaseStrategy(int n) {
        if (this.WjHzGCJ == n) {
            return;
        }
        NdDbDefConnectionPool ndDbDefConnectionPool = this;
        synchronized (ndDbDefConnectionPool) {
            if (this.WjHzGCJ == 2) {
                this.WjHzGAH.WjHzDvK();
                this.WjHzGAH = null;
            }
            this.WjHzGCJ = n;
            if (this.WjHzGCJ == 2) {
                this.WjHzGAH = new WjHzDvL(this);
            }
        }
    }

    public long getManagementThreadHeartBeat() {
        return this.WjHzGBI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagementThreadHeartBeat(long l) {
        NdDbDefConnectionPool ndDbDefConnectionPool = this;
        synchronized (ndDbDefConnectionPool) {
            this.WjHzGBI = l;
            if (this.WjHzGAH != null) {
                this.WjHzGAH.WjHzDvJ(this.WjHzGBI);
            }
        }
    }

    private NdDbConnection WjHzGDK() throws WjHzsPS {
        NdDbConnection ndDbConnection = new NdDbConnection(this, this.WjHzGwD);
        return ndDbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdDbConnection checkOutConnection(NdDbMapClassKey ndDbMapClassKey) throws WjHzsPS {
        NdDbConnection ndDbConnection = null;
        Hashtable hashtable = this.WjHzGvC;
        synchronized (hashtable) {
            WjHzGtQ wjHzGtQ = new WjHzGtQ(this.WjHzGwD, ndDbMapClassKey);
            WjHzHqZ wjHzHqZ = (WjHzHqZ)this.WjHzGvC.get(wjHzGtQ);
            if (wjHzHqZ == null) {
                ndDbConnection = this.WjHzGDK();
                if (ndDbConnection != null) {
                    wjHzHqZ = new WjHzHqZ(ndDbConnection);
                    this.WjHzGvC.put(wjHzGtQ, wjHzHqZ);
                    ndDbConnection = wjHzHqZ.WjHzHkT();
                }
            } else {
                ndDbConnection = wjHzHqZ.WjHzHkT();
            }
        }
        WjHzFYW.WjHzFYR(WjHzGuB + NdStrings.WjHzGtW("ObtainedConnectionFor", ndDbMapClassKey != null ? ndDbMapClassKey.getMappedClass() : "null"));
        return ndDbConnection;
    }

    private void WjHzGEL(NdDbConnection ndDbConnection, boolean bl) throws WjHzsPS {
        ndDbConnection.closeConnection(bl);
        WjHzFYW.WjHzFYR(WjHzGuB + NdStrings.WjHzGtY("ClosedDatabaseConnectionFor", this.WjHzGwD.getDriverStr(), this.WjHzGwD.getDbUrlStr(), this.WjHzGwD.getUserStr()));
    }

    private void WjHzGFM(NdDbConnection ndDbConnection) throws WjHzsPS {
        ndDbConnection.shutdownConnection();
        WjHzFYW.WjHzFYR(WjHzGuB + NdStrings.WjHzGtY("ClosedDatabaseConnectionFor", this.WjHzGwD.getDriverStr(), this.WjHzGwD.getDbUrlStr(), this.WjHzGwD.getUserStr()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WjHzGGN(NdDbMapClassKey ndDbMapClassKey, NdDbConnection ndDbConnection, boolean bl) throws WjHzsPS {
        try {
            Hashtable hashtable = this.WjHzGvC;
            synchronized (hashtable) {
                WjHzGtQ wjHzGtQ = new WjHzGtQ(this.WjHzGwD, ndDbMapClassKey);
                WjHzHqZ wjHzHqZ = (WjHzHqZ)this.WjHzGvC.get(wjHzGtQ);
                if (wjHzHqZ == null) {
                    return;
                }
                WjHzHqZ wjHzHqZ2 = wjHzHqZ;
                synchronized (wjHzHqZ2) {
                    wjHzHqZ.WjHzHlU();
                    WjHzFYW.WjHzFYR(WjHzGuB + NdStrings.WjHzGtW("ReleasedConnectionFor", ndDbMapClassKey != null ? ndDbMapClassKey.getMappedClass() : "null"));
                }
                if (wjHzHqZ.WjHzHpY() == 0) {
                    if (bl || this.WjHzGCJ == 0) {
                        this.WjHzGvC.remove(wjHzGtQ);
                        this.WjHzGEL(ndDbConnection, true);
                    } else {
                        this.WjHzGEL(ndDbConnection, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            WjHzyBN.WjHzyBJ(WjHzGuB + NdStrings.WjHzGtZ("ProblemClosingDatabaseConnectionFor", this.WjHzGwD.getDriverStr(), this.WjHzGwD.getDbUrlStr(), this.WjHzGwD.getUserStr(), exception));
            throw new WjHzsPS(exception);
        }
    }

    public void checkBackConnection(NdDbMapClassKey ndDbMapClassKey, NdDbConnection ndDbConnection) throws WjHzsPS {
        this.WjHzGGN(ndDbMapClassKey, ndDbConnection, false);
    }

    public void removeConnection(NdDbMapClassKey ndDbMapClassKey, NdDbConnection ndDbConnection) throws WjHzsPS {
        this.WjHzGGN(ndDbMapClassKey, ndDbConnection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpPool() {
        if (this.WjHzGvC == null) {
            return;
        }
        Hashtable hashtable = this.WjHzGvC;
        synchronized (hashtable) {
            Enumeration enumeration = this.WjHzGvC.keys();
            while (enumeration.hasMoreElements()) {
                NdDbConnection ndDbConnection;
                WjHzHqZ wjHzHqZ;
                WjHzGtQ wjHzGtQ = (WjHzGtQ)enumeration.nextElement();
                if (wjHzGtQ != null && wjHzGtQ.WjHzGtP() != null && wjHzGtQ.WjHzGtP().getObject() == null) {
                    wjHzHqZ = (WjHzHqZ)this.WjHzGvC.get(wjHzGtQ);
                    ndDbConnection = wjHzHqZ.WjHzHkT();
                    this.WjHzGvC.remove(wjHzGtQ);
                    this.WjHzGFM(ndDbConnection);
                    continue;
                }
                if (wjHzGtQ == null || wjHzGtQ.WjHzGtP() != null) continue;
                wjHzHqZ = (WjHzHqZ)this.WjHzGvC.get(wjHzGtQ);
                ndDbConnection = wjHzHqZ.WjHzHkT();
                this.WjHzGvC.remove(wjHzGtQ);
                this.WjHzGFM(ndDbConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPool() {
        NdDbDefConnectionPool ndDbDefConnectionPool = this;
        synchronized (ndDbDefConnectionPool) {
            this.WjHzGvC = new Hashtable();
        }
    }
}

