/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.objects.jdbc;

import com.blazesoft.objects.base.NdObjectHandle;
import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.jdbc.NdDbBoundValue;
import com.blazesoft.objects.jdbc.NdDbConnection;
import com.blazesoft.objects.jdbc.NdDbConnectionInfo;
import com.blazesoft.objects.jdbc.NdDbMapClass;
import com.blazesoft.objects.jdbc.NdDbMapClassKey;
import com.blazesoft.objects.jdbc.NdDbMapConnectionKey;
import com.blazesoft.objects.jdbc.NdDbQueryResults;
import com.blazesoft.objects.jdbc.NdDbResultSet;
import com.blazesoft.objects.jdbc.NdDbStoredProcColInfo;
import com.blazesoft.objects.jdbc.NdDbStoredProcInfo;
import com.blazesoft.objects.jdbc.NdDbTableColInfo;
import com.blazesoft.objects.jdbc.NdDbTableExportedKeyInfo;
import com.blazesoft.objects.jdbc.NdDbTableImportingKeyInfo;
import com.blazesoft.objects.jdbc.NdDbTableInfo;
import com.blazesoft.objects.jdbc.NdDbTableKeyEntryInfo;
import com.blazesoft.objects.jdbc.NdDbTablePrimaryKeyInfo;
import com.blazesoft.objects.jdbc.NdStrings;
import com.blazesoft.objects.jdbc.WjHzADS;
import com.blazesoft.objects.jdbc.WjHzAYY;
import com.blazesoft.objects.jdbc.WjHzCOT;
import com.blazesoft.objects.jdbc.WjHzDMB;
import com.blazesoft.objects.jdbc.WjHzFYA;
import com.blazesoft.objects.jdbc.WjHzFYW;
import com.blazesoft.objects.jdbc.WjHzFZA;
import com.blazesoft.objects.jdbc.WjHzHrD;
import com.blazesoft.objects.jdbc.WjHzrNU;
import com.blazesoft.objects.jdbc.WjHzriI;
import com.blazesoft.objects.jdbc.WjHzsCZ;
import com.blazesoft.objects.jdbc.WjHzsPS;
import com.blazesoft.objects.jdbc.WjHzyBN;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdSystemProperties;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NdDbServer {
    private static final String WjHzATV = NdStrings.WjHzGtU("AreNotConnectedToDatabase");
    private static final String WjHzAUW = NdStrings.WjHzGtU("CannotCreateStatement");
    private static final boolean WjHzAVX = "true".equals(NdSystemProperties.getSystemProperty("com.blazesoft.objects.jdbc.trackpreparedstatements"));
    private static final String WjHzAWY = "null";
    private WjHzriI WjHzAXZ = null;
    private transient NdDbConnection WjHzAYA;
    private int WjHzAYB = 0;
    private static Hashtable WjHzAYC = null;
    static /* synthetic */ Class class$com$blazesoft$objects$jdbc$NdDbServer;

    private String WjHzAYD(String string) {
        return NdStrings.WjHzGtW("CannotPrepareStatement", string);
    }

    private String WjHzAYE(String string) {
        return NdStrings.WjHzGtW("CannotSetUpPreparedQuery", string);
    }

    private String WjHzAYF(String string) {
        return NdStrings.WjHzGtW("CannotExecuteUpdateQuery", string);
    }

    private String WjHzAYG(String string) {
        return NdStrings.WjHzGtW("CanCallOnlyIfHaveSuppliedConnection", string);
    }

    private void WjHzAYH(NdDbConnectionInfo ndDbConnectionInfo, NdDbMapClassKey ndDbMapClassKey) {
        this.WjHzAYA = NdDbConnection.WjHzzaZ(ndDbMapClassKey, ndDbConnectionInfo);
    }

    private void WjHzAYI(NdDbConnection ndDbConnection) {
        this.WjHzAYA = ndDbConnection;
    }

    public NdDbServer(NdDbConnectionInfo ndDbConnectionInfo, NdDbMapClassKey ndDbMapClassKey) {
        this.WjHzAYH(ndDbConnectionInfo, ndDbMapClassKey);
    }

    public NdDbServer(NdDbConnectionInfo ndDbConnectionInfo) {
        this(ndDbConnectionInfo, null);
    }

    public NdDbServer(NdDbConnection ndDbConnection) {
        this.WjHzAYI(ndDbConnection);
    }

    protected void finalize() {
    }

    private String WjHzAYJ() {
        NdDbConnectionInfo ndDbConnectionInfo = this.getConnectionInfo();
        String string = ndDbConnectionInfo.getName();
        if (string == null) {
            string = NdStrings.WjHzGtU("Unamed");
        }
        string = string + "[" + ndDbConnectionInfo.getDriverStr() + ",";
        string = string + ndDbConnectionInfo.getDbUrlStr() + ",";
        string = string + ndDbConnectionInfo.getUserStr() + "]";
        return string;
    }

    public synchronized boolean init(NdDbMapConnectionKey ndDbMapConnectionKey) {
        if (this.WjHzAYA == null) {
            throw new WjHzsPS(this.WjHzAYG("NdDbServer.init"));
        }
        boolean bl = this.WjHzAYA.openConnection(ndDbMapConnectionKey);
        return bl;
    }

    public synchronized boolean init() {
        return this.init(null);
    }

    public synchronized void endClose(NdDbMapClassKey ndDbMapClassKey) {
        if (this.WjHzAYA == null) {
            throw new WjHzsPS(this.WjHzAYG("NdDbServer.end"));
        }
        NdDbConnection.WjHzzbB(ndDbMapClassKey, this.WjHzAYA);
        this.WjHzAYA = null;
    }

    public synchronized void end(NdDbMapClassKey ndDbMapClassKey) {
        if (this.WjHzAYA == null) {
            throw new WjHzsPS(this.WjHzAYG("NdDbServer.end"));
        }
        NdDbConnection.WjHzzbA(ndDbMapClassKey, this.WjHzAYA);
        this.WjHzAYA = null;
    }

    public synchronized void end() {
        this.end(null);
    }

    public NdDbConnectionInfo getConnectionInfo() {
        return this.WjHzAYA.getConnectionInfo();
    }

    public NdDbConnection getConnection() {
        return this.WjHzAYA;
    }

    public WjHzFYA createQuery(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
        WjHzpES wjHzpES = new WjHzpES(ndDbMapClassKey, wjHzsCZ);
        WjHzFYA wjHzFYA = new WjHzFYA(this, wjHzpES);
        return wjHzFYA;
    }

    public boolean deleteQuery(WjHzFYA wjHzFYA, boolean bl) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        if (!wjHzpES.WjHzFQR()) {
            wjHzpES.WjHzFPQ();
            wjHzFYA.WjHztRU(null);
            return true;
        }
        if (bl) {
            wjHzpES.WjHzFPQ();
            wjHzFYA.WjHztRU(null);
            return true;
        }
        return false;
    }

    public void deleteQueryResultSet(WjHzFYA wjHzFYA) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        wjHzpES.WjHzFOP();
    }

    public void prepare(WjHzFYA wjHzFYA) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        wjHzpES.WjHzFAB();
    }

    public void execute(WjHzFYA wjHzFYA) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        wjHzpES.WjHzFGH();
    }

    public void execute(WjHzFYA wjHzFYA, NdDbBoundValue[] ndDbBoundValueArray) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        wjHzpES.WjHzFHI(ndDbBoundValueArray);
    }

    public WjHzCOT getResultMetaInfo(WjHzFYA wjHzFYA) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        return wjHzpES.WjHzFIJ();
    }

    public NdDbQueryResults getNextResults(WjHzFYA wjHzFYA, int n) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        return wjHzpES.WjHzFJK(n);
    }

    public NdDbResultSet getResultSet(WjHzFYA wjHzFYA) {
        WjHzpES wjHzpES = (WjHzpES)wjHzFYA.WjHztRV();
        ResultSet resultSet = wjHzpES.WjHzFKL();
        return new NdDbResultSet(this, wjHzFYA, resultSet);
    }

    public WjHzADS createUpdate(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
        WjHzzNY wjHzzNY = new WjHzzNY(ndDbMapClassKey, wjHzsCZ);
        WjHzADS wjHzADS = new WjHzADS(this, wjHzzNY);
        return wjHzADS;
    }

    public boolean deleteQuery(WjHzADS wjHzADS, boolean bl) {
        WjHzzNY wjHzzNY = (WjHzzNY)wjHzADS.WjHztRV();
        if (!wjHzzNY.WjHzFQR()) {
            wjHzzNY.WjHzFPQ();
            wjHzADS.WjHztRU(null);
            return true;
        }
        if (bl) {
            wjHzzNY.WjHzFPQ();
            wjHzADS.WjHztRU(null);
            return true;
        }
        return false;
    }

    public void deleteQueryResultSet(WjHzADS wjHzADS) {
        WjHzzNY wjHzzNY = (WjHzzNY)wjHzADS.WjHztRV();
        wjHzzNY.WjHzFOP();
    }

    public void prepare(WjHzADS wjHzADS) {
        WjHzzNY wjHzzNY = (WjHzzNY)wjHzADS.WjHztRV();
        wjHzzNY.WjHzFAB();
    }

    public void execute(WjHzADS wjHzADS) {
        WjHzzNY wjHzzNY = (WjHzzNY)wjHzADS.WjHztRV();
        wjHzzNY.WjHzFGH();
    }

    public void execute(WjHzADS wjHzADS, NdDbBoundValue[] ndDbBoundValueArray) {
        WjHzzNY wjHzzNY = (WjHzzNY)wjHzADS.WjHztRV();
        wjHzzNY.WjHzFHI(ndDbBoundValueArray);
    }

    public int getExecutionStatus(WjHzADS wjHzADS) {
        WjHzzNY wjHzzNY = (WjHzzNY)wjHzADS.WjHztRV();
        return wjHzzNY.WjHzFMN();
    }

    public WjHzHrD createCall(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
        WjHzpFU wjHzpFU = new WjHzpFU(ndDbMapClassKey, wjHzsCZ);
        WjHzHrD wjHzHrD = new WjHzHrD(this, wjHzpFU);
        return wjHzHrD;
    }

    public boolean deleteCall(WjHzHrD wjHzHrD, boolean bl) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        if (!wjHzpFU.WjHzFQR()) {
            wjHzpFU.WjHzFPQ();
            wjHzHrD.WjHztRU(null);
            return true;
        }
        if (bl) {
            wjHzpFU.WjHzFPQ();
            wjHzHrD.WjHztRU(null);
            return true;
        }
        return false;
    }

    public void deleteCallResultSet(WjHzHrD wjHzHrD) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        wjHzpFU.WjHzFOP();
    }

    public void prepare(WjHzHrD wjHzHrD) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        wjHzpFU.WjHzFAB();
    }

    public void execute(WjHzHrD wjHzHrD) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        wjHzpFU.WjHzFGH();
    }

    public void execute(WjHzHrD wjHzHrD, NdDbBoundValue[] ndDbBoundValueArray) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        wjHzpFU.WjHzFHI(ndDbBoundValueArray);
    }

    public WjHzCOT getResultMetaInfo(WjHzHrD wjHzHrD) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        return wjHzpFU.WjHzFIJ();
    }

    public NdDbQueryResults getNextResults(WjHzHrD wjHzHrD, int n) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        return wjHzpFU.WjHzFJK(n);
    }

    public NdDbResultSet getResultSet(WjHzHrD wjHzHrD) {
        WjHzpFU wjHzpFU = (WjHzpFU)wjHzHrD.WjHztRV();
        ResultSet resultSet = wjHzpFU.WjHzFKL();
        return new NdDbResultSet(this, wjHzHrD, resultSet);
    }

    public WjHzrNU createUpdateCall(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
        WjHzCDH wjHzCDH = new WjHzCDH(ndDbMapClassKey, wjHzsCZ);
        WjHzrNU wjHzrNU = new WjHzrNU(this, wjHzCDH);
        return wjHzrNU;
    }

    public boolean deleteCall(WjHzrNU wjHzrNU, boolean bl) {
        WjHzCDH wjHzCDH = (WjHzCDH)wjHzrNU.WjHztRV();
        if (!wjHzCDH.WjHzFQR()) {
            wjHzCDH.WjHzFPQ();
            wjHzrNU.WjHztRU(null);
            return true;
        }
        if (bl) {
            wjHzCDH.WjHzFPQ();
            wjHzrNU.WjHztRU(null);
            return true;
        }
        return false;
    }

    public void deleteCallResultSet(WjHzrNU wjHzrNU) {
        WjHzCDH wjHzCDH = (WjHzCDH)wjHzrNU.WjHztRV();
        wjHzCDH.WjHzFOP();
    }

    public void prepare(WjHzrNU wjHzrNU) {
        WjHzCDH wjHzCDH = (WjHzCDH)wjHzrNU.WjHztRV();
        wjHzCDH.WjHzFAB();
    }

    public void execute(WjHzrNU wjHzrNU) {
        WjHzCDH wjHzCDH = (WjHzCDH)wjHzrNU.WjHztRV();
        wjHzCDH.WjHzFGH();
    }

    public void execute(WjHzrNU wjHzrNU, NdDbBoundValue[] ndDbBoundValueArray) {
        WjHzCDH wjHzCDH = (WjHzCDH)wjHzrNU.WjHztRV();
        wjHzCDH.WjHzFHI(ndDbBoundValueArray);
    }

    public int getExecutionStatus(WjHzrNU wjHzrNU) {
        WjHzCDH wjHzCDH = (WjHzCDH)wjHzrNU.WjHztRV();
        return wjHzCDH.WjHzFMN();
    }

    public void commit() {
        try {
            this.WjHzAYA.commit();
            this.WjHzAYP(NdStrings.WjHzGtW("CommittedTransactionOn", this.WjHzAYJ()));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtW("CouldNotCommitTransactionOn", this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
    }

    public void rollback() {
        try {
            this.WjHzAYA.rollback();
            this.WjHzAYP(NdStrings.WjHzGtW("RolledBackTransactionOn", this.WjHzAYJ()));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtW("CouldNotRollBackOn", this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
    }

    WjHzriI WjHzAYK() {
        return this.WjHzAXZ;
    }

    public void setStatementBoundValueProvider(WjHzriI wjHzriI) {
        this.WjHzAXZ = wjHzriI;
    }

    public synchronized WjHzFZA[] getCatalogsInfo() {
        Object[] objectArray;
        Vector<WjHzFZA> vector = null;
        if (this.WjHzAYA == null) {
            throw new RuntimeException(NdStrings.WjHzGtU("CannotRetrieveCatalogs") + WjHzATV);
        }
        try {
            objectArray = this.WjHzAYA.getMetaData();
            vector = new Vector<WjHzFZA>();
            ResultSet resultSet = null;
            resultSet = objectArray.getCatalogs();
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    WjHzFZA wjHzFZA = new WjHzFZA(string);
                    vector.addElement(wjHzFZA);
                }
                resultSet.close();
            }
            this.WjHzAYP(NdStrings.WjHzGtX("RetrievedCatalogsInformationFor", this.WjHzAYJ(), Integer.toString(vector.size())));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtW("CouldNotReadCatalogsInformationFor", this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        if (vector != null) {
            objectArray = new WjHzFZA[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public synchronized WjHzDMB[] getSchemasInfo() {
        Object[] objectArray;
        Vector<WjHzDMB> vector = null;
        if (this.WjHzAYA == null) {
            throw new RuntimeException(NdStrings.WjHzGtU("CannotRetrieveSchemes") + WjHzATV);
        }
        try {
            objectArray = this.WjHzAYA.getMetaData();
            vector = new Vector<WjHzDMB>();
            ResultSet resultSet = null;
            resultSet = objectArray.getSchemas();
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    WjHzDMB wjHzDMB = new WjHzDMB(string);
                    vector.addElement(wjHzDMB);
                }
                resultSet.close();
            }
            this.WjHzAYP(NdStrings.WjHzGtX("RetrievedSchemasInformationFor", this.WjHzAYJ(), Integer.toString(vector.size())));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtW("CouldNotReadSchemasInformationFor", this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        if (vector != null) {
            objectArray = new WjHzDMB[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private String[] WjHBnbL() throws SQLException {
        DatabaseMetaData databaseMetaData = this.WjHzAYA.getMetaData();
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = databaseMetaData.getTableTypes();
        if (resultSet != null) {
            int n = NdDotNETLib.isDotNETSupportEnabled() ? 4 : 1;
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(n));
            }
            resultSet.close();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private NdDbTableInfo[] WjHzAYL(String string, String string2, String string3) throws SQLException {
        Object[] objectArray;
        Vector<NdDbTableInfo> vector = null;
        DatabaseMetaData databaseMetaData = this.WjHzAYA.getMetaData();
        vector = new Vector<NdDbTableInfo>();
        ResultSet resultSet = null;
        String[] stringArray = NdDotNETLib.isDotNETSupportEnabled() ? this.WjHBnbL() : null;
        resultSet = databaseMetaData.getTables(string, string2, string3, stringArray);
        if (resultSet != null) {
            while (resultSet.next()) {
                objectArray = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                NdDbTableInfo ndDbTableInfo = new NdDbTableInfo(string5, (String)objectArray, string4, string6);
                ndDbTableInfo.setServer(this);
                vector.addElement(ndDbTableInfo);
            }
            resultSet.close();
        }
        if (vector != null) {
            objectArray = new NdDbTableInfo[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public synchronized NdDbTableInfo[] getTablesInfo() {
        if (this.WjHzAYA == null) {
            throw new RuntimeException(NdStrings.WjHzGtU("CannotRetrieveTables") + WjHzATV);
        }
        NdDbTableInfo[] ndDbTableInfoArray = null;
        try {
            ndDbTableInfoArray = this.WjHzAYL(null, "%", "%");
            if (ndDbTableInfoArray != null) {
                this.WjHzAYP(NdStrings.WjHzGtX("RetrievedTablesInformationForTables", this.WjHzAYJ(), Integer.toString(ndDbTableInfoArray.length)));
            }
        }
        catch (Throwable throwable) {
            try {
                ndDbTableInfoArray = this.WjHzAYL(null, null, null);
                if (ndDbTableInfoArray != null) {
                    this.WjHzAYP(NdStrings.WjHzGtX("RetrievedTablesInformationForTables", this.WjHzAYJ(), Integer.toString(ndDbTableInfoArray.length)));
                }
            }
            catch (Throwable throwable2) {
                this.WjHzAYQ(NdStrings.WjHzGtW("CouldNotReadTablesInformationFor", this.WjHzAYJ()), throwable2);
                throw new WjHzsPS(throwable2);
            }
        }
        return ndDbTableInfoArray;
    }

    public synchronized NdDbTableColInfo[] getTableColsInfo(NdDbTableInfo ndDbTableInfo) {
        Object[] objectArray;
        Vector<NdDbTableColInfo> vector = null;
        NdDbTablePrimaryKeyInfo ndDbTablePrimaryKeyInfo = null;
        try {
            ndDbTablePrimaryKeyInfo = this.getPrimaryKeyInfo(ndDbTableInfo);
        }
        catch (WjHzsPS wjHzsPS) {
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtX("CouldNotReadColumnInformationFor", ndDbTableInfo.getName(), this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        try {
            objectArray = this.WjHzAYA.getMetaData();
            vector = new Vector<NdDbTableColInfo>();
            ResultSet resultSet = null;
            resultSet = this.WjHzAYA.getVendor() == 0 ? objectArray.getColumns(ndDbTableInfo.getCatalog(), "%", ndDbTableInfo.getName(), "%") : objectArray.getColumns(ndDbTableInfo.getCatalog(), ndDbTableInfo.getSchema(), ndDbTableInfo.getName(), "%");
            if (resultSet != null) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    int n2;
                    String string = n >= 4 ? resultSet.getString(4) : "";
                    int n3 = n >= 5 ? resultSet.getInt(5) : 0;
                    String string2 = n >= 6 ? resultSet.getString(6) : "";
                    int n4 = n >= 7 ? resultSet.getInt(7) : 0;
                    int n5 = n >= 9 ? resultSet.getInt(9) : 0;
                    int n6 = n >= 10 ? resultSet.getInt(10) : 0;
                    int n7 = n >= 11 ? resultSet.getInt(11) : 2;
                    String string3 = n >= 12 ? resultSet.getString(12) : "";
                    switch (n3) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: 
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 91: 
                        case 92: 
                        case 93: {
                            break;
                        }
                        default: {
                            if (string2.equals("DATETIME") && objectArray.getDatabaseProductName().equals("ACCESS")) {
                                n3 = 93;
                                this.WjHzAYP(NdStrings.WjHzGtY("CorrectedTimeStampForAccess", ndDbTableInfo.getName(), this.WjHzAYJ(), string));
                                break;
                            }
                            if (!string2.equalsIgnoreCase("FLOAT") || this.WjHzAYA.getVendor() != 0) break;
                            n3 = 6;
                        }
                    }
                    Object object = null;
                    if (n >= 13) {
                        try {
                            object = resultSet.getObject(13);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    boolean bl = n7 == 1;
                    boolean bl2 = ndDbTablePrimaryKeyInfo != null ? ndDbTablePrimaryKeyInfo.containsColumn(string) : false;
                    if (n3 == 3 && (n2 = this.WjHzAYA.getVendor()) == 0) {
                        n3 = n5 != 0 ? 8 : 4;
                    }
                    NdDbTableColInfo ndDbTableColInfo = new NdDbTableColInfo(string, ndDbTableInfo, n3, n4, n5, n6, string3, object, bl, bl2);
                    vector.addElement(ndDbTableColInfo);
                }
                resultSet.close();
            }
            this.WjHzAYP(NdStrings.WjHzGtY("RetrievedColumnInformationForTable", ndDbTableInfo.getName(), this.WjHzAYJ(), Integer.toString(vector.size())));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtX("CouldNotReadColumnInformationFor", ndDbTableInfo.getName(), this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        if (vector != null) {
            objectArray = new NdDbTableColInfo[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public synchronized NdDbTablePrimaryKeyInfo getPrimaryKeyInfo(NdDbTableInfo ndDbTableInfo) {
        NdDbTablePrimaryKeyInfo ndDbTablePrimaryKeyInfo = null;
        try {
            DatabaseMetaData databaseMetaData = this.WjHzAYA.getMetaData();
            ResultSet resultSet = null;
            resultSet = databaseMetaData.getPrimaryKeys(ndDbTableInfo.getCatalog(), ndDbTableInfo.getSchema(), ndDbTableInfo.getName());
            if (resultSet != null) {
                while (resultSet.next()) {
                    NdDbTableKeyEntryInfo ndDbTableKeyEntryInfo = new NdDbTableKeyEntryInfo(resultSet.getString(4), resultSet.getInt(5));
                    if (ndDbTablePrimaryKeyInfo == null) {
                        ndDbTablePrimaryKeyInfo = new NdDbTablePrimaryKeyInfo("Primary");
                    }
                    ndDbTablePrimaryKeyInfo.WjHzyBU(ndDbTableKeyEntryInfo);
                }
                resultSet.close();
            }
            this.WjHzAYP(NdStrings.WjHzGtX("RetrievedPrimaryKeyForTableIn", ndDbTableInfo.getName(), this.WjHzAYJ()));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtX("CouldNotReadPrimaryKeyInformation", ndDbTableInfo.getName(), this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        return ndDbTablePrimaryKeyInfo;
    }

    public synchronized NdDbTableExportedKeyInfo[] getExportedKeysInfo(NdDbTableInfo ndDbTableInfo) {
        Object[] objectArray;
        Vector<NdDbTableExportedKeyInfo> vector = null;
        try {
            objectArray = this.WjHzAYA.getMetaData();
            ResultSet resultSet = null;
            resultSet = objectArray.getExportedKeys(ndDbTableInfo.getCatalog(), ndDbTableInfo.getSchema(), ndDbTableInfo.getName());
            if (resultSet != null) {
                while (resultSet.next()) {
                    NdDbTableKeyEntryInfo ndDbTableKeyEntryInfo = new NdDbTableKeyEntryInfo(resultSet.getString(8), resultSet.getInt(9));
                    NdDbTableExportedKeyInfo ndDbTableExportedKeyInfo = new NdDbTableExportedKeyInfo(resultSet.getString(12), resultSet.getString(4), ndDbTableKeyEntryInfo, new NdDbTableInfo(resultSet.getString(7), resultSet.getString(5), resultSet.getString(6), ""));
                    if (vector == null) {
                        vector = new Vector<NdDbTableExportedKeyInfo>();
                    }
                    vector.addElement(ndDbTableExportedKeyInfo);
                }
                resultSet.close();
            }
            this.WjHzAYP(NdStrings.WjHzGtX("RetrievedExportedKeysForTableIn", ndDbTableInfo.getName(), this.WjHzAYJ()));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtX("CouldNotReadExportedKeysInformation", ndDbTableInfo.getName(), this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        if (vector != null) {
            objectArray = new NdDbTableExportedKeyInfo[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public synchronized NdDbTableImportingKeyInfo[] getImportingKeysInfo(NdDbTableInfo ndDbTableInfo) {
        Object[] objectArray;
        Vector<NdDbTableImportingKeyInfo> vector = null;
        try {
            objectArray = this.WjHzAYA.getMetaData();
            ResultSet resultSet = null;
            resultSet = objectArray.getImportedKeys(ndDbTableInfo.getCatalog(), ndDbTableInfo.getSchema(), ndDbTableInfo.getName());
            if (resultSet != null) {
                while (resultSet.next()) {
                    NdDbTableKeyEntryInfo ndDbTableKeyEntryInfo = new NdDbTableKeyEntryInfo(resultSet.getString(8), resultSet.getInt(9));
                    NdDbTableImportingKeyInfo ndDbTableImportingKeyInfo = new NdDbTableImportingKeyInfo(resultSet.getString(12), ndDbTableKeyEntryInfo, resultSet.getString(4), new NdDbTableInfo(resultSet.getString(3), resultSet.getString(1), resultSet.getString(2), ""));
                    if (vector == null) {
                        vector = new Vector<NdDbTableImportingKeyInfo>();
                    }
                    vector.addElement(ndDbTableImportingKeyInfo);
                }
                resultSet.close();
            }
            this.WjHzAYP(NdStrings.WjHzGtX("RetrievedImportingKeysForTableIn", ndDbTableInfo.getName(), this.WjHzAYJ()));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtX("CouldNotReadImportingKeys", ndDbTableInfo.getName(), this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        if (vector != null) {
            objectArray = new NdDbTableImportingKeyInfo[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private ResultSet WjHzAYM(String string, String string2, String string3, PreparedStatement[] preparedStatementArray) throws SQLException {
        PreparedStatement preparedStatement = this.WjHzAYA.prepareStatement("SELECT DISTINCT NULL AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       NULL,\n       NULL,\n       NULL,\n       NULL AS remarks,\n\t\t0 as procedure_type\n FROM all_arguments\nWHERE (1 = ? or package_name LIKE ? ESCAPE '/')\n  AND owner LIKE ? ESCAPE '/'\n  AND owner NOT LIKE 'SYS'\n  AND object_name LIKE ? escape '/'\nORDER BY procedure_schem, procedure_name\n");
        preparedStatement.setInt(1, string == null ? 1 : 0);
        preparedStatement.setString(2, string == null ? "%" : string);
        preparedStatement.setString(3, string2 == null ? "%" : string2);
        preparedStatement.setString(4, string3 == null ? "%" : string3);
        preparedStatementArray[0] = preparedStatement;
        ResultSet resultSet = preparedStatement.executeQuery();
        return resultSet;
    }

    private ResultSet WjHzAYN(String string, String string2, String string3, String string4, PreparedStatement[] preparedStatementArray) throws SQLException {
        PreparedStatement preparedStatement = this.WjHzAYA.prepareStatement("SELECT NULL AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE (position, NULL, 3,\n               DECODE (in_out, 'IN', 1, 'OUT', 4, 'IN/OUT', 2, null))\n              AS column_type,\n       DECODE (data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4, 1111)\n              AS data_type,\n       data_type AS type_name,\n       DECODE (data_precision, NULL, data_length, data_precision)\n              AS precision,\n       data_length AS length,\n       data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       null AS remarks,\n       package_name,\n       sequence,\n       overload\n FROM all_arguments\nWHERE (1 = ? or package_name LIKE ? ESCAPE '/')\n  AND owner LIKE ? ESCAPE '/'\n  AND object_name LIKE ? escape '/'\n  AND argument_name LIKE ? escape '/'\nORDER BY procedure_schem, procedure_name, overload, sequence\n");
        preparedStatement.setInt(1, string == null ? 1 : 0);
        preparedStatement.setString(2, string == null ? "%" : string);
        preparedStatement.setString(3, string2 == null ? "%" : string2);
        preparedStatement.setString(4, string3 == null ? "%" : string3);
        preparedStatement.setString(5, string4 == null ? "%" : string4);
        preparedStatementArray[0] = preparedStatement;
        ResultSet resultSet = preparedStatement.executeQuery();
        return resultSet;
    }

    private NdDbStoredProcInfo[] WjHzAYO(String string, String string2, String string3) throws SQLException {
        Object[] objectArray;
        Vector<NdDbStoredProcInfo> vector = null;
        DatabaseMetaData databaseMetaData = this.WjHzAYA.getMetaData();
        try {
            if (!databaseMetaData.supportsStoredProcedures()) {
                return null;
            }
        }
        catch (Throwable throwable) {
            throw new WjHzsPS(throwable);
        }
        vector = new Vector<NdDbStoredProcInfo>();
        PreparedStatement[] preparedStatementArray = new PreparedStatement[]{null};
        ResultSet resultSet = null;
        resultSet = this.WjHzAYA.getVendor() == 0 ? this.WjHzAYM(string, string2, string3, preparedStatementArray) : databaseMetaData.getProcedures(string, string2, string3);
        if (resultSet != null) {
            while (resultSet.next()) {
                objectArray = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                int n = resultSet.getInt(8);
                String string6 = "";
                if (n == 0) {
                    string6 = NdStrings.WjHzGtU("StoredProcResultUnknown");
                } else if (n == 1) {
                    string6 = NdStrings.WjHzGtU("StoredProcResultNone");
                } else if (n == 2) {
                    string6 = NdStrings.WjHzGtU("StoredProcResult");
                }
                NdDbStoredProcInfo ndDbStoredProcInfo = new NdDbStoredProcInfo(string5, string6, (String)objectArray, string4);
                ndDbStoredProcInfo.setServer(this);
                vector.addElement(ndDbStoredProcInfo);
            }
            resultSet.close();
        }
        if (preparedStatementArray[0] != null) {
            preparedStatementArray[0].close();
        }
        if (vector != null) {
            objectArray = new NdDbStoredProcInfo[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public synchronized NdDbStoredProcInfo[] getStoredProcsInfo() {
        if (this.WjHzAYA == null) {
            throw new RuntimeException(NdStrings.WjHzGtU("CannotRetrieveStoredProcs") + WjHzATV);
        }
        NdDbStoredProcInfo[] ndDbStoredProcInfoArray = null;
        try {
            ndDbStoredProcInfoArray = this.WjHzAYO(null, null, null);
            if (ndDbStoredProcInfoArray != null) {
                this.WjHzAYP(NdStrings.WjHzGtX("RetrievedStoredProcsInformationForStoredProcs", this.WjHzAYJ(), Integer.toString(ndDbStoredProcInfoArray.length)));
            }
        }
        catch (Throwable throwable) {
            try {
                ndDbStoredProcInfoArray = this.WjHzAYO(null, null, null);
                if (ndDbStoredProcInfoArray != null) {
                    this.WjHzAYP(NdStrings.WjHzGtX("RetrievedStoredProcsInformationForStoredProcs", this.WjHzAYJ(), Integer.toString(ndDbStoredProcInfoArray.length)));
                }
            }
            catch (Throwable throwable2) {
                this.WjHzAYQ(NdStrings.WjHzGtW("CouldNotReadStoredProcsInformationFor", this.WjHzAYJ()), throwable2);
                throw new WjHzsPS(throwable2);
            }
        }
        return ndDbStoredProcInfoArray;
    }

    public synchronized NdDbStoredProcColInfo[] getStoredProcColsInfo(NdDbStoredProcInfo ndDbStoredProcInfo) {
        Vector<NdDbStoredProcColInfo> vector;
        Object[] objectArray;
        try {
            objectArray = this.WjHzAYA.getMetaData();
            vector = new Vector<NdDbStoredProcColInfo>();
            PreparedStatement[] preparedStatementArray = new PreparedStatement[]{null};
            String string = ndDbStoredProcInfo.getSchema() != null ? ndDbStoredProcInfo.getSchema() : "%";
            ResultSet resultSet = this.WjHzAYA.getVendor() == 0 ? this.WjHzAYN(ndDbStoredProcInfo.getCatalog(), string, ndDbStoredProcInfo.getName(), "%", preparedStatementArray) : objectArray.getProcedureColumns(ndDbStoredProcInfo.getCatalog(), string, ndDbStoredProcInfo.getName(), "%");
            if (resultSet != null) {
                while (resultSet.next()) {
                    int n;
                    String string2 = resultSet.getString(4);
                    int n2 = resultSet.getInt(5);
                    int n3 = resultSet.getInt(6);
                    int n4 = resultSet.getInt(8);
                    int n5 = resultSet.getInt(9);
                    int n6 = resultSet.getInt(10);
                    int n7 = resultSet.getInt(11);
                    if (n3 == 3 && (n = this.WjHzAYA.getVendor()) == 0) {
                        n3 = n6 != 0 ? 8 : 4;
                    }
                    NdDbStoredProcColInfo ndDbStoredProcColInfo = new NdDbStoredProcColInfo(string2, ndDbStoredProcInfo, n3, n5, n4, n7, n2);
                    vector.addElement(ndDbStoredProcColInfo);
                }
                resultSet.close();
            }
            if (preparedStatementArray[0] != null) {
                preparedStatementArray[0].close();
            }
            this.WjHzAYP(NdStrings.WjHzGtY("RetrievedColumnInformationForStoredProc", ndDbStoredProcInfo.getName(), this.WjHzAYJ(), Integer.toString(vector.size())));
        }
        catch (Throwable throwable) {
            this.WjHzAYQ(NdStrings.WjHzGtX("CouldNotReadColumnInformationFor", ndDbStoredProcInfo.getName(), this.WjHzAYJ()), throwable);
            throw new WjHzsPS(throwable);
        }
        if (vector != null) {
            objectArray = new NdDbStoredProcColInfo[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private void WjHzAYP(String string) {
        WjHzFYW.WjHzFYR("DbServer: " + string);
    }

    private void WjHzAYQ(String string, Throwable throwable) {
        WjHzyBN.WjHzyBK("DbServer: " + string, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void WjHzAYR(NdObjectHandle ndObjectHandle, WjHzFRS wjHzFRS) {
        Class clazz = class$com$blazesoft$objects$jdbc$NdDbServer == null ? (class$com$blazesoft$objects$jdbc$NdDbServer = NdDbServer.class$("com.blazesoft.objects.jdbc.NdDbServer")) : class$com$blazesoft$objects$jdbc$NdDbServer;
        synchronized (clazz) {
            if (WjHzAYC == null) {
                WjHzAYC = new Hashtable();
            }
            WjHzAYC.put(new WjHzzMZ(ndObjectHandle, wjHzFRS), wjHzFRS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpPreparedStatements() {
        Class clazz = class$com$blazesoft$objects$jdbc$NdDbServer == null ? (class$com$blazesoft$objects$jdbc$NdDbServer = NdDbServer.class$("com.blazesoft.objects.jdbc.NdDbServer")) : class$com$blazesoft$objects$jdbc$NdDbServer;
        synchronized (clazz) {
            if (WjHzAYC != null) {
                Enumeration enumeration = WjHzAYC.keys();
                while (enumeration.hasMoreElements()) {
                    WjHzzMZ wjHzzMZ = (WjHzzMZ)enumeration.nextElement();
                    if ((wjHzzMZ == null || wjHzzMZ.WjHzzLY() == null || wjHzzMZ.WjHzzLY().getObject() != null) && wjHzzMZ.WjHzzLY() != null) continue;
                    WjHzFRS wjHzFRS = (WjHzFRS)WjHzAYC.get(wjHzzMZ);
                    WjHzAYC.remove(wjHzzMZ);
                    wjHzFRS.WjHzFPQ();
                }
            }
        }
    }

    private int WjHzAYS(Object object) {
        int n = object instanceof String ? 12 : (object instanceof BigDecimal ? 2 : (object instanceof Boolean ? -7 : (object instanceof Short ? 5 : (object instanceof Integer ? 4 : (object instanceof Long ? -5 : (object instanceof Float ? 8 : (object instanceof Double ? 8 : (object instanceof Date ? 91 : (object instanceof Time ? 92 : (object instanceof Timestamp ? 93 : (object instanceof java.util.Date ? 91 : -3)))))))))));
        return n;
    }

    public static void reset() {
        NdDbServer.cleanUpPreparedStatements();
        NdDbConnection.cleanUpConnectionPoolProviders();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class WjHzzMZ {
        private WjHzFRS WjHzzJW;
        private NdObjectHandle WjHzzKX;

        WjHzzMZ(NdObjectHandle ndObjectHandle, WjHzFRS wjHzFRS) {
            this.WjHzzJW = wjHzFRS;
            this.WjHzzKX = ndObjectHandle;
        }

        public int hashCode() {
            return this.WjHzzJW.hashCode() / 2 + (this.WjHzzKX != null ? this.WjHzzKX.hashCode() / 2 : 0);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            WjHzzMZ wjHzzMZ = (WjHzzMZ)object;
            if (NdBaseObject.areEqual(wjHzzMZ.WjHzzJW, this.WjHzzJW) && NdBaseObject.areEqual(wjHzzMZ.WjHzzKX, this.WjHzzKX)) {
                bl = true;
            }
            return bl;
        }

        NdObjectHandle WjHzzLY() {
            return this.WjHzzKX;
        }
    }

    class WjHzCDH
    extends WjHzFRS {
        WjHzCDH(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
            super(ndDbMapClassKey, wjHzsCZ);
        }

        PreparedStatement WjHzFzA() throws SQLException {
            return NdDbServer.this.WjHzAYA.prepareCall(this.WjHzFyY());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void WjHzFAB() {
            NdDbConnection ndDbConnection;
            NdDbConnection ndDbConnection2 = ndDbConnection = NdDbServer.this.WjHzAYA;
            synchronized (ndDbConnection2) {
                try {
                    this.WjHzFyQ = NdDbServer.this.WjHzAYA.prepareCall(this.WjHzFyY());
                    NdDbServer.this.WjHzAYP(NdStrings.WjHzGtX("PreparedCallIn", this.WjHzFyY(), NdDbServer.this.WjHzAYJ()));
                }
                catch (Throwable throwable) {
                    NdDbServer.this.WjHzAYQ(NdDbServer.this.WjHzAYD(this.WjHzFyY()), throwable);
                    throw new WjHzsPS(throwable);
                }
            }
        }

        void WjHzFFG(PreparedStatement preparedStatement) throws SQLException {
            int n = preparedStatement.executeUpdate();
            this.WjHzFNO(n);
        }

        void WjHzFEF(Statement statement, String string) throws SQLException {
            int n = statement.executeUpdate(string);
            this.WjHzFNO(n);
        }
    }

    class WjHzpFU
    extends WjHzFRS {
        WjHzpFU(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
            super(ndDbMapClassKey, wjHzsCZ);
        }

        PreparedStatement WjHzFzA() throws SQLException {
            return NdDbServer.this.WjHzAYA.prepareCall(this.WjHzFyY());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void WjHzFAB() {
            NdDbConnection ndDbConnection;
            NdDbConnection ndDbConnection2 = ndDbConnection = NdDbServer.this.WjHzAYA;
            synchronized (ndDbConnection2) {
                try {
                    this.WjHzFyQ = NdDbServer.this.WjHzAYA.prepareCall(this.WjHzFyY());
                    NdDbServer.this.WjHzAYP(NdStrings.WjHzGtX("PreparedCallIn", this.WjHzFyY(), NdDbServer.this.WjHzAYJ()));
                }
                catch (Throwable throwable) {
                    NdDbServer.this.WjHzAYQ(NdDbServer.this.WjHzAYD(this.WjHzFyY()), throwable);
                    throw new WjHzsPS(throwable);
                }
            }
        }

        void WjHzFFG(PreparedStatement preparedStatement) throws SQLException {
            ResultSet resultSet = preparedStatement.executeQuery();
            this.WjHzFLM(resultSet);
        }

        void WjHzFEF(Statement statement, String string) throws SQLException {
            ResultSet resultSet = statement.executeQuery(string);
            this.WjHzFLM(resultSet);
        }
    }

    class WjHzzNY
    extends WjHzFRS {
        WjHzzNY(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
            super(ndDbMapClassKey, wjHzsCZ);
        }

        PreparedStatement WjHzFzA() throws SQLException {
            return NdDbServer.this.WjHzAYA.prepareStatement(this.WjHzFyY());
        }

        void WjHzFFG(PreparedStatement preparedStatement) throws SQLException {
            int n = preparedStatement.executeUpdate();
            this.WjHzFNO(n);
        }

        void WjHzFEF(Statement statement, String string) throws SQLException {
            int n = statement.executeUpdate(string);
            this.WjHzFNO(n);
        }
    }

    class WjHzpES
    extends WjHzFRS {
        WjHzpES(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
            super(ndDbMapClassKey, wjHzsCZ);
        }

        PreparedStatement WjHzFzA() throws SQLException {
            return NdDbServer.this.WjHzAYA.prepareStatement(this.WjHzFyY());
        }

        void WjHzFFG(PreparedStatement preparedStatement) throws SQLException {
            ResultSet resultSet = preparedStatement.executeQuery();
            this.WjHzFLM(resultSet);
        }

        void WjHzFEF(Statement statement, String string) throws SQLException {
            ResultSet resultSet = statement.executeQuery(string);
            this.WjHzFLM(resultSet);
        }
    }

    abstract class WjHzFRS {
        private String WjHzFyN = null;
        private String[] WjHzFyO;
        protected WjHzsCZ WjHzFyP;
        protected PreparedStatement WjHzFyQ;
        protected Statement WjHzFyR;
        private int WjHzFyS;
        private ResultSet WjHzFyT;
        private WjHzCOT WjHzFyU;
        private NdObjectHandle WjHzFyV;

        WjHzFRS(NdDbMapClassKey ndDbMapClassKey, WjHzsCZ wjHzsCZ) {
            this.WjHzFyV = ndDbMapClassKey != null ? ndDbMapClassKey.getContext() : null;
            this.WjHzFyP = wjHzsCZ;
            this.WjHzFyW(ndDbMapClassKey.getDbMapClass());
        }

        private void WjHzFyW(NdDbMapClass ndDbMapClass) {
            if (this.WjHzFyN == null) {
                String string = this.WjHzFyP.WjHzAwS();
                try {
                    if (string.indexOf(":") > -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        Vector<String> vector = null;
                        char[] cArray = string.toCharArray();
                        CharArrayReader charArrayReader = new CharArrayReader(cArray);
                        StreamTokenizer streamTokenizer = new StreamTokenizer(charArrayReader);
                        streamTokenizer.resetSyntax();
                        streamTokenizer.wordChars(97, 122);
                        streamTokenizer.wordChars(65, 90);
                        streamTokenizer.wordChars(160, 255);
                        streamTokenizer.whitespaceChars(0, 32);
                        streamTokenizer.wordChars(59, 59);
                        streamTokenizer.wordChars(44, 44);
                        streamTokenizer.wordChars(45, 45);
                        streamTokenizer.wordChars(34, 34);
                        streamTokenizer.wordChars(42, 42);
                        streamTokenizer.wordChars(60, 60);
                        streamTokenizer.wordChars(62, 62);
                        streamTokenizer.wordChars(38, 38);
                        streamTokenizer.wordChars(40, 40);
                        streamTokenizer.wordChars(58, 58);
                        streamTokenizer.wordChars(63, 63);
                        streamTokenizer.wordChars(43, 43);
                        streamTokenizer.wordChars(47, 47);
                        streamTokenizer.wordChars(62, 62);
                        streamTokenizer.wordChars(124, 124);
                        streamTokenizer.wordChars(41, 41);
                        streamTokenizer.wordChars(37, 37);
                        streamTokenizer.wordChars(39, 39);
                        streamTokenizer.wordChars(95, 95);
                        streamTokenizer.wordChars(32, 32);
                        streamTokenizer.wordChars(61, 61);
                        streamTokenizer.wordChars(94, 94);
                        streamTokenizer.wordChars(91, 91);
                        streamTokenizer.wordChars(64, 64);
                        streamTokenizer.wordChars(36, 36);
                        streamTokenizer.wordChars(93, 93);
                        streamTokenizer.wordChars(126, 126);
                        streamTokenizer.wordChars(35, 35);
                        streamTokenizer.wordChars(92, 92);
                        streamTokenizer.wordChars(33, 33);
                        streamTokenizer.wordChars(46, 46);
                        streamTokenizer.wordChars(123, 123);
                        streamTokenizer.wordChars(125, 125);
                        streamTokenizer.parseNumbers();
                        streamTokenizer.quoteChar(39);
                        int n = streamTokenizer.nextToken();
                        while (n != -1) {
                            if (streamTokenizer.sval != null) {
                                if (streamTokenizer.ttype == 39 && streamTokenizer.sval.startsWith(":")) {
                                    boolean bl = false;
                                    String[] stringArray = ndDbMapClass.getParamNames();
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        if (!streamTokenizer.sval.equals(":" + stringArray[i])) continue;
                                        if (vector == null) {
                                            vector = new Vector<String>();
                                        }
                                        vector.addElement(streamTokenizer.sval.substring(1, streamTokenizer.sval.length()));
                                        stringBuffer.append(" ?");
                                        bl = true;
                                        break;
                                    }
                                    if (!bl) {
                                        stringBuffer.append(" '" + streamTokenizer.sval + "'");
                                    }
                                } else if (streamTokenizer.ttype == 39) {
                                    stringBuffer.append(" '" + streamTokenizer.sval + "'");
                                } else {
                                    stringBuffer.append(" " + streamTokenizer.sval);
                                }
                            } else {
                                stringBuffer.append(" " + streamTokenizer.nval);
                            }
                            n = streamTokenizer.nextToken();
                        }
                        string = stringBuffer.toString();
                        if (vector != null) {
                            this.WjHzFyO = new String[vector.size()];
                            vector.copyInto(this.WjHzFyO);
                        }
                        NdDbServer.this.WjHzAYP(NdStrings.WjHzGtY("GeneratedSQLStatementOutOfIn", string, this.WjHzFyP.WjHzAwS(), NdDbServer.this.WjHzAYJ()));
                    }
                }
                catch (IOException iOException) {
                    NdDbServer.this.WjHzAYQ(NdStrings.WjHzGtX("CannotPrepareSQLForIn", this.WjHzFyP.WjHzAwS(), NdDbServer.this.WjHzAYJ()), iOException);
                    this.WjHzFyN = this.WjHzFyP.WjHzAwS();
                }
                this.WjHzFyN = string;
            }
        }

        NdObjectHandle WjHzFyX() {
            return this.WjHzFyV;
        }

        protected String WjHzFyY() {
            return this.WjHzFyN;
        }

        protected NdDbBoundValue[] WjHzFyZ() {
            if (this.WjHzFyO != null) {
                WjHzriI wjHzriI = NdDbServer.this.WjHzAYK();
                if (wjHzriI == null) {
                    throw new WjHzsPS(NdStrings.WjHzGtW("CannotHaveBoundParametersWithout", this.WjHzFyN));
                }
                NdDbBoundValue[] ndDbBoundValueArray = new NdDbBoundValue[this.WjHzFyO.length];
                for (int i = 0; i < this.WjHzFyO.length; ++i) {
                    ndDbBoundValueArray[i] = wjHzriI.WjHzrfF(this.WjHzFyO[i]);
                }
                return ndDbBoundValueArray;
            }
            return null;
        }

        abstract PreparedStatement WjHzFzA() throws SQLException;

        public void WjHzFAB() {
            try {
                this.WjHzFyQ = this.WjHzFzA();
                if (this.WjHzFQR()) {
                    NdDbServer.WjHzAYR(this.WjHzFyX(), this);
                }
                NdDbServer.this.WjHzAYP(NdStrings.WjHzGtX("PreparedStatementIn", this.WjHzFyY(), NdDbServer.this.WjHzAYJ()));
            }
            catch (Throwable throwable) {
                NdDbServer.this.WjHzAYQ(NdDbServer.this.WjHzAYD(this.WjHzFyY()), throwable);
                throw new WjHzsPS(throwable);
            }
        }

        protected void WjHzFBC(PreparedStatement preparedStatement, NdDbBoundValue[] ndDbBoundValueArray) throws SQLException {
            block7: for (int i = 0; i < ndDbBoundValueArray.length; ++i) {
                int n = ndDbBoundValueArray[i].getType();
                if (ndDbBoundValueArray[i] == null) {
                    preparedStatement.setNull(i + 1, 0);
                    continue;
                }
                Object object = ndDbBoundValueArray[i].getValue();
                if (object == null) {
                    preparedStatement.setNull(i + 1, n);
                    continue;
                }
                switch (n) {
                    case 2: 
                    case 3: {
                        preparedStatement.setObject(i + 1, object, n, ndDbBoundValueArray[i].getScale());
                        continue block7;
                    }
                    case -7: {
                        if (object instanceof Boolean) {
                            preparedStatement.setBoolean(i + 1, (Boolean)object);
                            continue block7;
                        }
                        preparedStatement.setObject(i + 1, object, n);
                        continue block7;
                    }
                    case 4: {
                        int n2;
                        if (object instanceof BigDecimal) {
                            n2 = NdDbServer.this.WjHzAYA.getVendor();
                            if (n2 == 0) {
                                preparedStatement.setInt(i + 1, ((BigDecimal)object).intValue());
                                continue block7;
                            }
                            preparedStatement.setObject(i + 1, object, n);
                            continue block7;
                        }
                        preparedStatement.setObject(i + 1, object, n);
                        continue block7;
                    }
                    case 8: {
                        int n2;
                        if (object instanceof BigDecimal) {
                            n2 = NdDbServer.this.WjHzAYA.getVendor();
                            if (n2 == 0) {
                                preparedStatement.setDouble(i + 1, ((BigDecimal)object).doubleValue());
                                continue block7;
                            }
                            preparedStatement.setObject(i + 1, object, n);
                            continue block7;
                        }
                        preparedStatement.setObject(i + 1, object, n);
                        continue block7;
                    }
                    case -6: 
                    case 5: {
                        if (object instanceof Short) {
                            preparedStatement.setInt(i + 1, ((Short)object).intValue());
                            continue block7;
                        }
                        preparedStatement.setObject(i + 1, object, n);
                        continue block7;
                    }
                    default: {
                        preparedStatement.setObject(i + 1, object, n);
                    }
                }
            }
        }

        protected void WjHzFCD(CallableStatement callableStatement, NdDbBoundValue[] ndDbBoundValueArray) throws SQLException {
            block10: for (int i = 0; i < ndDbBoundValueArray.length; ++i) {
                if (ndDbBoundValueArray[i] == null) {
                    throw new WjHzsPS(NdStrings.WjHzGtX("CannotHaveNullBoundParameter", "" + i, this.WjHzFyN));
                }
                int n = ndDbBoundValueArray[i].getType();
                if (ndDbBoundValueArray[i].getPurpose() == 0 || ndDbBoundValueArray[i].getPurpose() == 1) {
                    Object object = ndDbBoundValueArray[i].getValue();
                    if (object == null) {
                        callableStatement.setNull(i + 1, n);
                    } else {
                        switch (n) {
                            case 2: 
                            case 3: {
                                callableStatement.setObject(i + 1, object, n, ndDbBoundValueArray[i].getScale());
                                break;
                            }
                            case -7: {
                                if (object instanceof Boolean) {
                                    callableStatement.setBoolean(i + 1, (boolean)((Boolean)object));
                                    break;
                                }
                                callableStatement.setObject(i + 1, object, n);
                                break;
                            }
                            case 4: {
                                int n2;
                                if (object instanceof BigDecimal) {
                                    n2 = NdDbServer.this.WjHzAYA.getVendor();
                                    if (n2 == 0) {
                                        callableStatement.setInt(i + 1, ((BigDecimal)object).intValue());
                                        break;
                                    }
                                    callableStatement.setObject(i + 1, object, n);
                                    break;
                                }
                                callableStatement.setObject(i + 1, object, n);
                                break;
                            }
                            case 8: {
                                int n2;
                                if (object instanceof BigDecimal) {
                                    n2 = NdDbServer.this.WjHzAYA.getVendor();
                                    if (n2 == 0) {
                                        callableStatement.setDouble(i + 1, ((BigDecimal)object).doubleValue());
                                        break;
                                    }
                                    callableStatement.setObject(i + 1, object, n);
                                    break;
                                }
                                callableStatement.setObject(i + 1, object, n);
                                break;
                            }
                            case -6: 
                            case 5: {
                                if (object instanceof Short) {
                                    callableStatement.setInt(i + 1, ((Short)object).intValue());
                                    break;
                                }
                                callableStatement.setObject(i + 1, object, n);
                                break;
                            }
                            default: {
                                callableStatement.setObject(i + 1, object, n);
                            }
                        }
                    }
                }
                if (ndDbBoundValueArray[i].getPurpose() != 1 && ndDbBoundValueArray[i].getPurpose() != 2) continue;
                switch (ndDbBoundValueArray[i].getType()) {
                    case 2: 
                    case 3: {
                        callableStatement.registerOutParameter(i + 1, n, ndDbBoundValueArray[i].getScale());
                        continue block10;
                    }
                    default: {
                        callableStatement.registerOutParameter(i + 1, n);
                    }
                }
            }
        }

        protected void WjHzFDE(CallableStatement callableStatement, NdDbBoundValue[] ndDbBoundValueArray) throws SQLException {
            int n;
            WjHzriI wjHzriI = NdDbServer.this.WjHzAYK();
            if (wjHzriI == null) {
                throw new WjHzsPS(NdStrings.WjHzGtW("CannotHaveBoundParametersWithout", this.WjHzFyN));
            }
            for (n = 0; n < ndDbBoundValueArray.length; ++n) {
                if (ndDbBoundValueArray[n] == null) {
                    throw new WjHzsPS(NdStrings.WjHzGtX("CannotHaveNullBoundParameter", "" + n, this.WjHzFyN));
                }
                if (ndDbBoundValueArray[n].getPurpose() != 1 && ndDbBoundValueArray[n].getPurpose() != 2) continue;
                ndDbBoundValueArray[n] = new NdDbBoundValue(ndDbBoundValueArray[n], callableStatement.getObject(n + 1));
                if (NdDbServer.this.getConnectionInfo().getConvertNull() || !callableStatement.wasNull()) continue;
                ndDbBoundValueArray[n] = new NdDbBoundValue(ndDbBoundValueArray[n], null);
            }
            for (n = 0; n < ndDbBoundValueArray.length; ++n) {
                wjHzriI.WjHzrhH(ndDbBoundValueArray[n].getName(), ndDbBoundValueArray[n].getValue());
            }
        }

        abstract void WjHzFEF(Statement var1, String var2) throws SQLException;

        abstract void WjHzFFG(PreparedStatement var1) throws SQLException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void WjHzFGH() {
            NdDbConnection ndDbConnection;
            NdDbConnection ndDbConnection2 = ndDbConnection = NdDbServer.this.WjHzAYA;
            synchronized (ndDbConnection2) {
                Statement statement;
                String string = this.WjHzFyY();
                NdDbBoundValue[] ndDbBoundValueArray = this.WjHzFyZ();
                if (ndDbBoundValueArray != null) {
                    this.WjHzFHI(ndDbBoundValueArray);
                    return;
                }
                if (this.WjHzFyQ == null) {
                    try {
                        statement = ndDbConnection.createStatement();
                    }
                    catch (Throwable throwable) {
                        NdDbServer.this.WjHzAYQ(WjHzAUW, throwable);
                        throw new WjHzsPS(throwable);
                    }
                } else {
                    statement = this.WjHzFyQ;
                }
                if (this.WjHzFyR != null && this.WjHzFyR != this.WjHzFyQ) {
                    this.WjHzFPQ();
                }
                this.WjHzFyR = statement;
                if (this.WjHzFyT != null) {
                    try {
                        this.WjHzFyT.close();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (Throwable throwable) {
                        NdDbServer.this.WjHzAYQ(NdDbServer.this.WjHzAYD(string), throwable);
                        throw new WjHzsPS(throwable);
                    }
                }
                this.WjHzFyS = -1;
                this.WjHzFyT = null;
                this.WjHzFyU = null;
                try {
                    this.WjHzFEF(statement, string);
                    NdDbServer.this.WjHzAYP(NdStrings.WjHzGtX("ExecutedQueryIn", string, NdDbServer.this.WjHzAYJ()));
                }
                catch (Throwable throwable) {
                    this.WjHzFyS = -1;
                    this.WjHzFyT = null;
                    this.WjHzFyU = null;
                    NdDbServer.this.WjHzAYQ(NdStrings.WjHzGtX("ProblemExecutingQueryIn", string, NdDbServer.this.WjHzAYJ()), throwable);
                    throw new WjHzsPS(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void WjHzFHI(NdDbBoundValue[] ndDbBoundValueArray) {
            NdDbConnection ndDbConnection;
            NdDbConnection ndDbConnection2 = ndDbConnection = NdDbServer.this.WjHzAYA;
            synchronized (ndDbConnection2) {
                PreparedStatement preparedStatement;
                String string = this.WjHzFyY();
                if (this.WjHzFyQ == null) {
                    try {
                        preparedStatement = this.WjHzFzA();
                    }
                    catch (Throwable throwable) {
                        NdDbServer.this.WjHzAYQ(NdDbServer.this.WjHzAYD(string), throwable);
                        throw new WjHzsPS(throwable);
                    }
                } else {
                    preparedStatement = this.WjHzFyQ;
                }
                if (this.WjHzFyR != null && this.WjHzFyR != this.WjHzFyQ) {
                    this.WjHzFPQ();
                }
                this.WjHzFyR = preparedStatement;
                try {
                    if (preparedStatement instanceof CallableStatement) {
                        this.WjHzFCD((CallableStatement)preparedStatement, ndDbBoundValueArray);
                    } else {
                        this.WjHzFBC(preparedStatement, ndDbBoundValueArray);
                    }
                }
                catch (Throwable throwable) {
                    throw new WjHzsPS(throwable);
                }
                if (this.WjHzFyT != null) {
                    try {
                        this.WjHzFyT.close();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (Throwable throwable) {
                        NdDbServer.this.WjHzAYQ(NdDbServer.this.WjHzAYD(string), throwable);
                        throw new WjHzsPS(throwable);
                    }
                }
                this.WjHzFyS = -1;
                this.WjHzFyT = null;
                this.WjHzFyU = null;
                try {
                    this.WjHzFFG(preparedStatement);
                    if (preparedStatement instanceof CallableStatement) {
                        this.WjHzFDE((CallableStatement)preparedStatement, ndDbBoundValueArray);
                    }
                    String string2 = "";
                    if (ndDbBoundValueArray != null) {
                        for (int i = 0; i < ndDbBoundValueArray.length; ++i) {
                            if (i > 0) {
                                string2 = string2 + ", ";
                            }
                            string2 = ndDbBoundValueArray[i] != null ? string2 + ndDbBoundValueArray[i].getValue() : string2 + NdDbServer.WjHzAWY;
                        }
                    }
                    String string3 = NdStrings.WjHzGtY("ExecutedQueryWithValuesIn", string, string2, NdDbServer.this.WjHzAYJ());
                    WjHzFYW.WjHzFYR(string3);
                }
                catch (Throwable throwable) {
                    this.WjHzFyS = -1;
                    this.WjHzFyT = null;
                    this.WjHzFyU = null;
                    String string4 = "";
                    if (ndDbBoundValueArray != null) {
                        for (int i = 0; i < ndDbBoundValueArray.length; ++i) {
                            if (i > 0) {
                                string4 = string4 + ", ";
                            }
                            string4 = ndDbBoundValueArray[i] != null ? string4 + ndDbBoundValueArray[i].getValue() : string4 + NdDbServer.WjHzAWY;
                        }
                    }
                    NdDbServer.this.WjHzAYQ(NdStrings.WjHzGtY("CannotExecuteUpdateQueryIn", string, string4, NdDbServer.this.WjHzAYJ()), throwable);
                    throw new WjHzsPS(throwable);
                }
            }
        }

        public WjHzCOT WjHzFIJ() {
            int n;
            ResultSetMetaData resultSetMetaData;
            if (this.WjHzFyT == null) {
                return null;
            }
            if (this.WjHzFyU != null) {
                return this.WjHzFyU;
            }
            WjHzCOT wjHzCOT = new WjHzCOT();
            try {
                resultSetMetaData = this.WjHzFyT.getMetaData();
                n = resultSetMetaData.getColumnCount();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                boolean bl = false;
                throw new WjHzsPS(throwable);
            }
            if (resultSetMetaData != null) {
                wjHzCOT.WjHzCIN(n);
                for (int i = 0; i < n; ++i) {
                    int n2;
                    int n3;
                    String string;
                    try {
                        string = resultSetMetaData.getColumnLabel(i + 1);
                        n3 = resultSetMetaData.getColumnType(i + 1);
                        n2 = resultSetMetaData.getColumnDisplaySize(i + 1);
                    }
                    catch (SQLException sQLException) {
                        string = "";
                        n3 = 1;
                        n2 = -1;
                    }
                    catch (Throwable throwable) {
                        throw new WjHzsPS(throwable);
                    }
                    wjHzCOT.WjHzCJO(i, string, n3, n2);
                }
            }
            this.WjHzFyU = wjHzCOT;
            return wjHzCOT;
        }

        public NdDbQueryResults WjHzFJK(int n) {
            NdDbQueryResults ndDbQueryResults;
            if (this.WjHzFyT == null) {
                return null;
            }
            if (this.WjHzFyU == null) {
                this.WjHzFIJ();
            }
            try {
                ndDbQueryResults = new NdDbQueryResults();
                ndDbQueryResults.WjHzAsN(true);
                int n2 = 0;
                while (this.WjHzFyT.next()) {
                    int n3;
                    Object[] objectArray = new Object[this.WjHzFyU.WjHzCKP()];
                    for (n3 = 1; n3 <= this.WjHzFyU.WjHzCKP(); ++n3) {
                        objectArray[n3 - 1] = this.WjHzFyT.getObject(n3);
                        if (NdDbServer.this.getConnectionInfo().getConvertNull() || !this.WjHzFyT.wasNull()) continue;
                        objectArray[n3 - 1] = null;
                    }
                    if (NdDotNETLib.isDotNETSupportEnabled()) {
                        for (n3 = 0; n3 < objectArray.length; ++n3) {
                            if (!(objectArray[n3] instanceof BigDecimal)) continue;
                            try {
                                String string = this.WjHzFyT.getString(n3 + 1);
                                if (string == null || objectArray[n3] == null || string.equals(objectArray[n3].toString())) continue;
                                objectArray[n3] = new BigDecimal(string);
                                continue;
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                    WjHzAYY wjHzAYY = new WjHzAYY();
                    wjHzAYY.WjHzAYV(objectArray);
                    ndDbQueryResults.WjHzArM(wjHzAYY);
                    if (n <= 0 || ++n2 < n) continue;
                    ndDbQueryResults.WjHzAsN(false);
                    break;
                }
            }
            catch (SQLException sQLException) {
                String string = sQLException.getSQLState();
                if (string.equals("JZ0R0")) {
                    ndDbQueryResults = new NdDbQueryResults();
                    ndDbQueryResults.WjHzAsN(true);
                }
                NdDbServer.this.WjHzAYQ(NdStrings.WjHzGtU("CannotGetResults"), sQLException);
                NdDbQueryResults ndDbQueryResults2 = new NdDbQueryResults();
                ndDbQueryResults2.WjHzAsN(true);
                throw new WjHzsPS(sQLException);
            }
            catch (Throwable throwable) {
                NdDbServer.this.WjHzAYQ(NdStrings.WjHzGtU("CannotGetResults"), throwable);
                NdDbQueryResults ndDbQueryResults3 = new NdDbQueryResults();
                ndDbQueryResults3.WjHzAsN(true);
                throw new WjHzsPS(throwable);
            }
            return ndDbQueryResults;
        }

        ResultSet WjHzFKL() {
            return this.WjHzFyT;
        }

        void WjHzFLM(ResultSet resultSet) {
            this.WjHzFyT = resultSet;
        }

        int WjHzFMN() {
            return this.WjHzFyS;
        }

        void WjHzFNO(int n) {
            this.WjHzFyS = n;
        }

        protected void finalize() {
            this.WjHzFPQ();
        }

        public void WjHzFOP() {
            if (this.WjHzFyT != null) {
                try {
                    this.WjHzFyT.close();
                }
                catch (SQLException sQLException) {
                }
                catch (Throwable throwable) {
                    this.WjHzFyT = null;
                    throw new WjHzsPS(throwable);
                }
            }
            this.WjHzFyT = null;
        }

        public void WjHzFPQ() {
            block6: {
                this.WjHzFOP();
                try {
                    if (this.WjHzFyR == null) break block6;
                    try {
                        this.WjHzFyR.close();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (Throwable throwable) {
                        throw new WjHzsPS(throwable);
                    }
                    if (this.WjHzFyQ == this.WjHzFyR) {
                        this.WjHzFyQ = null;
                    }
                    this.WjHzFyR = null;
                }
                catch (Throwable throwable) {
                    NdDbServer.this.WjHzAYQ(NdStrings.WjHzGtW("ProblemClosingStatement", this.WjHzFyY()), throwable);
                    throw new WjHzsPS(throwable);
                }
            }
        }

        boolean WjHzFQR() {
            if (WjHzAVX) {
                return this.WjHzFyQ != null;
            }
            return false;
        }
    }
}

