/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.system;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.objects.java.NdCalendarValue;
import com.blazesoft.objects.java.NdDate;
import com.blazesoft.objects.java.NdDuration;
import com.blazesoft.objects.java.NdTime;
import com.blazesoft.objects.java.NdTimestamp;
import com.blazesoft.system.NdRuntimeExceptionHandler;
import com.blazesoft.system.NdSemaphore;
import com.blazesoft.system.NdStrings;
import com.blazesoft.util.NdSupportJavaClass;
import com.blazesoft.util.NdWrappedExceptionSupport;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NdClock
implements Runnable,
Serializable,
NdSupportJavaClass,
Cloneable {
    static final long serialVersionUID = 8522343480456949017L;
    private transient WjHzMgI WjHzMaV = new WjHzMgI();
    private transient NdTimestamp WjHzMJK;
    private transient NdTime WjHzMKL;
    private transient NdDate WjHzMLM;
    private boolean WjHzMaY = false;
    private long WjHzMaZ = 0L;
    private boolean WjHzMMN = false;
    private NdTimestamp WjHzMNO;
    private NdTimestamp WjHAQqG;
    private NdRuntimeExceptionHandler WjHzMcB;
    private transient NdCalendar WjHzMaW;
    private transient NdSemaphore WjHzMdC;
    private transient Thread WjHzNnY = null;
    private transient PropertyChangeSupport WjHzMbA = new PropertyChangeSupport(this);

    public NdClock(NdCalendar ndCalendar) {
        this.setCalendarDateTime(ndCalendar);
        this.WjHzSCC();
    }

    public NdClock(NdCalendar ndCalendar, long l) {
        this(ndCalendar);
        this.WjHzMaZ = l;
        this.WjHzSDD();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            this.abortRunning(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        NdClock ndClock = (NdClock)super.clone();
        ndClock.setCalendarDateTime((NdCalendar)this.WjHzMaW.clone());
        ndClock.WjHzMMN = this.WjHzMMN;
        if (this.WjHzMNO != null) {
            ndClock.WjHzMNO = (NdTimestamp)this.WjHzMNO.clone();
        }
        if (this.WjHAQqG != null) {
            ndClock.WjHAQqG = (NdTimestamp)this.WjHAQqG.clone();
        }
        ndClock.WjHzMbA = new PropertyChangeSupport(ndClock);
        ndClock.WjHzMaV = new WjHzMgI();
        ndClock.WjHzNnY = null;
        ndClock.WjHzMdC = null;
        ndClock.WjHzSCC();
        ndClock.WjHzSDD();
        this.WjHzSDD();
        return ndClock;
    }

    public void setCalendarDateTime(NdCalendar ndCalendar) {
        this.WjHzMaW = ndCalendar;
        this.WjHzMJK = this.WjHzSBB();
        this.WjHzMKL = this.WjHzUUM(null);
        this.WjHzMLM = this.WjHzUVN(null);
    }

    private NdTime WjHzUUM(NdTimestamp ndTimestamp) {
        return ndTimestamp == null ? this.WjHzMaW.currentTime(true) : ndTimestamp.getTime();
    }

    private NdDate WjHzUVN(NdTimestamp ndTimestamp) {
        return ndTimestamp == null ? this.WjHzMaW.currentDate() : ndTimestamp.getDate();
    }

    private NdTimestamp WjHzSBB() {
        return this.WjHzMaW.currentTimestamp(true);
    }

    private void WjHzSCC() {
        this.WjHzMdC = new NdSemaphore(0);
    }

    private void WjHzSDD() {
        if (this.WjHzMaY) {
            return;
        }
        if (this.WjHzMaZ > 0L) {
            this.WjHzNnY = new Thread(this);
            this.WjHzMaY = true;
            this.WjHzNnY.setDaemon(true);
            this.WjHzNnY.start();
        }
    }

    public NdDate getCurrentDate() {
        return this.WjHzMLM;
    }

    public void setCurrentDate(NdDate ndDate) {
        this.WjHzMeD(new NdTimestamp(ndDate, this.WjHzMKL, true));
    }

    public NdTime getCurrentTime() {
        return this.WjHzMKL;
    }

    public void setCurrentTime(NdTime ndTime) {
        this.WjHzMeD(new NdTimestamp(this.WjHzMLM, ndTime, true));
    }

    public NdTimestamp getCurrentTimestamp() {
        return this.WjHzMJK;
    }

    public void setCurrentTimestamp(NdTimestamp ndTimestamp) {
        this.WjHzMeD(ndTimestamp);
    }

    public String timestamp() {
        return "" + this.WjHzMJK;
    }

    public String heartbeat() {
        return "" + this.WjHzMaZ + " ms";
    }

    public boolean setHeartbeat(long l) {
        boolean bl = true;
        if (l < 0L) {
            bl = false;
        } else {
            this.WjHzMaZ = l;
        }
        if (this.isRunning()) {
            if (l == 0L) {
                try {
                    this.stopRunning(true);
                }
                catch (InterruptedException interruptedException) {
                    throw new NdWrappedRuntimeException(interruptedException);
                }
            } else {
                this.WjHzNnY.interrupt();
            }
        }
        this.WjHzSDD();
        return bl;
    }

    public synchronized void resetClock(String string) {
        NdCalendarValue ndCalendarValue;
        NdTimestamp ndTimestamp = this.WjHzMaW.tryParseTimestamp(string);
        if (ndTimestamp == null && (ndCalendarValue = this.WjHzMaW.tryParseDate(string)) != null) {
            ndTimestamp = new NdTimestamp((NdDate)ndCalendarValue, this.getCurrentTime(), true);
        }
        if (ndTimestamp == null && (ndCalendarValue = this.WjHzMaW.tryParseTime(string)) != null) {
            ndTimestamp = new NdTimestamp(this.getCurrentDate(), (NdTime)ndCalendarValue, true);
        }
        if (ndTimestamp == null) {
            throw new RuntimeException(NdStrings.WjHzADA("InvalidDateFormat", string));
        }
        if (!this.WjHzMMN) {
            this.WjHAQqG = this.WjHzSBB();
            this.WjHzMMN = true;
        } else {
            this.WjHAQqG.add(this.WjHzSBB().subtractInMilliseconds(this.WjHAQqG));
            this.WjHzMNO = null;
        }
        this.WjHzMeD(ndTimestamp);
    }

    public synchronized void updateClock() {
        this.WjHzMeD(this.WjHzSBB());
    }

    public void resetTimeZone(String string) throws RuntimeException {
        this.WjHzMaW.setDefaultTimeZoneFromString(string);
        this.updateClock();
    }

    private synchronized void WjHzMeD(NdTimestamp ndTimestamp) {
        NdTimestamp ndTimestamp2 = this.WjHzMJK;
        if (this.WjHzMMN) {
            NdDuration ndDuration;
            if (this.WjHzMNO == null) {
                this.WjHzMNO = ndTimestamp;
                ndDuration = new NdDuration(this.WjHzMaW, 16, 0L);
            } else {
                ndDuration = ndTimestamp.subtractInMilliseconds(this.WjHAQqG);
            }
            this.WjHzMJK = this.WjHzMNO.add(ndDuration);
        } else {
            this.WjHzMJK = ndTimestamp;
        }
        this.WjHzMKL = this.WjHzUUM(this.WjHzMJK);
        this.WjHzMLM = this.WjHzUVN(this.WjHzMJK);
        this.WjHzMPQ(ndTimestamp2);
    }

    private synchronized void WjHzMPQ(NdTimestamp ndTimestamp) {
        this.WjHzMbA.firePropertyChange("currentDate", ndTimestamp.getDate(), this.WjHzMLM);
        this.WjHzMbA.firePropertyChange("currentTime", ndTimestamp.getTime(), this.WjHzMKL);
        this.WjHzMbA.firePropertyChange("currentTimestamp", ndTimestamp, this.WjHzMJK);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.WjHzMbA.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.WjHzMbA.removePropertyChangeListener(propertyChangeListener);
    }

    public void start() {
        this.WjHzNnY.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.WjHzMaY) {
            WjHzMgI wjHzMgI = this.WjHzMaV;
            synchronized (wjHzMgI) {
                try {
                    this.WjHzMaV.wait(this.WjHzMaZ);
                }
                catch (InterruptedException interruptedException) {
                    this.WjHzMaY = false;
                }
                catch (RuntimeException runtimeException) {
                    this.WjHzMaY = false;
                    this.WjHzMcB.handleRuntimeException(runtimeException, this);
                }
            }
            if (!this.WjHzMaY) continue;
            try {
                this.WjHzMeD(this.WjHzSBB());
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = NdWrappedExceptionSupport.getOriginalSourceThrowable(runtimeException);
                if (throwable instanceof InterruptedException) {
                    this.WjHzMaY = false;
                    continue;
                }
                this.WjHzMcB.handleRuntimeException(runtimeException, this);
            }
        }
        try {
            this.WjHzMdC.release();
            this.WjHzNnY = null;
        }
        catch (RuntimeException runtimeException) {
            this.WjHzMcB.handleRuntimeException(runtimeException, this);
        }
    }

    public void stopRunning(boolean bl) throws InterruptedException {
        if (!this.WjHzMaY) {
            return;
        }
        this.WjHzMaY = false;
        if (bl && this.WjHzNnY != null) {
            this.WjHzNnY.interrupt();
            this.WjHzMdC.acquire();
        }
    }

    public void stopRunning() throws InterruptedException {
        this.WjHzMaY = false;
    }

    public void abortRunning(boolean bl) throws InterruptedException {
        this.WjHzMaY = false;
        if (bl && this.WjHzNnY != null) {
            this.WjHzNnY.interrupt();
            this.WjHzMdC.acquire();
        }
    }

    public void abortRunning() throws InterruptedException {
        this.WjHzMaY = false;
    }

    public void setRuntimeExceptionHandler(NdRuntimeExceptionHandler ndRuntimeExceptionHandler) {
        this.WjHzMcB = ndRuntimeExceptionHandler;
    }

    public void notifyBeginRun() {
    }

    public void notifyEndRun() {
    }

    public synchronized boolean isRunning() {
        return this.WjHzMaY && this.WjHzNnY != null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, InterruptedException {
        this.stopRunning(true);
        NdDotNETLib.defaultWriteObjectHelper(objectOutputStream, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NdDotNETLib.defaultReadObjectHelper(objectInputStream, this);
        this.WjHzMbA = new PropertyChangeSupport(this);
        this.WjHzMaV = new WjHzMgI();
        this.WjHzSCC();
        this.WjHzSDD();
    }

    private static class WjHzMgI {
        private WjHzMgI() {
        }
    }
}

