/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.system;

import com.blazesoft.system.NdExecutor;
import com.blazesoft.system.NdSynchronousChannel;
import com.blazesoft.system.NdSynchronousChannelAbortException;
import com.blazesoft.system.NdThreadFactory;

public class NdPooledExecutor
implements NdExecutor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    private NdThreadFactory WjHzGhL = new NdThreadFactory(){

        public Thread newThread(Runnable runnable) {
            return new Thread(NdPooledExecutor.this.getThreadGroup(), runnable);
        }
    };
    protected NdBlockedExecutionHandler _blockedExecutionHandler;
    protected int _maxPoolSize = Integer.MAX_VALUE;
    protected long _keepAliveTime = 60000L;
    protected int _poolSize;
    protected Object _poolSizeLock = new Object();
    protected NdSynchronousChannel _handOff;
    protected ThreadGroup _threadGroup;

    private ThreadGroup WjHzGiM() {
        return new ThreadGroup(this.toString());
    }

    public NdPooledExecutor() {
        this(Integer.MAX_VALUE, null);
    }

    public NdPooledExecutor(int n) {
        this(n, null);
    }

    public NdPooledExecutor(int n, ThreadGroup threadGroup) {
        this._maxPoolSize = n;
        this._threadGroup = threadGroup != null ? threadGroup : this.WjHzGiM();
        this._handOff = new NdSynchronousChannel();
        this.runWhenBlocked();
    }

    public synchronized int getMaximumPoolSize() {
        return this._maxPoolSize;
    }

    public synchronized void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this._maxPoolSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        Object object = this._poolSizeLock;
        synchronized (object) {
            return this._poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int WjHzGjN() {
        Object object = this._poolSizeLock;
        synchronized (object) {
            ++this._poolSize;
            return this._poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int WjHzGkO() {
        Object object = this._poolSizeLock;
        synchronized (object) {
            --this._poolSize;
            return this._poolSize;
        }
    }

    public synchronized long getKeepAliveTime() {
        return this._keepAliveTime;
    }

    public synchronized void setKeepAliveTime(long l) {
        this._keepAliveTime = l;
    }

    public ThreadGroup getThreadGroup() {
        return this._threadGroup;
    }

    public synchronized void setThreadFactory(NdThreadFactory ndThreadFactory) {
        this.WjHzGhL = ndThreadFactory;
    }

    private synchronized NdBlockedExecutionHandler WjHzGlP() {
        return this._blockedExecutionHandler;
    }

    public synchronized void runWhenBlocked() {
        this._blockedExecutionHandler = new NdRunWhenBlocked();
    }

    public synchronized void waitWhenBlocked() {
        this._blockedExecutionHandler = new NdWaitWhenBlocked();
    }

    public synchronized void discardWhenBlocked() {
        this._blockedExecutionHandler = new NdDiscardWhenBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) throws InterruptedException, IllegalStateException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        do {
            NdPooledExecutor ndPooledExecutor = this;
            synchronized (ndPooledExecutor) {
                int n = this.WjHzGjN();
                if (n > 1 && this._handOff.offer(runnable, 0L)) {
                    this.WjHzGkO();
                    return;
                }
                if (n <= this.getMaximumPoolSize()) {
                    Thread thread = this.WjHzGhL.newThread(new NdWorker(runnable));
                    thread.start();
                    return;
                }
                this.WjHzGkO();
            }
        } while (!this.WjHzGlP().WjHBnmQ(runnable));
    }

    public void shutdown() {
        this._handOff.abort();
    }

    protected class NdDiscardWhenBlocked
    extends NdBlockedExecutionHandler {
        protected NdDiscardWhenBlocked() {
        }

        protected boolean WjHBnmQ(Runnable runnable) throws IllegalStateException {
            return true;
        }
    }

    protected class NdWaitWhenBlocked
    extends NdBlockedExecutionHandler {
        protected NdWaitWhenBlocked() {
        }

        protected boolean WjHBnmQ(Runnable runnable) throws IllegalStateException {
            try {
                NdPooledExecutor.this._handOff.put(runnable);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    protected class NdRunWhenBlocked
    extends NdBlockedExecutionHandler {
        protected NdRunWhenBlocked() {
        }

        protected boolean WjHBnmQ(Runnable runnable) throws IllegalStateException {
            runnable.run();
            return true;
        }
    }

    protected abstract class NdBlockedExecutionHandler {
        protected NdBlockedExecutionHandler() {
        }

        abstract boolean WjHBnmQ(Runnable var1) throws IllegalStateException;
    }

    protected class NdWorker
    implements Runnable {
        protected Runnable WjHBmYH;

        NdWorker(Runnable runnable) {
            this.WjHBmYH = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable runnable = this.WjHBmYH;
                this.WjHBmYH = null;
                while (runnable != null && !Thread.interrupted()) {
                    runnable.run();
                    runnable = (Runnable)NdPooledExecutor.this._handOff.poll(NdPooledExecutor.this.getKeepAliveTime());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (NdSynchronousChannelAbortException ndSynchronousChannelAbortException) {
            }
            finally {
                NdPooledExecutor.this.WjHzGkO();
            }
        }
    }
}

