/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.system;

import com.blazesoft.system.NdSemaphore;

public final class NdWaiterPreferenceSemaphore
extends NdSemaphore {
    protected int _waits = 0;

    public NdWaiterPreferenceSemaphore(int n) {
        super(n);
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        NdWaiterPreferenceSemaphore ndWaiterPreferenceSemaphore = this;
        synchronized (ndWaiterPreferenceSemaphore) {
            if (this._permits > this._waits) {
                --this._permits;
                return;
            }
            ++this._waits;
            try {
                do {
                    this.wait();
                } while (this._permits <= 0);
                --this._waits;
                --this._permits;
                return;
            }
            catch (InterruptedException interruptedException) {
                --this._waits;
                this.notify();
                throw interruptedException;
            }
        }
    }

    public boolean attempt(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        NdWaiterPreferenceSemaphore ndWaiterPreferenceSemaphore = this;
        synchronized (ndWaiterPreferenceSemaphore) {
            if (this._permits > this._waits) {
                --this._permits;
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            ++this._waits;
            long l2 = System.currentTimeMillis();
            long l3 = l;
            try {
                do {
                    this.wait(l3);
                    if (this._permits <= 0) continue;
                    --this._waits;
                    --this._permits;
                    return true;
                } while ((l3 = l - (System.currentTimeMillis() - l2)) > 0L);
                --this._waits;
                return false;
            }
            catch (InterruptedException interruptedException) {
                --this._waits;
                this.notify();
                throw interruptedException;
            }
        }
    }

    public synchronized void release() {
        ++this._permits;
        this.notify();
    }

    public synchronized void release(int n) {
        this._permits += n;
        for (int i = 0; i < n; ++i) {
            this.notify();
        }
    }
}

