/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.test;

import com.blazesoft.test.NdAssertionFailedError;
import com.blazesoft.test.NdComparisonFailure;
import com.blazesoft.test.NdStrings;
import com.blazesoft.util.NdSupportJavaClass;

public class NdAssert
implements NdSupportJavaClass {
    public static final String ASSERT_CONTEXT = "nd.test.assertcontext";

    protected NdAssert() {
    }

    public static void assertTrue(String string, boolean bl) {
        if (!bl) {
            NdAssert.fail(string);
        }
    }

    public static void assertTrue(boolean bl) {
        NdAssert.assertTrue(null, bl);
    }

    public static void assertFalse(String string, boolean bl) {
        NdAssert.assertTrue(string, !bl);
    }

    public static void assertFalse(boolean bl) {
        NdAssert.assertFalse(null, bl);
    }

    public static void fail(String string) {
        throw new NdAssertionFailedError(string);
    }

    public static void fail() {
        NdAssert.fail(null);
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        NdAssert.failNotEquals(string, object, object2);
    }

    public static void assertEquals(Object object, Object object2) {
        NdAssert.assertEquals(null, object, object2);
    }

    public static void assertEquals(String string, String string2, String string3) {
        if (string2 == null && string3 == null) {
            return;
        }
        if (string2 != null && string2.equals(string3)) {
            return;
        }
        throw new NdComparisonFailure(string, string2, string3);
    }

    public static void assertEquals(String string, String string2) {
        NdAssert.assertEquals(null, string, string2);
    }

    public static void assertEquals(String string, double d, double d2, double d3) {
        if (NdAssert.compare(d, d2) != 0 && !(Math.abs(d - d2) <= d3)) {
            NdAssert.failNotEquals(string, new Double(d), new Double(d2));
        }
    }

    public static void assertEquals(double d, double d2, double d3) {
        NdAssert.assertEquals(null, d, d2, d3);
    }

    public static void assertEquals(String string, float f, float f2, float f3) {
        if (Float.isInfinite(f)) {
            if (f != f2) {
                NdAssert.failNotEquals(string, new Float(f), new Float(f2));
            }
        } else if (!(Math.abs(f - f2) <= f3)) {
            NdAssert.failNotEquals(string, new Float(f), new Float(f2));
        }
    }

    public static void assertEquals(float f, float f2, float f3) {
        NdAssert.assertEquals(null, f, f2, f3);
    }

    public static void assertEquals(String string, long l, long l2) {
        NdAssert.assertEquals(string, new Long(l), new Long(l2));
    }

    public static void assertEquals(long l, long l2) {
        NdAssert.assertEquals(null, l, l2);
    }

    public static void assertEquals(String string, boolean bl, boolean bl2) {
        NdAssert.assertEquals(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void assertEquals(boolean bl, boolean bl2) {
        NdAssert.assertEquals(null, bl, bl2);
    }

    public static void assertEquals(String string, byte by, byte by2) {
        NdAssert.assertEquals(string, new Byte(by), new Byte(by2));
    }

    public static void assertEquals(byte by, byte by2) {
        NdAssert.assertEquals(null, by, by2);
    }

    public static void assertEquals(String string, char c, char c2) {
        NdAssert.assertEquals(string, new Character(c), new Character(c2));
    }

    public static void assertEquals(char c, char c2) {
        NdAssert.assertEquals(null, c, c2);
    }

    public static void assertEquals(String string, short s, short s2) {
        NdAssert.assertEquals(string, new Short(s), new Short(s2));
    }

    public static void assertEquals(short s, short s2) {
        NdAssert.assertEquals(null, s, s2);
    }

    public static void assertEquals(String string, int n, int n2) {
        NdAssert.assertEquals(string, new Integer(n), new Integer(n2));
    }

    public static void assertEquals(int n, int n2) {
        NdAssert.assertEquals(null, n, n2);
    }

    public static void assertNotNull(Object object) {
        NdAssert.assertNotNull(null, object);
    }

    public static void assertNotNull(String string, Object object) {
        NdAssert.assertTrue(string, object != null);
    }

    public static void assertNull(Object object) {
        NdAssert.assertNull(null, object);
    }

    public static void assertNull(String string, Object object) {
        NdAssert.assertTrue(string, object == null);
    }

    public static void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        NdAssert.failNotSame(string, object, object2);
    }

    public static void assertSame(Object object, Object object2) {
        NdAssert.assertSame(null, object, object2);
    }

    public static void assertNotSame(String string, Object object, Object object2) {
        if (object == object2) {
            NdAssert.failSame(string);
        }
    }

    public static void assertNotSame(Object object, Object object2) {
        NdAssert.assertNotSame(null, object, object2);
    }

    public static void failSame(String string) {
        if (string == null) {
            NdAssert.fail(NdStrings.WjHCYMC("ExpectedNotSame"));
        } else {
            NdAssert.fail(NdStrings.WjHCYOE("ExpectedNotSameWithMessage", string));
        }
    }

    public static void failNotSame(String string, Object object, Object object2) {
        if (string == null) {
            NdAssert.fail(NdStrings.WjHCYPF("ExpectedSame", object, object2));
        } else {
            NdAssert.fail(NdStrings.WjHCYQG("ExpectedSameWithMessage", string, object, object2));
        }
    }

    public static void failNotEquals(String string, Object object, Object object2) {
        if (string == null) {
            NdAssert.fail(NdStrings.WjHCYPF("Expected", object, object2));
        } else {
            NdAssert.fail(NdStrings.WjHCYQG("ExpectedWithMessage", string, object, object2));
        }
    }

    public boolean checkTrue(String string, boolean bl) {
        try {
            NdAssert.assertTrue(string, bl);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    public boolean checkFalse(String string, boolean bl) {
        return this.checkTrue(string, !bl);
    }

    public boolean checkEquals(String string, Object object, Object object2) {
        try {
            NdAssert.assertEquals(string, object, object2);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    public boolean checkEquals(String string, String string2, String string3) {
        try {
            NdAssert.assertEquals(string, string2, string3);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    public boolean checkEquals(String string, double d, double d2, double d3) {
        try {
            NdAssert.assertEquals(string, d, d2, d3);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    public boolean checkEquals(String string, float f, float f2, float f3) {
        try {
            NdAssert.assertEquals(string, f, f2, f3);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    public boolean checkEquals(String string, long l, long l2) {
        return this.checkEquals(string, new Long(l), new Long(l2));
    }

    public boolean checkEquals(String string, boolean bl, boolean bl2) {
        return this.checkEquals(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean checkEquals(String string, byte by, byte by2) {
        return this.checkEquals(string, new Byte(by), new Byte(by2));
    }

    public boolean checkEquals(String string, char c, char c2) {
        return this.checkEquals(string, new Character(c), new Character(c2));
    }

    public boolean checkEquals(String string, short s, short s2) {
        return this.checkEquals(string, new Short(s), new Short(s2));
    }

    public boolean checkEquals(String string, int n, int n2) {
        return this.checkEquals(string, new Integer(n), new Integer(n2));
    }

    public boolean checkNotNull(String string, Object object) {
        return this.checkTrue(string, object != null);
    }

    public boolean checkNull(String string, Object object) {
        return this.checkTrue(string, object == null);
    }

    public boolean checkSame(String string, Object object, Object object2) {
        try {
            NdAssert.assertSame(string, object, object2);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    public boolean checkNotSame(String string, Object object, Object object2) {
        try {
            NdAssert.assertNotSame(string, object, object2);
            return true;
        }
        catch (NdAssertionFailedError ndAssertionFailedError) {
            this.signal(ndAssertionFailedError);
            return false;
        }
    }

    protected void signal(NdAssertionFailedError ndAssertionFailedError) {
        if (!this.handleAssertion(ndAssertionFailedError)) {
            throw ndAssertionFailedError;
        }
    }

    protected boolean handleAssertion(NdAssertionFailedError ndAssertionFailedError) {
        return false;
    }

    protected static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        return l2 == (l = Double.doubleToLongBits(d2)) ? 0 : (l2 < l ? -1 : 1);
    }
}

