/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class NdArrayList
implements Cloneable,
Serializable {
    private transient Object[] WjHBDNC;
    protected transient int modCount = 0;
    private int WjHBDND;

    public NdArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.WjHBDNC = new Object[n];
    }

    public NdArrayList() {
        this(10);
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.WjHBDNC.length;
        if (this.WjHBDND < n) {
            Object[] objectArray = this.WjHBDNC;
            this.WjHBDNC = new Object[this.WjHBDND];
            System.arraycopy(objectArray, 0, this.WjHBDNC, 0, this.WjHBDND);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.WjHBDNC.length;
        if (n > n2) {
            Object[] objectArray = this.WjHBDNC;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.WjHBDNC = new Object[n3];
            System.arraycopy(objectArray, 0, this.WjHBDNC, 0, this.WjHBDND);
        }
    }

    public int size() {
        return this.WjHBDND;
    }

    public boolean isEmpty() {
        return this.WjHBDND == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.WjHBDND; ++i) {
                if (this.WjHBDNC[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.WjHBDND; ++i) {
                if (!object.equals(this.WjHBDNC[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.WjHBDND - 1; i >= 0; --i) {
                if (this.WjHBDNC[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.WjHBDND - 1; i >= 0; --i) {
                if (!object.equals(this.WjHBDNC[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            NdArrayList ndArrayList = (NdArrayList)super.clone();
            ndArrayList.WjHBDNC = new Object[this.WjHBDND];
            System.arraycopy(this.WjHBDNC, 0, ndArrayList.WjHBDNC, 0, this.WjHBDND);
            ndArrayList.modCount = 0;
            return ndArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyInto(Object[] objectArray) {
        System.arraycopy(this.WjHBDNC, 0, objectArray, 0, this.WjHBDND);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.WjHBDND];
        System.arraycopy(this.WjHBDNC, 0, objectArray, 0, this.WjHBDND);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.WjHBDND) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.WjHBDND);
        }
        System.arraycopy(this.WjHBDNC, 0, objectArray, 0, this.WjHBDND);
        if (objectArray.length > this.WjHBDND) {
            objectArray[this.WjHBDND] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        this.WjHBDNE(n);
        return this.WjHBDNC[n];
    }

    public Object elementAt(int n) {
        this.WjHBDNE(n);
        return this.WjHBDNC[n];
    }

    public Object firstElement() {
        if (this.WjHBDND == 0) {
            throw new NoSuchElementException();
        }
        return this.WjHBDNC[0];
    }

    public Object lastElement() {
        if (this.WjHBDND == 0) {
            throw new NoSuchElementException();
        }
        return this.WjHBDNC[this.WjHBDND - 1];
    }

    public Object set(int n, Object object) {
        this.WjHBDNE(n);
        Object object2 = this.WjHBDNC[n];
        this.WjHBDNC[n] = object;
        return object2;
    }

    public void insertElementAt(Object object, int n) {
        this.add(n, object);
    }

    public void setElementAt(Object object, int n) {
        this.WjHBDNE(n);
        this.WjHBDNC[n] = object;
    }

    public boolean add(Object object) {
        this.ensureCapacity(this.WjHBDND + 1);
        this.WjHBDNC[this.WjHBDND++] = object;
        return true;
    }

    public void addElement(Object object) {
        this.ensureCapacity(this.WjHBDND + 1);
        this.WjHBDNC[this.WjHBDND++] = object;
    }

    public void add(int n, Object object) {
        if (n > this.WjHBDND || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.WjHBDND);
        }
        this.ensureCapacity(this.WjHBDND + 1);
        System.arraycopy(this.WjHBDNC, n, this.WjHBDNC, n + 1, this.WjHBDND - n);
        this.WjHBDNC[n] = object;
        ++this.WjHBDND;
    }

    public Object remove(Object object) {
        int n = this.indexOf(object);
        return this.remove(n);
    }

    public boolean removeElement(Object object) {
        boolean bl;
        int n = this.indexOf(object);
        if (n != -1) {
            this.remove(n);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public Object remove(int n) {
        this.WjHBDNE(n);
        ++this.modCount;
        Object object = this.WjHBDNC[n];
        int n2 = this.WjHBDND - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.WjHBDNC, n + 1, this.WjHBDNC, n, n2);
        }
        this.WjHBDNC[--this.WjHBDND] = null;
        return object;
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.WjHBDND; ++i) {
            this.WjHBDNC[i] = null;
        }
        this.WjHBDND = 0;
    }

    public Enumeration elements() {
        return new WjHBDoS(this.WjHBDNC, this.WjHBDND);
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.WjHBDND - n2;
        System.arraycopy(this.WjHBDNC, n2, this.WjHBDNC, n, n3);
        int n4 = this.WjHBDND - (n2 - n);
        while (this.WjHBDND != n4) {
            this.WjHBDNC[--this.WjHBDND] = null;
        }
    }

    private void WjHBDNE(int n) {
        if (n >= this.WjHBDND || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.WjHBDND);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.WjHBDNC.length);
        for (int i = 0; i < this.WjHBDND; ++i) {
            objectOutputStream.writeObject(this.WjHBDNC[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.WjHBDNC = new Object[n];
        for (int i = 0; i < this.WjHBDND; ++i) {
            this.WjHBDNC[i] = objectInputStream.readObject();
        }
    }

    protected static final class WjHBDoS
    implements Enumeration {
        private Object[] WjHBDlP;
        private int WjHBDmQ = 0;
        private int WjHBDnR;

        public WjHBDoS(Object[] objectArray, int n) {
            this.WjHBDnR = n;
            this.WjHBDlP = objectArray;
        }

        public boolean hasMoreElements() {
            return this.WjHBDmQ < this.WjHBDnR;
        }

        public Object nextElement() {
            if (this.WjHBDmQ < this.WjHBDnR) {
                return this.WjHBDlP[this.WjHBDmQ++];
            }
            throw new NoSuchElementException("NdArrayList Enumeration");
        }
    }
}

