/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util;

import com.blazesoft.util.NdCounter;
import com.blazesoft.util.NdCounterFactory;
import com.blazesoft.util.NdCounterInfo;
import com.blazesoft.util.NdElapsedTimeCounterFactory;
import com.blazesoft.util.NdHighPrecisionElapsedTimeCounterFactory;
import com.blazesoft.util.NdProductInfo;
import com.blazesoft.util.NdStrings;
import com.blazesoft.util.NdThreadTimeCounterFactory;
import com.blazesoft.util.NdWrappedRuntimeException;

public abstract class NdGenericCounterFactory
implements NdCounterFactory {
    private final String WjHBWGO;
    private final NdCounterInfo WjHBWGP;
    private final String WjHBWGQ;
    private transient boolean WjHBWGR;
    private transient Class WjHBWGS;

    private static NdCounterInfo WjHBWGT(String string, String string2) {
        NdCounterInfo ndCounterInfo;
        Class<?> clazz;
        try {
            NdProductInfo.initializeProductsForClass(string);
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToLoadCounterInfoClass", string, string2), classNotFoundException);
        }
        try {
            ndCounterInfo = (NdCounterInfo)clazz.newInstance();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToInstantiateCounterInfoClass", string, string2));
        }
        catch (InstantiationException instantiationException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToInstantiateCounterInfoClass", string, string2));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToInstantiateCounterInfoClass", string, string2));
        }
        catch (RuntimeException runtimeException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToInstantiateCounterInfoClass", string, string2));
        }
        return ndCounterInfo;
    }

    protected NdGenericCounterFactory(String string, String string2) {
        this.WjHBWGO = string;
        this.WjHBWGP = NdGenericCounterFactory.WjHBWGT(string2, string);
        this.WjHBWGQ = null;
    }

    protected NdGenericCounterFactory(String string, String string2, String string3) {
        this.WjHBWGO = string;
        this.WjHBWGP = NdGenericCounterFactory.WjHBWGT(string2, string);
        this.WjHBWGQ = string3;
    }

    public static NdCounterFactory getCounterFactory(int n) {
        NdGenericCounterFactory ndGenericCounterFactory;
        switch (n) {
            case 0: {
                ndGenericCounterFactory = new NdElapsedTimeCounterFactory();
                break;
            }
            case 1: {
                ndGenericCounterFactory = new NdHighPrecisionElapsedTimeCounterFactory();
                break;
            }
            case 2: {
                ndGenericCounterFactory = new NdThreadTimeCounterFactory();
                break;
            }
            default: {
                throw new IllegalArgumentException(NdStrings.WjHzpAN("IllegalCounterMeasurmentType", Integer.toString(n)));
            }
        }
        return ndGenericCounterFactory;
    }

    public int getCounterType() {
        return this.WjHBWGP.getCounterType();
    }

    public String getCounterDescription() {
        return this.WjHBWGP.getCounterDescription();
    }

    public String getCounterUnitDescription() {
        return this.WjHBWGP.getCounterUnitDescription();
    }

    public double getCounterUnitInMilliseconds() {
        return this.WjHBWGP.getCounterUnitInMilliseconds();
    }

    public int getCounterMeasurementType() {
        return this.WjHBWGP.getCounterMeasurementType();
    }

    public NdCounter newCounter() {
        NdCounter ndCounter;
        Class<?> clazz;
        if (this.WjHBWGQ != null && !this.WjHBWGR) {
            try {
                System.loadLibrary(this.WjHBWGQ);
                this.WjHBWGR = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToFindNativeLibraryForCounter", this.WjHBWGQ, this.WjHBWGO), unsatisfiedLinkError);
            }
            catch (RuntimeException runtimeException) {
                throw new NdWrappedRuntimeException(NdStrings.WjHzpBO("FailedToLoadNativeLibraryForCounter", this.WjHBWGQ, this.WjHBWGO), runtimeException);
            }
        }
        if ((clazz = this.WjHBWGS) == null) {
            try {
                NdProductInfo.initializeProductsForClass(this.WjHBWGO);
                this.WjHBWGS = clazz = Class.forName(this.WjHBWGO);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdWrappedRuntimeException(NdStrings.WjHzpAN("FailedToLoadCounterClass", this.WjHBWGO), classNotFoundException);
            }
        }
        try {
            ndCounter = (NdCounter)clazz.newInstance();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpAN("FailedToInstantiateCounterClass", this.WjHBWGO), exceptionInInitializerError);
        }
        catch (InstantiationException instantiationException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpAN("FailedToInstantiateCounterClass", this.WjHBWGO), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpAN("FailedToInstantiateCounterClass", this.WjHBWGO), illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            throw new NdWrappedRuntimeException(NdStrings.WjHzpAN("FailedToInstantiateCounterClass", this.WjHBWGO), runtimeException);
        }
        return ndCounter;
    }
}

