/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.util.NdIdentityComparator;
import com.blazesoft.util.NdStrings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class NdHashMap
extends Dictionary
implements Cloneable,
Serializable {
    private NdIdentityComparator WjHBChY;
    private transient WjHBCEG[] WjHBCiZ;
    private transient int WjHBCjA;
    private int WjHBCjB;
    private float WjHBCjC;
    static final long serialVersionUID = 3730136037990055576L;
    private static Object WjHEeyZ = new Object();

    static Object WjHEezA(Object object) {
        return object == WjHEeyZ ? null : object;
    }

    public NdHashMap(NdIdentityComparator ndIdentityComparator, int n, float f) {
        if (ndIdentityComparator == null) {
            throw new NullPointerException(NdStrings.WjHzpyL("ComparatorCannotBeNull"));
        }
        this.WjHBChY = ndIdentityComparator;
        if (n < 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.WjHBCjC = f;
        this.WjHBCiZ = new WjHBCEG[n];
        this.WjHBCjB = (int)((float)n * f);
    }

    public NdHashMap(NdIdentityComparator ndIdentityComparator, int n) {
        this(ndIdentityComparator, n, 0.75f);
    }

    public NdHashMap(NdIdentityComparator ndIdentityComparator) {
        this(ndIdentityComparator, 101, 0.75f);
    }

    public NdHashMap() {
        this(NdDotNETLib.getIdentityComparator(), 101, 0.75f);
    }

    public NdHashMap(int n) {
        this(NdDotNETLib.getIdentityComparator(), n);
    }

    public NdHashMap(int n, float f) {
        this(NdDotNETLib.getIdentityComparator(), n, f);
    }

    public int size() {
        return this.WjHBCjA;
    }

    public boolean isEmpty() {
        return this.WjHBCjA == 0;
    }

    public Enumeration keys() {
        return new WjHBDUR(this.WjHBCiZ, true);
    }

    public Enumeration elements() {
        return new WjHBDUR(this.WjHBCiZ, false);
    }

    public boolean contains(Object object) {
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n = wjHBCEGArray.length;
        while (n-- > 0) {
            WjHBCEG wjHBCEG = wjHBCEGArray[n];
            while (wjHBCEG != null) {
                if (object == null ? wjHBCEG.WjHBCCE == null : wjHBCEG.WjHBCCE != null && this.WjHBChY.areIdentical(wjHBCEG.WjHBCCE, object)) {
                    return true;
                }
                wjHBCEG = wjHBCEG.WjHBCDF;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            object = WjHEeyZ;
        }
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n = this.WjHBChY.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHBCEGArray.length;
        WjHBCEG wjHBCEG = wjHBCEGArray[n2];
        while (wjHBCEG != null) {
            if (wjHBCEG.WjHBCAC == n && this.WjHBChY.areIdentical(wjHBCEG.WjHBCBD, object)) {
                return true;
            }
            wjHBCEG = wjHBCEG.WjHBCDF;
        }
        return false;
    }

    public Object get(Object object) {
        if (object == null) {
            object = WjHEeyZ;
        }
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n = this.WjHBChY.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHBCEGArray.length;
        WjHBCEG wjHBCEG = wjHBCEGArray[n2];
        while (wjHBCEG != null) {
            if (wjHBCEG.WjHBCAC == n && this.WjHBChY.areIdentical(wjHBCEG.WjHBCBD, object)) {
                return wjHBCEG.WjHBCCE;
            }
            wjHBCEG = wjHBCEG.WjHBCDF;
        }
        return null;
    }

    protected void rehash() {
        int n = this.WjHBCiZ.length;
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n2 = n * 2 + 1;
        WjHBCEG[] wjHBCEGArray2 = new WjHBCEG[n2];
        this.WjHBCjB = (int)((float)n2 * this.WjHBCjC);
        this.WjHBCiZ = wjHBCEGArray2;
        int n3 = n;
        while (n3-- > 0) {
            WjHBCEG wjHBCEG = wjHBCEGArray[n3];
            while (wjHBCEG != null) {
                WjHBCEG wjHBCEG2 = wjHBCEG;
                wjHBCEG = wjHBCEG.WjHBCDF;
                int n4 = (wjHBCEG2.WjHBCAC & Integer.MAX_VALUE) % n2;
                wjHBCEG2.WjHBCDF = wjHBCEGArray2[n4];
                wjHBCEGArray2[n4] = wjHBCEG2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            object = WjHEeyZ;
        }
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n = this.WjHBChY.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHBCEGArray.length;
        WjHBCEG wjHBCEG = wjHBCEGArray[n2];
        while (wjHBCEG != null) {
            if (wjHBCEG.WjHBCAC == n && this.WjHBChY.areIdentical(wjHBCEG.WjHBCBD, object)) {
                Object object3 = wjHBCEG.WjHBCCE;
                wjHBCEG.WjHBCCE = object2;
                return object3;
            }
            wjHBCEG = wjHBCEG.WjHBCDF;
        }
        if (this.WjHBCjA >= this.WjHBCjB) {
            this.rehash();
            return this.put(object, object2);
        }
        wjHBCEG = new WjHBCEG();
        wjHBCEG.WjHBCAC = n;
        wjHBCEG.WjHBCBD = object;
        wjHBCEG.WjHBCCE = object2;
        wjHBCEG.WjHBCDF = wjHBCEGArray[n2];
        wjHBCEGArray[n2] = wjHBCEG;
        ++this.WjHBCjA;
        return null;
    }

    public Object remove(Object object) {
        if (object == null) {
            object = WjHEeyZ;
        }
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n = this.WjHBChY.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHBCEGArray.length;
        WjHBCEG wjHBCEG = wjHBCEGArray[n2];
        WjHBCEG wjHBCEG2 = null;
        while (wjHBCEG != null) {
            if (wjHBCEG.WjHBCAC == n && this.WjHBChY.areIdentical(wjHBCEG.WjHBCBD, object)) {
                if (wjHBCEG2 != null) {
                    wjHBCEG2.WjHBCDF = wjHBCEG.WjHBCDF;
                } else {
                    wjHBCEGArray[n2] = wjHBCEG.WjHBCDF;
                }
                --this.WjHBCjA;
                return wjHBCEG.WjHBCCE;
            }
            wjHBCEG2 = wjHBCEG;
            wjHBCEG = wjHBCEG.WjHBCDF;
        }
        return null;
    }

    public void clear() {
        WjHBCEG[] wjHBCEGArray = this.WjHBCiZ;
        int n = wjHBCEGArray.length;
        while (--n >= 0) {
            wjHBCEGArray[n] = null;
        }
        this.WjHBCjA = 0;
    }

    public synchronized Object clone() {
        try {
            NdHashMap ndHashMap = (NdHashMap)super.clone();
            ndHashMap.WjHBCiZ = new WjHBCEG[this.WjHBCiZ.length];
            int n = this.WjHBCiZ.length;
            while (n-- > 0) {
                ndHashMap.WjHBCiZ[n] = this.WjHBCiZ[n] != null ? (WjHBCEG)this.WjHBCiZ[n].clone() : null;
            }
            return ndHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.WjHBCiZ.length);
        objectOutputStream.writeInt(this.WjHBCjA);
        for (int i = this.WjHBCiZ.length - 1; i >= 0; --i) {
            WjHBCEG wjHBCEG = this.WjHBCiZ[i];
            while (wjHBCEG != null) {
                objectOutputStream.writeObject(wjHBCEG.WjHBCBD);
                objectOutputStream.writeObject(wjHBCEG.WjHBCCE);
                wjHBCEG = wjHBCEG.WjHBCDF;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.WjHBCjC) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.WjHBCiZ = new WjHBCEG[n3];
        this.WjHBCjA = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    private static final class WjHBDUR
    implements Enumeration {
        boolean WjHBDQN;
        int WjHBDRO;
        WjHBCEG[] WjHBDSP;
        WjHBCEG WjHBDTQ;

        WjHBDUR(WjHBCEG[] wjHBCEGArray, boolean bl) {
            this.WjHBDSP = wjHBCEGArray;
            this.WjHBDQN = bl;
            this.WjHBDRO = wjHBCEGArray.length;
        }

        public boolean hasMoreElements() {
            if (this.WjHBDTQ != null) {
                return true;
            }
            while (this.WjHBDRO-- > 0) {
                this.WjHBDTQ = this.WjHBDSP[this.WjHBDRO];
                if (this.WjHBDTQ == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.WjHBDTQ == null) {
                while (this.WjHBDRO-- > 0 && (this.WjHBDTQ = this.WjHBDSP[this.WjHBDRO]) == null) {
                }
            }
            if (this.WjHBDTQ != null) {
                WjHBCEG wjHBCEG = this.WjHBDTQ;
                this.WjHBDTQ = wjHBCEG.WjHBCDF;
                return this.WjHBDQN ? NdHashMap.WjHEezA(wjHBCEG.WjHBCBD) : wjHBCEG.WjHBCCE;
            }
            throw new NoSuchElementException("HashMapEnumerator");
        }
    }

    private static final class WjHBCEG {
        int WjHBCAC;
        Object WjHBCBD;
        Object WjHBCCE;
        WjHBCEG WjHBCDF;

        private WjHBCEG() {
        }

        public Object clone() {
            WjHBCEG wjHBCEG = new WjHBCEG();
            wjHBCEG.WjHBCAC = this.WjHBCAC;
            wjHBCEG.WjHBCBD = this.WjHBCBD;
            wjHBCEG.WjHBCCE = this.WjHBCCE;
            wjHBCEG.WjHBCDF = this.WjHBCDF != null ? (WjHBCEG)this.WjHBCDF.clone() : null;
            return wjHBCEG;
        }
    }
}

