/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.util.NdIdentityComparator;
import com.blazesoft.util.NdStrings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class NdHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private NdIdentityComparator WjHztvF;
    private transient WjHzvXM[] WjHztvG;
    private transient int WjHztvH;
    private int WjHztvI;
    private float WjHztvJ;
    static final long serialVersionUID = 3730136037990055576L;

    public NdHashtable(NdIdentityComparator ndIdentityComparator, int n, float f) {
        if (ndIdentityComparator == null) {
            throw new NullPointerException(NdStrings.WjHzpyL("ComparatorCannotBeNull"));
        }
        this.WjHztvF = ndIdentityComparator;
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.WjHztvJ = f;
        this.WjHztvG = new WjHzvXM[n];
        this.WjHztvI = (int)((float)n * f);
    }

    public NdHashtable(NdIdentityComparator ndIdentityComparator, int n) {
        this(ndIdentityComparator, n, 0.75f);
    }

    public NdHashtable(NdIdentityComparator ndIdentityComparator) {
        this(ndIdentityComparator, 101, 0.75f);
    }

    public int size() {
        return this.WjHztvH;
    }

    public boolean isEmpty() {
        return this.WjHztvH == 0;
    }

    public synchronized Enumeration keys() {
        return new WjHzyeW(this.WjHztvG, true);
    }

    public synchronized Enumeration elements() {
        return new WjHzyeW(this.WjHztvG, false);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n = wjHzvXMArray.length;
        while (n-- > 0) {
            WjHzvXM wjHzvXM = wjHzvXMArray[n];
            while (wjHzvXM != null) {
                if (this.WjHztvF.areIdentical(wjHzvXM.WjHzvXK, object)) {
                    return true;
                }
                wjHzvXM = wjHzvXM.WjHzvXL;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n = this.WjHztvF.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHzvXMArray.length;
        WjHzvXM wjHzvXM = wjHzvXMArray[n2];
        while (wjHzvXM != null) {
            if (wjHzvXM.WjHzvXI == n && this.WjHztvF.areIdentical(wjHzvXM.WjHzvXJ, object)) {
                return true;
            }
            wjHzvXM = wjHzvXM.WjHzvXL;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n = this.WjHztvF.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHzvXMArray.length;
        WjHzvXM wjHzvXM = wjHzvXMArray[n2];
        while (wjHzvXM != null) {
            if (wjHzvXM.WjHzvXI == n && this.WjHztvF.areIdentical(wjHzvXM.WjHzvXJ, object)) {
                return wjHzvXM.WjHzvXK;
            }
            wjHzvXM = wjHzvXM.WjHzvXL;
        }
        return null;
    }

    protected void rehash() {
        int n = this.WjHztvG.length;
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n2 = n * 2 + 1;
        WjHzvXM[] wjHzvXMArray2 = new WjHzvXM[n2];
        this.WjHztvI = (int)((float)n2 * this.WjHztvJ);
        this.WjHztvG = wjHzvXMArray2;
        int n3 = n;
        while (n3-- > 0) {
            WjHzvXM wjHzvXM = wjHzvXMArray[n3];
            while (wjHzvXM != null) {
                WjHzvXM wjHzvXM2 = wjHzvXM;
                wjHzvXM = wjHzvXM.WjHzvXL;
                int n4 = (wjHzvXM2.WjHzvXI & Integer.MAX_VALUE) % n2;
                wjHzvXM2.WjHzvXL = wjHzvXMArray2[n4];
                wjHzvXMArray2[n4] = wjHzvXM2;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n = this.WjHztvF.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHzvXMArray.length;
        WjHzvXM wjHzvXM = wjHzvXMArray[n2];
        while (wjHzvXM != null) {
            if (wjHzvXM.WjHzvXI == n && this.WjHztvF.areIdentical(wjHzvXM.WjHzvXJ, object)) {
                Object object3 = wjHzvXM.WjHzvXK;
                wjHzvXM.WjHzvXK = object2;
                return object3;
            }
            wjHzvXM = wjHzvXM.WjHzvXL;
        }
        if (this.WjHztvH >= this.WjHztvI) {
            this.rehash();
            return this.put(object, object2);
        }
        wjHzvXM = new WjHzvXM();
        wjHzvXM.WjHzvXI = n;
        wjHzvXM.WjHzvXJ = object;
        wjHzvXM.WjHzvXK = object2;
        wjHzvXM.WjHzvXL = wjHzvXMArray[n2];
        wjHzvXMArray[n2] = wjHzvXM;
        ++this.WjHztvH;
        return null;
    }

    public synchronized Object remove(Object object) {
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n = this.WjHztvF.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % wjHzvXMArray.length;
        WjHzvXM wjHzvXM = wjHzvXMArray[n2];
        WjHzvXM wjHzvXM2 = null;
        while (wjHzvXM != null) {
            if (wjHzvXM.WjHzvXI == n && this.WjHztvF.areIdentical(wjHzvXM.WjHzvXJ, object)) {
                if (wjHzvXM2 != null) {
                    wjHzvXM2.WjHzvXL = wjHzvXM.WjHzvXL;
                } else {
                    wjHzvXMArray[n2] = wjHzvXM.WjHzvXL;
                }
                --this.WjHztvH;
                return wjHzvXM.WjHzvXK;
            }
            wjHzvXM2 = wjHzvXM;
            wjHzvXM = wjHzvXM.WjHzvXL;
        }
        return null;
    }

    public synchronized void clear() {
        WjHzvXM[] wjHzvXMArray = this.WjHztvG;
        int n = wjHzvXMArray.length;
        while (--n >= 0) {
            wjHzvXMArray[n] = null;
        }
        this.WjHztvH = 0;
    }

    public synchronized Object clone() {
        try {
            NdHashtable ndHashtable = (NdHashtable)super.clone();
            ndHashtable.WjHztvG = new WjHzvXM[this.WjHztvG.length];
            int n = this.WjHztvG.length;
            while (n-- > 0) {
                ndHashtable.WjHztvG[n] = this.WjHztvG[n] != null ? (WjHzvXM)this.WjHztvG[n].clone() : null;
            }
            return ndHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NdDotNETLib.defaultWriteObjectHelper(objectOutputStream, this);
        objectOutputStream.writeInt(this.WjHztvG.length);
        objectOutputStream.writeInt(this.WjHztvH);
        for (int i = this.WjHztvG.length - 1; i >= 0; --i) {
            WjHzvXM wjHzvXM = this.WjHztvG[i];
            while (wjHzvXM != null) {
                NdDotNETLib.writeObjectHelper(objectOutputStream, wjHzvXM.WjHzvXJ);
                NdDotNETLib.writeObjectHelper(objectOutputStream, wjHzvXM.WjHzvXK);
                wjHzvXM = wjHzvXM.WjHzvXL;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NdDotNETLib.defaultReadObjectHelper(objectInputStream, this);
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.WjHztvJ) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.WjHztvG = new WjHzvXM[n3];
        this.WjHztvH = 0;
        while (n2 > 0) {
            Object object = NdDotNETLib.readObjectHelper(objectInputStream);
            Object object2 = NdDotNETLib.readObjectHelper(objectInputStream);
            this.put(object, object2);
            --n2;
        }
    }

    private static class WjHzyeW
    implements Enumeration {
        boolean WjHzyeS;
        int WjHzyeT;
        WjHzvXM[] WjHzyeU;
        WjHzvXM WjHzyeV;

        WjHzyeW(WjHzvXM[] wjHzvXMArray, boolean bl) {
            this.WjHzyeU = wjHzvXMArray;
            this.WjHzyeS = bl;
            this.WjHzyeT = wjHzvXMArray.length;
        }

        public boolean hasMoreElements() {
            if (this.WjHzyeV != null) {
                return true;
            }
            while (this.WjHzyeT-- > 0) {
                this.WjHzyeV = this.WjHzyeU[this.WjHzyeT];
                if (this.WjHzyeV == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.WjHzyeV == null) {
                while (this.WjHzyeT-- > 0 && (this.WjHzyeV = this.WjHzyeU[this.WjHzyeT]) == null) {
                }
            }
            if (this.WjHzyeV != null) {
                WjHzvXM wjHzvXM = this.WjHzyeV;
                this.WjHzyeV = wjHzvXM.WjHzvXL;
                return this.WjHzyeS ? wjHzvXM.WjHzvXJ : wjHzvXM.WjHzvXK;
            }
            throw new NoSuchElementException("HashtableEnumerator");
        }
    }

    private static class WjHzvXM {
        int WjHzvXI;
        Object WjHzvXJ;
        Object WjHzvXK;
        WjHzvXM WjHzvXL;

        private WjHzvXM() {
        }

        protected Object clone() {
            WjHzvXM wjHzvXM = new WjHzvXM();
            wjHzvXM.WjHzvXI = this.WjHzvXI;
            wjHzvXM.WjHzvXJ = this.WjHzvXJ;
            wjHzvXM.WjHzvXK = this.WjHzvXK;
            wjHzvXM.WjHzvXL = this.WjHzvXL != null ? (WjHzvXM)this.WjHzvXL.clone() : null;
            return wjHzvXM;
        }
    }
}

