/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.dotnet.NdFile;
import com.blazesoft.objects.dotnet.NdResourceManager;
import com.blazesoft.util.NdArrayList;
import com.blazesoft.util.NdProductInfo;
import com.blazesoft.util.NdStrings;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.NdWrappedIOException;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class NdIOUtil {
    public static final String UTF8_DOTNET = "utf-8";
    public static final String UTF8_JAVA = "UTF8";
    public static final String UTF8_MIME = "UTF-8";
    public static final int DEFAULT_READ_BUFFER_SIZE = 2048;
    public static final int MAX_READ_BUFFER_INCREMENT = 0x100000;
    private static final char[] WjHANiH = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int WjHAJOI = 3;
    private static final boolean WjHFcyV = NdDotNETLib.isDotNETSupportEnabledForceInitialization() && NdSystemProperties.getBooleanSystemProperty("nd.compatExtResourceLoading");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(File file) throws IOException, FileNotFoundException {
        long l = file.length();
        int n = l <= Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE;
        n = n > 0 ? n : 2048;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = NdIOUtil.readAllBytes(fileInputStream, n);
            return byArray;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException, EOFException {
        int n = inputStream.available();
        n = n > 0 ? n : 2048;
        return NdIOUtil.readAllBytes(inputStream, n);
    }

    public static char[] readAllChars(Reader reader, int n) throws IOException, EOFException {
        char[] cArray;
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException(NdStrings.WjHzpyL("IllegalMinBufSize"));
        }
        int n3 = 0;
        int n4 = n;
        char[] cArray2 = new char[n4];
        NdArrayList ndArrayList = new NdArrayList();
        int n5 = 0;
        int n6 = n4;
        WjHANID wjHANID = null;
        while ((n2 = reader.read(cArray2, n5, n6)) != -1) {
            n3 += n2;
            if (wjHANID == null) {
                wjHANID = new WjHANID(cArray2, n2);
                ndArrayList.addElement(wjHANID);
            } else {
                wjHANID.WjHANHC = n5 + n2;
            }
            if (wjHANID.WjHANHC == n4) {
                if (n2 == n4) {
                    n4 *= 2;
                }
                cArray2 = new char[n4];
                wjHANID = null;
                n5 = 0;
                n6 = n4;
                continue;
            }
            n5 = wjHANID.WjHANHC;
            n6 = n4 - n5;
        }
        if (ndArrayList.size() == 0) {
            cArray = new char[]{};
        } else if (ndArrayList.size() == 1) {
            char[] cArray3 = ((WjHANID)ndArrayList.elementAt((int)0)).WjHANGB;
            if (cArray3.length == n3) {
                cArray = cArray3;
            } else {
                cArray = new char[n3];
                System.arraycopy(cArray3, 0, cArray, 0, cArray.length);
            }
        } else {
            Object object;
            int n7;
            cArray = new char[n3];
            int n8 = 0;
            for (n7 = 0; n7 < ndArrayList.size() - 1; ++n7) {
                object = (WjHANID)ndArrayList.elementAt(n7);
                char[] cArray4 = ((WjHANID)object).WjHANGB;
                int n9 = ((WjHANID)object).WjHANHC;
                System.arraycopy(cArray4, 0, cArray, n8, n9);
                n8 += n9;
            }
            n7 = n3 - n8;
            object = ((WjHANID)ndArrayList.lastElement()).WjHANGB;
            System.arraycopy(object, 0, cArray, n8, n7);
        }
        return cArray;
    }

    public static char[] readAllChars(Reader reader) throws IOException, EOFException {
        return NdIOUtil.readAllChars(reader, 2048);
    }

    public static byte[] readAllBytes(InputStream inputStream, int n) throws IOException, EOFException {
        byte[] byArray;
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException(NdStrings.WjHzpyL("IllegalMinBufSize"));
        }
        int n3 = 0;
        int n4 = n;
        byte[] byArray2 = new byte[n4];
        NdArrayList ndArrayList = new NdArrayList();
        int n5 = 0;
        int n6 = n4;
        WjHAJbJ wjHAJbJ = null;
        while ((n2 = inputStream.read(byArray2, n5, n6)) != -1) {
            n3 += n2;
            if (wjHAJbJ == null) {
                wjHAJbJ = new WjHAJbJ(byArray2, n2);
                ndArrayList.addElement(wjHAJbJ);
            } else {
                wjHAJbJ.WjHAJbI = n5 + n2;
            }
            if (wjHAJbJ.WjHAJbI == n4) {
                if (n2 == n4) {
                    n4 *= 2;
                }
                byArray2 = new byte[n4];
                wjHAJbJ = null;
                n5 = 0;
                n6 = n4;
                continue;
            }
            n5 = wjHAJbJ.WjHAJbI;
            n6 = n4 - n5;
        }
        if (ndArrayList.size() == 0) {
            byArray = new byte[]{};
        } else if (ndArrayList.size() == 1) {
            byte[] byArray3 = ((WjHAJbJ)ndArrayList.elementAt((int)0)).WjHAJbH;
            if (byArray3.length == n3) {
                byArray = byArray3;
            } else {
                byArray = new byte[n3];
                System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
            }
        } else {
            Object object;
            int n7;
            byArray = new byte[n3];
            int n8 = 0;
            for (n7 = 0; n7 < ndArrayList.size() - 1; ++n7) {
                object = (WjHAJbJ)ndArrayList.elementAt(n7);
                byte[] byArray4 = ((WjHAJbJ)object).WjHAJbH;
                int n9 = ((WjHAJbJ)object).WjHAJbI;
                System.arraycopy(byArray4, 0, byArray, n8, n9);
                n8 += n9;
            }
            n7 = n3 - n8;
            object = ((WjHAJbJ)ndArrayList.lastElement()).WjHAJbH;
            System.arraycopy(object, 0, byArray, n8, n7);
        }
        return byArray;
    }

    public static byte[] readFile(String string) throws IOException {
        return NdIOUtil.readAllBytes(new File(string));
    }

    private static InputStream WjHBfVU(Class clazz, String string, String[] stringArray, boolean bl) throws IOException {
        String[] stringArray2;
        InputStream inputStream = null;
        if (bl && (stringArray2 = NdSystemProperties.getSystemExternalResourceDirs()) != null && stringArray2.length > 0) {
            inputStream = NdIOUtil.WjHFcCZ(clazz, stringArray2, string);
        }
        if (inputStream == null && stringArray != null && stringArray.length > 0) {
            inputStream = NdIOUtil.WjHFcCZ(clazz, stringArray, string);
        }
        if (inputStream == null) {
            stringArray2 = NdDotNETLib.getResourceManager();
            inputStream = clazz == null ? stringArray2.getSystemResourceAsStream(string) : stringArray2.getResourceAsStream(clazz, string);
        }
        return inputStream;
    }

    public static URL getResource(Class clazz, String string, String[] stringArray, boolean bl) {
        String[] stringArray2;
        URL uRL = null;
        File file = null;
        if (bl && (stringArray2 = NdSystemProperties.getSystemExternalResourceDirs()) != null && stringArray2.length > 0) {
            file = NdIOUtil.WjHFcBY(clazz, stringArray2, string);
        }
        if (file == null && stringArray != null && stringArray.length > 0) {
            file = NdIOUtil.WjHFcBY(clazz, stringArray, string);
        }
        if (file == null) {
            uRL = clazz == null ? ClassLoader.getSystemResource(string) : clazz.getResource(string);
        } else {
            try {
                stringArray2 = file.getAbsolutePath();
                String string2 = stringArray2.startsWith("/") ? "file://" : "file:///";
                string2 = string2 + (String)stringArray2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NdWrappedRuntimeException(malformedURLException);
            }
        }
        return uRL;
    }

    public static URL getSystemResource(String string, String[] stringArray, boolean bl) {
        return NdIOUtil.getResource(null, string, stringArray, bl);
    }

    public static URL getResource(Class clazz, String string, String string2) {
        return NdIOUtil.getResource(clazz, string, NdProductInfo.getProductExternalResourceDirs(string2), true);
    }

    public static URL getSystemResource(String string, String string2) {
        return NdIOUtil.getSystemResource(string, NdProductInfo.getProductExternalResourceDirs(string2), true);
    }

    public static InputStream getResourceAsStream(Class clazz, String string, String[] stringArray, boolean bl) {
        InputStream inputStream;
        try {
            inputStream = NdIOUtil.WjHBfVU(clazz, string, stringArray, bl);
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException(iOException);
        }
        return inputStream;
    }

    public static InputStream getResourceAsStream(Class clazz, String string, String string2) {
        return NdIOUtil.getResourceAsStream(clazz, string, NdProductInfo.getProductExternalResourceDirs(string2), true);
    }

    public static InputStream getSystemResourceAsStream(String string, String[] stringArray, boolean bl) {
        return NdIOUtil.getResourceAsStream(null, string, stringArray, bl);
    }

    public static InputStream getSystemResourceAsStream(String string, String string2) {
        return NdIOUtil.getSystemResourceAsStream(string, NdProductInfo.getProductExternalResourceDirs(string2), true);
    }

    private static void WjHBgbD(InputStream inputStream, String string, String[] stringArray) throws IOException {
        if (inputStream == null) {
            String string2;
            if (stringArray != null && stringArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(File.pathSeparator);
                    }
                    stringBuffer.append(stringArray[i]);
                }
                string2 = NdStrings.WjHzpBO("CouldNotFindExternalResource", string, stringBuffer.toString());
            } else {
                string2 = NdStrings.WjHzpAN("CouldNotFindResource", string);
            }
            throw new IOException(string2);
        }
    }

    public static byte[] readResourceFile(Class clazz, String string, String[] stringArray, boolean bl) throws IOException {
        InputStream inputStream = NdIOUtil.WjHBfVU(clazz, string, stringArray, bl);
        NdIOUtil.WjHBgbD(inputStream, string, stringArray);
        byte[] byArray = NdIOUtil.readAllBytes(inputStream);
        inputStream.close();
        return byArray;
    }

    public static byte[] compress(byte[] byArray) throws IOException {
        int n = (double)byArray.length * 0.1 > 2048.0 ? (int)((double)byArray.length * 0.1) : 2048;
        return NdIOUtil.compress(byArray, n);
    }

    public static byte[] compress(byte[] byArray, int n) throws IOException {
        byte[] byArray2;
        if (n < 1) {
            throw new IllegalArgumentException(NdStrings.WjHzpyL("IllegalMinBufSize"));
        }
        int n2 = 0;
        int n3 = n;
        byte[] byArray3 = new byte[n3];
        NdArrayList ndArrayList = new NdArrayList();
        Deflater deflater = new Deflater(1, true);
        deflater.setInput(byArray, 0, byArray.length);
        deflater.finish();
        while (!deflater.finished()) {
            int n4 = deflater.deflate(byArray3, 0, n3);
            ndArrayList.addElement(new WjHAJbJ(byArray3, n4));
            n2 += n4;
            if (n4 == n3 && n3 < 0x100000) {
                n3 *= 2;
            }
            byArray3 = new byte[n3];
        }
        if (ndArrayList.size() == 0) {
            byArray2 = new byte[]{};
        } else if (ndArrayList.size() == 1) {
            byte[] byArray4 = ((WjHAJbJ)ndArrayList.elementAt((int)0)).WjHAJbH;
            if (byArray4.length == n2) {
                byArray2 = byArray4;
            } else {
                byArray2 = new byte[n2];
                System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
            }
        } else {
            Object object;
            int n5;
            byArray2 = new byte[n2];
            int n6 = 0;
            for (n5 = 0; n5 < ndArrayList.size() - 1; ++n5) {
                object = (WjHAJbJ)ndArrayList.elementAt(n5);
                byte[] byArray5 = ((WjHAJbJ)object).WjHAJbH;
                int n7 = ((WjHAJbJ)object).WjHAJbI;
                System.arraycopy(byArray5, 0, byArray2, n6, n7);
                n6 += n7;
            }
            n5 = n2 - n6;
            object = ((WjHAJbJ)ndArrayList.lastElement()).WjHAJbH;
            System.arraycopy(object, 0, byArray2, n6, n5);
        }
        return byArray2;
    }

    public static byte[] uncompress(byte[] byArray) throws IOException {
        int n = byArray.length > 2048 ? 10 * byArray.length : 2048;
        return NdIOUtil.uncompress(byArray, n);
    }

    public static byte[] uncompress(byte[] byArray, int n) throws IOException {
        byte[] byArray2;
        if (n < 1) {
            throw new IllegalArgumentException(NdStrings.WjHzpyL("IllegalMinBufSize"));
        }
        int n2 = 0;
        int n3 = n;
        byte[] byArray3 = new byte[n3];
        NdArrayList ndArrayList = new NdArrayList();
        Inflater inflater = new Inflater(true);
        inflater.setInput(byArray, 0, byArray.length);
        try {
            int n4;
            while ((n4 = inflater.inflate(byArray3, 0, n3)) != 0) {
                ndArrayList.addElement(new WjHAJbJ(byArray3, n4));
                n2 += n4;
                if (n4 == n3 && n3 < 0x100000) {
                    n3 *= 2;
                }
                byArray3 = new byte[n3];
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException(dataFormatException.getMessage());
        }
        if (ndArrayList.size() == 0) {
            byArray2 = new byte[]{};
        } else if (ndArrayList.size() == 1) {
            byte[] byArray4 = ((WjHAJbJ)ndArrayList.elementAt((int)0)).WjHAJbH;
            if (byArray4.length == n2) {
                byArray2 = byArray4;
            } else {
                byArray2 = new byte[n2];
                System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
            }
        } else {
            Object object;
            int n5;
            byArray2 = new byte[n2];
            int n6 = 0;
            for (n5 = 0; n5 < ndArrayList.size() - 1; ++n5) {
                object = (WjHAJbJ)ndArrayList.elementAt(n5);
                byte[] byArray5 = ((WjHAJbJ)object).WjHAJbH;
                int n7 = ((WjHAJbJ)object).WjHAJbI;
                System.arraycopy(byArray5, 0, byArray2, n6, n7);
                n6 += n7;
            }
            n5 = n2 - n6;
            object = ((WjHAJbJ)ndArrayList.lastElement()).WjHAJbH;
            System.arraycopy(object, 0, byArray2, n6, n5);
        }
        return byArray2;
    }

    public static byte[] readResourceFile(String string, String[] stringArray) throws IOException {
        return NdIOUtil.readResourceFile(null, string, stringArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String string, byte[] byArray) throws IOException {
        Object object;
        string = string.replace('/', File.separatorChar);
        File file = new File(string);
        if (string.indexOf(File.separatorChar) != -1) {
            object = file.getParent();
            new File((String)object).mkdirs();
        }
        object = null;
        try {
            object = new FileOutputStream(string);
            ((FileOutputStream)object).write(byArray);
        }
        finally {
            if (object != null) {
                ((FileOutputStream)object).close();
            }
        }
    }

    public static void saveTextFile(String string, String string2) throws IOException {
        Object object;
        string = string.replace('/', File.separatorChar);
        File file = new File(string);
        if (string.indexOf(File.separatorChar) != -1) {
            object = file.getParent();
            new File((String)object).mkdir();
        }
        object = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        ((PrintWriter)object).write(string2);
        ((PrintWriter)object).close();
    }

    public static String convertToURL(String string) throws IOException {
        int n = string.indexOf(" ");
        if (n > 0) {
            while ((n = (string = string.substring(0, n) + "%20" + string.substring(n + 1)).indexOf(" ")) != -1) {
            }
        }
        return string;
    }

    public static void copyFile(String string, String string2) throws IOException {
        byte[] byArray = NdIOUtil.readFile(string);
        File file = new File(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static String convertToEscapedUnicode(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u");
            stringBuffer.append(WjHANiH[(c & 0xF000) >> 12]);
            stringBuffer.append(WjHANiH[(c & 0xF00) >> 8]);
            stringBuffer.append(WjHANiH[(c & 0xF0) >> 4]);
            stringBuffer.append(WjHANiH[c & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String convertToCharacterLiteral(String string) {
        return NdIOUtil.WjHAPOP(string, true);
    }

    public static String convertToStringLiteral(String string) {
        return NdIOUtil.WjHAPOP(string, false);
    }

    private static String WjHAPOP(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                if (c > '\'') {
                    if (c == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '\'') {
                    if (bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '\"') {
                    if (!bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    stringBuffer.append("\\f");
                    continue;
                }
                if (c == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                if (c == '\b') {
                    stringBuffer.append("\\b");
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u");
            stringBuffer.append(WjHANiH[(c & 0xF000) >> 12]);
            stringBuffer.append(WjHANiH[(c & 0xF00) >> 8]);
            stringBuffer.append(WjHANiH[(c & 0xF0) >> 4]);
            stringBuffer.append(WjHANiH[c & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String convertToJavaName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.trim();
        boolean bl = false;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isWhitespace(c)) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static NdParsedURL parseRMIURL(String string) throws MalformedURLException {
        return NdParsedURL.parseURL(string);
    }

    public static NdParsedURL parseURL(String string) throws MalformedURLException {
        return NdParsedURL.parseURL(string);
    }

    private static URL WjHECvO(String string) throws MalformedURLException {
        URL uRL;
        File file = new File(string);
        if (file.exists()) {
            String string2 = string;
            if (!file.isAbsolute()) {
                string2 = file.getAbsolutePath();
            }
            try {
                uRL = new URL("file", "", -1, string2);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = new URL(string);
            }
        } else {
            uRL = NdIOUtil.WjHECvP(string);
        }
        return uRL;
    }

    private static URL WjHECvP(String string) throws MalformedURLException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            String string2 = string;
            if (!file.isAbsolute()) {
                string2 = file.getAbsolutePath();
            }
            uRL = new URL("file", "", -1, string2);
        }
        return uRL;
    }

    public static URL getURLForFileOrURLSpec(String string) throws MalformedURLException {
        URL uRL = string.indexOf(58) >= 0 ? (string.length() > 1 && string.charAt(1) == ':' && NdSystemProperties.isOSWindows() ? NdIOUtil.WjHECvO(string) : NdIOUtil.WjHECvP(string)) : NdIOUtil.WjHECvO(string);
        return uRL;
    }

    private static String WjHAJOJ(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static PropertyResourceBundle getNonLocalizedResourceBundleFromClasspath(Class clazz, String string) throws MissingResourceException {
        return NdIOUtil.WjHASaX(clazz, string, null, false);
    }

    public static PropertyResourceBundle getNonLocalizedResourceBundle(Class clazz, String string, String[] stringArray) throws MissingResourceException {
        return NdIOUtil.WjHASaX(clazz, string, stringArray, true);
    }

    private static String WjHFczW(Class clazz, String string) {
        String string2;
        String string3;
        String string4 = string;
        if (clazz != null && !string.startsWith("/") && (string3 = (string2 = NdIOUtil.WjHAJOJ(clazz)).replace('.', '/')).length() > 0) {
            string4 = string3 + "/" + string;
        }
        return string4;
    }

    private static PropertyResourceBundle WjHASaX(Class clazz, String string, String[] stringArray, boolean bl) throws MissingResourceException {
        Object object;
        PropertyResourceBundle propertyResourceBundle = null;
        String string2 = NdIOUtil.WjHFczW(clazz, string);
        String string3 = string2 + ".properties";
        if (bl && (object = NdSystemProperties.getSystemExternalResourceDirs()) != null && ((String[])object).length > 0) {
            propertyResourceBundle = NdIOUtil.WjHASdA(object, string2, string3);
        }
        if (propertyResourceBundle == null && stringArray != null && stringArray.length > 0) {
            propertyResourceBundle = NdIOUtil.WjHASdA(stringArray, string2, string3);
        }
        if (propertyResourceBundle == null) {
            if (!NdDotNETLib.isDotNETSupportEnabled() && System.getSecurityManager() != null) {
                propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string2);
            } else {
                object = "/" + string3;
                NdResourceManager ndResourceManager = NdDotNETLib.getResourceManager();
                InputStream inputStream = ndResourceManager.getResourceAsStream(clazz, (String)object);
                if (inputStream == null) {
                    throw new MissingResourceException(NdStrings.WjHzpAN("CannotOpenResourceStream", string3), string, "");
                }
                try {
                    inputStream = new BufferedInputStream(inputStream);
                    propertyResourceBundle = new PropertyResourceBundle(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new MissingResourceException(NdStrings.WjHzpBO("CannotReadResourceStream", object, iOException.getMessage()), string, "");
                }
            }
        }
        return propertyResourceBundle;
    }

    private static NdArrayList WjHDURP(String string, Locale locale) {
        String string2;
        int n;
        String string3;
        int n2;
        NdArrayList ndArrayList = new NdArrayList(3);
        String string4 = locale.getLanguage();
        int n3 = string4.length();
        if (n3 + (n2 = (string3 = locale.getCountry()).length()) + (n = (string2 = locale.getVariant()).length()) == 0) {
            return ndArrayList;
        }
        StringBuffer stringBuffer = new StringBuffer(string.replace('.', '/'));
        stringBuffer.append('_');
        stringBuffer.append(string4);
        ndArrayList.addElement(stringBuffer.toString() + ".properties");
        if (n2 + n == 0) {
            return ndArrayList;
        }
        stringBuffer.append('_');
        stringBuffer.append(string3);
        ndArrayList.addElement(stringBuffer.toString() + ".properties");
        if (n == 0) {
            return ndArrayList;
        }
        stringBuffer.append('_');
        stringBuffer.append(string2);
        ndArrayList.addElement(stringBuffer.toString() + ".properties");
        return ndArrayList;
    }

    private static PropertyResourceBundle WjHDUSQ(String[] stringArray, String string, NdArrayList ndArrayList) throws MissingResourceException {
        PropertyResourceBundle propertyResourceBundle = null;
        if (stringArray != null && stringArray.length > 0) {
            block2: for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < ndArrayList.size(); ++j) {
                    String string2 = (String)ndArrayList.elementAt(j);
                    String string3 = stringArray[i].endsWith("/") ? stringArray[i] + string2 : stringArray[i] + "/" + string2;
                    try {
                        File file = new File(string3);
                        if (!file.exists()) continue;
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        propertyResourceBundle = new PropertyResourceBundle(bufferedInputStream);
                        ((InputStream)bufferedInputStream).close();
                        continue block2;
                    }
                    catch (IOException iOException) {
                        throw new MissingResourceException(NdStrings.WjHzpBO("CannotReadResourceFile", string3, iOException.getMessage()), string, "");
                    }
                }
            }
        }
        return propertyResourceBundle;
    }

    private static PropertyResourceBundle WjHASdA(String[] stringArray, String string, String string2) throws MissingResourceException {
        PropertyResourceBundle propertyResourceBundle = null;
        try {
            InputStream inputStream = NdIOUtil.WjHFcCZ(null, stringArray, string2);
            if (inputStream != null) {
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new MissingResourceException(NdStrings.WjHzpBO("CannotReadResourceFile", string2, iOException.getMessage()), string, "");
        }
        return propertyResourceBundle;
    }

    private static File WjHFcAX(String string, String[] stringArray) {
        boolean bl;
        File file = null;
        try {
            bl = !new File(string).isAbsolute();
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].endsWith("/") ? stringArray[i] + string : stringArray[i] + "/" + string;
                File file2 = new File(string2);
                if (!file2.exists()) continue;
                file = file2;
                break;
            }
        }
        return file;
    }

    private static File WjHFcBY(Class clazz, String[] stringArray, String string) {
        String string2;
        File file = null;
        if (stringArray != null && stringArray.length > 0 && (file = NdIOUtil.WjHFcAX(string2 = NdIOUtil.WjHFczW(clazz, string), stringArray)) == null && WjHFcyV && string2 != string) {
            file = NdIOUtil.WjHFcAX(string, stringArray);
        }
        return file;
    }

    private static InputStream WjHFcCZ(Class clazz, String[] stringArray, String string) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        File file = NdIOUtil.WjHFcBY(clazz, stringArray, string);
        if (file != null) {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException iOException) {
                throw new NdWrappedIOException(NdStrings.WjHzpAN("CannotOpenResourceStream", file.getPath()), iOException);
            }
        }
        return bufferedInputStream;
    }

    private static PropertyResourceBundle WjHASdC(Class clazz, String string, String string2) throws MissingResourceException {
        PropertyResourceBundle propertyResourceBundle;
        String string3 = "/" + string2;
        NdResourceManager ndResourceManager = NdDotNETLib.getResourceManager();
        InputStream inputStream = ndResourceManager.getResourceAsStream(clazz, string3);
        if (inputStream == null) {
            propertyResourceBundle = null;
        } else {
            inputStream = new BufferedInputStream(inputStream);
            try {
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new MissingResourceException(NdStrings.WjHzpBO("CannotReadResourceStream", string3, iOException.getMessage()), string, "");
            }
        }
        return propertyResourceBundle;
    }

    private static PropertyResourceBundle WjHASdD(Class clazz, String string, Locale locale, String[] stringArray, boolean bl) throws MissingResourceException {
        String[] stringArray2;
        PropertyResourceBundle propertyResourceBundle = null;
        NdArrayList ndArrayList = null;
        NdArrayList ndArrayList2 = null;
        String string2 = null;
        if (bl && (stringArray2 = NdSystemProperties.getSystemExternalResourceDirs()) != null && stringArray2.length > 0 && (propertyResourceBundle = NdIOUtil.WjHDUSQ(stringArray2, string, ndArrayList = NdIOUtil.WjHDURP(string, locale))) == null) {
            if (!locale.equals(Locale.getDefault())) {
                ndArrayList2 = NdIOUtil.WjHDURP(string, Locale.getDefault());
                propertyResourceBundle = NdIOUtil.WjHDUSQ(stringArray2, string, ndArrayList2);
            }
            if (propertyResourceBundle == null) {
                string2 = string.replace('.', '/') + ".properties";
                propertyResourceBundle = NdIOUtil.WjHASdA(stringArray2, string, string2);
            }
        }
        if (propertyResourceBundle == null && stringArray != null && stringArray.length > 0) {
            if (ndArrayList == null) {
                ndArrayList = NdIOUtil.WjHDURP(string, locale);
            }
            if ((propertyResourceBundle = NdIOUtil.WjHDUSQ(stringArray, string, ndArrayList)) == null) {
                if (!locale.equals(Locale.getDefault())) {
                    if (ndArrayList2 == null) {
                        ndArrayList2 = NdIOUtil.WjHDURP(string, Locale.getDefault());
                    }
                    propertyResourceBundle = NdIOUtil.WjHDUSQ(stringArray, string, ndArrayList2);
                }
                if (propertyResourceBundle == null) {
                    if (string2 == null) {
                        string2 = string.replace('.', '/') + ".properties";
                    }
                    propertyResourceBundle = NdIOUtil.WjHASdA(stringArray, string, string2);
                }
            }
        }
        if (propertyResourceBundle == null) {
            if (System.getSecurityManager() != null && !NdDotNETLib.isDotNETSupportEnabled()) {
                propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string, locale);
            } else {
                String string3;
                int n;
                if (ndArrayList == null) {
                    ndArrayList = NdIOUtil.WjHDURP(string, locale);
                }
                propertyResourceBundle = null;
                for (n = 0; n < ndArrayList.size() && (propertyResourceBundle = NdIOUtil.WjHASdC(clazz, string, string3 = (String)ndArrayList.elementAt(n))) == null; ++n) {
                }
                if (propertyResourceBundle == null) {
                    if (!locale.equals(Locale.getDefault())) {
                        if (ndArrayList2 == null) {
                            ndArrayList2 = NdIOUtil.WjHDURP(string, Locale.getDefault());
                        }
                        for (n = 0; n < ndArrayList2.size() && (propertyResourceBundle = NdIOUtil.WjHASdC(clazz, string, string3 = (String)ndArrayList2.elementAt(n))) == null; ++n) {
                        }
                    }
                    if (propertyResourceBundle == null) {
                        if (string2 == null) {
                            string2 = string.replace('.', '/') + ".properties";
                        }
                        if ((propertyResourceBundle = NdIOUtil.WjHASdC(clazz, string, string2)) == null) {
                            throw new MissingResourceException(NdStrings.WjHzpAN("CannotFindResource", string), string, "");
                        }
                    }
                }
            }
        }
        return propertyResourceBundle;
    }

    public static PropertyResourceBundle getLocalizedResourceBundleFromClasspath(Class clazz, String string) throws MissingResourceException {
        PropertyResourceBundle propertyResourceBundle = NdIOUtil.getLocalizedResourceBundleFromClasspath(clazz, string, Locale.getDefault());
        return propertyResourceBundle;
    }

    public static PropertyResourceBundle getLocalizedResourceBundleFromClasspath(Class clazz, String string, Locale locale) throws MissingResourceException {
        return NdIOUtil.WjHASdD(clazz, string, locale, null, false);
    }

    public static PropertyResourceBundle getLocalizedResourceBundle(Class clazz, String string, Locale locale, String[] stringArray) throws MissingResourceException {
        return NdIOUtil.WjHASdD(clazz, string, locale, stringArray, true);
    }

    public static File[] listFiles(File file) {
        File[] fileArray = new File[]{};
        String[] stringArray = file.list();
        if (stringArray != null) {
            fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(file, stringArray[i]);
            }
        }
        return fileArray;
    }

    public static boolean isSameDrive(String string, String string2) {
        int n = string.indexOf(File.separatorChar);
        String string3 = n == -1 ? string.trim() : string.substring(0, n).trim();
        n = string2.indexOf(File.separatorChar);
        String string4 = n == -1 ? string2.trim() : string2.substring(0, n).trim();
        return string3.equals(string4);
    }

    private static String WjHDQuH(String string, String string2, String string3) {
        if (string2.equals(string)) {
            return "";
        }
        if (string2.startsWith(string) && string2.charAt(string.length()) == File.separatorChar) {
            return string3.substring(string.length() + 1, string3.length());
        }
        int n = string.lastIndexOf(File.separatorChar);
        String string4 = string.substring(0, n);
        String string5 = NdIOUtil.WjHDQuH(string4, string2, string3);
        if (string5.length() == 0) {
            return "..";
        }
        return ".." + File.separatorChar + string5;
    }

    public static String getRelativePath(String string, String string2) {
        String string3;
        String string4;
        String string5;
        try {
            string5 = new File(string).getCanonicalPath();
            string3 = string4 = new File(string2).getCanonicalPath();
            if (NdSystemProperties.isOSWindows()) {
                string5 = string5.toLowerCase();
                string4 = string4.toLowerCase();
            }
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException(iOException);
        }
        if (!NdIOUtil.isSameDrive(string5, string4)) {
            return string2;
        }
        if (string4.equals(string5)) {
            return "";
        }
        if (string5.endsWith(File.separator)) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if (string4.startsWith(string5) && string4.charAt(string5.length()) == File.separatorChar) {
            return string3.substring(string5.length() + 1, string3.length());
        }
        int n = string5.lastIndexOf(File.separatorChar);
        String string6 = string5.substring(0, n);
        String string7 = NdIOUtil.WjHDQuH(string6, string4, string3);
        if (string7.length() == 0) {
            return "..";
        }
        return ".." + File.separatorChar + string7;
    }

    public static String getAbsolutePath(String string, String string2) {
        String string3;
        if (string != null && string.length() > 0) {
            NdFile ndFile = NdDotNETLib.getFileSupport().getFile(NdIOUtil.getNormalizedPath(string));
            if (ndFile.isAbsolute()) {
                string3 = ndFile.getPath();
            } else if (string2 != null && string2.length() > 0) {
                NdFile ndFile2 = NdDotNETLib.getFileSupport().getFile(NdIOUtil.getNormalizedPath(string2), ndFile.getPath());
                string3 = ndFile2.getAbsolutePath();
            } else {
                string3 = ndFile.getAbsolutePath();
            }
        } else {
            string3 = string;
        }
        return string3;
    }

    public static String getNormalizedPath(String string) {
        if (string != null && string.length() > 0) {
            boolean bl = false;
            if (string.startsWith("\\\\")) {
                bl = true;
                string = string.substring(2);
            }
            if (File.separatorChar == '\\') {
                string = string.replace('/', File.separatorChar);
            } else if (File.separatorChar == '/') {
                string = string.replace('\\', File.separatorChar);
            }
            if (bl) {
                string = "\\\\" + string;
            }
        }
        return string;
    }

    public static class NdParsedURL {
        private String WjHBivT;
        private int WjHBiwU;
        private String WjHBixV;
        private String WjHBiyW;
        private static final String WjHBizX = "http";

        public static NdParsedURL parseURL(String string) throws MalformedURLException {
            URL uRL;
            String string2 = null;
            int n = string.indexOf(":");
            if (n > 0) {
                String string3 = WjHBizX + string.substring(n);
                string2 = string.substring(0, n);
                uRL = new URL(string3);
            } else {
                uRL = new URL(string);
            }
            return new NdParsedURL(uRL, string2);
        }

        public NdParsedURL(URL uRL) {
            this(uRL, null);
        }

        private NdParsedURL(URL uRL, String string) {
            int n;
            this.WjHBivT = string != null ? string : uRL.getProtocol();
            this.WjHBiwU = uRL.getPort();
            this.WjHBixV = uRL.getHost();
            String string2 = uRL.toString();
            if (this.WjHBiwU > -1) {
                String string3 = Integer.toString(this.WjHBiwU);
                n = string2.indexOf(string3) + string3.length();
            } else {
                n = this.WjHBixV != null ? string2.indexOf(this.WjHBixV) + this.WjHBixV.length() : ((n = string2.indexOf("//")) > -1 ? (n += 2) : ((n = string2.indexOf(":")) > -1 ? ++n : 0));
            }
            if (n >= string2.length()) {
                this.WjHBiyW = null;
            } else {
                String string4 = uRL.getFile();
                int n2 = string4 != null ? string2.indexOf(string4, n) : string2.length();
                this.WjHBiyW = n2 <= n ? null : string2.substring(n, n2);
            }
        }

        public String getProtocol() {
            return this.WjHBivT;
        }

        public int getPort() {
            return this.WjHBiwU;
        }

        public String getHostName() {
            return this.WjHBixV;
        }

        public String getPath() {
            return this.WjHBiyW;
        }
    }

    private static final class WjHANID {
        public final char[] WjHANGB;
        public int WjHANHC;

        WjHANID(char[] cArray, int n) {
            this.WjHANGB = cArray;
            this.WjHANHC = n;
        }
    }

    private static final class WjHAJbJ {
        public final byte[] WjHAJbH;
        public int WjHAJbI;

        WjHAJbJ(byte[] byArray, int n) {
            this.WjHAJbH = byArray;
            this.WjHAJbI = n;
        }
    }
}

