/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util;

import com.blazesoft.util.NdIOUtil;
import com.blazesoft.util.NdStrings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class NdJarMerger {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            System.out.println(NdStrings.WjHzpyL("JarMergerUsage"));
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                ZipFile zipFile = new ZipFile(stringArray[i]);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (hashtable.get(string) != null) continue;
                    hashtable.put(string, string);
                    byte[] byArray = NdIOUtil.readAllBytes(zipFile.getInputStream(zipEntry));
                    ZipEntry zipEntry2 = new ZipEntry(string);
                    zipOutputStream.putNextEntry(zipEntry2);
                    zipOutputStream.write(byArray, 0, byArray.length);
                    zipOutputStream.closeEntry();
                }
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error processing file " + stringArray[i] + "\n" + iOException);
            }
        }
        zipOutputStream.close();
    }
}

