/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.concurrent;

import com.blazesoft.util.concurrent.NdStrings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NdConcurrentArray
implements Cloneable,
Serializable {
    protected transient WjHBBVW[] table;
    protected static final int CONCURRENCY_LEVEL = 32;
    protected static final int SEGMENT_MASK = 31;
    protected final WjHBCzL[] segments = new WjHBCzL[32];
    public static int DEFAULT_INITIAL_CAPACITY = 64;
    private static final int WjHBBMY = 32;
    private static final int WjHBBMZ = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected float loadFactor;
    protected int threshold;
    protected int curMaxIndex;
    protected volatile transient int votesForResize;

    protected final int bitcount(int n) {
        n -= (0xAAAAAAAA & n) >>> 1;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0xFF;
    }

    private int WjHBBNA(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            for (n2 = 32; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    protected final int hash(int n) {
        return (n << 20) - n + (n >>> 22) + (n >>> 30);
    }

    protected WjHBBVW[] newTable(int n) {
        this.threshold = (int)((float)n * this.loadFactor / 32.0f) + 1;
        return new WjHBBVW[n];
    }

    public NdConcurrentArray(int n, float f) {
        int n2;
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException(NdStrings.WjHBDIA("IllegalLoadFactor") + f);
        }
        this.loadFactor = f;
        for (n2 = 0; n2 < this.segments.length; ++n2) {
            this.segments[n2] = new WjHBCzL();
        }
        n2 = this.WjHBBNA(n);
        this.table = this.newTable(n2);
    }

    protected NdConcurrentArray(NdConcurrentArray ndConcurrentArray) {
        this(Math.max((int)((float)ndConcurrentArray.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(ndConcurrentArray);
    }

    public NdConcurrentArray(int n) {
        this(n, 0.75f);
    }

    public NdConcurrentArray() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            n += this.segments[i].WjHBCzJ();
        }
        return n;
    }

    public int getLength() {
        return this.curMaxIndex;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].WjHBCzJ() == 0) continue;
            return false;
        }
        return true;
    }

    public void printStats() {
        for (int i = 0; i < this.segments.length; ++i) {
            System.out.print("," + this.segments[i].WjHBCzJ());
        }
        System.out.println();
        System.out.println(NdStrings.WjHBDIA("Total") + this.table.length + NdStrings.WjHBDIA("Threshold") + this.threshold + NdStrings.WjHBDIA("MaxCapacity") + 0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        WjHBCzL wjHBCzL;
        WjHBBVW[] wjHBBVWArray = this.table;
        int n2 = this.hash(n);
        int n3 = n2 & wjHBBVWArray.length - 1;
        WjHBBVW wjHBBVW = wjHBBVWArray[n3];
        if (wjHBBVW != null) {
            if (wjHBBVW.WjHBBQR == n2 && n == wjHBBVW.WjHBBOP) {
                return wjHBBVW.WjHBBPQ;
            }
            if (n3 != 0 || n == 0) {
                throw new IllegalStateException(NdStrings.WjHBDIA("IndexError"));
            }
        }
        WjHBCzL wjHBCzL2 = wjHBCzL = this.segments[n2 & 0x1F];
        synchronized (wjHBCzL2) {
            wjHBBVWArray = this.table;
            n3 = n2 & this.table.length - 1;
            WjHBBVW wjHBBVW2 = this.table[n3];
            if (wjHBBVW2 != null) {
                if (wjHBBVW2.WjHBBQR == n2 && n == wjHBBVW2.WjHBBOP) {
                    return wjHBBVW2.WjHBBPQ;
                }
                if (n3 == 0 && n != 0) {
                    throw new IndexOutOfBoundsException(NdStrings.WjHBDIA("IndexError"));
                }
                throw new IllegalStateException(NdStrings.WjHBDIA("IndexError"));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndex(int n) {
        WjHBCzL wjHBCzL;
        WjHBBVW[] wjHBBVWArray = this.table;
        int n2 = this.hash(n);
        int n3 = n2 & wjHBBVWArray.length - 1;
        WjHBBVW wjHBBVW = wjHBBVWArray[n3];
        if (wjHBBVW != null && wjHBBVW.WjHBBQR == n2 && n == wjHBBVW.WjHBBOP) {
            return true;
        }
        WjHBCzL wjHBCzL2 = wjHBCzL = this.segments[n2 & 0x1F];
        synchronized (wjHBCzL2) {
            wjHBBVWArray = this.table;
            n3 = n2 & this.table.length - 1;
            WjHBBVW wjHBBVW2 = this.table[n3];
            return wjHBBVW2 != null && wjHBBVW2.WjHBBQR == n2 && n == wjHBBVW2.WjHBBOP;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int n, Object object) {
        int n2;
        int n3;
        int n4 = this.hash(n);
        WjHBCzL wjHBCzL = this.segments[n4 & 0x1F];
        WjHBBVW[] wjHBBVWArray = this.table;
        WjHBCzL wjHBCzL2 = wjHBCzL;
        synchronized (wjHBCzL2) {
            WjHBBVW wjHBBVW;
            wjHBBVWArray = this.table;
            int n5 = n4 & wjHBBVWArray.length - 1;
            WjHBBVW wjHBBVW2 = wjHBBVWArray[n5];
            if (wjHBBVW2 != null) {
                if (wjHBBVW2.WjHBBQR == n4 && n == wjHBBVW2.WjHBBOP) {
                    wjHBBVW2.WjHBBPQ = object;
                    return;
                }
                throw new IllegalStateException(NdStrings.WjHBDIA("IndexError"));
            }
            this.table[n5] = wjHBBVW = new WjHBBVW(n4, n, object, wjHBBVW2);
            if (n > this.curMaxIndex) {
                this.curMaxIndex = n;
            }
            n3 = ++wjHBCzL.WjHBCzI;
            if (wjHBCzL.WjHBCzI < this.threshold) {
                return;
            }
            n2 = this.votesForResize;
            int n6 = 1 << (n4 & 0x1F);
            if ((n2 & n6) == 0) {
                n2 = this.votesForResize |= n6;
            }
        }
        if (this.bitcount(n2) >= 8 || n3 > this.threshold * 32) {
            this.resize(0, wjHBBVWArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int n, WjHBBVW[] wjHBBVWArray) {
        WjHBCzL wjHBCzL;
        WjHBCzL wjHBCzL2 = wjHBCzL = this.segments[n];
        synchronized (wjHBCzL2) {
            if (wjHBBVWArray == this.table) {
                int n2 = n + 1;
                if (n2 < this.segments.length) {
                    this.resize(n2, wjHBBVWArray);
                } else {
                    this.rehash();
                }
            }
        }
    }

    protected void rehash() {
        this.votesForResize = 0;
        WjHBBVW[] wjHBBVWArray = this.table;
        int n = wjHBBVWArray.length;
        if (n >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n2 = n << 1;
        WjHBBVW[] wjHBBVWArray2 = this.newTable(n2);
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            WjHBBVW wjHBBVW = wjHBBVWArray[i];
            if (wjHBBVW == null) continue;
            int n4 = wjHBBVW.WjHBBQR & n3;
            wjHBBVWArray2[n4] = wjHBBVW;
        }
        this.table = wjHBBVWArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        WjHBCzL wjHBCzL;
        int n2 = this.hash(n);
        WjHBCzL wjHBCzL2 = wjHBCzL = this.segments[n2 & 0x1F];
        synchronized (wjHBCzL2) {
            WjHBBVW[] wjHBBVWArray = this.table;
            int n3 = n2 & wjHBBVWArray.length - 1;
            WjHBBVW wjHBBVW = wjHBBVWArray[n3];
            if (wjHBBVW != null && wjHBBVW.WjHBBQR == n2 && n == wjHBBVW.WjHBBOP) {
                wjHBBVWArray[n3] = null;
                --wjHBCzL.WjHBCzI;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            WjHBBVW[] wjHBBVWArray;
            WjHBCzL wjHBCzL;
            WjHBCzL wjHBCzL2 = wjHBCzL = this.segments[i];
            synchronized (wjHBCzL2) {
                wjHBBVWArray = this.table;
            }
            for (int j = i; j < wjHBBVWArray.length; j += this.segments.length) {
                WjHBBVW wjHBBVW = wjHBBVWArray[j];
                while (wjHBBVW != null) {
                    if (object.equals(wjHBBVW.WjHBBPQ)) {
                        return true;
                    }
                    wjHBBVW = wjHBBVW.WjHBBRS;
                }
            }
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            WjHBCzL wjHBCzL;
            WjHBCzL wjHBCzL2 = wjHBCzL = this.segments[i];
            synchronized (wjHBCzL2) {
                WjHBBVW[] wjHBBVWArray = this.table;
                for (int j = i; j < wjHBBVWArray.length; j += this.segments.length) {
                    WjHBBVW wjHBBVW = wjHBBVWArray[j];
                    while (wjHBBVW != null) {
                        wjHBBVW.WjHBBPQ = null;
                        wjHBBVW = wjHBBVW.WjHBBRS;
                    }
                    wjHBBVWArray[j] = null;
                    wjHBCzL.WjHBCzI = 0;
                }
                continue;
            }
        }
    }

    public Object clone() {
        return new NdConcurrentArray(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAll(NdConcurrentArray ndConcurrentArray) {
        WjHBBVW[] wjHBBVWArray;
        int n = ndConcurrentArray.size();
        if (n == 0) {
            return;
        }
        while (true) {
            int n2;
            WjHBBVW[] wjHBBVWArray2;
            wjHBBVWArray = this.segments[0];
            synchronized (wjHBBVWArray) {
                wjHBBVWArray2 = this.table;
                n2 = this.threshold * 32;
            }
            if (n < n2) break;
            this.resize(0, wjHBBVWArray2);
        }
        for (int i = 0; i < ndConcurrentArray.segments.length; ++i) {
            WjHBCzL wjHBCzL;
            WjHBCzL wjHBCzL2 = wjHBCzL = ndConcurrentArray.segments[i];
            synchronized (wjHBCzL2) {
                wjHBBVWArray = ndConcurrentArray.table;
            }
            for (int j = i; j < wjHBBVWArray.length; j += ndConcurrentArray.segments.length) {
                WjHBBVW wjHBBVW = wjHBBVWArray[j];
                this.put(wjHBBVW.WjHBBOP, wjHBBVW.WjHBBPQ);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        WjHBCzL wjHBCzL = this.segments[0];
        synchronized (wjHBCzL) {
            n = this.table.length;
        }
        objectOutputStream.writeInt(n);
        for (int i = 0; i < this.segments.length; ++i) {
            WjHBBVW[] wjHBBVWArray;
            WjHBCzL wjHBCzL2;
            WjHBCzL wjHBCzL3 = wjHBCzL2 = this.segments[i];
            synchronized (wjHBCzL3) {
                wjHBBVWArray = this.table;
            }
            for (int j = i; j < wjHBBVWArray.length; j += this.segments.length) {
                WjHBBVW wjHBBVW = wjHBBVWArray[j];
                while (wjHBBVW != null) {
                    objectOutputStream.writeInt(wjHBBVW.WjHBBOP);
                    objectOutputStream.writeObject(wjHBBVW.WjHBBPQ);
                    wjHBBVW = wjHBBVW.WjHBBRS;
                }
            }
        }
        objectOutputStream.writeInt(-1);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.table = this.newTable(n2);
        for (n = 0; n < this.segments.length; ++n) {
            this.segments[n] = new WjHBCzL();
        }
        while (true) {
            n = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            if (n == -1) break;
            this.put(n, object);
        }
    }

    protected static class WjHBBVW {
        protected final int WjHBBOP;
        protected volatile Object WjHBBPQ;
        protected final int WjHBBQR;
        protected final WjHBBVW WjHBBRS;

        WjHBBVW(int n, int n2, Object object, WjHBBVW wjHBBVW) {
            this.WjHBBPQ = object;
            this.WjHBBQR = n;
            this.WjHBBOP = n2;
            this.WjHBBRS = wjHBBVW;
        }

        public int WjHBBST() {
            return this.WjHBBOP;
        }

        public Object WjHBBTU() {
            return this.WjHBBPQ;
        }

        public Object WjHBBUV(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.WjHBBPQ;
            this.WjHBBPQ = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WjHBBVW)) {
                return false;
            }
            WjHBBVW wjHBBVW = (WjHBBVW)object;
            return this.WjHBBOP == wjHBBVW.WjHBBST() && this.WjHBBPQ.equals(wjHBBVW.WjHBBTU());
        }

        public int hashCode() {
            return this.WjHBBOP ^ this.WjHBBPQ.hashCode();
        }

        public String toString() {
            return this.WjHBBOP + "=" + this.WjHBBPQ;
        }
    }

    protected static final class WjHBCzL
    implements Serializable {
        protected int WjHBCzI;

        protected WjHBCzL() {
        }

        protected synchronized int WjHBCzJ() {
            return this.WjHBCzI;
        }

        protected synchronized void WjHBCzK() {
        }
    }
}

