/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.concurrent;

import com.blazesoft.util.concurrent.NdStrings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NdConcurrentHashtable
extends Dictionary
implements Cloneable,
Serializable {
    protected transient WjHBBWZ[] table;
    protected static final int CONCURRENCY_LEVEL = 32;
    protected static final int SEGMENT_MASK = 31;
    protected final WjHBDMT[] segments = new WjHBDMT[32];
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int WjHBDAH = 32;
    private static final int WjHBDAI = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected float loadFactor;
    protected int threshold;
    protected volatile transient int votesForResize;

    protected static int bitcount(int n) {
        n -= (0xAAAAAAAA & n) >>> 1;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0xFF;
    }

    private int WjHBDAJ(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            for (n2 = 32; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    protected static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected WjHBBWZ[] newTable(int n) {
        this.threshold = (int)((float)n * this.loadFactor / 32.0f) + 1;
        return new WjHBBWZ[n];
    }

    public NdConcurrentHashtable(int n, float f) {
        int n2;
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException(NdStrings.WjHBDIA("IllegalLoadFactor") + f);
        }
        this.loadFactor = f;
        for (n2 = 0; n2 < this.segments.length; ++n2) {
            this.segments[n2] = new WjHBDMT();
        }
        n2 = this.WjHBDAJ(n);
        this.table = this.newTable(n2);
    }

    protected NdConcurrentHashtable(NdConcurrentHashtable ndConcurrentHashtable) {
        this(Math.max((int)((float)ndConcurrentHashtable.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(ndConcurrentHashtable);
    }

    public NdConcurrentHashtable(int n) {
        this(n, 0.75f);
    }

    public NdConcurrentHashtable() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            n += this.segments[i].WjHBDKR();
        }
        return n;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].WjHBDKR() == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Object object2;
        WjHBBWZ wjHBBWZ;
        int n = NdConcurrentHashtable.hash(object);
        WjHBBWZ[] wjHBBWZArray = this.table;
        int n2 = n & wjHBBWZArray.length - 1;
        WjHBBWZ wjHBBWZ2 = wjHBBWZ = wjHBBWZArray[n2];
        while (wjHBBWZ2 != null) {
            if (wjHBBWZ2.WjHBBWU == n && this.eq(object, wjHBBWZ2.WjHBBWS)) {
                object2 = wjHBBWZ2.WjHBBWT;
                if (object2 == null) break;
                return object2;
            }
            wjHBBWZ2 = wjHBBWZ2.WjHBBWV;
        }
        object2 = this.segments[n & 0x1F];
        WjHBDMT wjHBDMT = object2;
        synchronized (wjHBDMT) {
            wjHBBWZArray = this.table;
            n2 = n & wjHBBWZArray.length - 1;
            WjHBBWZ wjHBBWZ3 = wjHBBWZArray[n2];
            if (wjHBBWZ2 != null || wjHBBWZ != wjHBBWZ3) {
                wjHBBWZ2 = wjHBBWZ3;
                while (wjHBBWZ2 != null) {
                    if (wjHBBWZ2.WjHBBWU == n && this.eq(object, wjHBBWZ2.WjHBBWS)) {
                        return wjHBBWZ2.WjHBBWT;
                    }
                    wjHBBWZ2 = wjHBBWZ2.WjHBBWV;
                }
            }
            return null;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        int n;
        int n2;
        WjHBBWZ[] wjHBBWZArray;
        WjHBDMT wjHBDMT;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n3 = NdConcurrentHashtable.hash(object);
        WjHBDMT wjHBDMT2 = wjHBDMT = this.segments[n3 & 0x1F];
        synchronized (wjHBDMT2) {
            WjHBBWZ wjHBBWZ;
            wjHBBWZArray = this.table;
            int n4 = n3 & wjHBBWZArray.length - 1;
            WjHBBWZ wjHBBWZ2 = wjHBBWZ = wjHBBWZArray[n4];
            while (wjHBBWZ2 != null) {
                if (wjHBBWZ2.WjHBBWU == n3 && this.eq(object, wjHBBWZ2.WjHBBWS)) {
                    Object object3 = wjHBBWZ2.WjHBBWT;
                    wjHBBWZ2.WjHBBWT = object2;
                    return object3;
                }
                wjHBBWZ2 = wjHBBWZ2.WjHBBWV;
            }
            wjHBBWZArray[n4] = wjHBBWZ2 = new WjHBBWZ(n3, object, object2, wjHBBWZ);
            n2 = ++wjHBDMT.WjHBDJQ;
            if (wjHBDMT.WjHBDJQ < this.threshold) {
                return null;
            }
            n = this.votesForResize;
            int n5 = 1 << (n3 & 0x1F);
            if ((n & n5) == 0) {
                n = this.votesForResize |= n5;
            }
        }
        if (NdConcurrentHashtable.bitcount(n) >= 8 || n2 > this.threshold * 32) {
            this.resize(0, wjHBBWZArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int n, WjHBBWZ[] wjHBBWZArray) {
        WjHBDMT wjHBDMT;
        WjHBDMT wjHBDMT2 = wjHBDMT = this.segments[n];
        synchronized (wjHBDMT2) {
            if (wjHBBWZArray == this.table) {
                int n2 = n + 1;
                if (n2 < this.segments.length) {
                    this.resize(n2, wjHBBWZArray);
                } else {
                    this.rehash();
                }
            }
        }
    }

    protected void rehash() {
        this.votesForResize = 0;
        WjHBBWZ[] wjHBBWZArray = this.table;
        int n = wjHBBWZArray.length;
        if (n >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n2 = n << 1;
        WjHBBWZ[] wjHBBWZArray2 = this.newTable(n2);
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            WjHBBWZ wjHBBWZ = wjHBBWZArray[i];
            if (wjHBBWZ == null) continue;
            int n5 = wjHBBWZ.WjHBBWU & n3;
            WjHBBWZ wjHBBWZ2 = wjHBBWZ.WjHBBWV;
            if (wjHBBWZ2 == null) {
                wjHBBWZArray2[n5] = wjHBBWZ;
                continue;
            }
            WjHBBWZ wjHBBWZ3 = wjHBBWZ;
            int n6 = n5;
            WjHBBWZ wjHBBWZ4 = wjHBBWZ2;
            while (wjHBBWZ4 != null) {
                n4 = wjHBBWZ4.WjHBBWU & n3;
                if (n4 != n6) {
                    n6 = n4;
                    wjHBBWZ3 = wjHBBWZ4;
                }
                wjHBBWZ4 = wjHBBWZ4.WjHBBWV;
            }
            wjHBBWZArray2[n6] = wjHBBWZ3;
            wjHBBWZ4 = wjHBBWZ;
            while (wjHBBWZ4 != wjHBBWZ3) {
                n4 = wjHBBWZ4.WjHBBWU & n3;
                wjHBBWZArray2[n4] = new WjHBBWZ(wjHBBWZ4.WjHBBWU, wjHBBWZ4.WjHBBWS, wjHBBWZ4.WjHBBWT, wjHBBWZArray2[n4]);
                wjHBBWZ4 = wjHBBWZ4.WjHBBWV;
            }
        }
        this.table = wjHBBWZArray2;
    }

    public Object remove(Object object) {
        return this.remove(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(Object object, Object object2) {
        WjHBDMT wjHBDMT;
        int n = NdConcurrentHashtable.hash(object);
        WjHBDMT wjHBDMT2 = wjHBDMT = this.segments[n & 0x1F];
        synchronized (wjHBDMT2) {
            WjHBBWZ wjHBBWZ;
            WjHBBWZ[] wjHBBWZArray = this.table;
            int n2 = n & wjHBBWZArray.length - 1;
            WjHBBWZ wjHBBWZ2 = wjHBBWZ = wjHBBWZArray[n2];
            while (true) {
                if (wjHBBWZ2 == null) {
                    return null;
                }
                if (wjHBBWZ2.WjHBBWU == n && this.eq(object, wjHBBWZ2.WjHBBWS)) break;
                wjHBBWZ2 = wjHBBWZ2.WjHBBWV;
            }
            Object object3 = wjHBBWZ2.WjHBBWT;
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            wjHBBWZ2.WjHBBWT = null;
            WjHBBWZ wjHBBWZ3 = wjHBBWZ2.WjHBBWV;
            WjHBBWZ wjHBBWZ4 = wjHBBWZ;
            while (wjHBBWZ4 != wjHBBWZ2) {
                wjHBBWZ3 = new WjHBBWZ(wjHBBWZ4.WjHBBWU, wjHBBWZ4.WjHBBWS, wjHBBWZ4.WjHBBWT, wjHBBWZ3);
                wjHBBWZ4 = wjHBBWZ4.WjHBBWV;
            }
            wjHBBWZArray[n2] = wjHBBWZ3;
            --wjHBDMT.WjHBDJQ;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            WjHBBWZ[] wjHBBWZArray;
            WjHBDMT wjHBDMT;
            WjHBDMT wjHBDMT2 = wjHBDMT = this.segments[i];
            synchronized (wjHBDMT2) {
                wjHBBWZArray = this.table;
            }
            for (int j = i; j < wjHBBWZArray.length; j += this.segments.length) {
                WjHBBWZ wjHBBWZ = wjHBBWZArray[j];
                while (wjHBBWZ != null) {
                    if (object.equals(wjHBBWZ.WjHBBWT)) {
                        return true;
                    }
                    wjHBBWZ = wjHBBWZ.WjHBBWV;
                }
            }
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            WjHBDMT wjHBDMT;
            WjHBDMT wjHBDMT2 = wjHBDMT = this.segments[i];
            synchronized (wjHBDMT2) {
                WjHBBWZ[] wjHBBWZArray = this.table;
                for (int j = i; j < wjHBBWZArray.length; j += this.segments.length) {
                    WjHBBWZ wjHBBWZ = wjHBBWZArray[j];
                    while (wjHBBWZ != null) {
                        wjHBBWZ.WjHBBWT = null;
                        wjHBBWZ = wjHBBWZ.WjHBBWV;
                    }
                    wjHBBWZArray[j] = null;
                    wjHBDMT.WjHBDJQ = 0;
                }
                continue;
            }
        }
    }

    public Object clone() {
        return new NdConcurrentHashtable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAll(NdConcurrentHashtable ndConcurrentHashtable) {
        Object object;
        int n = ndConcurrentHashtable.size();
        if (n == 0) {
            return;
        }
        while (true) {
            int n2;
            WjHBDMT wjHBDMT = this.segments[0];
            synchronized (wjHBDMT) {
                object = this.table;
                n2 = this.threshold * 32;
            }
            if (n < n2) break;
            this.resize(0, (WjHBBWZ[])object);
        }
        object = ndConcurrentHashtable.entries();
        while (object.hasMoreElements()) {
            WjHBBWZ wjHBBWZ = (WjHBBWZ)object.nextElement();
            this.put(wjHBBWZ.WjHBBWW(), wjHBBWZ.WjHBBWX());
        }
    }

    public Enumeration keys() {
        return new WjHBDYU();
    }

    public Enumeration elements() {
        return new WjHBDaO();
    }

    protected Enumeration entries() {
        return new WjHBDOE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        WjHBDMT wjHBDMT = this.segments[0];
        synchronized (wjHBDMT) {
            n = this.table.length;
        }
        objectOutputStream.writeInt(n);
        for (int i = 0; i < this.segments.length; ++i) {
            WjHBBWZ[] wjHBBWZArray;
            WjHBDMT wjHBDMT2;
            WjHBDMT wjHBDMT3 = wjHBDMT2 = this.segments[i];
            synchronized (wjHBDMT3) {
                wjHBBWZArray = this.table;
            }
            for (int j = i; j < wjHBBWZArray.length; j += this.segments.length) {
                WjHBBWZ wjHBBWZ = wjHBBWZArray[j];
                while (wjHBBWZ != null) {
                    objectOutputStream.writeObject(wjHBBWZ.WjHBBWS);
                    objectOutputStream.writeObject(wjHBBWZ.WjHBBWT);
                    wjHBBWZ = wjHBBWZ.WjHBBWV;
                }
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = this.newTable(n);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new WjHBDMT();
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    protected class WjHBDOE
    extends WjHBDxC {
        protected WjHBDOE() {
        }

        protected Object WjHBDuZ() {
            return this.WjHBDuU;
        }
    }

    protected class WjHBDaO
    extends WjHBDxC {
        protected WjHBDaO() {
        }

        protected Object WjHBDuZ() {
            return this.WjHBDuW;
        }
    }

    protected class WjHBDYU
    extends WjHBDxC {
        protected WjHBDYU() {
        }

        protected Object WjHBDuZ() {
            return this.WjHBDuV;
        }
    }

    protected class WjHBDxC
    implements Enumeration {
        protected final WjHBBWZ[] WjHBDuS;
        protected int WjHBDuT;
        protected WjHBBWZ WjHBDuU = null;
        protected Object WjHBDuV;
        protected Object WjHBDuW;
        protected WjHBBWZ WjHBDuX = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WjHBDxC() {
            WjHBDMT wjHBDMT = NdConcurrentHashtable.this.segments[0];
            synchronized (wjHBDMT) {
                this.WjHBDuS = NdConcurrentHashtable.this.table;
            }
            for (int i = 1; i < NdConcurrentHashtable.this.segments.length; ++i) {
                NdConcurrentHashtable.this.segments[i].WjHBDLS();
            }
            this.WjHBDuT = this.WjHBDuS.length - 1;
        }

        public boolean hasMoreElements() {
            return this.WjHBDuY();
        }

        public Object nextElement() {
            return this.WjHBDvA();
        }

        protected boolean WjHBDuY() {
            do {
                if (this.WjHBDuU != null) {
                    Object object = this.WjHBDuU.WjHBBWT;
                    if (object != null) {
                        this.WjHBDuV = this.WjHBDuU.WjHBBWS;
                        this.WjHBDuW = object;
                        return true;
                    }
                    this.WjHBDuU = this.WjHBDuU.WjHBBWV;
                }
                while (this.WjHBDuU == null && this.WjHBDuT >= 0) {
                    this.WjHBDuU = this.WjHBDuS[this.WjHBDuT--];
                }
            } while (this.WjHBDuU != null);
            this.WjHBDuW = null;
            this.WjHBDuV = null;
            return false;
        }

        protected Object WjHBDuZ() {
            return this.WjHBDuU;
        }

        protected Object WjHBDvA() {
            if (this.WjHBDuV == null && !this.WjHBDuY()) {
                throw new NoSuchElementException();
            }
            Object object = this.WjHBDuZ();
            this.WjHBDuX = this.WjHBDuU;
            this.WjHBDuW = null;
            this.WjHBDuV = null;
            this.WjHBDuU = this.WjHBDuU.WjHBBWV;
            return object;
        }

        protected void WjHBDwB() {
            if (this.WjHBDuX == null) {
                throw new IllegalStateException();
            }
            NdConcurrentHashtable.this.remove(this.WjHBDuX.WjHBBWS);
            this.WjHBDuX = null;
        }
    }

    protected static class WjHBBWZ {
        protected final Object WjHBBWS;
        protected volatile Object WjHBBWT;
        protected final int WjHBBWU;
        protected final WjHBBWZ WjHBBWV;

        WjHBBWZ(int n, Object object, Object object2, WjHBBWZ wjHBBWZ) {
            this.WjHBBWT = object2;
            this.WjHBBWU = n;
            this.WjHBBWS = object;
            this.WjHBBWV = wjHBBWZ;
        }

        public Object WjHBBWW() {
            return this.WjHBBWS;
        }

        public Object WjHBBWX() {
            return this.WjHBBWT;
        }

        public Object WjHBBWY(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.WjHBBWT;
            this.WjHBBWT = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WjHBBWZ)) {
                return false;
            }
            WjHBBWZ wjHBBWZ = (WjHBBWZ)object;
            return this.WjHBBWS.equals(wjHBBWZ.WjHBBWW()) && this.WjHBBWT.equals(wjHBBWZ.WjHBBWX());
        }

        public int hashCode() {
            return this.WjHBBWS.hashCode() ^ this.WjHBBWT.hashCode();
        }

        public String toString() {
            return this.WjHBBWS + "=" + this.WjHBBWT;
        }
    }

    protected static final class WjHBDMT
    implements Serializable {
        protected int WjHBDJQ;

        protected WjHBDMT() {
        }

        protected synchronized int WjHBDKR() {
            return this.WjHBDJQ;
        }

        protected synchronized void WjHBDLS() {
        }
    }
}

