/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.concurrent;

import com.blazesoft.util.NdObjectReader;
import com.blazesoft.util.NdObjectWriter;
import com.blazesoft.util.NdSerializable;
import com.blazesoft.util.NdSerializationException;
import com.blazesoft.util.concurrent.NdStrings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NdConcurrentReaderHashtable
extends Dictionary
implements Cloneable,
NdSerializable {
    protected final WjHBCFJ barrierLock = new WjHBCFJ();
    protected transient Object lastWrite;
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int WjHBDhY = 4;
    private static final int WjHBDhZ = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient WjHBCzG[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordModification(Object object) {
        WjHBCFJ wjHBCFJ = this.barrierLock;
        synchronized (wjHBCFJ) {
            this.lastWrite = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final WjHBCzG[] getTableForReading() {
        WjHBCFJ wjHBCFJ = this.barrierLock;
        synchronized (wjHBCFJ) {
            return this.table;
        }
    }

    private int WjHBDiA(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    private static int WjHBDjB(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public NdConcurrentReaderHashtable(int n, float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(NdStrings.WjHBDIA("IllegalLoadFactor") + f);
        }
        this.loadFactor = f;
        int n2 = this.WjHBDiA(n);
        this.table = new WjHBCzG[n2];
        this.threshold = (int)((float)n2 * f);
    }

    public NdConcurrentReaderHashtable(int n) {
        this(n, 0.75f);
    }

    public NdConcurrentReaderHashtable() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    protected NdConcurrentReaderHashtable(NdConcurrentReaderHashtable ndConcurrentReaderHashtable) {
        this(Math.max((int)((float)ndConcurrentReaderHashtable.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(ndConcurrentReaderHashtable);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        WjHBCzG wjHBCzG;
        int n = NdConcurrentReaderHashtable.WjHBDjB(object);
        WjHBCzG[] wjHBCzGArray = this.table;
        int n2 = n & wjHBCzGArray.length - 1;
        WjHBCzG wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
        while (true) {
            Object object2;
            if (wjHBCzG2 == null) {
                object2 = this.getTableForReading();
                if (wjHBCzGArray == object2 && wjHBCzG == wjHBCzGArray[n2]) {
                    return null;
                }
                wjHBCzGArray = object2;
                n2 = n & wjHBCzGArray.length - 1;
                wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
                continue;
            }
            if (wjHBCzG2.WjHBCyZ == n && this.eq(object, wjHBCzG2.WjHBCzA)) {
                object2 = wjHBCzG2.WjHBCzC;
                if (object2 != null) {
                    return object2;
                }
                NdConcurrentReaderHashtable ndConcurrentReaderHashtable = this;
                synchronized (ndConcurrentReaderHashtable) {
                    wjHBCzGArray = this.table;
                }
                n2 = n & wjHBCzGArray.length - 1;
                wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
                continue;
            }
            wjHBCzG2 = wjHBCzG2.WjHBCzB;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        WjHBCzG wjHBCzG;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = NdConcurrentReaderHashtable.WjHBDjB(object);
        WjHBCzG[] wjHBCzGArray = this.table;
        int n2 = n & wjHBCzGArray.length - 1;
        WjHBCzG wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
        while (!(wjHBCzG2 == null || wjHBCzG2.WjHBCyZ == n && this.eq(object, wjHBCzG2.WjHBCzA))) {
            wjHBCzG2 = wjHBCzG2.WjHBCzB;
        }
        NdConcurrentReaderHashtable ndConcurrentReaderHashtable = this;
        synchronized (ndConcurrentReaderHashtable) {
            if (wjHBCzGArray == this.table) {
                if (wjHBCzG2 == null) {
                    if (wjHBCzG == wjHBCzGArray[n2]) {
                        WjHBCzG wjHBCzG3;
                        wjHBCzGArray[n2] = wjHBCzG3 = new WjHBCzG(n, object, object2, wjHBCzG);
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(wjHBCzG3);
                        }
                        return null;
                    }
                } else {
                    Object object3 = wjHBCzG2.WjHBCzC;
                    if (wjHBCzG == wjHBCzGArray[n2] && object3 != null) {
                        wjHBCzG2.WjHBCzC = object2;
                        return object3;
                    }
                }
            }
            return this.sput(object, object2, n);
        }
    }

    protected Object sput(Object object, Object object2, int n) {
        WjHBCzG wjHBCzG;
        WjHBCzG[] wjHBCzGArray = this.table;
        int n2 = n & wjHBCzGArray.length - 1;
        WjHBCzG wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
        while (true) {
            if (wjHBCzG2 == null) {
                WjHBCzG wjHBCzG3;
                wjHBCzGArray[n2] = wjHBCzG3 = new WjHBCzG(n, object, object2, wjHBCzG);
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(wjHBCzG3);
                }
                return null;
            }
            if (wjHBCzG2.WjHBCyZ == n && this.eq(object, wjHBCzG2.WjHBCzA)) {
                Object object3 = wjHBCzG2.WjHBCzC;
                wjHBCzG2.WjHBCzC = object2;
                return object3;
            }
            wjHBCzG2 = wjHBCzG2.WjHBCzB;
        }
    }

    protected void rehash() {
        WjHBCzG[] wjHBCzGArray = this.table;
        int n = wjHBCzGArray.length;
        if (n >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n2 = n << 1;
        int n3 = n2 - 1;
        this.threshold = (int)((float)n2 * this.loadFactor);
        WjHBCzG[] wjHBCzGArray2 = new WjHBCzG[n2];
        for (int i = 0; i < n; ++i) {
            int n4;
            WjHBCzG wjHBCzG = wjHBCzGArray[i];
            if (wjHBCzG == null) continue;
            int n5 = wjHBCzG.WjHBCyZ & n3;
            WjHBCzG wjHBCzG2 = wjHBCzG.WjHBCzB;
            if (wjHBCzG2 == null) {
                wjHBCzGArray2[n5] = wjHBCzG;
                continue;
            }
            WjHBCzG wjHBCzG3 = wjHBCzG;
            int n6 = n5;
            WjHBCzG wjHBCzG4 = wjHBCzG2;
            while (wjHBCzG4 != null) {
                n4 = wjHBCzG4.WjHBCyZ & n3;
                if (n4 != n6) {
                    n6 = n4;
                    wjHBCzG3 = wjHBCzG4;
                }
                wjHBCzG4 = wjHBCzG4.WjHBCzB;
            }
            wjHBCzGArray2[n6] = wjHBCzG3;
            wjHBCzG4 = wjHBCzG;
            while (wjHBCzG4 != wjHBCzG3) {
                n4 = wjHBCzG4.WjHBCyZ & n3;
                wjHBCzGArray2[n4] = new WjHBCzG(wjHBCzG4.WjHBCyZ, wjHBCzG4.WjHBCzA, wjHBCzG4.WjHBCzC, wjHBCzGArray2[n4]);
                wjHBCzG4 = wjHBCzG4.WjHBCzB;
            }
        }
        this.table = wjHBCzGArray2;
        this.recordModification(wjHBCzGArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        WjHBCzG wjHBCzG;
        int n = NdConcurrentReaderHashtable.WjHBDjB(object);
        WjHBCzG[] wjHBCzGArray = this.table;
        int n2 = n & wjHBCzGArray.length - 1;
        WjHBCzG wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
        wjHBCzG2 = wjHBCzG;
        while (!(wjHBCzG2 == null || wjHBCzG2.WjHBCyZ == n && this.eq(object, wjHBCzG2.WjHBCzA))) {
            wjHBCzG2 = wjHBCzG2.WjHBCzB;
        }
        NdConcurrentReaderHashtable ndConcurrentReaderHashtable = this;
        synchronized (ndConcurrentReaderHashtable) {
            if (wjHBCzGArray == this.table) {
                if (wjHBCzG2 == null) {
                    if (wjHBCzG == wjHBCzGArray[n2]) {
                        return null;
                    }
                } else {
                    Object object2 = wjHBCzG2.WjHBCzC;
                    if (wjHBCzG == wjHBCzGArray[n2] && object2 != null) {
                        wjHBCzG2.WjHBCzC = null;
                        --this.count;
                        WjHBCzG wjHBCzG3 = wjHBCzG2.WjHBCzB;
                        WjHBCzG wjHBCzG4 = wjHBCzG;
                        while (wjHBCzG4 != wjHBCzG2) {
                            wjHBCzG3 = new WjHBCzG(wjHBCzG4.WjHBCyZ, wjHBCzG4.WjHBCzA, wjHBCzG4.WjHBCzC, wjHBCzG3);
                            wjHBCzG4 = wjHBCzG4.WjHBCzB;
                        }
                        wjHBCzGArray[n2] = wjHBCzG3;
                        this.recordModification(wjHBCzG3);
                        return object2;
                    }
                }
            }
            return this.sremove(object, n);
        }
    }

    protected Object sremove(Object object, int n) {
        WjHBCzG wjHBCzG;
        WjHBCzG[] wjHBCzGArray = this.table;
        int n2 = n & wjHBCzGArray.length - 1;
        WjHBCzG wjHBCzG2 = wjHBCzG = wjHBCzGArray[n2];
        while (wjHBCzG2 != null) {
            if (wjHBCzG2.WjHBCyZ == n && this.eq(object, wjHBCzG2.WjHBCzA)) {
                Object object2 = wjHBCzG2.WjHBCzC;
                wjHBCzG2.WjHBCzC = null;
                --this.count;
                WjHBCzG wjHBCzG3 = wjHBCzG2.WjHBCzB;
                WjHBCzG wjHBCzG4 = wjHBCzG;
                while (wjHBCzG4 != wjHBCzG2) {
                    wjHBCzG3 = new WjHBCzG(wjHBCzG4.WjHBCyZ, wjHBCzG4.WjHBCzA, wjHBCzG4.WjHBCzC, wjHBCzG3);
                    wjHBCzG4 = wjHBCzG4.WjHBCzB;
                }
                wjHBCzGArray[n2] = wjHBCzG3;
                this.recordModification(wjHBCzG3);
                return object2;
            }
            wjHBCzG2 = wjHBCzG2.WjHBCzB;
        }
        return null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        WjHBCzG[] wjHBCzGArray = this.getTableForReading();
        for (int i = 0; i < wjHBCzGArray.length; ++i) {
            WjHBCzG wjHBCzG = wjHBCzGArray[i];
            while (wjHBCzG != null) {
                if (object.equals(wjHBCzG.WjHBCzC)) {
                    return true;
                }
                wjHBCzG = wjHBCzG.WjHBCzB;
            }
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    protected synchronized void putAll(NdConcurrentReaderHashtable ndConcurrentReaderHashtable) {
        int n = ndConcurrentReaderHashtable.size();
        if (n == 0) {
            return;
        }
        while (n >= this.threshold) {
            this.rehash();
        }
        Enumeration enumeration = ndConcurrentReaderHashtable.entries();
        while (enumeration.hasMoreElements()) {
            WjHBCzG wjHBCzG = (WjHBCzG)enumeration.nextElement();
            this.put(wjHBCzG.WjHBCzD(), wjHBCzG.WjHBCzE());
        }
    }

    public synchronized void clear() {
        WjHBCzG[] wjHBCzGArray = this.table;
        for (int i = 0; i < wjHBCzGArray.length; ++i) {
            WjHBCzG wjHBCzG = wjHBCzGArray[i];
            while (wjHBCzG != null) {
                wjHBCzG.WjHBCzC = null;
                wjHBCzG = wjHBCzG.WjHBCzB;
            }
            wjHBCzGArray[i] = null;
        }
        this.count = 0;
        this.recordModification(wjHBCzGArray);
    }

    public synchronized Object clone() {
        try {
            NdConcurrentReaderHashtable ndConcurrentReaderHashtable = (NdConcurrentReaderHashtable)super.clone();
            WjHBCzG[] wjHBCzGArray = this.table;
            WjHBCzG[] wjHBCzGArray2 = ndConcurrentReaderHashtable.table = new WjHBCzG[wjHBCzGArray.length];
            for (int i = 0; i < wjHBCzGArray.length; ++i) {
                WjHBCzG wjHBCzG = null;
                WjHBCzG wjHBCzG2 = wjHBCzGArray[i];
                while (wjHBCzG2 != null) {
                    wjHBCzG = new WjHBCzG(wjHBCzG2.WjHBCyZ, wjHBCzG2.WjHBCzA, wjHBCzG2.WjHBCzC, wjHBCzG);
                    wjHBCzG2 = wjHBCzG2.WjHBCzB;
                }
                wjHBCzGArray2[i] = wjHBCzG;
            }
            return ndConcurrentReaderHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Enumeration keys() {
        return new WjHBDZO();
    }

    public Enumeration elements() {
        return new WjHBCJX();
    }

    protected Enumeration entries() {
        return new WjHBDuG();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            WjHBCzG wjHBCzG = this.table[i];
            while (wjHBCzG != null) {
                objectOutputStream.writeObject(wjHBCzG.WjHBCzA);
                objectOutputStream.writeObject(wjHBCzG.WjHBCzC);
                wjHBCzG = wjHBCzG.WjHBCzB;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new WjHBCzG[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    public NdConcurrentReaderHashtable(NdObjectReader ndObjectReader) {
    }

    public void writeObject(NdObjectWriter ndObjectWriter) throws IOException, NdSerializationException {
        ndObjectWriter.putIntVal(this.threshold);
        ndObjectWriter.putFloatVal(this.loadFactor);
        ndObjectWriter.putIntVal(this.table.length);
        ndObjectWriter.putIntVal(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            WjHBCzG wjHBCzG = this.table[i];
            while (wjHBCzG != null) {
                ndObjectWriter.putJavaObject(wjHBCzG.WjHBCzA);
                ndObjectWriter.putJavaObject(wjHBCzG.WjHBCzC);
                wjHBCzG = wjHBCzG.WjHBCzB;
            }
        }
        ndObjectWriter.putEnd();
    }

    public void readObject(NdObjectReader ndObjectReader) throws IOException, NdSerializationException {
        this.threshold = ndObjectReader.getIntVal();
        this.loadFactor = ndObjectReader.getFloatVal();
        int n = ndObjectReader.getIntVal();
        this.table = new WjHBCzG[n];
        int n2 = ndObjectReader.getIntVal();
        for (int i = 0; i < n2; ++i) {
            Object object = ndObjectReader.getJavaObject();
            Object object2 = ndObjectReader.getJavaObject();
            this.put(object, object2);
        }
        ndObjectReader.getEnd();
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    protected class WjHBDuG
    extends WjHBDXX {
        protected WjHBDuG() {
        }

        protected Object WjHBDXU() {
            return this.WjHBDXP;
        }
    }

    protected class WjHBCJX
    extends WjHBDXX {
        protected WjHBCJX() {
        }

        protected Object WjHBDXU() {
            return this.WjHBDXR;
        }
    }

    protected class WjHBDZO
    extends WjHBDXX {
        protected WjHBDZO() {
        }

        protected Object WjHBDXU() {
            return this.WjHBDXQ;
        }
    }

    protected class WjHBDXX
    implements Enumeration {
        protected final WjHBCzG[] WjHBDXN;
        protected int WjHBDXO;
        protected WjHBCzG WjHBDXP = null;
        protected Object WjHBDXQ;
        protected Object WjHBDXR;
        protected WjHBCzG WjHBDXS = null;

        protected WjHBDXX() {
            this.WjHBDXN = NdConcurrentReaderHashtable.this.getTableForReading();
            this.WjHBDXO = this.WjHBDXN.length - 1;
        }

        public boolean hasMoreElements() {
            return this.WjHBDXT();
        }

        public Object nextElement() {
            return this.WjHBDXV();
        }

        public boolean WjHBDXT() {
            do {
                if (this.WjHBDXP != null) {
                    Object object = this.WjHBDXP.WjHBCzC;
                    if (object != null) {
                        this.WjHBDXQ = this.WjHBDXP.WjHBCzA;
                        this.WjHBDXR = object;
                        return true;
                    }
                    this.WjHBDXP = this.WjHBDXP.WjHBCzB;
                }
                while (this.WjHBDXP == null && this.WjHBDXO >= 0) {
                    this.WjHBDXP = this.WjHBDXN[this.WjHBDXO--];
                }
            } while (this.WjHBDXP != null);
            this.WjHBDXR = null;
            this.WjHBDXQ = null;
            return false;
        }

        protected Object WjHBDXU() {
            return this.WjHBDXP;
        }

        public Object WjHBDXV() {
            if (this.WjHBDXQ == null && !this.WjHBDXT()) {
                throw new NoSuchElementException();
            }
            Object object = this.WjHBDXU();
            this.WjHBDXS = this.WjHBDXP;
            this.WjHBDXR = null;
            this.WjHBDXQ = null;
            this.WjHBDXP = this.WjHBDXP.WjHBCzB;
            return object;
        }

        public void WjHBDXW() {
            if (this.WjHBDXS == null) {
                throw new IllegalStateException();
            }
            NdConcurrentReaderHashtable.this.remove(this.WjHBDXS.WjHBCzA);
            this.WjHBDXS = null;
        }
    }

    protected static class WjHBCzG {
        protected final int WjHBCyZ;
        protected final Object WjHBCzA;
        protected final WjHBCzG WjHBCzB;
        protected volatile Object WjHBCzC;

        WjHBCzG(int n, Object object, Object object2, WjHBCzG wjHBCzG) {
            this.WjHBCyZ = n;
            this.WjHBCzA = object;
            this.WjHBCzB = wjHBCzG;
            this.WjHBCzC = object2;
        }

        public Object WjHBCzD() {
            return this.WjHBCzA;
        }

        public Object WjHBCzE() {
            return this.WjHBCzC;
        }

        public Object WjHBCzF(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.WjHBCzC;
            this.WjHBCzC = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WjHBCzG)) {
                return false;
            }
            WjHBCzG wjHBCzG = (WjHBCzG)object;
            return this.WjHBCzA.equals(wjHBCzG.WjHBCzD()) && this.WjHBCzC.equals(wjHBCzG.WjHBCzE());
        }

        public int hashCode() {
            return this.WjHBCzA.hashCode() ^ this.WjHBCzC.hashCode();
        }

        public String toString() {
            return this.WjHBCzA + "=" + this.WjHBCzC;
        }
    }

    protected static class WjHBCFJ
    implements Serializable {
        protected WjHBCFJ() {
        }
    }
}

