/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.concurrent;

import com.blazesoft.util.NdObjectReader;
import com.blazesoft.util.NdObjectWriter;
import com.blazesoft.util.NdSerializable;
import com.blazesoft.util.NdSerializationException;
import com.blazesoft.util.concurrent.NdStrings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NdConcurrentReaderVector
implements Cloneable,
NdSerializable {
    protected Object[] _elementData;
    protected int elementCount;
    protected transient int modCount = 0;
    protected int capacityIncrement;
    static final long serialVersionUID = 5957066419583715215L;

    public NdConcurrentReaderVector(NdObjectReader ndObjectReader) {
    }

    public void readObject(NdObjectReader ndObjectReader) throws IOException, NdSerializationException {
        this.elementCount = ndObjectReader.getIntVal();
        this.capacityIncrement = ndObjectReader.getIntVal();
        this._elementData = (Object[])ndObjectReader.getArray();
        ndObjectReader.getEnd();
    }

    public void writeObject(NdObjectWriter ndObjectWriter) throws IOException, NdSerializationException {
        ndObjectWriter.putIntVal(this.elementCount);
        ndObjectWriter.putIntVal(this.capacityIncrement);
        ndObjectWriter.putArray(this._elementData);
        ndObjectWriter.putEnd();
    }

    protected final synchronized Object[] array() {
        return this._elementData;
    }

    public NdConcurrentReaderVector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException(NdStrings.WjHBDIA("IllegalCapacity") + n);
        }
        this._elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public NdConcurrentReaderVector(int n) {
        this(n, 0);
    }

    public NdConcurrentReaderVector() {
        this(10);
    }

    public void copyInto(Object[] objectArray) {
        Object[] objectArray2 = this.array();
        int n = this.getElementCount(objectArray2, this.elementCount);
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int n = this._elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this._elementData;
            Object[] objectArray2 = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, objectArray2, 0, this.elementCount);
            this._elementData = objectArray2;
        }
    }

    public synchronized void ensureCapacity(int n) {
        ++this.modCount;
        this.WjHBDZV(n);
    }

    private void WjHBDZV(int n) {
        int n2 = this._elementData.length;
        if (n > n2) {
            int n3;
            Object[] objectArray = this._elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            Object[] objectArray2 = new Object[n3];
            System.arraycopy(objectArray, 0, objectArray2, 0, this.elementCount);
            this._elementData = objectArray2;
        }
    }

    public synchronized void setSize(int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            this.WjHBDZV(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this._elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public int capacity() {
        return this.array().length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        Object[] objectArray = this.array();
        int n = this.getElementCount(objectArray, this.elementCount);
        return new WjHBCnU(objectArray, n);
    }

    public boolean contains(Object object) {
        int n;
        Object[] objectArray = this.array();
        return NdConcurrentReaderVector.indexOf(object, objectArray, 0, n = this.getElementCount(objectArray, this.elementCount)) >= 0;
    }

    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n = this.getElementCount(objectArray, this.elementCount);
        return NdConcurrentReaderVector.indexOf(object, objectArray, 0, n);
    }

    public int indexOf(Object object, int n) {
        Object[] objectArray = this.array();
        int n2 = this.getElementCount(objectArray, this.elementCount);
        return NdConcurrentReaderVector.indexOf(object, objectArray, n, n2);
    }

    protected static int indexOf(Object object, Object[] objectArray, int n, int n2) {
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n = this.getElementCount(objectArray, this.elementCount);
        return NdConcurrentReaderVector.lastIndexOf(object, objectArray, n - 1, n);
    }

    public int lastIndexOf(Object object, int n) {
        Object[] objectArray = this.array();
        int n2 = this.getElementCount(objectArray, this.elementCount);
        return NdConcurrentReaderVector.lastIndexOf(object, objectArray, n, n2);
    }

    protected static int lastIndexOf(Object object, Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            throw new IndexOutOfBoundsException(n + " >= " + n2);
        }
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this._elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[0];
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[this.elementCount - 1];
    }

    public synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this._elementData[n] = object;
    }

    public synchronized void removeElementAt(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            Object[] objectArray = this._elementData;
            Object[] objectArray2 = new Object[objectArray.length];
            System.arraycopy(this._elementData, 0, objectArray2, 0, n);
            System.arraycopy(this._elementData, n + 1, objectArray2, n, n2);
            this._elementData = objectArray2;
        }
        --this.elementCount;
        this._elementData[this.elementCount] = null;
    }

    public synchronized void insertElementAt(Object object, int n) {
        ++this.modCount;
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.WjHBDZV(this.elementCount + 1);
        Object[] objectArray = this._elementData;
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(this._elementData, 0, objectArray2, 0, n);
        System.arraycopy(this._elementData, n, objectArray2, n + 1, this.elementCount - n);
        objectArray2[n] = object;
        this._elementData = objectArray2;
        ++this.elementCount;
    }

    public synchronized void addElement(Object object) {
        ++this.modCount;
        this.WjHBDZV(this.elementCount + 1);
        this._elementData[this.elementCount++] = object;
    }

    public synchronized boolean removeElement(Object object) {
        ++this.modCount;
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        this._elementData = new Object[this.elementCount];
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            NdConcurrentReaderVector ndConcurrentReaderVector = (NdConcurrentReaderVector)super.clone();
            ndConcurrentReaderVector._elementData = new Object[this.elementCount];
            System.arraycopy(this._elementData, 0, ndConcurrentReaderVector._elementData, 0, this.elementCount);
            ndConcurrentReaderVector.modCount = 0;
            return ndConcurrentReaderVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = this.array();
        int n = this.getElementCount(objectArray, this.elementCount);
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.array();
        int n = this.getElementCount(objectArray2, this.elementCount);
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public final String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected int getElementCount(Object[] objectArray, int n) {
        int n2 = objectArray.length;
        if (n2 == 0) {
            return 0;
        }
        if (n <= n2 && (n == 0 ? objectArray[n] == null : objectArray[n - 1] != null && (n == n2 || objectArray[n] == null))) {
            return n;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (true) {
            int n5;
            int n6;
            if (objectArray[n6 = (n3 + n4) / 2] == null) {
                if (n6 == 0) {
                    return 0;
                }
                if (objectArray[n6 - 1] != null) {
                    return n6;
                }
                n5 = -1;
            } else {
                if (n6 == n2 - 1) {
                    return n2;
                }
                if (objectArray[n6 + 1] == null) {
                    return n6 + 1;
                }
                n5 = 1;
            }
            if (n5 == 0) {
                return n6;
            }
            if (n6 == n3 && n5 < 0) {
                return 0;
            }
            if (n6 == n4 && n5 > 0) {
                return n2;
            }
            if (n3 == n6) {
                ++n3;
                continue;
            }
            if (n4 == n6) {
                --n4;
                continue;
            }
            if (n5 > 0) {
                n3 = n6;
                continue;
            }
            n4 = n6;
        }
    }

    protected static final class WjHBCnU
    implements Enumeration {
        private Object[] WjHBCkR;
        private int WjHBClS = 0;
        private int WjHBCmT;

        public WjHBCnU(Object[] objectArray, int n) {
            this.WjHBCmT = n;
            this.WjHBCkR = objectArray;
        }

        public boolean hasMoreElements() {
            return this.WjHBClS < this.WjHBCmT;
        }

        public Object nextElement() {
            if (this.WjHBClS < this.WjHBCmT) {
                return this.WjHBCkR[this.WjHBClS++];
            }
            throw new NoSuchElementException(NdStrings.WjHBDIA("NdConcurrentReaderVectorEnumeration"));
        }
    }
}

