/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.logging;

import com.blazesoft.dynobj.xml.NdConfigurationRuntimeException;
import com.blazesoft.util.logging.NdLogHandler;
import com.blazesoft.util.logging.NdLogHandlerFactory;
import com.blazesoft.util.logging.NdLogLevel;
import com.blazesoft.util.logging.NdLogManager;
import com.blazesoft.util.logging.NdLogger;
import com.blazesoft.util.logging.NdLoggerConfig;
import com.blazesoft.util.logging.NdNamedLogger;
import com.blazesoft.util.logging.NdStrings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class NdNamedLogManager
implements NdLogManager {
    private HashMap WjHDhBG;
    private NdLogLevel WjHDhBH;
    private HashMap WjHDMwG;
    private static NdLogManager WjHDxpM = new NdNamedLogManager();

    public NdNamedLogManager() {
        this(NdLogLevel.INFO);
    }

    public NdNamedLogManager(NdLogLevel ndLogLevel) {
        this.WjHDhBH = ndLogLevel;
        this.WjHDhBG = new HashMap();
        this.WjHDMwG = new HashMap();
    }

    public static NdLogManager getInstance() {
        return WjHDxpM;
    }

    public NdLogger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public NdLogger getLogger(Class clazz, String string) {
        return this.getLogger(clazz.getName(), string);
    }

    public NdLogger getLogger(String string) {
        NdLogger ndLogger = (NdLogger)this.WjHDhBG.get(string);
        if (ndLogger == null) {
            String string2 = string;
            NdLogLevel ndLogLevel = this.WjHDhBH;
            while (string2.lastIndexOf(".") != -1) {
                NdLogger ndLogger2 = (NdLogger)this.WjHDhBG.get(string2 = string2.substring(0, string2.lastIndexOf(".")));
                if (ndLogger2 == null) continue;
                ndLogLevel = ndLogger2.getLevel();
                break;
            }
            ndLogger = new NdNamedLogger(string, ndLogLevel);
            this.WjHDhBG.put(string, ndLogger);
        }
        return ndLogger;
    }

    public NdLogger getLogger(String string, String string2) {
        if (string2 != null) {
            return this.getLogger(string + ":" + string2);
        }
        return this.getLogger(string);
    }

    public NdLogger getLogger(NdLoggerConfig ndLoggerConfig) {
        String string = ndLoggerConfig.getName();
        if (string == null || string.length() == 0) {
            string = "RootLogger";
        }
        if (!this.WjHDhBG.containsKey(string)) {
            NdLogLevel ndLogLevel = this.WjHDhBH;
            if (ndLoggerConfig.getLogLevel() != null) {
                ndLogLevel = NdLogLevel.parse(ndLoggerConfig.getLogLevel());
            }
            NdNamedLogger ndNamedLogger = new NdNamedLogger(string, ndLogLevel);
            NdLogHandlerFactory[] ndLogHandlerFactoryArray = ndLoggerConfig.getAllLogHandlerFactories();
            String[] stringArray = ndLoggerConfig.getNamedLogHandler();
            if (ndLogHandlerFactoryArray.length > 0 || stringArray != null && stringArray.length > 0) {
                NdLogHandler[] ndLogHandlerArray = ndNamedLogger.getHandlers();
                for (int i = 0; i < ndLogHandlerArray.length; ++i) {
                    ndNamedLogger.removeHandler(ndLogHandlerArray[i]);
                }
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    NdLogHandler ndLogHandler = this.getLogHandler(stringArray[i]);
                    if (ndLogHandler == null) {
                        throw new NdConfigurationRuntimeException(NdStrings.WjHDioQ("NamedHandlerNotFound", stringArray[i]));
                    }
                    ndNamedLogger.addHandler(ndLogHandler);
                }
            }
            for (int i = 0; i < ndLogHandlerFactoryArray.length; ++i) {
                if (ndLogHandlerFactoryArray[i].getLogLevel() == null) {
                    ndLogHandlerFactoryArray[i].setLogLevel(ndLogLevel.getName());
                }
                NdLogHandler ndLogHandler = ndLogHandlerFactoryArray[i].createLogHandler();
                ndNamedLogger.addHandler(ndLogHandler);
            }
            this.WjHDhBG.put(string, ndNamedLogger);
        }
        return this.getLogger(string);
    }

    public NdLogger getRegisteredLogger(String string) {
        return (NdLogger)this.WjHDhBG.get(string);
    }

    public void registerLogHandler(String string, NdLogHandler ndLogHandler) {
        if (!this.WjHDMwG.containsKey(string)) {
            this.WjHDMwG.put(string, ndLogHandler);
        }
    }

    public NdLogHandler getLogHandler(String string) {
        return (NdLogHandler)this.WjHDMwG.get(string);
    }

    public void close() throws IOException {
        Iterator iterator = this.WjHDMwG.entrySet().iterator();
        while (iterator.hasNext()) {
            NdLogHandler ndLogHandler = (NdLogHandler)iterator.next().getValue();
            ndLogHandler.close();
        }
    }

    public String[] getRegisteredLoggerNames() {
        if (this.WjHDhBG.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.WjHDhBG.size()];
        Iterator iterator = this.WjHDhBG.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }
}

