/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.logging;

import com.blazesoft.dynobj.xml.NdConfigurationRuntimeException;
import com.blazesoft.util.logging.NdLogHandler;
import com.blazesoft.util.logging.NdLogLevel;
import com.blazesoft.util.logging.NdLogRecord;
import com.blazesoft.util.logging.NdNamedLogger;
import com.blazesoft.util.logging.NdStrings;
import java.io.IOException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;

public class NdRegisteredLog4JLoggerLogHandler
implements NdLogHandler {
    private NdLogLevel WjHDwTV;
    private String WjHDwUW;
    private String WjHDNmX;
    private Category WjHDwVX;

    public NdRegisteredLog4JLoggerLogHandler(NdLogLevel ndLogLevel) {
        this(ndLogLevel, null, null);
    }

    public NdRegisteredLog4JLoggerLogHandler(NdLogLevel ndLogLevel, String string, String string2) {
        this.WjHDwTV = ndLogLevel;
        this.WjHDNmX = string;
        this.WjHDwUW = string2;
        if (LogManager.exists((String)this.WjHDwUW) == null) {
            throw new NdConfigurationRuntimeException(NdStrings.WjHDioQ("RegisteredLoggerNotFound", this.WjHDwUW));
        }
        this.WjHDwVX = LogManager.getLogger((String)this.WjHDwUW);
    }

    public String getId() {
        return this.WjHDNmX;
    }

    public void log(NdLogRecord ndLogRecord) {
        this.WjHDwWY(ndLogRecord);
    }

    public NdLogLevel getLevel() {
        return this.WjHDwTV;
    }

    public void setLevel(NdLogLevel ndLogLevel) {
        this.WjHDwTV = ndLogLevel;
    }

    protected Level convertLevel(NdLogLevel ndLogLevel) {
        int n = ndLogLevel.intValue();
        switch (n) {
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
            case 1000: {
                return Level.ERROR;
            }
            case 900: {
                return Level.WARN;
            }
            case 800: {
                return Level.INFO;
            }
            case 700: {
                return Level.DEBUG;
            }
            case 500: {
                return Level.DEBUG;
            }
            case 400: {
                return Level.DEBUG;
            }
            case 300: {
                return Level.DEBUG;
            }
            case -2147483648: {
                return Level.ALL;
            }
        }
        return Level.INFO;
    }

    private void WjHDwWY(NdLogRecord ndLogRecord) {
        if (!NdNamedLogger.isLogLevelEnabled(this.WjHDwTV, ndLogRecord.getLevel())) {
            return;
        }
        this.WjHDwXZ(ndLogRecord.getLevel(), ndLogRecord.getMessage(), ndLogRecord.getUserData());
    }

    private void WjHDwXZ(NdLogLevel ndLogLevel, String string, Object object) {
        Throwable throwable = null;
        if (object instanceof Throwable) {
            throwable = (Throwable)object;
        }
        if (throwable != null) {
            this.WjHDwVX.log((Priority)this.convertLevel(ndLogLevel), (Object)string, throwable);
        } else {
            this.WjHDwVX.log((Priority)this.convertLevel(ndLogLevel), (Object)string);
        }
    }

    public void close() throws IOException {
    }
}

