/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.logging;

import com.blazesoft.dynobj.NdDynObjFactoryInstance;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.NdWrappedExceptionSupport;
import com.blazesoft.util.NdWrappedRuntimeException;
import com.blazesoft.util.logging.NdLogHandler;
import com.blazesoft.util.logging.NdLogLevel;
import com.blazesoft.util.logging.NdLogRecord;
import com.blazesoft.util.logging.NdNamedLogger;
import com.blazesoft.util.logging.NdStrings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Date;

public class NdStreamLogHandler
implements NdLogHandler,
NdDynObjFactoryInstance {
    public static final String EOL = NdSystemProperties.getSystemProperty("line.separator");
    private static String WjHDiKL = "{0,number,integer}-{1,time,long} [{2}] [{3}] {4,choice,0#|1#[{5}]} - {6} {7,choice,0#|0<\n{8}}";
    private String WjHDNuZ;
    private NdLogLevel WjHDiMN;
    private MessageFormat WjHDiOP;
    private String WjHDiPQ;
    private OutputStream WjHDiQR;
    private OutputStreamWriter WjHDiRS;

    public NdStreamLogHandler(NdLogLevel ndLogLevel) {
        this(ndLogLevel, null);
    }

    public NdStreamLogHandler(NdLogLevel ndLogLevel, String string) {
        this.WjHDNuZ = string;
        this.WjHDiMN = ndLogLevel;
        this.WjHDiOP = new MessageFormat(WjHDiKL);
    }

    public void setId(String string) {
        this.WjHDNuZ = string;
    }

    public String getId() {
        return this.WjHDNuZ;
    }

    public void setFormat(String string) {
        this.WjHDiOP = new MessageFormat(string);
    }

    public String getFormat() {
        return this.WjHDiOP.toPattern();
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.flushAndClose();
        this.WjHDiQR = outputStream;
        String string = this.getEncoding();
        if (string == null) {
            this.WjHDiRS = new OutputStreamWriter(this.WjHDiQR);
        } else {
            try {
                this.WjHDiRS = new OutputStreamWriter(this.WjHDiQR, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(NdStrings.WjHDioQ("UnsupportedEncoding", string));
            }
        }
    }

    public void setEncoding(String string) throws UnsupportedEncodingException, IOException {
        this.WjHDiPQ = string;
        if (this.WjHDiQR == null) {
            return;
        }
        this.flush();
        this.WjHDiRS = this.WjHDiPQ == null ? new OutputStreamWriter(this.WjHDiQR) : new OutputStreamWriter(this.WjHDiQR, string);
    }

    public String getEncoding() {
        return this.WjHDiPQ;
    }

    public void log(NdLogRecord ndLogRecord) {
        if (!NdNamedLogger.isLogLevelEnabled(this.WjHDiMN, ndLogRecord.getLevel())) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.format(ndLogRecord));
        stringBuffer.append(EOL);
        try {
            this.WjHDiRS.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException(iOException);
        }
    }

    public NdLogLevel getLevel() {
        return this.WjHDiMN;
    }

    public void setLevel(NdLogLevel ndLogLevel) {
        this.WjHDiMN = ndLogLevel;
    }

    public synchronized void close() throws IOException {
        this.flushAndClose();
    }

    public void finishInitialization() {
    }

    protected synchronized void flush() {
        if (this.WjHDiRS != null) {
            try {
                this.WjHDiRS.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void flushAndClose() throws IOException {
        if (this.WjHDiRS != null) {
            try {
                this.WjHDiRS.flush();
                this.WjHDiRS.close();
            }
            finally {
                this.WjHDiRS = null;
                this.WjHDiQR = null;
            }
        }
    }

    protected String format(NdLogRecord ndLogRecord) {
        Object[] objectArray;
        String string = ndLogRecord.getLoggerName();
        String string2 = null;
        if (ndLogRecord.getUserData() != null) {
            objectArray = ndLogRecord.getUserData();
            string2 = objectArray instanceof Throwable ? NdWrappedExceptionSupport.getStackTrace((Throwable)objectArray) : objectArray.toString();
        }
        objectArray = new Object[]{new Long(ndLogRecord.getSequenceNumber()), new Date(ndLogRecord.getMillis()), Thread.currentThread().getName(), ndLogRecord.getLevel().getLocalizedName(), string == null ? new Integer(0) : new Integer(1), string, ndLogRecord.getMessage(), string2 == null ? new Integer(0) : new Integer(1), string2};
        return this.WjHDiOP.format(objectArray);
    }
}

