/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.util.xml;

import com.blazesoft.util.xml.NdStrings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class NdXMLDOMSerializer {
    private Writer WjHAjhB;
    private PrintWriter WjHzHTU;
    private String WjHzHUV;
    private boolean WjHAjhC;
    private boolean WjHAJcH;
    private boolean WjHARkF;
    private int WjHAjhD;
    private boolean WjHAPxM;
    private String WjHAPyN;
    private Stack WjHAPzO;

    public NdXMLDOMSerializer(Writer writer) {
        this(writer, null, false, false, true);
    }

    public NdXMLDOMSerializer(Writer writer, boolean bl) {
        this(writer, null, bl, false, true);
    }

    public NdXMLDOMSerializer(Writer writer, String string) {
        this(writer, string, false, false, true);
    }

    public NdXMLDOMSerializer(Writer writer, String string, boolean bl) {
        this(writer, string, bl, false, true);
    }

    public NdXMLDOMSerializer(Writer writer, boolean bl, boolean bl2) {
        this(writer, null, bl, bl2, true);
    }

    public NdXMLDOMSerializer(Writer writer, String string, boolean bl, boolean bl2) {
        this(writer, string, bl, bl2, true);
    }

    public NdXMLDOMSerializer(Writer writer, String string, boolean bl, boolean bl2, boolean bl3) {
        this.WjHAjhB = writer;
        this.WjHzHTU = new PrintWriter(this.WjHAjhB);
        this.WjHzHUV = string;
        this.WjHAjhC = bl;
        this.WjHAJcH = bl2;
        this.WjHARkF = bl3;
        this.WjHAPxM = true;
        this.WjHAPyN = "\t";
        this.WjHAPzO = new Stack();
    }

    private String WjHAPAP(String string, char c, String string2) {
        int n = 0;
        while ((n = string.indexOf(c, n)) != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            string = string3 + string2 + string4;
            n += string2.length();
        }
        return string;
    }

    public void useDoubleQuotes(boolean bl) {
        this.WjHAPxM = bl;
    }

    protected boolean isUsingDoubleQuotes() {
        return this.WjHAPxM;
    }

    private void WjHAPBQ() {
        this.WjHzHTU.print(this.WjHAPxM ? (char)'\"' : '\'');
    }

    public void setIndentSequence(String string) {
        this.WjHAPyN = string;
    }

    protected String getIndentSequence() {
        return this.WjHAPyN;
    }

    protected String convertText(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        string = this.WjHAPAP(string, '&', "&amp;");
        string = this.WjHAPAP(string, '<', "&lt;");
        string = this.WjHAPAP(string, '>', "&gt;");
        if (bl) {
            string = this.WjHAPxM ? this.WjHAPAP(string, '\"', "&quot;") : this.WjHAPAP(string, '\'', "&apos;");
        }
        return string;
    }

    protected String convertData(String string) {
        if (string == null) {
            return "";
        }
        int n = 0;
        String string2 = "]]]]><![CDATA[";
        while ((n = string.indexOf("]]>", n)) != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 2);
            string = string3 + string2 + string4;
            n += string2.length() - 2;
        }
        return string;
    }

    protected void writeNode(Node node) throws IOException {
        short s = node.getNodeType();
        switch (s) {
            case 2: {
                this.writeAttributeNode((Attr)node);
                break;
            }
            case 4: {
                this.writeCDATANode((CDATASection)node);
                break;
            }
            case 8: {
                this.writeCommentNode((Comment)node);
                break;
            }
            case 11: {
                this.WjHAPCR((DocumentFragment)node);
                break;
            }
            case 9: {
                this.writeDocumentNode((Document)node);
                break;
            }
            case 10: {
                this.writeDocumentTypeNode((DocumentType)node);
                break;
            }
            case 1: {
                this.WjHAPDS((Element)node);
                break;
            }
            case 6: {
                this.writeEntityNode((Entity)node);
                break;
            }
            case 5: {
                this.writeEntityReference((EntityReference)node);
                break;
            }
            case 12: {
                this.writeNotationNode((Notation)node);
                break;
            }
            case 7: {
                this.writeProcessingInstructionNode((ProcessingInstruction)node);
                break;
            }
            case 3: {
                this.writeTextNode((Text)node);
                break;
            }
            default: {
                throw new IOException(NdStrings.WjHzHOA("UnknownNodeType", node.getNodeName(), Short.toString(s)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocumentFragmentNode(DocumentFragment documentFragment) throws IOException {
        try {
            this.WjHAjhD = 0;
            this.WjHAPzO.push(this.WjHAjhC ? Boolean.TRUE : Boolean.FALSE);
            this.WjHARkG(documentFragment);
        }
        finally {
            while (!this.WjHAPzO.empty()) {
                this.WjHAPzO.pop();
            }
        }
    }

    private void WjHAPCR(DocumentFragment documentFragment) throws IOException {
        this.WjHARkG(documentFragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChildNodes(Node node) throws IOException {
        try {
            this.WjHAjhD = 0;
            this.WjHAPzO.push(this.WjHAjhC ? Boolean.TRUE : Boolean.FALSE);
            this.WjHARkG(node);
        }
        finally {
            while (!this.WjHAPzO.empty()) {
                this.WjHAPzO.pop();
            }
        }
    }

    private void WjHARkG(Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            this.writeNode(node2);
        }
    }

    private boolean WjHARkH(Node node) {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Text) || !this.WjHARkI((Text)node2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean WjHARkI(Text text) {
        boolean bl = (Boolean)this.WjHAPzO.peek();
        if (!bl) {
            return true;
        }
        String string = text.getData();
        int n = string.length();
        boolean bl2 = false;
        if (n != 0) {
            if (this.WjHARkF) {
                bl2 = true;
            } else {
                for (int i = 0; i < n; ++i) {
                    if (Character.isWhitespace(string.charAt(i))) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        return bl2;
    }

    private boolean WjHARkJ(Node node) {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeElementNode(Element element) throws IOException {
        try {
            this.WjHAjhD = 0;
            this.WjHAPzO.push(this.WjHAjhC ? Boolean.TRUE : Boolean.FALSE);
            this.WjHAPDS(element);
        }
        finally {
            while (!this.WjHAPzO.empty()) {
                this.WjHAPzO.pop();
            }
        }
    }

    private void WjHAPDS(Element element) throws IOException {
        this.writeBeginOfLine();
        this.WjHAPET();
        this.WjHzHTU.print('<');
        this.WjHzHTU.print(element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            this.WjHzHTU.print(' ');
            Attr attr = (Attr)namedNodeMap.item(i);
            this.writeAttributeNode(attr);
        }
        boolean bl = this.WjHARkH(element);
        boolean bl2 = this.WjHARkJ(element);
        if (this.WjHAJcH && !bl && !bl2) {
            this.WjHzHTU.print("/>");
            this.WjHAPFU();
        } else {
            this.WjHzHTU.print('>');
            boolean bl3 = this.WjHAjhC && !bl && bl2;
            this.WjHAPzO.push(bl3 ? Boolean.TRUE : Boolean.FALSE);
            this.writeEndOfLine();
            this.WjHARkG(element);
            this.WjHAPFU();
            this.writeBeginOfLine();
            this.WjHzHTU.print("</");
            this.WjHzHTU.print(element.getNodeName());
            this.WjHzHTU.print('>');
            this.WjHAPzO.pop();
        }
        this.writeEndOfLine();
    }

    protected void writeAttributeNode(Attr attr) throws IOException {
        if (attr.getSpecified()) {
            this.WjHzHTU.print(attr.getNodeName());
            this.WjHzHTU.print('=');
            this.WjHAPBQ();
            this.WjHzHTU.print(this.convertText(attr.getNodeValue(), true));
            this.WjHAPBQ();
        }
    }

    protected void writeCommentNode(Comment comment) throws IOException {
        this.writeBeginOfLine();
        this.WjHzHTU.print("<!--");
        this.WjHzHTU.print(comment.getData());
        this.WjHzHTU.print("-->");
        this.writeEndOfLine();
    }

    protected void writeCDATANode(CDATASection cDATASection) throws IOException {
        this.writeBeginOfLine();
        this.WjHzHTU.print("<![CDATA[");
        this.WjHzHTU.print(this.convertData(cDATASection.getData()));
        this.WjHzHTU.print("]]>");
        this.writeEndOfLine();
    }

    protected void writeTextNode(Text text) throws IOException {
        if (this.WjHARkI(text)) {
            String string = this.convertText(text.getData(), false);
            this.WjHzHTU.print(string);
        }
    }

    protected void writeEntityNode(Entity entity) throws IOException {
        String string;
        this.writeBeginOfLine();
        this.WjHzHTU.print("<!ENTITY ");
        this.WjHzHTU.print(entity.getNodeName());
        String string2 = entity.getPublicId();
        if (string2 != null) {
            this.WjHzHTU.print("\n    PUBLIC ");
            this.WjHAPBQ();
            this.WjHzHTU.print(string2);
            this.WjHAPBQ();
        }
        if ((string = entity.getSystemId()) != null) {
            this.WjHzHTU.print("\n    SYSTEM ");
            this.WjHAPBQ();
            this.WjHzHTU.print(string);
            this.WjHAPBQ();
        }
        this.WjHzHTU.print('>');
        this.writeEndOfLine();
    }

    protected void writeNotationNode(Notation notation) throws IOException {
        String string;
        this.writeBeginOfLine();
        this.WjHzHTU.print("<!NOTATION ");
        this.WjHzHTU.print(notation.getNodeName());
        String string2 = notation.getPublicId();
        if (string2 != null) {
            this.WjHzHTU.print("\n    PUBLIC ");
            this.WjHAPBQ();
            this.WjHzHTU.print(string2);
            this.WjHAPBQ();
        }
        if ((string = notation.getSystemId()) != null) {
            this.WjHzHTU.print("\n    SYSTEM ");
            this.WjHAPBQ();
            this.WjHzHTU.print(string);
            this.WjHAPBQ();
        }
        this.WjHzHTU.print('>');
        this.writeEndOfLine();
    }

    protected void writeProcessingInstructionNode(ProcessingInstruction processingInstruction) throws IOException {
        this.writeBeginOfLine();
        this.WjHzHTU.print("<?");
        this.WjHzHTU.print(processingInstruction.getTarget());
        this.WjHzHTU.print(' ');
        this.WjHzHTU.print(processingInstruction.getData());
        this.WjHzHTU.print("?>");
        this.writeEndOfLine();
    }

    protected void writeEntityReference(EntityReference entityReference) throws IOException {
        this.writeBeginOfLine();
        this.WjHzHTU.print('&');
        this.WjHzHTU.print(entityReference.getNodeName());
        this.WjHzHTU.print(';');
        this.writeEndOfLine();
    }

    protected void writeDocumentHeader(Document document) throws IOException {
        this.writeBeginOfLine();
        this.WjHzHTU.print("<?xml version=");
        this.WjHAPBQ();
        this.WjHzHTU.print("1.0");
        this.WjHAPBQ();
        if (this.getXMLEncoding() != null) {
            this.WjHzHTU.print(" encoding=");
            this.WjHAPBQ();
            this.WjHzHTU.print(this.getXMLEncoding());
            this.WjHAPBQ();
        }
        this.WjHzHTU.print("?>\n");
    }

    protected void writeBeginOfLine() throws IOException {
        if (this.isCurrentLevelPretty()) {
            int n = this.WjHAjhD;
            while (n-- > 0) {
                this.WjHzHTU.print(this.WjHAPyN);
            }
        }
    }

    protected void writeEndOfLine() throws IOException {
        if (this.isCurrentLevelPretty()) {
            this.WjHzHTU.print('\n');
        }
    }

    protected void writeDocumentTypeNode(DocumentType documentType) throws IOException {
        if (documentType != null) {
            this.writeDocumentTypeNode(documentType, documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
    }

    protected void writeDocumentTypeNode(DocumentType documentType, String string, String string2, String string3) throws IOException {
        this.writeBeginOfLine();
        if (string != null) {
            this.WjHzHTU.print("<!DOCTYPE ");
            this.WjHzHTU.print(string);
            if (string2 != null) {
                this.WjHzHTU.println("\nPUBLIC ");
                this.WjHAPBQ();
                this.WjHzHTU.print(string2);
                this.WjHAPBQ();
            }
            if (string3 != null) {
                this.WjHzHTU.println("\n  ");
                this.WjHAPBQ();
                this.WjHzHTU.print(string3);
                this.WjHAPBQ();
            }
            if (documentType.getInternalSubset() != null) {
                this.WjHzHTU.print("[");
                this.WjHzHTU.println("\n  ");
                this.WjHzHTU.println(documentType.getInternalSubset());
                this.WjHzHTU.print("]");
            }
            this.WjHzHTU.println(">\n");
        }
        this.writeEndOfLine();
    }

    protected PrintWriter getPrintWriter() {
        return this.WjHzHTU;
    }

    protected Writer getWriter() {
        return this.WjHAjhB;
    }

    protected boolean isCurrentLevelPretty() {
        return (Boolean)this.WjHAPzO.peek();
    }

    private void WjHAPET() {
        ++this.WjHAjhD;
    }

    private void WjHAPFU() {
        --this.WjHAjhD;
    }

    protected String getXMLEncoding() {
        return this.WjHzHUV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document document) throws IOException {
        try {
            this.WjHAjhD = 0;
            this.WjHAPzO.push(this.WjHAjhC ? Boolean.TRUE : Boolean.FALSE);
            this.writeDocumentHeader(document);
            this.writeDocumentTypeNode(document.getDoctype());
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 7) continue;
                this.writeProcessingInstructionNode((ProcessingInstruction)node);
            }
            this.WjHAPDS(document.getDocumentElement());
            this.flush();
        }
        finally {
            while (!this.WjHAPzO.empty()) {
                this.WjHAPzO.pop();
            }
        }
    }

    public void writeDocumentNode(Document document) throws IOException {
        this.writeDocumentNode(document, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocumentNode(Document document, boolean bl) throws IOException {
        try {
            this.WjHAjhD = 0;
            this.WjHAPzO.push(this.WjHAjhC ? Boolean.TRUE : Boolean.FALSE);
            this.writeDocumentHeader(document);
            if (bl) {
                this.writeDocumentTypeNode(document.getDoctype());
            }
            this.WjHAPDS(document.getDocumentElement());
            this.flush();
        }
        finally {
            while (!this.WjHAPzO.empty()) {
                this.WjHAPzO.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocumentNode(Document document, String string, String string2, String string3) throws IOException {
        try {
            this.WjHAjhD = 0;
            this.WjHAPzO.push(this.WjHAjhC ? Boolean.TRUE : Boolean.FALSE);
            this.writeDocumentHeader(document);
            this.writeDocumentTypeNode(document.getDoctype(), string, string2, string3);
            this.WjHAPDS(document.getDocumentElement());
            this.flush();
        }
        finally {
            while (!this.WjHAPzO.empty()) {
                this.WjHAPzO.pop();
            }
        }
    }

    public void flush() {
        this.WjHzHTU.flush();
    }
}

