/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.web;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.web.NdStrings;
import com.blazesoft.web.NdWebApplicationContainer;
import com.blazesoft.web.NdWebApplicationContainerException;

public class NdWebApplicationContainerFactory {
    private static NdWebApplicationContainer WjHBkdS;

    public static NdWebApplicationContainer getWebApplicationContainer() throws NdWebApplicationContainerException {
        if (WjHBkdS == null) {
            WjHBkdS = NdWebApplicationContainerFactory.WjHBkdT();
            WjHBkdS.init();
            WjHBkdS.start();
        }
        return WjHBkdS;
    }

    private static NdWebApplicationContainer WjHBkdT() throws NdWebApplicationContainerException {
        String string = null;
        if (!NdDotNETLib.isDotNETSupportEnabled()) {
            if (NdSystemProperties.isJavaMajorVersionEqual(NdSystemProperties.JAVA_VERSION_10)) {
                throw new NdWebApplicationContainerException(NdStrings.WjHBjwX("JavaVersionNotSupported"));
            }
            string = NdSystemProperties.isJavaMajorVersionEqual(NdSystemProperties.JAVA_VERSION_11) ? "com.blazesoft.web.tomcat3.NdTomcat3WebApplicationContainer" : (NdSystemProperties.isJavaVersionAtLeast(NdSystemProperties.JAVA_VERSION_12) ? "com.blazesoft.web.tomcat4.NdTomcat4WebApplicationContainer" : "com.blazesoft.web.tomcat4.NdTomcat4WebApplicationContainer");
        } else {
            string = "com.blazesoft.web.dotnet.NdDotNETWebApplicationContainer";
        }
        String string2 = NdSystemProperties.getSystemProperty("com.blazesoft.util.WebApplicationContainerClassName");
        if (string2 != null) {
            string = string2;
        }
        if (string == null) {
            throw new NdWebApplicationContainerException(NdStrings.WjHBjwX("PlatformNotSupported"));
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (NdWebApplicationContainer)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdWebApplicationContainerException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new NdWebApplicationContainerException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdWebApplicationContainerException(illegalAccessException);
        }
    }
}

