/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.engines.rules;

import com.blazesoft.engines.flow.NdRuleflowEvent;
import com.blazesoft.engines.rules.NdEvaluationContext;
import com.blazesoft.engines.rules.NdFunctionalItem;
import com.blazesoft.engines.rules.NdFunctionalItemEvent;
import com.blazesoft.engines.rules.NdNamedItem;
import com.blazesoft.engines.rules.NdPatternBinding;
import com.blazesoft.engines.rules.NdRule;
import com.blazesoft.engines.rules.NdRuleAgendaEntry;
import com.blazesoft.engines.rules.NdRuleAgent;
import com.blazesoft.engines.rules.NdRuleEngineEvent;
import com.blazesoft.engines.rules.NdRuleEvent;
import com.blazesoft.engines.rules.NdRuleSetEvent;
import com.blazesoft.engines.rules.NdScriptContext;
import com.blazesoft.engines.rules.NdStatementEvent;
import com.blazesoft.engines.rules.NdStrings;
import com.blazesoft.engines.rules.expressions.NdExpression;
import com.blazesoft.util.NdBaseObject;

public final class NdTraceEvent
extends NdRuleEngineEvent {
    public static final int UNSPECIFIED = -1;
    public static final int RULE_SCHEDULED = 0;
    public static final int RULE_UNSCHEDULED = 1;
    public static final int FUNCTIONAL_CALL = 14;
    public static final int FUNCTIONAL_RETURN = 15;
    public static final int RULESET_ENTERING_PROPAGATION = 16;
    public static final int RULESET_EXITING_PROPAGATION = 17;
    public static final int RULESET_ENTERING_FIRE = 18;
    public static final int RULESET_EXITING_FIRE = 19;
    public static final int STATEMENT_ENTERING = 23;
    public static final int STATEMENT_EXITING = 24;
    public static final int RULEFLOW_STARTING = 25;
    public static final int RULEFLOW_ENDING = 26;
    public static final int RULEFLOW_ENTERINGBLOCK = 27;
    public static final int RULEFLOW_EXITINGBLOCK = 28;
    public static final int RULEFLOW_BEGINNINGFLOW = 29;
    public static final int RULEFLOW_ENDINGFLOW = 30;
    public static final int RULEFLOW_MODIFYINGVARIABLE = 31;
    public static final int RULEFLOW_CONTINUINGLOOP = 32;
    public static final int RULEFLOW_ENDINGLOOP = 33;
    public static final int RULEFLOW_TAKINGDECISION = 34;
    public static final int RULEFLOW_INVOKINGTASK = 35;
    public static final int RULEFLOW_ENDINGEVENTWAIT = 36;
    public static final int RULE_ENTERING_FIRE = 2;
    public static final int RULE_EXITING_FIRE = 3;
    public static final int RULE_FIRED = 2;
    public static final int STATEMENT_EXECUTION = 23;
    public static final int NAMESPACE_ENTRY = 14;
    public static final int NAMESPACE_EXIT = 15;
    private String WjHBHVB;
    private transient NdNamedItem WjHBHWC;
    private transient NdPatternBinding[] WjHBHXD;

    NdTraceEvent(NdRuleSetEvent ndRuleSetEvent) {
        super(ndRuleSetEvent.getScriptContext(), -1);
        NdFunctionalItem ndFunctionalItem = ndRuleSetEvent.getFunctionalItem();
        this.WjHBHWC = ndFunctionalItem;
        int n = ndRuleSetEvent.getEventCode();
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.WjHPsrK(n);
                break;
            }
        }
        this.WjHBHVB = NdTraceEvent.formatFunctionalItemEvent(ndRuleSetEvent);
    }

    NdTraceEvent(NdFunctionalItemEvent ndFunctionalItemEvent) {
        super(ndFunctionalItemEvent.getScriptContext(), -1);
        NdFunctionalItem ndFunctionalItem = ndFunctionalItemEvent.getFunctionalItem();
        this.WjHBHWC = ndFunctionalItem;
        int n = ndFunctionalItemEvent.getEventCode();
        switch (n) {
            case 14: 
            case 15: {
                this.WjHPsrK(n);
                break;
            }
        }
        this.WjHBHVB = NdTraceEvent.formatFunctionalItemEvent(ndFunctionalItemEvent);
    }

    public static String formatFunctionalItemEvent(NdFunctionalItemEvent ndFunctionalItemEvent) {
        return NdTraceEvent.formatFunctionalItemEvent(ndFunctionalItemEvent.getFunctionalItem(), ndFunctionalItemEvent.getParameterValues(), ndFunctionalItemEvent.getResultValue(), ndFunctionalItemEvent.getEventCode());
    }

    public static String formatFunctionalItemEvent(NdFunctionalItem ndFunctionalItem, Object object, Object object2, int n) {
        String string;
        String string2 = ndFunctionalItem.getName() + NdBaseObject.arrayFormat((Object)object, (String)"(", (String)",", (String)")");
        switch (n) {
            case 14: {
                string = NdStrings.WjHAPAH("FunctionalItemCall", string2);
                break;
            }
            case 15: {
                string = ndFunctionalItem.getReturnType().isVoid() ? NdStrings.WjHAPAH("FunctionalItemVoidReturn", string2) : NdStrings.WjHAPBI("FunctionalItemResultReturn", string2, object2);
                break;
            }
            case 16: {
                string = NdStrings.WjHAPAH("FunctionalItemBeginPropagation", string2);
                break;
            }
            case 17: {
                string = NdStrings.WjHAPAH("FunctionalItemEndPropagation", string2);
                break;
            }
            case 18: {
                string = NdStrings.WjHAPAH("FunctionalItemBeginFire", string2);
                break;
            }
            case 19: {
                string = NdStrings.WjHAPAH("FunctionalItemEndFire", string2);
                break;
            }
            default: {
                string = "??" + n + "??";
            }
        }
        return string;
    }

    NdTraceEvent(NdScriptContext ndScriptContext, NdStatementEvent ndStatementEvent) {
        this(ndScriptContext, ndStatementEvent.getEvalCx(), ndStatementEvent.getStatement(), ndStatementEvent.getEventCode());
    }

    private NdTraceEvent(NdScriptContext ndScriptContext, NdEvaluationContext ndEvaluationContext, NdExpression ndExpression, int n) {
        super(ndScriptContext, -1);
        this.WjHBHWC = ndEvaluationContext.getFunctionalItem();
        this.WjHBHVB = NdStatementEvent.getFormattedMessageForEvent(ndExpression, n);
        switch (n) {
            case 23: 
            case 24: {
                this.WjHPsrK(n);
                break;
            }
        }
    }

    NdTraceEvent(NdScriptContext ndScriptContext, NdRuleEvent ndRuleEvent) {
        this(ndScriptContext, ndRuleEvent.getAgendaEntry(), ndRuleEvent.getEventCode());
    }

    private NdTraceEvent(NdScriptContext ndScriptContext, NdRuleAgendaEntry ndRuleAgendaEntry, int n) {
        super(ndScriptContext, -1);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.WjHPsrK(n);
                break;
            }
        }
        this.WjHBHWC = ndRuleAgendaEntry.WjHAQvH();
        this.WjHBHVB = NdTraceEvent.formatRuleEvent(ndRuleAgendaEntry.WjHAQvH(), n);
        this.WjHBHXD = NdPatternBinding.WjHBEaS(ndRuleAgendaEntry);
    }

    public static String formatRuleEvent(NdRule ndRule, int n) {
        String string;
        switch (n) {
            case 0: {
                string = NdStrings.WjHAPyF("Scheduling");
                break;
            }
            case 1: {
                string = NdStrings.WjHAPyF("Unscheduling");
                break;
            }
            case 2: {
                string = NdStrings.WjHAPyF("StartFiring");
                break;
            }
            case 3: {
                string = NdStrings.WjHAPyF("EndFiring");
                break;
            }
            default: {
                string = "??" + n + "??";
            }
        }
        string = string + " " + ndRule.WjHAYOD();
        return string;
    }

    NdTraceEvent(NdScriptContext ndScriptContext, NdRuleflowEvent ndRuleflowEvent) {
        super(ndScriptContext, -1);
        this.WjHBHWC = null;
        this.WjHBHVB = ndRuleflowEvent.getMessage();
        int n = ndRuleflowEvent.getEventCode();
        switch (n) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.WjHPsrK(n);
                break;
            }
        }
    }

    public NdRuleAgent getRuleAgent() {
        return this.getScriptContext().getAgent();
    }

    public NdScriptContext getScriptContext() {
        return (NdScriptContext)this.getSource();
    }

    public String getTraceString() {
        return this.WjHBHVB;
    }

    public NdNamedItem getTraceItem() {
        return this.WjHBHWC;
    }

    public NdPatternBinding[] getPatternBindings() {
        if (this.WjHBHXD == null) {
            this.WjHBHXD = new NdPatternBinding[0];
        }
        return this.WjHBHXD;
    }

    public String getFormattedMessage() {
        return this.getTraceString();
    }
}

