/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.engines.rules;

import com.blazesoft.engines.rules.NdMathBuiltIns;
import com.blazesoft.engines.rules.NdStrings;
import com.blazesoft.util.NdSupportJavaClass;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.math.BigDecimal;

public class NdDefMathBuiltIns
implements NdMathBuiltIns,
NdSupportJavaClass {
    static double[] WjHUPfF = new double[]{1.0E14, 1.0E13, 1.0E12, 1.0E11, 1.0E10, 1.0E9, 1.0E8, 1.0E7, 1000000.0, 100000.0, 10000.0, 1000.0, 100.0, 10.0, 1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14};
    static int[] WjHUPgG = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    static int[] WjHUPhH = new int[]{Integer.MIN_VALUE, 0, -2147483600, 0, -2147480000, 0, -2147000000, 0, -2100000000, -2000000000};
    static int[] WjHUPiI = new int[]{Integer.MIN_VALUE, -2147483640, -2147483600, -2147483000, -2147480000, -2147400000, -2147000000, -2140000000, -2100000000, -2000000000};

    public long abs(long l) {
        return Math.abs(l);
    }

    public double abs(double d) {
        return Math.abs(d);
    }

    public double exp(double d) {
        return Math.exp(d);
    }

    public double log(double d) {
        return Math.log(d);
    }

    public long floor(double d) {
        return (long)Math.floor(d);
    }

    public long ceil(double d) {
        return (long)Math.ceil(d);
    }

    public long round(double d) {
        return Math.round(d);
    }

    public long truncate(double d) {
        return (long)d;
    }

    public long min(long l, long l2) {
        return Math.min(l, l2);
    }

    public double min(double d, double d2) {
        return Math.min(d, d2);
    }

    public long max(long l, long l2) {
        return Math.max(l, l2);
    }

    public double max(double d, double d2) {
        return Math.max(d, d2);
    }

    public double round(double d, int n) {
        if (-14 > n || n > 14) {
            throw new NdWrappedRuntimeException((Throwable)new Exception(NdStrings.WjHAPAH("RoundParmOutOfRange", new Integer(n))));
        }
        return NdDefMathBuiltIns.WjHUPjJ(d, n, true);
    }

    public long round(long l, int n) {
        if (0 > n || n > 9) {
            throw new NdWrappedRuntimeException((Throwable)new Exception(NdStrings.WjHAPAH("RoundParmOutOfRange", new Long(n))));
        }
        if (l == (long)WjHUPhH[0]) {
            throw new NdWrappedRuntimeException((Throwable)new Exception(NdStrings.WjHAPAH("RoundParmCantBeRounded", new Long(l))));
        }
        int n2 = NdDefMathBuiltIns.WjHUPkK((int)l, n, true);
        if (n2 < 0 && l > 0L || n2 > 0 && l < 0L) {
            throw new NdWrappedRuntimeException((Throwable)new Exception(NdStrings.WjHAPBI("RoundParmCantBeRounded", new Long(l), new Long(n))));
        }
        return n2;
    }

    public double truncate(double d, int n) {
        if (-14 > n || n > 14) {
            throw new NdWrappedRuntimeException((Throwable)new Exception(NdStrings.WjHAPAH("TruncateParmOutOfRange", new Integer(n))));
        }
        return NdDefMathBuiltIns.WjHUPjJ(d, n, false);
    }

    public long truncate(long l, int n) {
        if (0 > n || n > 9) {
            throw new NdWrappedRuntimeException((Throwable)new Exception(NdStrings.WjHAPAH("TruncateParmOutOfRange", new Integer(n))));
        }
        if (l == (long)WjHUPiI[0]) {
            return WjHUPiI[n];
        }
        return NdDefMathBuiltIns.WjHUPkK((int)l, n, false);
    }

    public double tanh(double d) {
        double d2 = Math.exp(d);
        double d3 = Math.exp(-d);
        return (d2 - d3) / (d2 + d3);
    }

    public long mod(long l, long l2) {
        return l % l2;
    }

    public double power(double d, double d2) {
        return Math.pow(d, d2);
    }

    public double sin(double d) {
        return Math.sin(d);
    }

    public double cos(double d) {
        return Math.cos(d);
    }

    public double arctan(double d) {
        return Math.atan(d);
    }

    static double WjHUPjJ(double d, int n, boolean bl) {
        long l;
        double d2 = WjHUPfF[n + 14];
        if (bl) {
            l = (long)(d += (d *= d2) < 0.0 ? -0.5 : 0.5);
        } else {
            BigDecimal bigDecimal = new BigDecimal(new Double(d).toString());
            bigDecimal = bigDecimal.multiply(new BigDecimal(d2));
            l = bigDecimal.longValue();
        }
        return (double)l / d2;
    }

    static int WjHUPkK(int n, int n2, boolean bl) {
        int n3 = WjHUPgG[n2];
        int n4 = Math.abs(n);
        int n5 = n4 / n3;
        if (bl && n3 > 1 && n4 % n3 >= n3 / 2) {
            ++n5;
        }
        return n < 0 ? -n5 : (n5 *= n3);
    }
}

