/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.engines.rules;

import com.blazesoft.engines.rules.NdIndexedPropertyIndex;
import com.blazesoft.engines.rules.NdProperty;
import com.blazesoft.engines.rules.NdRuleEngineEvent;
import com.blazesoft.engines.rules.NdScriptContext;
import com.blazesoft.engines.rules.NdStrings;
import com.blazesoft.objects.base.NdExternalMethod;
import com.blazesoft.objects.base.NdExternalObject;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdLocalizedConstants;

public final class NdExternalAccessEvent
extends NdRuleEngineEvent {
    private NdExternalMethod WjHAQMT;
    private Object WjHAQMV;
    private Object[] WjHAQMW;
    private NdProperty WjHAQMX;
    private NdScriptContext WjHFDVY;
    private NdIndexedPropertyIndex WjHPsXY;
    public static final int READ = 20;
    public static final int WRITE = 21;
    public static final int INVOKE = 22;

    public NdExternalAccessEvent(NdScriptContext ndScriptContext, NdExternalObject ndExternalObject, NdProperty ndProperty, NdExternalMethod ndExternalMethod, int n, Object object, Object[] objectArray) {
        super(ndExternalObject, n);
        this.WjHFDVY = ndScriptContext;
        this.WjHAQMX = ndProperty;
        this.WjHAQMT = ndExternalMethod;
        this.WjHAQMV = object;
        this.WjHAQMW = objectArray;
    }

    public NdExternalAccessEvent(NdScriptContext ndScriptContext, NdExternalObject ndExternalObject, NdProperty ndProperty, NdIndexedPropertyIndex ndIndexedPropertyIndex, NdExternalMethod ndExternalMethod, int n, Object object, Object[] objectArray) {
        this(ndScriptContext, ndExternalObject, ndProperty, ndExternalMethod, n, object, objectArray);
        this.WjHPsXY = ndIndexedPropertyIndex;
    }

    public NdExternalObject getObject() {
        return (NdExternalObject)this.getSource();
    }

    public NdProperty getNdProperty() {
        return this.WjHAQMX;
    }

    public NdExternalMethod getNdExternalMethod() {
        return this.WjHAQMT;
    }

    public int getEventType() {
        return this.getEventCode();
    }

    public Object getReturnValue() {
        return this.WjHAQMV;
    }

    public Object[] getArgs() {
        return this.WjHAQMW;
    }

    public NdIndexedPropertyIndex getIndexedPropertyIndex() {
        return this.WjHPsXY;
    }

    public String toString() {
        String string = "ExternalAccessEvent ";
        switch (this.getEventCode()) {
            case 20: {
                string = string + "(Read) " + this.WjHAQMX.getName();
                break;
            }
            case 21: {
                string = string + "(Write) " + this.WjHAQMX.getName();
                break;
            }
            case 22: {
                string = string + "(Invoke) " + this.WjHAQMT.getName();
                break;
            }
        }
        return string + " on " + this.getObject() + " => return value: " + this.WjHAQMV;
    }

    public String getFormattedMessage() {
        String string;
        switch (this.getEventCode()) {
            case 20: {
                if (this.getArgs() != null && this.getArgs().length > 0) {
                    string = NdStrings.WjHAPDK("IndexedExternalAccessEventRead", this.getObject(), this.getNdProperty().getName(), NdBaseObject.arrayFormat((Object)this.getArgs(), (String)"(", (String)",", (String)")"), this.getReturnValue());
                    break;
                }
                string = NdStrings.WjHAPCJ("ExternalAccessEventRead", this.getObject(), this.getNdProperty().getName(), this.getReturnValue());
                break;
            }
            case 21: {
                if (this.getIndexedPropertyIndex() != null) {
                    string = NdStrings.WjHAPDK("IndexedExternalAccessEventWrite", this.getObject(), this.getNdProperty().getName(), NdBaseObject.arrayFormat((Object)this.getIndexedPropertyIndex(), (String)"(", (String)",", (String)")"), NdBaseObject.arrayFormat((Object)this.getArgs(), (String)"", (String)",", (String)""));
                    break;
                }
                string = NdStrings.WjHAPCJ("ExternalAccessEventWrite", this.getObject(), this.getNdProperty().getName(), NdBaseObject.arrayFormat((Object)this.getArgs(), (String)"", (String)",", (String)""));
                break;
            }
            case 22: {
                if (this.getArgs() != null && this.getArgs().length > 0) {
                    string = NdStrings.WjHAPDK("ArgsExternalAccessEventInvoke", this.getObject(), this.getNdExternalMethod().getName(), NdBaseObject.arrayFormat((Object)this.getArgs(), (String)"(", (String)",", (String)")"), this.getReturnValue());
                    break;
                }
                string = NdStrings.WjHAPCJ("ExternalAccessEventInvoke", this.getObject(), this.getNdExternalMethod().getName(), this.getReturnValue());
                break;
            }
            default: {
                string = "??" + this.getClass().getName() + NdLocalizedConstants.getColon() + this.getEventCode() + "??";
            }
        }
        return string;
    }
}

