/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.engines.rules.interf;

import com.blazesoft.engines.rules.NdClass;
import com.blazesoft.engines.rules.NdClassEventHandler;
import com.blazesoft.engines.rules.NdCompilationException;
import com.blazesoft.engines.rules.NdDefProjectResource;
import com.blazesoft.engines.rules.NdEvaluationException;
import com.blazesoft.engines.rules.NdEventHandler;
import com.blazesoft.engines.rules.NdFileProjectResource;
import com.blazesoft.engines.rules.NdFunction;
import com.blazesoft.engines.rules.NdFunctionalItem;
import com.blazesoft.engines.rules.NdParameter;
import com.blazesoft.engines.rules.NdProjectResource;
import com.blazesoft.engines.rules.NdProperty;
import com.blazesoft.engines.rules.NdPropertyEventHandler;
import com.blazesoft.engines.rules.NdResourceException;
import com.blazesoft.engines.rules.NdRuleAgent;
import com.blazesoft.engines.rules.NdRuleSet;
import com.blazesoft.engines.rules.NdRulesServiceScript;
import com.blazesoft.engines.rules.NdType;
import com.blazesoft.engines.rules.NdURLProjectResource;
import com.blazesoft.engines.rules.WjHBIEZ;
import com.blazesoft.engines.rules.WjHBpKX;
import com.blazesoft.engines.rules.interf.NdStrings;
import java.net.MalformedURLException;
import java.net.URL;

public class NdSrlInterfaceGenerator {
    protected void generateSrlFunctional(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer, NdFunctionalItem ndFunctionalItem) {
        int n;
        String string = ndFunctionalItem.getName();
        NdParameter[] ndParameterArray = ndFunctionalItem.getParameters();
        if (string.startsWith("$")) {
            return;
        }
        if (string.startsWith("ND_")) {
            return;
        }
        NdType ndType = ndFunctionalItem.getReturnType();
        NdType[] ndTypeArray = new NdType[ndParameterArray.length];
        for (n = 0; n < ndParameterArray.length; ++n) {
            ndTypeArray[n] = ndParameterArray[n].getType();
        }
        stringBuffer.append("\t<SrlFunctional>\n");
        stringBuffer.append("\t\t<SrlReturnType>" + ndType.getName() + "</SrlReturnType>\n");
        stringBuffer.append("\t\t<SrlName>" + string + "</SrlName>\n");
        for (n = 0; n < ndParameterArray.length; ++n) {
            stringBuffer.append("\t\t<SrlArgumentType>" + (Object)((Object)ndTypeArray[n]) + "</SrlArgumentType>\n");
        }
        stringBuffer.append("\t</SrlFunctional>\n");
    }

    protected void generateSrlFunctionals(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer) {
        int n;
        NdRulesServiceScript ndRulesServiceScript = ndRuleAgent.getRulesServiceScript();
        NdRuleSet[] ndRuleSetArray = ((WjHBIEZ)ndRulesServiceScript).getRuleSets();
        NdFunction[] ndFunctionArray = ((WjHBIEZ)ndRulesServiceScript).getFunctions();
        for (n = 0; n < ndRuleSetArray.length; ++n) {
            this.generateSrlFunctional(ndRuleAgent, stringBuffer, ndRuleSetArray[n]);
        }
        for (n = 0; n < ndFunctionArray.length; ++n) {
            this.generateSrlFunctional(ndRuleAgent, stringBuffer, ndFunctionArray[n]);
        }
    }

    protected void generateSrlTriggeringEventClass(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer, NdClassEventHandler ndClassEventHandler) {
        String string = ndClassEventHandler.getName();
        NdClass ndClass = ndClassEventHandler.getEventClass();
        int n = ndClassEventHandler.getEvent();
        if (string.startsWith("$")) {
            return;
        }
        if (string.startsWith("ND_")) {
            return;
        }
        stringBuffer.append("\t<SrlTriggeringEventClass>\n");
        stringBuffer.append("\t\t<SrlClass>" + ndClass.getName() + "</SrlClass>\n");
        stringBuffer.append("\t\t<SrlEventType>" + WjHBpKX.WjHBpGT(n) + "</SrlEventType>\n");
        stringBuffer.append("\t</SrlTriggeringEventClass>\n");
    }

    protected void generateSrlTriggeringEventClasses(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer) {
        NdRulesServiceScript ndRulesServiceScript = ndRuleAgent.getRulesServiceScript();
        NdEventHandler[] ndEventHandlerArray = ((NdFunctionalItem)ndRulesServiceScript).getEventHandlers();
        for (int i = 0; i < ndEventHandlerArray.length; ++i) {
            if (!(ndEventHandlerArray[i] instanceof NdClassEventHandler)) continue;
            this.generateSrlTriggeringEventClass(ndRuleAgent, stringBuffer, (NdClassEventHandler)ndEventHandlerArray[i]);
        }
    }

    protected void generateSrlIsNeededQuestionsGroup(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer, String string, NdPropertyEventHandler ndPropertyEventHandler) {
        String string2 = ndPropertyEventHandler.getName();
        NdClass ndClass = ndPropertyEventHandler.getEventClass();
        NdProperty ndProperty = ndPropertyEventHandler.getEventClassProperty();
        int n = ndPropertyEventHandler.getEvent();
        if (string2.startsWith("$")) {
            return;
        }
        if (string2.startsWith("ND_")) {
            return;
        }
        if (n != 115 && n != 119) {
            return;
        }
        stringBuffer.append("\t<SrlQuestionsGroup>\n");
        stringBuffer.append("\t\t<SrlName>" + (string != null ? string + ":" : "") + ndProperty.getName() + "</SrlName>\n");
        stringBuffer.append("\t\t<SrlQuestionPrompt>Value for property " + ndProperty.getName() + "</SrlQuestionPrompt>\n");
        stringBuffer.append("\t\t<SrlQuestion>\n");
        stringBuffer.append("\t\t\t<SrlQuestionPrompt>Value for property " + ndProperty.getName() + "</SrlQuestionPrompt>\n");
        stringBuffer.append("\t\t\t<SrlClassProperty>\n");
        stringBuffer.append("\t\t\t\t<SrlClass>" + ndClass.getName() + "</SrlClass>\n");
        stringBuffer.append("\t\t\t\t<SrlProperty>" + ndProperty.getName() + "</SrlProperty>\n");
        stringBuffer.append("\t\t\t</SrlClassProperty>\n");
        stringBuffer.append("\t\t</SrlQuestion>\n");
        stringBuffer.append("\t</SrlQuestionsGroup>\n");
    }

    protected void generateSrlIsNeededQuestionsGroup(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer, NdPropertyEventHandler ndPropertyEventHandler) {
        this.generateSrlIsNeededQuestionsGroup(ndRuleAgent, stringBuffer, null, ndPropertyEventHandler);
    }

    protected void generateSrlIsNeededQuestionsGroups(NdRuleAgent ndRuleAgent, StringBuffer stringBuffer) {
        NdRulesServiceScript ndRulesServiceScript = ndRuleAgent.getRulesServiceScript();
        NdEventHandler[] ndEventHandlerArray = ((NdFunctionalItem)ndRulesServiceScript).getEventHandlers();
        for (int i = 0; i < ndEventHandlerArray.length; ++i) {
            if (!(ndEventHandlerArray[i] instanceof NdPropertyEventHandler)) continue;
            this.generateSrlIsNeededQuestionsGroup(ndRuleAgent, stringBuffer, (NdPropertyEventHandler)ndEventHandlerArray[i]);
        }
        NdRuleSet[] ndRuleSetArray = ((WjHBIEZ)ndRulesServiceScript).getRuleSets();
        for (int i = 0; i < ndRuleSetArray.length; ++i) {
            ndEventHandlerArray = ndRuleSetArray[i].getEventHandlers();
            for (int j = 0; j < ndEventHandlerArray.length; ++j) {
                if (!(ndEventHandlerArray[i] instanceof NdPropertyEventHandler)) continue;
                this.generateSrlIsNeededQuestionsGroup(ndRuleAgent, stringBuffer, ndRuleSetArray[i].getName(), (NdPropertyEventHandler)ndEventHandlerArray[j]);
            }
        }
    }

    public String generateSrlInterfaceDescription(NdRuleAgent ndRuleAgent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" ?>\n");
        stringBuffer.append("<!-- $Id: NdSrlInterfaceGenerator.java 83134 2003-08-01 19:11:54Z rkesavan $ -->\n\n");
        stringBuffer.append("<SrlInterface>\n");
        this.generateSrlFunctionals(ndRuleAgent, stringBuffer);
        this.generateSrlTriggeringEventClasses(ndRuleAgent, stringBuffer);
        this.generateSrlIsNeededQuestionsGroups(ndRuleAgent, stringBuffer);
        stringBuffer.append("</SrlInterface>\n");
        return stringBuffer.toString();
    }

    private NdProjectResource WjHRbnT(String string) throws NdResourceException {
        boolean bl = false;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            bl = true;
        }
        NdDefProjectResource ndDefProjectResource = bl ? new NdFileProjectResource(string) : new NdURLProjectResource(string);
        return ndDefProjectResource;
    }

    public String generateSrlInterfaceDescription(String string) {
        NdRuleAgent ndRuleAgent = null;
        try {
            NdProjectResource ndProjectResource = this.WjHRbnT(string);
            ndRuleAgent = NdRuleAgent.createRuleAgent(ndProjectResource);
            ndRuleAgent.loadProject();
            ndRuleAgent.compile();
        }
        catch (NdCompilationException ndCompilationException) {
            System.out.println(NdStrings.WjHCmZK("CompilationExceptionInInterfaceGeneration") + ndCompilationException.fullMessage());
            ndCompilationException.printStackTrace();
        }
        catch (NdEvaluationException ndEvaluationException) {
            ndEvaluationException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(NdStrings.WjHCmZK("ExceptionInInterfaceGeneration") + exception);
            exception.printStackTrace();
        }
        catch (Error error) {
            throw error;
        }
        return this.generateSrlInterfaceDescription(ndRuleAgent);
    }

    public static void main(String[] stringArray) {
        String string = new NdSrlInterfaceGenerator().generateSrlInterfaceDescription(stringArray[0]);
        System.out.println(string);
    }
}

