/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.base;

import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdStrings;
import java.util.EventObject;

public class NdServerManagementEvent
extends EventObject {
    public static final int SERVER_STATE_UNKNOWN = -2;
    public static final int SERVER_CREATION_REQUESTED = 0;
    public static final int SERVER_CREATED = 1;
    public static final int SERVER_INITIALIZED = 2;
    public static final int SERVER_SHUTDOWN_REQUESTED = 3;
    public static final int SERVER_SHUTDOWN_COMPLETE = 4;
    private int SiPNzMK;
    private NdServerId SiPNzNL;

    public NdServerManagementEvent(NdServerId ndServerId, int n) {
        super(ndServerId);
        this.SiPNzNL = ndServerId;
        this.SiPNzMK = n;
    }

    public int getType() {
        return this.SiPNzMK;
    }

    public NdServerId getServerId() {
        return this.SiPNzNL;
    }

    public static String getUnlocalizedTypeString(int n) {
        switch (n) {
            case 0: {
                return "SERVER_CREATION_REQUESTED";
            }
            case 1: {
                return "SERVER_CREATED";
            }
            case 2: {
                return "SERVER_INITIALIZED";
            }
            case 3: {
                return "SERVER_SHUTDOWN_REQUESTED";
            }
            case 4: {
                return "SERVER_SHUTDOWN_COMPLETE";
            }
        }
        return "SERVER_STATE_UNKNOWN";
    }

    public String getUnlocalizedTypeString() {
        return NdServerManagementEvent.getUnlocalizedTypeString(this.getType());
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return NdStrings.SiPoUGH("ServerCreationRequested");
            }
            case 1: {
                return NdStrings.SiPoUGH("ServerCreated");
            }
            case 2: {
                return NdStrings.SiPoUGH("ServerInitialized");
            }
            case 3: {
                return NdStrings.SiPoUGH("ServerShutdownRequested");
            }
            case 4: {
                return NdStrings.SiPoUGH("ServerShutdownComplete");
            }
        }
        return NdStrings.SiPoUGH("ServerOther");
    }

    public String getMessage() {
        String string = this.getServerId().getIdentifierString();
        if (this.getServerId() != null) {
            string = string + ": " + this.getServerId().getIdentifierString();
            string = string + " (" + this.getTypeString() + ")";
        }
        return string;
    }

    public String toString() {
        return this.getMessage();
    }
}

