/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.base;

import com.blazesoft.server.base.NdServiceAgent;
import com.blazesoft.server.base.NdServiceExecContext;
import com.blazesoft.server.base.NdServiceId;
import com.blazesoft.server.base.NdStrings;
import java.io.Serializable;
import java.util.EventObject;

public class NdServiceEvent
extends EventObject
implements Serializable {
    public static final int AGENT_ADDED = 0;
    public static final int AGENT_REMOVED = 1;
    public static final int AGENT_EXECUTING = 2;
    public static final int AGENT_DONE = 4;
    public static final int AGENT_FREE = 5;
    public static final int AGENT_REINITIALIZED = 6;
    private NdServiceId SiPpmrX;
    private int SiPpmrY;
    private transient NdServiceAgent SiPpmrZ;
    private transient NdServiceExecContext SiPpmsA;

    public NdServiceEvent(NdServiceId ndServiceId, int n, NdServiceAgent ndServiceAgent) {
        this(ndServiceId, n, ndServiceAgent, null);
    }

    public NdServiceEvent(NdServiceId ndServiceId, int n, NdServiceAgent ndServiceAgent, NdServiceExecContext ndServiceExecContext) {
        super(ndServiceId);
        this.SiPpmrX = ndServiceId;
        this.SiPpmrY = n;
        this.SiPpmrZ = ndServiceAgent;
        this.SiPpmsA = ndServiceExecContext;
    }

    public int getType() {
        return this.SiPpmrY;
    }

    public NdServiceAgent getAgent() {
        return this.SiPpmrZ;
    }

    public NdServiceExecContext getExecContext() {
        return this.SiPpmsA;
    }

    public NdServiceId getServiceId() {
        return this.SiPpmrX;
    }

    public static String getUnlocalizedTypeString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "AGENT_ADDED";
                break;
            }
            case 1: {
                string = "AGENT_REMOVED";
                break;
            }
            case 2: {
                string = "AGENT_EXECUTING";
                break;
            }
            case 4: {
                string = "AGENT_DONE";
                break;
            }
            case 5: {
                string = "AGENT_FREE";
                break;
            }
            case 6: {
                string = "AGENT_REINITIALIZED";
                break;
            }
            default: {
                string = "AGENT_UNKNOWN";
            }
        }
        return string;
    }

    public String getUnlocalizedTypeString() {
        return NdServiceEvent.getUnlocalizedTypeString(this.getType());
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return NdStrings.SiPoUGH("ServiceAddedEvent");
            }
            case 1: {
                return NdStrings.SiPoUGH("ServiceRemovedEvent");
            }
            case 2: {
                return NdStrings.SiPoUGH("ServiceExecutingEvent");
            }
            case 4: {
                return NdStrings.SiPoUGH("ServiceDoneEvent");
            }
            case 5: {
                return NdStrings.SiPoUGH("ServiceFreeEvent");
            }
            case 6: {
                return NdStrings.SiPoUGH("ServiceReinitializedEvent");
            }
        }
        return NdStrings.SiPoUGH("ServiceOtherEvent");
    }

    public String getMessage() {
        return this.getServiceId().getServiceName() + ": agent " + this.getTypeString();
    }

    public String toString() {
        return this.getMessage();
    }
}

