/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy;

import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdMonitoredServer;
import com.blazesoft.server.base.NdMonitoredService;
import com.blazesoft.server.base.NdMonitoredServiceManager;
import com.blazesoft.server.base.NdMonitoredServiceSessionManager;
import com.blazesoft.server.base.NdServer;
import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdServerRuntimeException;
import com.blazesoft.server.base.NdServerStatistics;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceManager;
import com.blazesoft.server.base.SiPpmrF;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.config.NdServerConfigFactory;
import com.blazesoft.server.config.NdServiceConfig;
import com.blazesoft.server.deploy.NdDefaultServerDeploymentContext;
import com.blazesoft.server.deploy.NdDeploymentSupport;
import com.blazesoft.server.deploy.NdManagedComponent;
import com.blazesoft.server.deploy.NdServerDeploymentAccessException;
import com.blazesoft.server.deploy.NdServerDeploymentContext;
import com.blazesoft.server.deploy.NdServerDeploymentIllegalStateException;
import com.blazesoft.server.deploy.NdServerDeploymentInitializationException;
import com.blazesoft.server.deploy.NdStrings;
import com.blazesoft.server.local.NdInvalidServerConfigurationException;
import com.blazesoft.server.local.NdLocalServer;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.server.local.NdLocalServerRuntimeException;
import com.blazesoft.server.local.NdStringBufferServerConfigFactory;
import com.blazesoft.server.local.NdURLServerConfigFactory;
import com.blazesoft.system.NdMonitoredSystemErrStream;
import com.blazesoft.system.NdMonitoredSystemOutStream;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.NdWrappedExceptionSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class NdServerDeployment
extends NdManagedComponent
implements NdServer,
Cloneable {
    private transient NdServerId SiPpkyY;
    private transient SiPqYvW SiPqWQM;
    private transient boolean SiPpkzA;
    private transient boolean SiPpkAB;
    private transient boolean SiPsgzT;
    private transient boolean SiPtFjP;
    private static final Hashtable SiPpkCD = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SiPqWRN(SiPqYvW siPqYvW) throws NdLocalServerException {
        NdServerDeployment ndServerDeployment = this;
        synchronized (ndServerDeployment) {
            if (this.SiPpkAB) {
                this.SiPrEuI();
            } else if (this.SiPpkzA) {
                throw new NdServerDeploymentIllegalStateException(siPqYvW.SiPqYuV(), NdStrings.SiPpjKN("ErrorAlreadyInitialized"));
            }
            this.SiPqWQM = siPqYvW;
            NdLocalServer ndLocalServer = this.SiPpkEF();
            if (ndLocalServer != null) {
                this.SiPpkyY = ndLocalServer.getServerId();
                if (!this.SiPpkzA) {
                    this.SiPpkzA = true;
                    this.SiPpOjC();
                }
            }
        }
    }

    SiPqYvW SiPqWSO() {
        return this.SiPqWQM;
    }

    private void SiPpOjC() throws NdLocalServerException {
        NdServerConfig ndServerConfig = this.getLocalServer().getServerConfig();
        NdServiceConfig[] ndServiceConfigArray = ndServerConfig.getServiceConfig();
        if (ndServiceConfigArray != null) {
            for (int i = 0; i < ndServiceConfigArray.length; ++i) {
                if (ndServiceConfigArray[i].getNumAgents() != -2) continue;
                ((NdManagedService)((Object)this.getLocalServer().getService(ndServiceConfigArray[i].getName()))).addServiceAgents(1);
            }
        }
        this.SiPtFjP = true;
    }

    private void SiPpOjD() throws NdLocalServerException {
        if (!this.SiPtFjP) {
            return;
        }
        NdServerConfig ndServerConfig = this.getLocalServer().getServerConfig();
        NdServiceConfig[] ndServiceConfigArray = ndServerConfig.getServiceConfig();
        if (ndServiceConfigArray != null) {
            for (int i = 0; i < ndServiceConfigArray.length; ++i) {
                if (ndServiceConfigArray[i].getNumAgents() != -2) continue;
                ((NdManagedService)((Object)this.getLocalServer().getService(ndServiceConfigArray[i].getName()))).removeServiceAgents(1);
            }
        }
        this.SiPtFjP = false;
    }

    private Object SiPtTjN() throws NdServerDeploymentIllegalStateException {
        Object object = this.getKey();
        if (object == null) {
            throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("ErrorKeyNotSet"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NdLocalServer SiPpkEF() throws NdServerDeploymentAccessException {
        NdLocalServer ndLocalServer = null;
        Object object = this.SiPtTjN();
        Hashtable hashtable = SiPpkCD;
        synchronized (hashtable) {
            SiPpjBD siPpjBD = (SiPpjBD)SiPpkCD.get(object);
            if (siPpjBD != null) {
                ndLocalServer = (NdLocalServer)siPpjBD.SiPpjBB.SiPpmrD();
                ++siPpjBD.SiPpjBC;
                NdServerConfig ndServerConfig = ndLocalServer.getServerConfig();
                this.SiPqWQM.SiPrHLT(ndServerConfig);
                this.SiPsgzT = ndServerConfig.getShutdownOnZeroRefCount();
            }
        }
        return ndLocalServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPrEtH(boolean bl) throws NdServerException {
        if (!this.SiPpkAB) {
            NdServer ndServer = null;
            boolean bl2 = false;
            try {
                NdServerDeployment ndServerDeployment = this;
                synchronized (ndServerDeployment) {
                    if (!this.SiPpkAB) {
                        Hashtable hashtable = SiPpkCD;
                        synchronized (hashtable) {
                            block18: {
                                Object object = this.SiPtTjN();
                                SiPpjBD siPpjBD = (SiPpjBD)SiPpkCD.get(object);
                                if (siPpjBD != null) {
                                    ndServer = siPpjBD.SiPpjBB.SiPpmrD();
                                    try {
                                        this.SiPpOjD();
                                        Object var9_8 = null;
                                        --siPpjBD.SiPpjBC;
                                        if (bl) {
                                            siPpjBD.SiPsgAX = true;
                                        }
                                        this.SiPpkAB = true;
                                        if (siPpjBD.SiPpjBC != 0L || !siPpjBD.SiPsgAX) break block18;
                                        siPpjBD.SiPpjBB.SiPpmrE(null);
                                        SiPpkCD.remove(object);
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_9 = null;
                                        --siPpjBD.SiPpjBC;
                                        if (bl) {
                                            siPpjBD.SiPsgAX = true;
                                        }
                                        this.SiPpkAB = true;
                                        if (siPpjBD.SiPpjBC == 0L && siPpjBD.SiPsgAX) {
                                            siPpjBD.SiPpjBB.SiPpmrE(null);
                                            SiPpkCD.remove(object);
                                            bl2 = true;
                                        }
                                        throw throwable;
                                    }
                                    bl2 = true;
                                    {
                                        break block18;
                                    }
                                }
                                this.SiPpkAB = true;
                            }
                        }
                    }
                }
                Object var13_13 = null;
                if (ndServer != null && bl2) {
                    ndServer.shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (ndServer != null && bl2) {
                    ndServer.shutdown();
                }
                throw throwable;
            }
        }
    }

    protected void removed() {
        try {
            this.SiPrEtH(this.SiPsgzT);
        }
        catch (NdServerException ndServerException) {
            throw new NdServerRuntimeException((Throwable)((Object)ndServerException));
        }
    }

    public Object getKey() {
        Object object = null;
        if (this.SiPqWQM != null) {
            object = this.SiPqWQM.SiPrCoY();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws NdLocalServerException {
        try {
            this.prepareTxContext();
            if (!this.SiPpkzA) {
                NdServerDeployment ndServerDeployment = this;
                synchronized (ndServerDeployment) {
                    if (!this.SiPpkzA) {
                        NdLocalServer ndLocalServer = null;
                        Hashtable hashtable = SiPpkCD;
                        synchronized (hashtable) {
                            ndLocalServer = this.SiPpkEF();
                            if (ndLocalServer == null) {
                                NdServerConfig ndServerConfig = this.SiPqWQM.SiPqYtU();
                                this.SiPsgzT = ndServerConfig.getShutdownOnZeroRefCount();
                                this.validateServerConfiguration(ndServerConfig);
                                ndLocalServer = this.createServer(ndServerConfig);
                                SiPpkCD.put(this.SiPtTjN(), new SiPpjBD(ndLocalServer));
                            }
                        }
                        this.SiPpkyY = ndLocalServer.getServerId();
                        this.SiPpkzA = true;
                        this.SiPpOjC();
                    }
                }
            }
            this.validateTxContext();
        }
        catch (RuntimeException runtimeException) {
            throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)runtimeException);
        }
    }

    protected void validateServerConfiguration(NdServerConfig ndServerConfig) throws NdInvalidServerConfigurationException {
    }

    protected abstract NdLocalServer createServer(NdServerConfig var1) throws NdLocalServerException;

    public void resetDeploymentService(String string) throws NdLocalServerException {
        this.prepareTxContext();
        this.getLocalServer().resetService(string);
        this.validateTxContext();
    }

    public void shutdownDeployment() throws NdServerException {
        this.prepareTxContext();
        if (this.SiPpkzA) {
            try {
                this.removed();
            }
            catch (NdServerRuntimeException ndServerRuntimeException) {
                Throwable throwable = ndServerRuntimeException.getSourceThrowable();
                if (throwable instanceof NdServerException) {
                    throw (NdServerException)((Object)throwable);
                }
                throw ndServerRuntimeException;
            }
        }
        this.validateTxContext();
    }

    public void shutdown() throws NdServerException {
        this.SiPsgzT = true;
        this.shutdownDeployment();
    }

    private SiPpjBD SiPpkFG() throws NdServerDeploymentAccessException {
        SiPpjBD siPpjBD;
        try {
            if (this.SiPpkAB) {
                throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("AttemptToAccessServerAfterShutdown"));
            }
            if (!this.SiPpkzA) {
                try {
                    this.initialize();
                }
                catch (NdLocalServerException ndLocalServerException) {
                    if (ndLocalServerException instanceof NdServerDeploymentAccessException) {
                        throw (NdServerDeploymentAccessException)ndLocalServerException;
                    }
                    throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)((Object)ndLocalServerException));
                }
            }
            if ((siPpjBD = (SiPpjBD)SiPpkCD.get(this.SiPtTjN())) == null) {
                throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("AttemptToAccessServerAfterShutdown"));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)runtimeException);
        }
        return siPpjBD;
    }

    protected SiPpmrF getServerHandle() throws NdLocalServerException {
        return this.SiPpkFG().SiPpjBB;
    }

    protected Object getServerProperty(Object object) throws NdLocalServerException {
        return this.SiPpkFG().SiPrEvM.get(object);
    }

    protected void setServerProperty(Object object, Object object2) throws NdLocalServerException {
        if (object2 == null) {
            this.SiPpkFG().SiPrEvM.remove(object);
        } else {
            this.SiPpkFG().SiPrEvM.put(object, object2);
        }
    }

    protected Enumeration getServerProperties() throws NdLocalServerException {
        return this.SiPpkFG().SiPrEvM.keys();
    }

    protected NdLocalServer tryGetLocalServer() {
        NdLocalServer ndLocalServer = null;
        if (!this.SiPpkAB && this.SiPpkzA) {
            Object object;
            try {
                object = this.SiPtTjN();
            }
            catch (NdServerDeploymentIllegalStateException ndServerDeploymentIllegalStateException) {
                throw new NdLocalServerRuntimeException(this.getServerId(), (Throwable)((Object)ndServerDeploymentIllegalStateException));
            }
            SiPpjBD siPpjBD = (SiPpjBD)SiPpkCD.get(object);
            if (siPpjBD != null) {
                ndLocalServer = (NdLocalServer)siPpjBD.SiPpjBB.SiPpmrD();
            }
        }
        return ndLocalServer;
    }

    protected NdLocalServer getLocalServerInternal() throws NdLocalServerException {
        NdLocalServer ndLocalServer;
        try {
            ndLocalServer = (NdLocalServer)this.SiPpkFG().SiPpjBB.SiPpmrD();
        }
        catch (NdLocalServerException ndLocalServerException) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.blazesoft.server.deploy.NdServerDeploymentAccessException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)classNotFoundException);
            }
            Throwable throwable = NdWrappedExceptionSupport.getMatchingSourceThrowable((Throwable)((Object)ndLocalServerException), clazz);
            if (throwable == null) {
                throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)((Object)ndLocalServerException));
            }
            throw ndLocalServerException;
        }
        if (ndLocalServer == null) {
            throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("AttemptToAccessServerAfterShutdown"));
        }
        return ndLocalServer;
    }

    public NdServerConfig getServerConfig() throws NdLocalServerException {
        NdLocalServer ndLocalServer = this.tryGetLocalServer();
        NdServerConfig ndServerConfig = ndLocalServer == null ? this.SiPqWQM.SiPqYtU() : ndLocalServer.getServerConfig();
        return ndServerConfig;
    }

    public NdMonitoredServer getLocalMonitoredServer() throws NdLocalServerException {
        return this.getLocalServerInternal();
    }

    public NdMonitoredServiceManager getLocalMonitoredServiceManager() throws NdLocalServerException {
        return (NdMonitoredServiceManager)((Object)this.getLocalServerInternal().getServiceManager());
    }

    public NdMonitoredService getLocalMonitoredService(String string) throws NdLocalServerException {
        return (NdMonitoredService)((Object)this.getLocalServerInternal().getService(string));
    }

    public NdMonitoredServiceSessionManager getLocalMonitoredServiceSessionManager(String string) throws NdLocalServerException {
        return (NdMonitoredServiceSessionManager)((Object)((NdManagedService)((Object)this.getLocalServerInternal().getService(string))).getServiceSessionManager());
    }

    public NdMonitoredSystemOutStream getLocalMonitoredSystemOutStream() throws NdLocalServerException {
        return this.getLocalServerInternal();
    }

    public NdMonitoredSystemErrStream getLocalMonitoredSystemErrStream() throws NdLocalServerException {
        return this.getLocalServerInternal();
    }

    protected void finalize() throws Throwable {
        this.shutdownDeployment();
        super.finalize();
    }

    public NdServerDeployment() {
    }

    protected NdServerDeployment(Object object, NdServerConfigFactory ndServerConfigFactory) throws NdLocalServerException {
        this();
        this.setServerDeploymentContext(new NdDefaultServerDeploymentContext(object, ndServerConfigFactory));
    }

    protected NdServerDeployment(Object object, String string) throws NdLocalServerException {
        this(object, string, null);
    }

    protected NdServerDeployment(Object object, String string, Object[] objectArray) throws NdLocalServerException {
        this(object, new NdURLServerConfigFactory(string, objectArray));
    }

    protected NdServerDeployment(Object object, StringBuffer stringBuffer) throws NdLocalServerException {
        this(object, stringBuffer, null);
    }

    protected NdServerDeployment(Object object, StringBuffer stringBuffer, Object[] objectArray) throws NdLocalServerException {
        this(object, new NdStringBufferServerConfigFactory(stringBuffer, objectArray));
    }

    protected void setServerDeploymentContext(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
        SiPqYvW siPqYvW = new SiPqYvW(ndServerDeploymentContext);
        this.SiPqWRN(siPqYvW);
    }

    protected NdServerDeployment cloneServerDeployment() throws NdLocalServerException {
        NdServerDeployment ndServerDeployment;
        try {
            ndServerDeployment = (NdServerDeployment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        ndServerDeployment.SiPrEuI();
        ndServerDeployment.SiPqWRN(this.SiPqWQM);
        return ndServerDeployment;
    }

    public NdLocalServer getLocalServer() {
        NdLocalServer ndLocalServer;
        try {
            ndLocalServer = this.getLocalServerInternal();
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw new NdLocalServerRuntimeException(this.getServerId(), NdStrings.SiPpjKN("ErrorInitializingServer"), (Throwable)((Object)ndLocalServerException));
        }
        return ndLocalServer;
    }

    public void setServiceClassLoadingContext(String string, NdClassLoadingContext ndClassLoadingContext) throws NdLocalServerException {
        this.getLocalServerInternal().setServiceClassLoadingContext(string, ndClassLoadingContext);
    }

    public NdServiceManager getServiceManager() {
        this.prepareTxContext();
        NdServiceManager ndServiceManager = this.getLocalServer().getServiceManager();
        this.validateTxContext();
        return ndServiceManager;
    }

    public NdService getService(String string) {
        this.prepareTxContext();
        NdService ndService = this.getLocalServer().getService(string);
        this.validateTxContext();
        return ndService;
    }

    public String[] getServiceNames() {
        this.prepareTxContext();
        String[] stringArray = this.getLocalServer().getServiceNames();
        this.validateTxContext();
        return stringArray;
    }

    public NdServerId getServerId() {
        this.prepareTxContext();
        NdServerId ndServerId = this.SiPpkyY;
        if (ndServerId == null) {
            ndServerId = this.SiPqWQM == null ? new NdServerId(NdStrings.SiPpjKN("UnspecifiedServerConfig")) : this.SiPqWQM.SiPqYuV();
        }
        this.validateTxContext();
        return ndServerId;
    }

    public NdServerStatistics getStatistics() {
        this.prepareTxContext();
        NdServerStatistics ndServerStatistics = this.getLocalServer().getStatistics();
        this.validateTxContext();
        return ndServerStatistics;
    }

    public void garbageCollect() {
        this.prepareTxContext();
        System.gc();
        System.runFinalization();
        this.validateTxContext();
    }

    public long getUsedMemory() {
        this.prepareTxContext();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        this.validateTxContext();
        return l;
    }

    public long getFreeMemory() {
        this.prepareTxContext();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        this.validateTxContext();
        return l;
    }

    public long getTotalMemory() {
        this.prepareTxContext();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        this.validateTxContext();
        return l;
    }

    public String getSystemPropertiesList() {
        this.prepareTxContext();
        String string = NdDeploymentSupport.getSystemPropertiesList();
        this.validateTxContext();
        return string;
    }

    private void SiPrEuI() {
        this.SiPpkyY = null;
        this.SiPqWQM = null;
        this.SiPpkzA = false;
        this.SiPpkAB = false;
    }

    static class SiPqYvW
    implements Serializable {
        private NdServerDeploymentContext SiPrAxJ;
        private Object SiPrCmW;
        private NdServerConfig SiPqYpQ;
        private NdServerId SiPqYsT;

        SiPqYvW(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
            this.SiPrAxJ = ndServerDeploymentContext;
            this.SiPrCnX(ndServerDeploymentContext);
        }

        private void SiPrCnX(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
            if (this.SiPrCmW != null) {
                throw new NdLocalServerException(this.SiPqYuV(), NdStrings.SiPpjKN("ErrorSettingKey"));
            }
            Object object = ndServerDeploymentContext.getServerConfigKey();
            if (object == null) {
                throw new NdLocalServerException(this.SiPqYuV(), NdStrings.SiPpjKN("ErrorSettingNullKey"));
            }
            this.SiPrCmW = object;
        }

        public Object SiPrCoY() {
            return this.SiPrCmW;
        }

        public NdServerConfig SiPqYtU() throws NdLocalServerException {
            if (this.SiPqYpQ == null) {
                try {
                    this.SiPqYpQ = this.SiPrAxJ.getServerConfig();
                }
                catch (NdServerException ndServerException) {
                    if (ndServerException instanceof NdLocalServerException) {
                        throw (NdLocalServerException)ndServerException;
                    }
                    throw new NdLocalServerException(this.SiPqYuV(), (Throwable)((Object)ndServerException));
                }
                this.SiPrAxJ = null;
            }
            return this.SiPqYpQ;
        }

        void SiPrHLT(NdServerConfig ndServerConfig) {
            this.SiPqYpQ = ndServerConfig;
            this.SiPrAxJ = null;
        }

        public NdServerId SiPqYuV() {
            if (this.SiPqYsT == null) {
                this.SiPqYsT = this.SiPqYpQ != null ? new NdServerId(this.SiPqYpQ.getName()) : new NdServerId(String.valueOf(this.SiPrAxJ.getServerConfigKey()));
            }
            return this.SiPqYsT;
        }
    }

    private static class SiPpjBD {
        public SiPpmrF SiPpjBB;
        public long SiPpjBC;
        public Hashtable SiPrEvM;
        public boolean SiPsgAX;

        public SiPpjBD(NdLocalServer ndLocalServer) {
            this.SiPpjBB = new SiPpmrF(ndLocalServer);
            this.SiPpjBC = 1L;
            this.SiPrEvM = new Hashtable();
        }
    }
}

