/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy;

import com.blazesoft.server.base.NdInteractiveServiceSession;
import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdMonitoredServer;
import com.blazesoft.server.base.NdMonitoredService;
import com.blazesoft.server.base.NdMonitoredServiceAgent;
import com.blazesoft.server.base.NdMonitoredServiceManager;
import com.blazesoft.server.base.NdMonitoredServiceSession;
import com.blazesoft.server.base.NdMonitoredServiceSessionManager;
import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceExecContext;
import com.blazesoft.server.base.NdServiceSessionDebugFilter;
import com.blazesoft.server.base.NdServiceSessionException;
import com.blazesoft.server.base.NdServiceSessionId;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.config.NdServiceClientContextFactory;
import com.blazesoft.server.deploy.NdDeployServiceClientContext;
import com.blazesoft.server.deploy.NdStatelessServiceSessionInitializationInfo;
import com.blazesoft.server.deploy.NdStrings;
import com.blazesoft.server.deploy.SiPrOSG;
import com.blazesoft.server.local.NdLocalServer;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.system.NdMonitoredSystemErrStream;
import com.blazesoft.system.NdMonitoredSystemOutStream;
import com.blazesoft.util.NdClassLoadingContext;

public class NdStatelessServer
extends NdLocalServer {
    private static final SiPrOSG SiPrTSQ = new SiPrOSG();

    public NdStatelessServer(NdServerConfig ndServerConfig) throws NdLocalServerException {
        this();
        this.configure(ndServerConfig);
    }

    protected NdStatelessServer() throws NdLocalServerException {
    }

    private NdServiceExecContext SiPsQAV(NdService ndService, String string, NdClassLoadingContext ndClassLoadingContext, boolean bl) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        NdServiceExecContext ndServiceExecContext;
        NdServiceClientContextFactory ndServiceClientContextFactory = ((NdManagedService)((Object)ndService)).getClientContextFactory();
        if (ndServiceClientContextFactory != null) {
            NdServiceSessionId ndServiceSessionId;
            NdDeployServiceClientContext ndDeployServiceClientContext = null;
            try {
                ndDeployServiceClientContext = (NdDeployServiceClientContext)ndServiceClientContextFactory.newServiceClientContext(string);
                ndDeployServiceClientContext.setSessionStateInputObject(SiPrTSQ);
                ndDeployServiceClientContext.setClassLoadingContext(ndClassLoadingContext);
                ndDeployServiceClientContext.SiPsQXX(bl);
            }
            catch (ClassCastException classCastException) {
                NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), NdStrings.SiPpjMP("IncorrectServiceClientContextFactory", ndService.getServiceId().getServiceName()), classCastException);
                this.notifyServiceException(ndService, ndServiceException);
                throw ndServiceException;
            }
            try {
                ndServiceSessionId = ndService.createServiceSession(ndDeployServiceClientContext);
            }
            catch (RuntimeException runtimeException) {
                NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), (Throwable)runtimeException);
                this.notifyServiceException(ndService, ndServiceException);
                throw ndServiceException;
            }
            try {
                ndServiceExecContext = ((NdManagedService)((Object)ndService)).getServiceSessionManager().getExecContext(ndServiceSessionId);
            }
            catch (RuntimeException runtimeException) {
                NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), (Throwable)runtimeException);
                this.notifyServiceException(ndService, ndServiceException);
                ndService.abortServiceSession(ndServiceSessionId);
                throw ndServiceException;
            }
        }
        NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), NdStrings.SiPpjMP("NoServiceClientContextFactory", ndService.getServiceId().getServiceName()));
        this.notifyServiceException(ndService, ndServiceException);
        throw ndServiceException;
        return ndServiceExecContext;
    }

    private boolean SiPsQAW(NdManagedService ndManagedService, String string, String string2, Object[] objectArray) {
        boolean bl = true;
        NdServiceSessionDebugFilter ndServiceSessionDebugFilter = ndManagedService.getServiceSessionDebugFilter();
        if (ndServiceSessionDebugFilter != null) {
            bl = ndServiceSessionDebugFilter.isDebuggingRequested(new NdStatelessServiceSessionInitializationInfo(string2, string, objectArray));
        }
        return bl;
    }

    private Object SiPsoKE(NdService ndService, String string, String string2, Object[] objectArray, NdClassLoadingContext ndClassLoadingContext) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        Object object;
        if (ndService instanceof NdManagedService) {
            Object object2;
            NdServiceExecContext ndServiceExecContext = this.SiPsQAV(ndService, string2, ndClassLoadingContext, this.SiPsQAW((NdManagedService)((Object)ndService), string, string2, objectArray));
            if (SiPrTSQ.SiPrUbO(ndServiceExecContext)) {
                object2 = this.SiPsQAV(ndService, string2, ndClassLoadingContext, false);
                ndService.passivateServiceSession(object2.getServiceSessionId());
                SiPrTSQ.SiPrUbP((NdServiceExecContext)object2);
            }
            object2 = (NdDeployServiceClientContext)ndServiceExecContext.getServiceClientContext();
            ((NdDeployServiceClientContext)object2).setServiceEntryPointId(string);
            ((NdDeployServiceClientContext)object2).setServiceArgs(objectArray);
            NdServiceSessionId ndServiceSessionId = ndServiceExecContext.getServiceSessionId();
            try {
                ((NdDeployServiceClientContext)object2).startInvocation(ndServiceExecContext);
                int n = 0;
                int n2 = ((NdDeployServiceClientContext)object2).getMaxServiceInvocationCount();
                do {
                    ndService.invokeServiceSession(ndServiceSessionId);
                } while (ndServiceExecContext.getPendingQuestions() && (n2 == -1 || ++n < n2));
                object = ((NdDeployServiceClientContext)object2).getServiceResult(ndServiceExecContext);
                ((NdDeployServiceClientContext)object2).endInvocation(ndServiceExecContext);
            }
            catch (RuntimeException runtimeException) {
                NdServiceSessionException ndServiceSessionException = new NdServiceSessionException(ndServiceExecContext, (Throwable)runtimeException);
                this.notifyServiceException(ndService, ndServiceSessionException);
                ndService.abortServiceSession(ndServiceSessionId);
                throw ndServiceSessionException;
            }
            try {
                ndService.terminateServiceSession(ndServiceSessionId);
            }
            catch (RuntimeException runtimeException) {
                NdServiceSessionException ndServiceSessionException = new NdServiceSessionException(ndServiceExecContext, (Throwable)runtimeException);
                this.notifyServiceException(ndService, ndServiceSessionException);
                throw ndServiceSessionException;
            }
        }
        NdLocalServerException ndLocalServerException = ndService == null ? new NdLocalServerException(this.getServerId(), NdStrings.SiPpjKN("InvokeOnNullService")) : new NdLocalServerException(this.getServerId(), NdStrings.SiPpjMP("ServiceNotManageable", ndService.getServiceId().getServiceName()));
        this.notifyException((Throwable)((Object)ndLocalServerException));
        throw ndLocalServerException;
        return object;
    }

    public Object invokeService(NdService ndService, String string, String string2, Object[] objectArray, NdClassLoadingContext ndClassLoadingContext) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        Object object;
        try {
            object = this.SiPsoKE(ndService, string, string2, objectArray, ndClassLoadingContext);
        }
        catch (RuntimeException runtimeException) {
            NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), (Throwable)runtimeException);
            this.notifyServiceException(ndService, ndServiceException);
            throw ndServiceException;
        }
        return object;
    }

    public Object invokeService(NdService ndService, String string, String string2, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        Object object;
        try {
            object = this.SiPsoKE(ndService, string, string2, objectArray, null);
        }
        catch (RuntimeException runtimeException) {
            NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), (Throwable)runtimeException);
            this.notifyServiceException(ndService, ndServiceException);
            throw ndServiceException;
        }
        return object;
    }

    public Object invokeService(NdService ndService, String string, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        Object object;
        try {
            object = this.SiPsoKE(ndService, null, string, objectArray, null);
        }
        catch (RuntimeException runtimeException) {
            NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), (Throwable)runtimeException);
            this.notifyServiceException(ndService, ndServiceException);
            throw ndServiceException;
        }
        return object;
    }

    public Object invokeService(NdService ndService, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeService(ndService, null, objectArray);
    }

    public Object invokeService(String string, String string2, String string3, Object[] objectArray, NdClassLoadingContext ndClassLoadingContext) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        NdService ndService = this.getExistingService(string);
        Object object = this.invokeService(ndService, string2, string3, objectArray, ndClassLoadingContext);
        return object;
    }

    public Object invokeService(String string, String string2, String string3, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        NdService ndService = this.getExistingService(string);
        Object object = this.invokeService(ndService, string2, string3, objectArray);
        return object;
    }

    public Object invokeService(String string, String string2, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        NdService ndService = this.getExistingService(string);
        Object object = this.invokeService(ndService, string2, objectArray);
        return object;
    }

    public Object invokeService(String string, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeService(string, null, objectArray);
    }

    protected NdMonitoredServer getLocalMonitoredServer() {
        return this;
    }

    protected NdMonitoredServiceManager getLocalMonitoredServiceManager() {
        return (NdMonitoredServiceManager)((Object)this.getServiceManager());
    }

    protected NdMonitoredService getLocalMonitoredService(String string) {
        return (NdMonitoredService)((Object)this.getService(string));
    }

    protected NdMonitoredServiceSessionManager getLocalMonitoredServiceSessionManager(String string) {
        return (NdMonitoredServiceSessionManager)((Object)((NdManagedService)((Object)this.getService(string))).getServiceSessionManager());
    }

    protected NdMonitoredServiceSession getLocalMonitoredServiceSession(String string, String string2) {
        return ((NdManagedService)((Object)this.getService(string))).getMonitoredServiceSession(string2);
    }

    protected NdMonitoredServiceAgent getLocalMonitoredServiceAgent(String string, String string2) {
        return ((NdManagedService)((Object)this.getService(string))).getMonitoredServiceAgent(string2);
    }

    protected NdMonitoredSystemOutStream getLocalMonitoredSystemOutStream() {
        return this;
    }

    protected NdMonitoredSystemErrStream getLocalMonitoredSystemErrStream() {
        return this;
    }

    protected NdInteractiveServiceSession getLocalInteractiveServiceSession(String string, String string2) throws NdLocalServerException {
        return ((NdManagedService)((Object)this.getService(string))).getInteractiveServiceSession(string2);
    }

    public static NdStatelessServer createStatelessServer(NdServerConfig ndServerConfig) throws NdLocalServerException {
        NdStatelessServer ndStatelessServer;
        try {
            ndStatelessServer = (NdStatelessServer)NdLocalServer.createServer(ndServerConfig);
        }
        catch (ClassCastException classCastException) {
            throw new NdLocalServerException(new NdServerId(ndServerConfig.getName()), NdStrings.SiPpjKN("CreateServerFromConfigFailed"), classCastException);
        }
        return ndStatelessServer;
    }

    public static NdStatelessServer createStatelessServer(String string) throws NdLocalServerException {
        return NdStatelessServer.createStatelessServer(string, null);
    }

    public static NdStatelessServer createStatelessServer(String string, Object[] objectArray) throws NdLocalServerException {
        NdStatelessServer ndStatelessServer;
        try {
            ndStatelessServer = (NdStatelessServer)NdLocalServer.createServer(string, objectArray);
        }
        catch (ClassCastException classCastException) {
            throw new NdLocalServerException(new NdServerId(string), NdStrings.SiPpjKN("CreateServerFromConfigFileNameFailed"), classCastException);
        }
        return ndStatelessServer;
    }

    public static NdStatelessServer createStatelessServer(StringBuffer stringBuffer, Object[] objectArray) throws NdLocalServerException {
        NdStatelessServer ndStatelessServer;
        try {
            ndStatelessServer = (NdStatelessServer)NdLocalServer.createServer(stringBuffer, objectArray);
        }
        catch (ClassCastException classCastException) {
            throw new NdLocalServerException(new NdServerId(stringBuffer.toString()), NdStrings.SiPpjKN("CreateServerFromConfigBufferFailed"), classCastException);
        }
        return ndStatelessServer;
    }

    public static NdStatelessServer createStatelessServer() throws NdLocalServerException {
        NdStatelessServer ndStatelessServer;
        try {
            ndStatelessServer = (NdStatelessServer)NdLocalServer.createServer();
        }
        catch (ClassCastException classCastException) {
            NdServerId ndServerId = new NdServerId(NdStrings.SiPpjKN("Unknown"));
            throw new NdLocalServerException(ndServerId, NdStrings.SiPpjKN("CreateServerFromDefaultConfigFailed"), classCastException);
        }
        return ndStatelessServer;
    }
}

