/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy;

import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdMonitoredServer;
import com.blazesoft.server.base.NdMonitoredService;
import com.blazesoft.server.base.NdMonitoredServiceManager;
import com.blazesoft.server.base.NdMonitoredServiceSessionManager;
import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.deploy.NdStrings;
import com.blazesoft.server.local.NdLocalServer;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.system.NdMonitoredSystemErrStream;
import com.blazesoft.system.NdMonitoredSystemOutStream;

public class NdSynchronousStatefulServer
extends NdLocalServer {
    public NdSynchronousStatefulServer(NdServerConfig ndServerConfig) throws NdLocalServerException {
        this();
        this.configure(ndServerConfig);
    }

    protected NdSynchronousStatefulServer() throws NdLocalServerException {
    }

    protected NdMonitoredServer getLocalMonitoredServer() {
        return this;
    }

    protected NdMonitoredServiceManager getLocalMonitoredServiceManager() {
        return (NdMonitoredServiceManager)((Object)this.getServiceManager());
    }

    protected NdMonitoredService getLocalMonitoredService(String string) {
        return (NdMonitoredService)((Object)this.getService(string));
    }

    protected NdMonitoredServiceSessionManager getLocalMonitoredServiceSessionManager(String string) {
        return (NdMonitoredServiceSessionManager)((Object)((NdManagedService)((Object)this.getService(string))).getServiceSessionManager());
    }

    protected NdMonitoredSystemOutStream getLocalMonitoredSystemOutStream() {
        return this;
    }

    protected NdMonitoredSystemErrStream getLocalMonitoredSystemErrStream() {
        return this;
    }

    public static NdSynchronousStatefulServer createSynchronousStatefulServer(NdServerConfig ndServerConfig) throws NdLocalServerException {
        NdSynchronousStatefulServer ndSynchronousStatefulServer;
        try {
            ndSynchronousStatefulServer = (NdSynchronousStatefulServer)NdLocalServer.createServer(ndServerConfig);
        }
        catch (ClassCastException classCastException) {
            throw new NdLocalServerException(new NdServerId(ndServerConfig.getName()), NdStrings.SiPpjKN("CreateServerFromConfigFailed"), classCastException);
        }
        return ndSynchronousStatefulServer;
    }

    public static NdSynchronousStatefulServer createSynchronousStatefulServer(String string) throws NdLocalServerException {
        return NdSynchronousStatefulServer.createSynchronousStatefulServer(string, null);
    }

    public static NdSynchronousStatefulServer createSynchronousStatefulServer(String string, Object[] objectArray) throws NdLocalServerException {
        NdSynchronousStatefulServer ndSynchronousStatefulServer;
        try {
            ndSynchronousStatefulServer = (NdSynchronousStatefulServer)NdLocalServer.createServer(string, objectArray);
        }
        catch (ClassCastException classCastException) {
            throw new NdLocalServerException(new NdServerId(string), NdStrings.SiPpjKN("CreateServerFromConfigFileNameFailed"), classCastException);
        }
        return ndSynchronousStatefulServer;
    }

    public static NdSynchronousStatefulServer createSynchronousStatefulServer() throws NdLocalServerException {
        NdSynchronousStatefulServer ndSynchronousStatefulServer;
        try {
            ndSynchronousStatefulServer = (NdSynchronousStatefulServer)NdLocalServer.createServer();
        }
        catch (ClassCastException classCastException) {
            NdServerId ndServerId = new NdServerId(NdStrings.SiPpjKN("Unknown"));
            throw new NdLocalServerException(ndServerId, NdStrings.SiPpjKN("CreateServerFromDefaultConfigFailed"), classCastException);
        }
        return ndSynchronousStatefulServer;
    }
}

