/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.ejb;

import com.blazesoft.objects.ejb.NdEJBLib;
import com.blazesoft.objects.java2.NdDefaultClassLoadingContext;
import com.blazesoft.server.base.NdServer;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.config.NdServerConfigFactory;
import com.blazesoft.server.config.NdServerConfigLoader;
import com.blazesoft.server.config.NdServiceConfig;
import com.blazesoft.server.deploy.NdDefaultServerDeploymentContext;
import com.blazesoft.server.deploy.NdServerDeploymentContext;
import com.blazesoft.server.deploy.ejb.NdStrings;
import com.blazesoft.server.local.NdInvalidServerConfigurationException;
import com.blazesoft.server.local.NdURLServerConfigFactory;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class NdEjbServerDeploymentUtil {
    public static final String EJB_ENVIRONMENT_CONTEXT_NAME = "java:comp/env";

    public static Object getEnvPropertyValue(Context context, EJBContext eJBContext, String string) throws NamingException {
        Object object;
        if (NdEJBLib.isEJB11SupportEnabled()) {
            if (NdBaseObject.areEqual(context.getEnvironment().get("java.naming.factory.initial"), (Object)"jrun.naming.JRunContextFactory")) {
                Context context2 = (Context)context.lookup(EJB_ENVIRONMENT_CONTEXT_NAME);
                object = (String)context2.lookup(string);
            } else if (NdBaseObject.areEqual(context.getEnvironment().get("java.naming.factory.initial"), (Object)"org.jnp.interfaces.NamingContextFactory")) {
                Context context3 = (Context)context.lookup(EJB_ENVIRONMENT_CONTEXT_NAME);
                object = context3.lookup(string);
            } else {
                Name name = new CompositeName(EJB_ENVIRONMENT_CONTEXT_NAME).add(string);
                object = context.lookup(name);
            }
        } else {
            Properties properties;
            try {
                properties = eJBContext.getEnvironment();
            }
            catch (RuntimeException runtimeException) {
                throw new NdWrappedRuntimeException(NdStrings.SiPrAZX("FailedToRetrieveEnvironment"), (Throwable)runtimeException);
            }
            object = ((Hashtable)properties).get(string);
            if (object == null) {
                throw new NameNotFoundException(NdStrings.SiPrAZZ("CoundNotFindEnvironmentProperty", string));
            }
        }
        return object;
    }

    public static boolean getUseClassLoadingContext(Context context, EJBContext eJBContext) {
        String string;
        try {
            string = (String)NdEjbServerDeploymentUtil.getEnvPropertyValue(context, eJBContext, "ndconfig.useClassLoadingContext");
        }
        catch (NamingException namingException) {
            string = null;
        }
        Boolean bl = string != null ? Boolean.valueOf(string) : Boolean.TRUE;
        return bl;
    }

    public static NdServerDeploymentContext createServerDeploymentContext(Context context, EJBContext eJBContext, String string) throws RemoteException {
        return NdEjbServerDeploymentUtil.createServerDeploymentContext(context, eJBContext, string, null);
    }

    public static NdServerDeploymentContext createServerDeploymentContext(Context context, EJBContext eJBContext, String string, NdClassLoadingContext ndClassLoadingContext) throws RemoteException {
        SiPrBtV siPrBtV;
        NdServerConfigFactory ndServerConfigFactory;
        Serializable serializable;
        String string2 = null;
        String string3 = null;
        try {
            string2 = (String)NdEjbServerDeploymentUtil.getEnvPropertyValue(context, eJBContext, NdServerConfigLoader.DEF_SERVER_CONFIG_FILE_NAME_TAG);
        }
        catch (NamingException namingException) {
            try {
                string3 = (String)NdEjbServerDeploymentUtil.getEnvPropertyValue(context, eJBContext, NdServerConfigLoader.DEF_SERVER_CONFIG_FACTORY_CLASS_NAME_TAG);
            }
            catch (NamingException namingException2) {
                Exception exception = NdEJBLib.newEJBSystemException((String)NdStrings.SiPrBaA("CouldNotFindServerConfigEnvironmentProps", NdServerConfigLoader.DEF_SERVER_CONFIG_FILE_NAME_TAG, NdServerConfigLoader.DEF_SERVER_CONFIG_FACTORY_CLASS_NAME_TAG), (Exception)namingException2);
                if (NdEJBLib.isEJB11SupportEnabled()) {
                    throw (RuntimeException)exception;
                }
                throw (RemoteException)exception;
            }
        }
        if (string3 != null) {
            Object t;
            try {
                serializable = NdDefaultClassLoadingContext.classForName((NdClassLoadingContext)ndClassLoadingContext, (String)string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exception exception = NdEJBLib.newEJBSystemException((String)NdStrings.SiPrAZZ("CouldNotFindServerConfigFactoryClass", string3));
                if (NdEJBLib.isEJB11SupportEnabled()) {
                    throw (RuntimeException)exception;
                }
                throw (RemoteException)exception;
            }
            try {
                t = serializable.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                Exception exception = NdEJBLib.newEJBSystemException((String)NdStrings.SiPrAZZ("CouldNotInstantiateServerConfigFactoryClass", string3), (Exception)illegalAccessException);
                if (NdEJBLib.isEJB11SupportEnabled()) {
                    throw (RuntimeException)exception;
                }
                throw (RemoteException)exception;
            }
            catch (InstantiationException instantiationException) {
                Exception exception = NdEJBLib.newEJBSystemException((String)NdStrings.SiPrAZZ("CouldNotInstantiateServerConfigFactoryClass", string3), (Exception)instantiationException);
                if (NdEJBLib.isEJB11SupportEnabled()) {
                    throw (RuntimeException)exception;
                }
                throw (RemoteException)exception;
            }
            catch (SecurityException securityException) {
                Exception exception = NdEJBLib.newEJBSystemException((String)NdStrings.SiPrAZZ("CouldNotInstantiateServerConfigFactoryClass", string3), (Exception)securityException);
                if (NdEJBLib.isEJB11SupportEnabled()) {
                    throw (RuntimeException)exception;
                }
                throw (RemoteException)exception;
            }
            if (!(t instanceof NdServerConfigFactory)) {
                Exception exception = NdEJBLib.newEJBSystemException((String)(NdStrings.SiPrAZX("FailedToConfigureServer") + "\n" + NdStrings.SiPrAZZ("ConfigFactoryWrongType", string3)));
                if (NdEJBLib.isEJB11SupportEnabled()) {
                    throw (RuntimeException)exception;
                }
                throw (RemoteException)exception;
            }
            ndServerConfigFactory = (NdServerConfigFactory)t;
            siPrBtV = new SiPrBtV(string3, string);
        } else {
            ndServerConfigFactory = new NdURLServerConfigFactory(string2);
            siPrBtV = new SiPrBtV(string2, string);
        }
        serializable = new NdDefaultServerDeploymentContext(siPrBtV, ndServerConfigFactory, ndClassLoadingContext);
        return serializable;
    }

    public static void validateServerConfiguration(NdServer ndServer, NdServerConfig ndServerConfig, boolean bl) throws NdInvalidServerConfigurationException {
        if (bl) {
            NdServiceConfig[] ndServiceConfigArray = ndServerConfig.getServiceConfig();
            for (int i = 0; i < ndServiceConfigArray.length; ++i) {
                ndServiceConfigArray[i].useDeploymentClassLoadingContextDefault(true);
            }
        }
    }

    public static NdClassLoadingContext createClassLoadingContext(Class clazz) {
        NdDefaultClassLoadingContext ndDefaultClassLoadingContext = new NdDefaultClassLoadingContext(Thread.currentThread(), clazz.getClassLoader());
        return ndDefaultClassLoadingContext;
    }

    private static class SiPrBtV
    implements Serializable {
        private String SiPrBtT;
        private String SiPrBtU;

        SiPrBtV(String string, String string2) {
            this.SiPrBtT = string;
            this.SiPrBtU = string2;
        }

        public int hashCode() {
            return this.SiPrBtT.hashCode() / 2 + this.SiPrBtU.hashCode() / 2;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof SiPrBtV) {
                SiPrBtV siPrBtV = (SiPrBtV)object;
                if (this.SiPrBtT.equals(siPrBtV.SiPrBtT) && this.SiPrBtU.equals(siPrBtV.SiPrBtU)) {
                    bl = true;
                }
            }
            return bl;
        }

        public String toString() {
            return NdStrings.SiPrBaA("ServerConfigOfClass", this.SiPrBtT, this.SiPrBtU);
        }
    }
}

