/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.ejb.session;

import com.blazesoft.objects.ejb.NdEJBLib;
import com.blazesoft.server.base.NdInteractiveServiceSession;
import com.blazesoft.server.base.NdMonitoredServer;
import com.blazesoft.server.base.NdMonitoredService;
import com.blazesoft.server.base.NdMonitoredServiceAgent;
import com.blazesoft.server.base.NdMonitoredServiceManager;
import com.blazesoft.server.base.NdMonitoredServiceSession;
import com.blazesoft.server.base.NdMonitoredServiceSessionManager;
import com.blazesoft.server.base.NdPersistableServiceSession;
import com.blazesoft.server.base.NdServer;
import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.base.NdServerRuntimeException;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceQuestionsEvent;
import com.blazesoft.server.base.NdServiceSessionId;
import com.blazesoft.server.deploy.NdManagedComponent;
import com.blazesoft.server.deploy.NdServerDeploymentContext;
import com.blazesoft.server.deploy.NdServerDeploymentUtil;
import com.blazesoft.server.deploy.NdServiceSessionDeployment;
import com.blazesoft.server.deploy.ejb.NdEjbServerDeploymentUtil;
import com.blazesoft.server.deploy.ejb.NdWrappedEJBException;
import com.blazesoft.server.deploy.ejb.session.NdEjbServiceSession;
import com.blazesoft.server.deploy.ejb.session.NdStrings;
import com.blazesoft.server.deploy.ejb.session.NdSynchronousStatefulEjbServer;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.system.NdMonitoredSystemErrStream;
import com.blazesoft.system.NdMonitoredSystemOutStream;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.WjHzFYN;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class NdEjbServiceSessionBeanBase
extends NdManagedComponent {
    public static final String DEF_SERVICE_NAME_PROPERTY = "ndservice.name";
    public static final String DEF_CLIENT_CONTEXT_ID_PROPERTY = "ndserviceSession.clientContextId";
    private transient Boolean SiPRlhY;
    private NdClassLoadingContext SiPRliZ;
    public Object serviceSession;
    public Context jndiContext;
    public SessionContext ejbSessionContext;

    protected NdServiceSessionDeployment getServiceSessionDeployment() throws IllegalStateException {
        NdServiceSessionDeployment ndServiceSessionDeployment = null;
        if (this.serviceSession != null) {
            ndServiceSessionDeployment = ((NdEjbServiceSession)this.serviceSession).getServiceSessionDeployment();
        }
        if (ndServiceSessionDeployment == null) {
            throw new IllegalStateException(NdStrings.SiPpjaU("ServiceSessionHasBeenRemoved"));
        }
        return ndServiceSessionDeployment;
    }

    protected NdSynchronousStatefulEjbServer getServerDeployment() throws IllegalStateException {
        NdServiceSessionDeployment ndServiceSessionDeployment = this.getServiceSessionDeployment();
        NdSynchronousStatefulEjbServer ndSynchronousStatefulEjbServer = (NdSynchronousStatefulEjbServer)ndServiceSessionDeployment.getServer();
        return ndSynchronousStatefulEjbServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.removed();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPRljA() throws NdServerException {
        if (this.serviceSession != null) {
            try {
                ((NdEjbServiceSession)this.serviceSession).destroySession();
                Object var2_1 = null;
                this.serviceSession = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.serviceSession = null;
                throw throwable;
            }
        }
    }

    protected void removed() {
        try {
            this.SiPRljA();
        }
        catch (NdServerException ndServerException) {
            throw new NdServerRuntimeException((Throwable)((Object)ndServerException));
        }
    }

    protected void activate() {
        NdServiceSessionDeployment ndServiceSessionDeployment = this.getServiceSessionDeployment();
        try {
            ndServiceSessionDeployment.activateSession();
        }
        catch (NdServerException ndServerException) {
            throw new NdServerRuntimeException((Throwable)((Object)ndServerException));
        }
    }

    protected void deactivate() {
        NdServiceSessionDeployment ndServiceSessionDeployment = this.getServiceSessionDeployment();
        try {
            ndServiceSessionDeployment.passivateSession();
        }
        catch (NdServerException ndServerException) {
            throw new NdServerRuntimeException((Throwable)((Object)ndServerException));
        }
    }

    protected Context createInitialContext() throws NamingException {
        return new InitialContext();
    }

    protected NdServerDeploymentContext createServerDeploymentContext() throws EJBException {
        NdServerDeploymentContext ndServerDeploymentContext;
        if (this.getUseClassLoadingContext()) {
            this.SiPRliZ = NdEjbServerDeploymentUtil.createClassLoadingContext(this.getClass());
        }
        try {
            ndServerDeploymentContext = NdEjbServerDeploymentUtil.createServerDeploymentContext(this.jndiContext, (EJBContext)this.ejbSessionContext, this.getClass().getName(), this.SiPRliZ);
        }
        catch (RemoteException remoteException) {
            throw new NdWrappedEJBException(remoteException);
        }
        return ndServerDeploymentContext;
    }

    protected NdSynchronousStatefulEjbServer createServerDeployment(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
        NdSynchronousStatefulEjbServer ndSynchronousStatefulEjbServer = new NdSynchronousStatefulEjbServer(ndServerDeploymentContext, this.getUseClassLoadingContext());
        return ndSynchronousStatefulEjbServer;
    }

    protected String getDeploymentServiceName() throws EJBException {
        String string;
        try {
            string = (String)NdEjbServerDeploymentUtil.getEnvPropertyValue(this.jndiContext, (EJBContext)this.ejbSessionContext, DEF_SERVICE_NAME_PROPERTY);
        }
        catch (NamingException namingException) {
            throw new NdWrappedEJBException(namingException);
        }
        catch (EJBException eJBException) {
            throw eJBException;
        }
        catch (RuntimeException runtimeException) {
            throw new NdWrappedEJBException(runtimeException);
        }
        return string;
    }

    protected abstract String getDeploymentClientContextId() throws EJBException;

    protected boolean getUseClassLoadingContext() throws EJBException {
        if (this.SiPRlhY == null) {
            try {
                this.SiPRlhY = new Boolean(NdEjbServerDeploymentUtil.getUseClassLoadingContext(this.jndiContext, (EJBContext)this.ejbSessionContext));
            }
            catch (RuntimeException runtimeException) {
                throw new NdWrappedEJBException(runtimeException);
            }
        }
        return this.SiPRlhY;
    }

    private NdSynchronousStatefulEjbServer SiPRljB() throws EJBException {
        NdSynchronousStatefulEjbServer ndSynchronousStatefulEjbServer;
        NdServerDeploymentContext ndServerDeploymentContext;
        try {
            ndServerDeploymentContext = this.createServerDeploymentContext();
        }
        catch (RuntimeException runtimeException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServerDeploymentContext"), (Exception)runtimeException));
        }
        try {
            ndSynchronousStatefulEjbServer = this.createServerDeployment(ndServerDeploymentContext);
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServerFromDeploymentContext"), (Exception)((Object)ndLocalServerException)));
        }
        catch (RuntimeException runtimeException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServerFromDeploymentContext"), (Exception)runtimeException));
        }
        try {
            ndSynchronousStatefulEjbServer.initialize();
        }
        catch (NdLocalServerException ndLocalServerException) {
            String string = NdStrings.SiPpjaU("FailedToInitializeServer");
            try {
                ndSynchronousStatefulEjbServer.shutdownDeployment();
            }
            catch (NdServerException ndServerException) {
                string = string + "\n" + NdStrings.SiPpjaU("FailedToRemoveServerReference") + ((Throwable)((Object)ndServerException)).toString();
            }
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)string, (Exception)((Object)ndLocalServerException)));
        }
        catch (RuntimeException runtimeException) {
            String string = NdStrings.SiPpjaU("FailedToInitializeServer");
            try {
                ndSynchronousStatefulEjbServer.shutdownDeployment();
            }
            catch (NdServerException ndServerException) {
                string = string + "\n" + NdStrings.SiPpjaU("FailedToRemoveServerReference") + ((Throwable)((Object)ndServerException)).toString();
            }
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)string, (Exception)runtimeException));
        }
        return ndSynchronousStatefulEjbServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create() throws EJBException {
        NdSynchronousStatefulEjbServer ndSynchronousStatefulEjbServer = this.SiPRljB();
        try {
            if (this.getUseClassLoadingContext()) {
                this.SiPRliZ = NdEjbServerDeploymentUtil.createClassLoadingContext(this.getClass());
            }
            ndSynchronousStatefulEjbServer.setServiceClassLoadingContext(this.getDeploymentServiceName(), this.SiPRliZ);
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToInitializeClassLoadingContext"), (Exception)((Object)ndLocalServerException)));
        }
        catch (RuntimeException runtimeException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToInitializeClassLoadingContext"), (Exception)runtimeException));
        }
        try {
            try {
                this.serviceSession = ndSynchronousStatefulEjbServer.createSession(this.getDeploymentServiceName(), this.getDeploymentClientContextId(), this.SiPRliZ);
            }
            catch (NdLocalServerException ndLocalServerException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServiceSession"), (Exception)((Object)ndLocalServerException)));
            }
            catch (NdServiceException ndServiceException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServiceSession"), (Exception)((Object)ndServiceException)));
            }
            catch (RuntimeException runtimeException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServiceSession"), (Exception)runtimeException));
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {
                ndSynchronousStatefulEjbServer.shutdownDeployment();
            }
            catch (NdServerException ndServerException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToRemoveServerReference"), (Exception)((Object)ndServerException)));
            }
            throw throwable;
        }
        try {
            ndSynchronousStatefulEjbServer.shutdownDeployment();
        }
        catch (NdServerException ndServerException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToRemoveServerReference"), (Exception)((Object)ndServerException)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(byte[] byArray) throws EJBException {
        NdSynchronousStatefulEjbServer ndSynchronousStatefulEjbServer = this.SiPRljB();
        try {
            if (this.getUseClassLoadingContext()) {
                this.SiPRliZ = NdEjbServerDeploymentUtil.createClassLoadingContext(this.getClass());
            }
            ndSynchronousStatefulEjbServer.setServiceClassLoadingContext(this.getDeploymentServiceName(), this.SiPRliZ);
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToInitializeClassLoadingContext"), (Exception)((Object)ndLocalServerException)));
        }
        catch (RuntimeException runtimeException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToInitializeClassLoadingContext"), (Exception)runtimeException));
        }
        try {
            try {
                NdEjbServiceSession ndEjbServiceSession = ndSynchronousStatefulEjbServer.loadSession(this.getDeploymentServiceName(), byArray, this.getDeploymentClientContextId(), this.SiPRliZ);
                ndEjbServiceSession.getServiceSessionDeployment().activateSession();
                this.serviceSession = ndEjbServiceSession;
            }
            catch (NdLocalServerException ndLocalServerException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServiceSession"), (Exception)((Object)ndLocalServerException)));
            }
            catch (NdServiceException ndServiceException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServiceSession"), (Exception)((Object)ndServiceException)));
            }
            catch (RuntimeException runtimeException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToCreateServiceSession"), (Exception)runtimeException));
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                ndSynchronousStatefulEjbServer.shutdownDeployment();
            }
            catch (NdServerException ndServerException) {
                throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToRemoveServerReference"), (Exception)((Object)ndServerException)));
            }
            throw throwable;
        }
        try {
            ndSynchronousStatefulEjbServer.shutdownDeployment();
        }
        catch (NdServerException ndServerException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToRemoveServerReference"), (Exception)((Object)ndServerException)));
        }
    }

    protected void destroy() {
        try {
            try {
                NdServiceSessionDeployment ndServiceSessionDeployment = this.getServiceSessionDeployment();
                ndServiceSessionDeployment.terminateSession();
            }
            catch (NdServerException ndServerException) {
                throw new NdWrappedEJBException((Exception)((Object)ndServerException));
            }
            catch (RuntimeException runtimeException) {
                throw new NdWrappedEJBException(runtimeException);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.SiPRljC();
            throw throwable;
        }
        this.SiPRljC();
    }

    private void SiPRljC() throws EJBException {
        try {
            this.removed();
        }
        catch (RuntimeException runtimeException) {
            throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)NdStrings.SiPpjaU("FailedToRemove"), (Exception)runtimeException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPRljD() throws EJBException {
        try {
            try {
                this.invalidateTxContext();
            }
            catch (RuntimeException runtimeException) {
                throw new NdWrappedEJBException(runtimeException);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.SiPRljC();
            throw throwable;
        }
        this.SiPRljC();
    }

    protected NdMonitoredServer getLocalMonitoredServer() throws NdLocalServerException {
        return this.getServerDeployment().getLocalMonitoredServer();
    }

    protected NdMonitoredServiceManager getLocalMonitoredServiceManager() throws NdLocalServerException {
        return this.getServerDeployment().getLocalMonitoredServiceManager();
    }

    protected NdMonitoredService getLocalMonitoredService() throws NdLocalServerException {
        return this.getServerDeployment().getLocalMonitoredService(this.getServiceSessionDeployment().getService().getServiceId().getServiceName());
    }

    protected NdMonitoredServiceSessionManager getLocalMonitoredServiceSessionManager() throws NdLocalServerException {
        return this.getServerDeployment().getLocalMonitoredServiceSessionManager(this.getServiceSessionDeployment().getService().getServiceId().getServiceName());
    }

    protected NdInteractiveServiceSession getLocalInteractiveServiceSession() throws NdLocalServerException {
        return this.getServiceSessionDeployment();
    }

    protected NdInteractiveServiceSession getInteractiveServiceSession() throws EJBException {
        try {
            return this.getServiceSessionDeployment();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
    }

    protected NdMonitoredServiceSession getLocalMonitoredServiceSession() {
        return this.getServiceSessionDeployment();
    }

    protected NdMonitoredServiceAgent getLocalMonitoredServiceAgent() {
        return this.getServiceSessionDeployment();
    }

    protected NdMonitoredSystemOutStream getLocalMonitoredSystemOutStream() throws NdLocalServerException {
        return this.getServerDeployment().getLocalMonitoredSystemOutStream();
    }

    protected NdMonitoredSystemErrStream getLocalMonitoredSystemErrStream() throws NdLocalServerException {
        return this.getServerDeployment().getLocalMonitoredSystemErrStream();
    }

    protected NdServiceSessionId getInternalSessionId() throws EJBException {
        NdServiceSessionId ndServiceSessionId;
        try {
            ndServiceSessionId = this.getServiceSessionDeployment().getInternalSessionId();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return ndServiceSessionId;
    }

    protected String getPersistentSessionId() throws EJBException {
        String string;
        try {
            string = this.getServiceSessionDeployment().getPersistentSessionId();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return string;
    }

    protected String getSessionId() throws EJBException {
        String string;
        try {
            string = this.getServiceSessionDeployment().getSessionId();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return string;
    }

    protected String getClientContextId() throws EJBException {
        String string;
        try {
            string = this.getServiceSessionDeployment().getClientContextId();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return string;
    }

    protected NdServer getServer() throws EJBException {
        NdServer ndServer;
        try {
            ndServer = this.getServiceSessionDeployment().getServer();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return ndServer;
    }

    protected NdService getService() throws EJBException {
        NdService ndService;
        try {
            ndService = this.getServiceSessionDeployment().getService();
        }
        catch (NdLocalServerException ndLocalServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndLocalServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return ndService;
    }

    protected String getDescription() throws EJBException {
        String string;
        try {
            string = this.getServiceSessionDeployment().getDescription();
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return string;
    }

    protected Object invokeSession(String string, Object[] objectArray) throws EJBException {
        Object object;
        try {
            object = this.getServiceSessionDeployment().invokeSession(string, objectArray);
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return object;
    }

    protected Object invokeSession(Object[] objectArray) throws EJBException {
        Object object;
        try {
            object = this.getServiceSessionDeployment().invokeSession(objectArray);
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return object;
    }

    protected Object invokeSessionWithAnswers(String string, Object[] objectArray, NdServiceQuestionsEvent[] ndServiceQuestionsEventArray) throws EJBException {
        Object object;
        try {
            object = this.getServiceSessionDeployment().invokeSessionWithAnswers(string, objectArray, ndServiceQuestionsEventArray);
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return object;
    }

    protected Object invokeSessionWithAnswers(Object[] objectArray, NdServiceQuestionsEvent[] ndServiceQuestionsEventArray) throws EJBException {
        Object object;
        try {
            object = this.getServiceSessionDeployment().invokeSessionWithAnswers(objectArray, ndServiceQuestionsEventArray);
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return object;
    }

    public boolean hasPendingQuestions() throws EJBException {
        boolean bl;
        try {
            bl = this.getServiceSessionDeployment().hasPendingQuestions();
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return bl;
    }

    public NdServiceQuestionsEvent[] getPendingQuestions() throws EJBException {
        NdServiceQuestionsEvent[] ndServiceQuestionsEventArray;
        try {
            ndServiceQuestionsEventArray = this.getServiceSessionDeployment().getPendingQuestions();
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return ndServiceQuestionsEventArray;
    }

    protected byte[] getSessionState() throws EJBException {
        byte[] byArray;
        try {
            NdServiceSessionDeployment ndServiceSessionDeployment = this.getServiceSessionDeployment();
            boolean bl = NdServerDeploymentUtil.passivateSession(ndServiceSessionDeployment);
            byArray = WjHzFYN.WjHzWbN((Object)ndServiceSessionDeployment);
            if (bl) {
                NdServerDeploymentUtil.activateSession(ndServiceSessionDeployment);
            }
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (IOException iOException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSessionState(byte[] byArray) throws EJBException {
        NdEjbServiceSession ndEjbServiceSession;
        try {
            this.SiPRljA();
        }
        catch (NdServerException ndServerException) {
            this.invalidateTxContext();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.invalidateTxContext();
            throw new NdWrappedEJBException(runtimeException);
        }
        if (this.getUseClassLoadingContext()) {
            this.SiPRliZ = NdEjbServerDeploymentUtil.createClassLoadingContext(this.getClass());
        }
        try {
            NdSynchronousStatefulEjbServer ndSynchronousStatefulEjbServer = this.getServerDeployment();
            ndEjbServiceSession = ndSynchronousStatefulEjbServer.loadSession(this.getDeploymentServiceName(), byArray, this.getDeploymentClientContextId(), this.SiPRliZ);
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (EJBException eJBException) {
            this.SiPRljD();
            throw eJBException;
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        try {
            ndEjbServiceSession.getServiceSessionDeployment().activateSession();
            this.serviceSession = ndEjbServiceSession;
        }
        catch (NdServerException ndServerException) {
            try {
                try {
                    ndEjbServiceSession.destroySession();
                }
                catch (NdServerException ndServerException2) {
                    throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)((Throwable)((Object)ndServerException2)).toString(), (Exception)((Object)ndServerException)));
                }
                Object var6_13 = null;
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                this.SiPRljD();
                throw throwable;
            }
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            try {
                try {
                    ndEjbServiceSession.destroySession();
                }
                catch (NdServerException ndServerException) {
                    throw (EJBException)((Object)NdEJBLib.newEJBSystemException((String)((Throwable)((Object)ndServerException)).toString(), (Exception)runtimeException));
                }
                Object var8_16 = null;
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                this.SiPRljD();
                throw throwable;
            }
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
    }

    protected NdPersistableServiceSession cloneSession() throws EJBException {
        NdServiceSessionDeployment ndServiceSessionDeployment;
        try {
            NdServiceSessionDeployment ndServiceSessionDeployment2 = this.getServiceSessionDeployment();
            boolean bl = NdServerDeploymentUtil.passivateSession(ndServiceSessionDeployment2);
            ndServiceSessionDeployment = ndServiceSessionDeployment2.cloneSession();
            if (bl) {
                NdServerDeploymentUtil.activateSession(ndServiceSessionDeployment2);
            }
        }
        catch (NdServerException ndServerException) {
            this.SiPRljD();
            throw new NdWrappedEJBException((Exception)((Object)ndServerException));
        }
        catch (RuntimeException runtimeException) {
            this.SiPRljD();
            throw new NdWrappedEJBException(runtimeException);
        }
        return ndServiceSessionDeployment;
    }

    protected NdClassLoadingContext getClassLoadingContext() {
        return this.SiPRliZ;
    }
}

