/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.manager;

import com.blazesoft.server.config.NdDeploymentManagerConfig;
import com.blazesoft.server.config.NdDeploymentManagerConfigLoader;
import com.blazesoft.server.config.NdDeploymentManagerExceptionMonitorFactory;
import com.blazesoft.server.config.NdDeploymentManagerFactory;
import com.blazesoft.server.config.NdDeploymentManagerMgmtBeanConfig;
import com.blazesoft.server.config.NdDeploymentManagerMonitorFactory;
import com.blazesoft.server.config.NdDeploymentManagerServerManagerFactory;
import com.blazesoft.server.config.NdDeploymentManagerSupportFactory;
import com.blazesoft.server.deploy.manager.NdDeploymentEvent;
import com.blazesoft.server.deploy.manager.NdDeploymentListener;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerAsyncEventMulticaster;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerEvent;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerEventMulticaster;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerException;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerListener;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerRuntimeExceptionHandler;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServerManager;
import com.blazesoft.server.deploy.manager.NdManagedDeploymentManagerServerManager;
import com.blazesoft.server.deploy.manager.NdStrings;
import com.blazesoft.server.deploy.manager.cache.NdProjectCacheManager;
import com.blazesoft.server.deploy.manager.logging.NdDMLoggingMonitor;
import com.blazesoft.server.deploy.manager.management.NdDefaultDeploymentManagerMgmtBean;
import com.blazesoft.server.deploy.manager.management.NdDeploymentManagerMgmtBean;
import com.blazesoft.server.management.NdManagementException;
import com.blazesoft.server.management.NdMgmtBeanPublisherServer;
import com.blazesoft.server.management.config.NdDeploymentManagerMgmtBeanFactory;
import com.blazesoft.server.management.config.NdMgmtBeanPublisherServerFactory;
import com.blazesoft.system.NdAsyncExceptionMulticaster;
import com.blazesoft.system.NdAsyncNonThreadedExceptionMulticaster;
import com.blazesoft.system.NdConnectableAdapter;
import com.blazesoft.system.NdExceptionEvent;
import com.blazesoft.system.NdExceptionListener;
import com.blazesoft.system.NdExportableAdapter;
import com.blazesoft.system.NdMutexManager;
import com.blazesoft.system.NdRunnableStoppable;
import com.blazesoft.system.NdRuntimeExceptionHandler;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.NdWrappedRuntimeException;
import com.blazesoft.util.logging.NdLogManager;
import com.blazesoft.util.logging.NdLogManagerFactory;
import com.blazesoft.util.logging.NdLoggerConfig;
import java.util.Hashtable;
import java.util.Vector;

public class NdDeploymentManager
implements NdDeploymentListener {
    private NdDeploymentManagerConfig SiPpJYQ;
    private Vector SiPpMcZ;
    private Vector SiPpMdA;
    private Vector SiPpMdB;
    private Vector SiPpKaS;
    private Vector SiPpKbT;
    private Vector SiPVqKQ;
    private NdDeploymentManagerEventMulticaster SiPpKcU;
    private static final Hashtable SiPqaqP = new Hashtable();
    private NdClassLoadingContext SiPPIxO;
    private NdMgmtBeanPublisherServer SiPVqLR;
    private NdLogManager SiPVqMS;
    private NdDefaultDeploymentManagerMgmtBean SiPVqNT;
    private NdExceptionListener SiPVqOU;
    private NdRuntimeExceptionHandler SiPVqPV;
    private NdProjectCacheManager SiPNzdT;
    private final NdMutexManager SiPNzdV = new NdMutexManager();

    public NdDeploymentManager(NdDeploymentManagerConfig ndDeploymentManagerConfig) {
        this.SiPpJYQ = ndDeploymentManagerConfig;
    }

    public NdDeploymentManagerConfig getConfig() {
        return this.SiPpJYQ;
    }

    protected void configure() throws NdDeploymentManagerException {
        this.SiPpKcU = this.getConfig().getDeploymentManagerEventMulticasterFactory().newDeploymentManagerEventMulticaster();
        if (this.SiPpKcU instanceof NdRunnableStoppable) {
            ((NdRunnableStoppable)this.SiPpKcU).start();
        }
        this.SiPVqOU = (NdAsyncExceptionMulticaster)this.getConfig().getDeploymentManagerAsynExceptionMulticasterFactory().newDeploymentManagerAsyncExceptionMulticaster();
        if (this.SiPVqOU instanceof NdRunnableStoppable) {
            ((NdRunnableStoppable)this.SiPVqOU).start();
        }
        this.SiPVqPV = new NdDeploymentManagerRuntimeExceptionHandler(this, this.SiPVqOU);
        this.createDeploymentManagerMgmtBean(this.getConfig());
        this.createLogManager(this.getConfig());
        this.createDeploymentManagerServerManagers(this.getConfig());
        this.createDeploymentManagerMonitors(this.getConfig());
        this.createDeploymentManagerExceptionMonitors(this.getConfig());
        this.createDeploymentManagerSupports(this.getConfig());
        if (this.getConfig().getProjectCacheStoreFactory() != null) {
            this.SiPNzdT = new NdProjectCacheManager(this.getConfig(), this.SiPVqOU);
        }
        if (this.SiPNzdT == null && this.getConfig().isMemoryProjectCacheEnabled()) {
            this.SiPNzdT = new NdProjectCacheManager(this.getConfig(), this.SiPVqOU);
        }
        if (this.SiPNzdT != null && this.SiPVqNT != null) {
            this.SiPVqNT.publishProjectCacheManagerMgmtBean(this.SiPNzdT);
        }
        SiPqaqP.put(this.getConfig().getName(), this);
        this.SiPpKhZ(3);
    }

    protected void createDeploymentManagerServerManagers(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        try {
            NdDeploymentManagerServerManagerFactory[] ndDeploymentManagerServerManagerFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerServerManagerFactory();
            if (ndDeploymentManagerServerManagerFactoryArray != null) {
                for (int i = 0; i < ndDeploymentManagerServerManagerFactoryArray.length; ++i) {
                    NdDeploymentManagerServerManager ndDeploymentManagerServerManager = ndDeploymentManagerServerManagerFactoryArray[i].newDeploymentManagerServerManager(this);
                    if (!(ndDeploymentManagerServerManager instanceof NdManagedDeploymentManagerServerManager)) {
                        throw new NdDeploymentManagerException(NdStrings.SiPpJqD("NotManagedDMServerManager"));
                    }
                    ((NdManagedDeploymentManagerServerManager)((Object)ndDeploymentManagerServerManager)).setExceptionListener(this.SiPVqOU);
                    if (this.SiPVqNT != null) {
                        this.SiPVqNT.publishServerManagerMgmtBean(ndDeploymentManagerServerManager);
                    }
                    this.addDeploymentManagerServerManager(ndDeploymentManagerServerManager);
                    this.SiPpMdC(ndDeploymentManagerServerManager);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NdDeploymentManagerException(NdStrings.SiPpJqF("CreateDeploymentManagerServerManagerFailed", ndDeploymentManagerConfig.getName()), runtimeException);
        }
    }

    public synchronized void addDeploymentManagerServerManager(NdDeploymentManagerServerManager ndDeploymentManagerServerManager) throws NdDeploymentManagerException {
        this.SiPpKiC(ndDeploymentManagerServerManager);
        this.addDeploymentManagerListener(ndDeploymentManagerServerManager);
    }

    public synchronized NdDeploymentManagerServerManager getDeploymentManagerServerManager(String string) {
        NdDeploymentManagerServerManager ndDeploymentManagerServerManager = null;
        if (this.SiPpKbT != null) {
            for (int i = 0; i < this.SiPpKbT.size(); ++i) {
                NdDeploymentManagerServerManager ndDeploymentManagerServerManager2 = (NdDeploymentManagerServerManager)this.SiPpKbT.elementAt(i);
                if (!string.equals(ndDeploymentManagerServerManager2.getServerManagerName())) continue;
                ndDeploymentManagerServerManager = ndDeploymentManagerServerManager2;
                break;
            }
        }
        return ndDeploymentManagerServerManager;
    }

    protected void createDeploymentManagerMonitors(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        try {
            NdDeploymentManagerMonitorFactory[] ndDeploymentManagerMonitorFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerMonitorFactory();
            if (ndDeploymentManagerMonitorFactoryArray != null) {
                for (int i = 0; i < ndDeploymentManagerMonitorFactoryArray.length; ++i) {
                    NdDeploymentManagerListener ndDeploymentManagerListener = ndDeploymentManagerMonitorFactoryArray[i].newDeploymentManagerMonitor(this);
                    this.addManagedDeploymentManagerListener(ndDeploymentManagerListener);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NdDeploymentManagerException(NdStrings.SiPpJqF("CreateDeploymentManagerMonitorFailed", ndDeploymentManagerConfig.getName()), runtimeException);
        }
    }

    protected void createDeploymentManagerExceptionMonitors(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        try {
            NdDeploymentManagerExceptionMonitorFactory[] ndDeploymentManagerExceptionMonitorFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerExceptionMonitorFactory();
            if (ndDeploymentManagerExceptionMonitorFactoryArray != null) {
                for (int i = 0; i < ndDeploymentManagerExceptionMonitorFactoryArray.length; ++i) {
                    NdExceptionListener ndExceptionListener = ndDeploymentManagerExceptionMonitorFactoryArray[i].newExceptionMonitor(this);
                    this.addManagedExceptionListener(ndExceptionListener);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NdDeploymentManagerException(NdStrings.SiPpJqF("CreateDeploymentManagerMonitorFailed", ndDeploymentManagerConfig.getName()), runtimeException);
        }
    }

    protected void createDeploymentManagerSupports(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        try {
            NdDeploymentManagerSupportFactory[] ndDeploymentManagerSupportFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerSupportFactory();
            if (ndDeploymentManagerSupportFactoryArray != null) {
                for (int i = 0; i < ndDeploymentManagerSupportFactoryArray.length; ++i) {
                    Object object = ndDeploymentManagerSupportFactoryArray[i].newDeploymentManagerSupport(this);
                    if (object instanceof NdRunnableStoppable) {
                        ((NdRunnableStoppable)object).setRuntimeExceptionHandler(this.SiPVqPV);
                    }
                    this.SiPpMdC(object);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NdDeploymentManagerException(NdStrings.SiPpJqF("CreateDeploymentManagerSupportFailed", ndDeploymentManagerConfig.getName()), runtimeException);
        }
    }

    public NdDeploymentManagerServerManager[] getDeploymentManagerServerManagers() {
        Object[] objectArray = new NdDeploymentManagerServerManager[this.SiPpKbT.size()];
        this.SiPpKbT.copyInto(objectArray);
        return objectArray;
    }

    public void shutdown() throws NdDeploymentManagerException {
        this.SiPpKhZ(4);
        try {
            this.SiPpMdG();
            this.SiPpMdE();
            this.SiPpKiB();
            this.SiPVqUF();
            this.SiPpKiF();
            this.SiPpKiD();
            if (this.SiPpKcU instanceof NdRunnableStoppable) {
                ((NdDeploymentManagerAsyncEventMulticaster)this.SiPpKcU).stopRunning();
            }
        }
        catch (InterruptedException interruptedException) {
            this.notifyException(interruptedException);
            throw new NdWrappedRuntimeException((Throwable)interruptedException);
        }
        try {
            this.SiPVqSY();
            ((NdRunnableStoppable)this.SiPVqOU).stopRunning();
        }
        catch (InterruptedException interruptedException) {
            throw new NdWrappedRuntimeException((Throwable)interruptedException);
        }
        SiPqaqP.remove(this.getConfig().getName());
    }

    private void SiPrrOB(int n, Object object) {
        NdDeploymentManagerEvent ndDeploymentManagerEvent = new NdDeploymentManagerEvent(this, n, object);
        this.SiPpKcU.onDeploymentManagerEvent(ndDeploymentManagerEvent);
    }

    private void SiPpKhZ(int n) {
        this.SiPrrOB(n, null);
    }

    public void notifyDeploymentManagerEvent(int n, Object object) {
        this.SiPrrOB(n, object);
    }

    private void SiPpMdC(Object object) {
        if (object instanceof NdRunnableStoppable) {
            this.SiPpKiA((NdRunnableStoppable)object);
            ((NdRunnableStoppable)object).start();
        }
        if (object instanceof NdExportableAdapter) {
            this.SiPpMdF((NdExportableAdapter)object);
            ((NdExportableAdapter)object).export();
        }
        if (object instanceof NdConnectableAdapter) {
            this.SiPpMdD((NdConnectableAdapter)object);
            ((NdConnectableAdapter)object).connect();
        }
        if (object instanceof NdDMLoggingMonitor) {
            this.SiPVqQW((NdDMLoggingMonitor)object);
        }
    }

    private void SiPVqQW(NdDMLoggingMonitor ndDMLoggingMonitor) {
        if (this.SiPVqNT != null) {
            this.SiPVqNT.publishLoggingMonitor(ndDMLoggingMonitor);
        }
    }

    private synchronized void SiPpKiA(NdRunnableStoppable ndRunnableStoppable) {
        if (this.SiPpMcZ == null) {
            this.SiPpMcZ = new Vector();
        }
        this.SiPpMcZ.addElement(ndRunnableStoppable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpKiB() throws InterruptedException {
        Object[] objectArray = null;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            objectArray = new NdRunnableStoppable[this.SiPpMcZ != null ? this.SiPpMcZ.size() : 0];
            if (this.SiPpMcZ != null) {
                this.SiPpMcZ.copyInto(objectArray);
                this.SiPpMcZ = null;
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].stopRunning();
        }
    }

    private synchronized void SiPpMdD(NdConnectableAdapter ndConnectableAdapter) {
        if (this.SiPpMdA == null) {
            this.SiPpMdA = new Vector();
        }
        this.SiPpMdA.addElement(ndConnectableAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpMdE() {
        Object[] objectArray = null;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            objectArray = new NdConnectableAdapter[this.SiPpMdA != null ? this.SiPpMdA.size() : 0];
            if (this.SiPpMdA != null) {
                this.SiPpMdA.copyInto(objectArray);
                this.SiPpMdA = null;
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].disconnect();
        }
    }

    private synchronized void SiPpMdF(NdExportableAdapter ndExportableAdapter) {
        if (this.SiPpMdB == null) {
            this.SiPpMdB = new Vector();
        }
        this.SiPpMdB.addElement(ndExportableAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpMdG() {
        Object[] objectArray = null;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            objectArray = new NdExportableAdapter[this.SiPpMdB != null ? this.SiPpMdB.size() : 0];
            if (this.SiPpMdB != null) {
                this.SiPpMdB.copyInto(objectArray);
                this.SiPpMdB = null;
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].unexport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpKiC(NdDeploymentManagerServerManager ndDeploymentManagerServerManager) {
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpKbT == null) {
                this.SiPpKbT = new Vector();
            }
            this.SiPpKbT.addElement(ndDeploymentManagerServerManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpKiD() {
        Object[] objectArray = null;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpKbT != null) {
                objectArray = new NdDeploymentManagerServerManager[this.SiPpKbT.size()];
                this.SiPpKbT.copyInto(objectArray);
                this.SiPpKbT.removeAllElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpKiE(NdDeploymentManagerListener ndDeploymentManagerListener) {
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpKaS == null) {
                this.SiPpKaS = new Vector();
            }
            this.SiPpKaS.addElement(ndDeploymentManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPpKiF() throws NdDeploymentManagerException {
        Object[] objectArray = null;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpKaS != null) {
                objectArray = new NdDeploymentManagerListener[this.SiPpKaS.size()];
                this.SiPpKaS.copyInto(objectArray);
                this.SiPpKaS.removeAllElements();
            }
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeDeploymentManagerListener((NdDeploymentManagerListener)objectArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVqRX(NdExceptionListener ndExceptionListener) {
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPVqKQ == null) {
                this.SiPVqKQ = new Vector();
            }
            this.SiPVqKQ.addElement(ndExceptionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVqSY() throws NdDeploymentManagerException {
        Object[] objectArray = null;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPVqKQ != null) {
                objectArray = new NdExceptionListener[this.SiPVqKQ.size()];
                this.SiPVqKQ.copyInto(objectArray);
                this.SiPVqKQ.removeAllElements();
            }
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeExceptionListener((NdExceptionListener)objectArray[i]);
            }
        }
    }

    public void addDeploymentManagerListener(NdDeploymentManagerListener ndDeploymentManagerListener) throws NdDeploymentManagerException {
        this.SiPpKcU.addNdDeploymentManagerListener(ndDeploymentManagerListener);
    }

    public void removeDeploymentManagerListener(NdDeploymentManagerListener ndDeploymentManagerListener) throws NdDeploymentManagerException {
        this.SiPpKcU.removeNdDeploymentManagerListener(ndDeploymentManagerListener);
    }

    public void addManagedDeploymentManagerListener(NdDeploymentManagerListener ndDeploymentManagerListener) throws NdDeploymentManagerException {
        this.SiPpKiE(ndDeploymentManagerListener);
        this.addDeploymentManagerListener(ndDeploymentManagerListener);
        this.SiPpMdC(ndDeploymentManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedDeploymentManagerListener(NdDeploymentManagerListener ndDeploymentManagerListener) throws NdDeploymentManagerException {
        Vector vector = this.SiPpKaS;
        synchronized (vector) {
            if (this.SiPpKaS != null) {
                this.SiPpKaS.removeElement(ndDeploymentManagerListener);
            }
        }
        this.removeDeploymentManagerListener(ndDeploymentManagerListener);
        try {
            this.SiPVqUA(ndDeploymentManagerListener);
        }
        catch (InterruptedException interruptedException) {
            throw new NdDeploymentManagerException(interruptedException);
        }
    }

    public void addManagedExceptionListener(NdExceptionListener ndExceptionListener) throws NdDeploymentManagerException {
        this._addNdExceptionListener(ndExceptionListener, true);
    }

    public void addExceptionListener(NdExceptionListener ndExceptionListener) throws NdDeploymentManagerException {
        this._addNdExceptionListener(ndExceptionListener, false);
    }

    public void _addNdExceptionListener(NdExceptionListener ndExceptionListener, boolean bl) {
        if (this.SiPVqOU instanceof NdAsyncExceptionMulticaster) {
            ((NdAsyncExceptionMulticaster)this.SiPVqOU).addNdExceptionListener(ndExceptionListener);
        } else if (this.SiPVqOU instanceof NdAsyncNonThreadedExceptionMulticaster) {
            ((NdAsyncNonThreadedExceptionMulticaster)this.SiPVqOU).addNdExceptionListener(ndExceptionListener);
        }
        if (bl) {
            this.SiPVqRX(ndExceptionListener);
            this.SiPpMdC(ndExceptionListener);
        }
    }

    public void removeManagedExceptionListener(NdExceptionListener ndExceptionListener) throws NdDeploymentManagerException {
        try {
            this.SiPVqTZ(ndExceptionListener, true);
        }
        catch (InterruptedException interruptedException) {
            throw new NdDeploymentManagerException(interruptedException);
        }
    }

    public void removeExceptionListener(NdExceptionListener ndExceptionListener) throws NdDeploymentManagerException {
        try {
            this.SiPVqTZ(ndExceptionListener, false);
        }
        catch (Exception exception) {
            throw new NdDeploymentManagerException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVqTZ(NdExceptionListener ndExceptionListener, boolean bl) throws InterruptedException {
        if (this.SiPVqOU instanceof NdAsyncExceptionMulticaster) {
            ((NdAsyncExceptionMulticaster)this.SiPVqOU).removeNdExceptionListener(ndExceptionListener);
        } else if (this.SiPVqOU instanceof NdAsyncNonThreadedExceptionMulticaster) {
            ((NdAsyncNonThreadedExceptionMulticaster)this.SiPVqOU).removeNdExceptionListener(ndExceptionListener);
        }
        if (bl) {
            Vector vector = this.SiPVqKQ;
            synchronized (vector) {
                if (this.SiPVqKQ != null) {
                    this.SiPVqKQ.removeElement(ndExceptionListener);
                }
            }
            this.SiPVqUA(ndExceptionListener);
        }
    }

    private void SiPVqUA(Object object) throws InterruptedException {
        if (object instanceof NdRunnableStoppable) {
            this.SiPVqUB(object);
        }
        if (object instanceof NdExportableAdapter) {
            this.SiPVqUD(object);
        }
        if (object instanceof NdConnectableAdapter) {
            this.SiPVqUC(object);
        }
        if (object instanceof NdDMLoggingMonitor) {
            this.SiPVqUE((NdDMLoggingMonitor)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVqUB(Object object) throws InterruptedException {
        boolean bl = false;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpMcZ != null) {
                bl = this.SiPpMcZ.removeElement(object);
            }
        }
        if (bl) {
            ((NdRunnableStoppable)object).stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVqUC(Object object) throws InterruptedException {
        boolean bl = false;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpMdA != null) {
                bl = this.SiPpMdA.removeElement(object);
            }
        }
        if (bl) {
            ((NdConnectableAdapter)object).disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVqUD(Object object) throws InterruptedException {
        boolean bl = false;
        NdDeploymentManager ndDeploymentManager = this;
        synchronized (ndDeploymentManager) {
            if (this.SiPpMdB != null) {
                bl = this.SiPpMdB.removeElement(object);
            }
        }
        if (bl) {
            ((NdExportableAdapter)object).unexport();
        }
    }

    private void SiPVqUE(NdDMLoggingMonitor ndDMLoggingMonitor) {
        if (this.SiPVqNT != null) {
            this.SiPVqNT.unpublishLoggingMonitor(ndDMLoggingMonitor);
        }
    }

    public void onDeploymentEvent(NdDeploymentEvent ndDeploymentEvent) {
        if (ndDeploymentEvent.getEventType() == 0) {
            this.SiPrrOB(0, ndDeploymentEvent.getRulesSourceIds());
        }
    }

    public static NdDeploymentManagerConfig getConfig(String string) throws NdDeploymentManagerException {
        return NdDeploymentManager.getConfig(string, null);
    }

    public static NdDeploymentManagerConfig getConfig(String string, Object[] objectArray) throws NdDeploymentManagerException {
        if (string == null) {
            throw new IllegalArgumentException(NdStrings.SiPpJqD("DeploymentManagerConfigFileURLNull"));
        }
        if (string.length() < 1) {
            throw new IllegalArgumentException(NdStrings.SiPpJqD("DeploymentManagerConfigFileURLZeroLength"));
        }
        NdDeploymentManagerConfig ndDeploymentManagerConfig = NdDeploymentManagerConfigLoader.getDefaultDeploymentManagerConfigLoader().load(string);
        if (objectArray != null && ndDeploymentManagerConfig != null) {
            NdDeploymentManagerFactory ndDeploymentManagerFactory = ndDeploymentManagerConfig.getDeploymentManagerFactory();
            ndDeploymentManagerFactory.setJavaMethodArg(objectArray);
        }
        return ndDeploymentManagerConfig;
    }

    public static NdDeploymentManager createDeploymentManager(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        NdDeploymentManager ndDeploymentManager = null;
        try {
            ndDeploymentManager = (NdDeploymentManager)ndDeploymentManagerConfig.getDeploymentManagerFactory().newDeploymentManager(ndDeploymentManagerConfig);
            ndDeploymentManager.configure();
        }
        catch (RuntimeException runtimeException) {
            throw new NdDeploymentManagerException(NdStrings.SiPpJqF("CreateDeploymentManagerFromConfigFailed", ndDeploymentManagerConfig.getName()), runtimeException);
        }
        return ndDeploymentManager;
    }

    public static NdDeploymentManager createDeploymentManager(String string) throws NdDeploymentManagerException {
        return NdDeploymentManager.createDeploymentManager(string, null);
    }

    public static NdDeploymentManager createDeploymentManager(String string, Object[] objectArray) throws NdDeploymentManagerException {
        return NdDeploymentManager.createDeploymentManager(NdDeploymentManager.getConfig(string, objectArray));
    }

    public static NdDeploymentManager getDeploymentManager(String string) {
        return (NdDeploymentManager)SiPqaqP.get(string);
    }

    protected void createDeploymentManagerMgmtBean(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        NdDeploymentManagerMgmtBeanConfig ndDeploymentManagerMgmtBeanConfig = ndDeploymentManagerConfig.getDeploymentManagerMgmtBeanConfig();
        if (ndDeploymentManagerMgmtBeanConfig != null) {
            NdMgmtBeanPublisherServerFactory ndMgmtBeanPublisherServerFactory = ndDeploymentManagerMgmtBeanConfig.getPublisherServerFactory();
            try {
                this.SiPVqLR = ndMgmtBeanPublisherServerFactory.newPublisherServer();
            }
            catch (NdManagementException ndManagementException) {
                throw new NdDeploymentManagerException((Throwable)((Object)ndManagementException));
            }
            NdDeploymentManagerMgmtBeanFactory ndDeploymentManagerMgmtBeanFactory = ndDeploymentManagerMgmtBeanConfig.getDeploymentManagerMgmtBeanFactory();
            this.SiPVqNT = (NdDefaultDeploymentManagerMgmtBean)ndDeploymentManagerMgmtBeanFactory.newNdDeploymentManagerMgmtBean(this);
            this.SiPVqNT.publish();
            this.addDeploymentManagerListener(this.SiPVqNT);
            this.addExceptionListener(this.SiPVqNT);
        }
    }

    private void SiPVqUF() throws NdDeploymentManagerException {
        if (this.SiPVqLR != null) {
            this.SiPVqNT.dispose();
            this.SiPVqNT = null;
            try {
                this.SiPVqLR.shutdown();
            }
            catch (NdManagementException ndManagementException) {
                throw new NdDeploymentManagerException((Throwable)((Object)ndManagementException));
            }
        }
    }

    protected void createLogManager(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentManagerException {
        NdLogManagerFactory ndLogManagerFactory = ndDeploymentManagerConfig.getLogManagerFactory();
        if (ndLogManagerFactory == null) {
            ndLogManagerFactory = new NdLogManagerFactory();
        }
        this.SiPVqMS = ndLogManagerFactory.createLogManager();
        NdLoggerConfig[] ndLoggerConfigArray = ndDeploymentManagerConfig.getLoggerConfig();
        if (ndLoggerConfigArray != null) {
            for (int i = 0; i < ndLoggerConfigArray.length; ++i) {
                this.SiPVqMS.getLogger(ndLoggerConfigArray[i]);
            }
        }
    }

    public NdLogManager getLogManager() {
        return this.SiPVqMS;
    }

    public NdDeploymentManagerMgmtBean getDeploymentManagerMgmtBean() {
        return this.SiPVqNT;
    }

    public NdProjectCacheManager getProjectCacheManager() {
        return this.SiPNzdT;
    }

    public NdExceptionListener getExceptionListener() {
        return this.SiPVqOU;
    }

    public NdMutexManager getCompilationMutexManager() {
        return this.SiPNzdV;
    }

    public void setClassLoadingContext(NdClassLoadingContext ndClassLoadingContext) {
        this.SiPPIxO = ndClassLoadingContext;
    }

    public NdClassLoadingContext getClassLoadingContext() {
        return this.SiPPIxO;
    }

    public NdMgmtBeanPublisherServer getPublisherServer() {
        return this.SiPVqLR;
    }

    public void notifyException(Throwable throwable) {
        this.notifyException(new NdExceptionEvent(Thread.currentThread(), throwable));
    }

    public void notifyException(NdExceptionEvent ndExceptionEvent) {
        this.SiPVqOU.onException(ndExceptionEvent);
    }
}

