/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.manager.logging;

import com.blazesoft.server.deploy.manager.NdDeploymentManager;
import com.blazesoft.server.deploy.manager.logging.NdDMLoggingMonitor;
import com.blazesoft.system.NdExceptionEvent;
import com.blazesoft.system.NdExceptionListener;
import com.blazesoft.util.NdWrappedExceptionSupport;
import com.blazesoft.util.logging.NdLogLevel;
import java.util.EventObject;

public class NdDMExceptionLoggingMonitor
extends NdDMLoggingMonitor
implements NdExceptionListener {
    private boolean SiPVoeR = true;
    private boolean SiPVoeS = false;

    public NdDMExceptionLoggingMonitor(NdDeploymentManager ndDeploymentManager) {
        super(ndDeploymentManager);
    }

    protected NdLogLevel getLogLevel(EventObject eventObject) {
        return NdLogLevel.SEVERE;
    }

    protected String getLogMessage(EventObject eventObject) {
        StringBuffer stringBuffer = new StringBuffer("[" + this.getLogLevel(eventObject).getName() + "] ");
        Exception exception = (Exception)((NdExceptionEvent)eventObject).getException();
        if (this.isIncludeAllStackTraceInLogMessage()) {
            stringBuffer.append(this.SiPVoeU(exception));
        } else if (this.isIncludeStackTraceInLogMessage()) {
            stringBuffer.append(this.SiPVoeV(exception));
        } else {
            stringBuffer.append(this.SiPVoeT(exception));
        }
        return stringBuffer.toString();
    }

    private String SiPVoeT(Throwable throwable) {
        return NdWrappedExceptionSupport.getMessage((Throwable)throwable);
    }

    private String SiPVoeU(Throwable throwable) {
        return NdWrappedExceptionSupport.getAllStackTraces((Throwable)throwable);
    }

    private String SiPVoeV(Throwable throwable) {
        return NdWrappedExceptionSupport.getStackTrace((Throwable)throwable);
    }

    public void onException(NdExceptionEvent ndExceptionEvent) {
        if (this.isEventEnabled((EventObject)ndExceptionEvent)) {
            this.logEvent((EventObject)ndExceptionEvent);
        }
    }

    public boolean isIncludeStackTraceInLogMessage() {
        return this.SiPVoeR;
    }

    public void setIncludeStackTraceInLogMessage(boolean bl) {
        this.SiPVoeR = bl;
    }

    public boolean isIncludeAllStackTraceInLogMessage() {
        return this.SiPVoeS;
    }

    public void setIncludeAllStackTraceInLogMessage(boolean bl) {
        this.SiPVoeS = bl;
    }

    public String getName() {
        String string = super.getName();
        if (string == null) {
            string = "NdDMExceptionLoggingMonitor";
        }
        return string;
    }
}

