/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploygen.definitions.NdCodeGenerationOptionsWithDefaults;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentMgr;
import java.io.File;
import java.util.Arrays;

public class NdCodeGenerationOptions
extends NdDeploymentConfigDefinition {
    public static final String SERVER_CONFIG_FILE_NAME = "serverConfigFileName";
    public static final String SOURCE_PACKAGE_NAME = "sourcePackageName";
    public static final String CLASS_NAME_PREFIX = "classNamePrefix";
    public static final String DLL_NAME = "dllName";
    public static final String KEEP_GENERATED_FILES = "keepGeneratedFiles";
    public static final String USING_DEBUG_LOGGER = "usingDebugLogger";
    public static final String APP_STARTED_ON_INIT = "appStartedOnInit";
    public static final String SERVER_CONFIG_URL = "serverConfigURL";
    public static final String COBOL_PROGRAM_NAME = "cobolProgramName";
    public static final String MAX_COBOL_STRING_LENGTH = "maxCobolStringLength";
    public static final String COBOL_SUBPROGRAM_PREFIX = "cobolSubprogramPrefix";
    public static final String NESTED_COBOL = "nestedCobol";
    public static final String SPLIT_COBOL_CODE = "splitCobolCode";
    public static final String SPLIT_COBOL_CODE_BY_PROGRAM = "splitCobolCodeByProgram";
    public static final String COBOL_LINE_LIMIT = "cobolLineLimit";
    public static final String COBOL_COPYBOOK_PREFIX = "cobolCopybookPrefix";
    public static final String[] COBOL_OPTIONS = new String[]{"cobolProgramName", "maxCobolStringLength", "nestedCobol", "splitCobolCode", "splitCobolCodeByProgram", "cobolSubprogramPrefix", "cobolLineLimit", "cobolCopybookPrefix"};

    public NdCodeGenerationOptions() {
    }

    public NdCodeGenerationOptions(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdDeploymentDefinition ndDeploymentDefinition) {
        this(ndDeploymentEnvironmentMgr, ndDeploymentDefinition, null);
    }

    protected NdCodeGenerationOptions(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdDeploymentDefinition ndDeploymentDefinition, NdCodeGenerationOptions ndCodeGenerationOptions) {
        super(ndDeploymentEnvironmentMgr, ndDeploymentDefinition, ndCodeGenerationOptions);
    }

    public void copyFrom(NdConfigDefinition ndConfigDefinition) throws NdConfigurationException {
        super.copyFrom(ndConfigDefinition);
        NdCodeGenerationOptions ndCodeGenerationOptions = (NdCodeGenerationOptions)ndConfigDefinition;
        this.setServerConfigFileName(ndCodeGenerationOptions.getServerConfigFileName());
        this.setSourcePackageName(ndCodeGenerationOptions.getSourcePackageName());
        this.setClassNamePrefix(ndCodeGenerationOptions.getClassNamePrefix());
        this.setDllName(ndCodeGenerationOptions.getDllName());
        this.setKeepGeneratedFiles(ndCodeGenerationOptions.getKeepGeneratedFiles());
        this.setUsingDebugLogger(ndCodeGenerationOptions.getUsingDebugLogger());
        this.setAppStartedOnInit(ndCodeGenerationOptions.getAppStartedOnInit());
        this.setServerConfigURL(ndCodeGenerationOptions.getServerConfigURL());
        this.setCobolProgramName(ndCodeGenerationOptions.getCobolProgramName());
        this.setMaxCobolStringLength(ndCodeGenerationOptions.getMaxCobolStringLength());
        this.setCobolSubprogramPrefix(ndCodeGenerationOptions.getCobolSubprogramPrefix());
        this.setNestedCobol(ndCodeGenerationOptions.getNestedCobol());
        this.setSplitCobolCode(ndCodeGenerationOptions.getSplitCobolCode());
        this.setSplitCobolCodeByProgram(ndCodeGenerationOptions.getSplitCobolCodeByProgram());
        this.setCobolLineLimit(ndCodeGenerationOptions.getCobolLineLimit());
        this.setCobolCopybookPrefix(ndCodeGenerationOptions.getCobolCopybookPrefix());
    }

    NdCodeGenerationOptions SiPGeuV(NdDeploymentDefinition ndDeploymentDefinition, NdConfigDefaultsContext ndConfigDefaultsContext) {
        return new NdCodeGenerationOptionsWithDefaults(this.getEnvironmentMgr(), ndDeploymentDefinition, this, ndConfigDefaultsContext);
    }

    NdDeploymentDefinition SiPGeuW() {
        return (NdDeploymentDefinition)this.getParentDefinition();
    }

    public String getClassNamePrefix() {
        return this.get(CLASS_NAME_PREFIX);
    }

    public String getServerConfigFileName() {
        return this.get(SERVER_CONFIG_FILE_NAME);
    }

    public String getSourcePackageName() {
        return this.get(SOURCE_PACKAGE_NAME);
    }

    public String getDllName() {
        return this.get(DLL_NAME);
    }

    public Boolean getKeepGeneratedFiles() {
        return this.getBoolean(KEEP_GENERATED_FILES);
    }

    public Boolean getUsingDebugLogger() {
        return this.getBoolean(USING_DEBUG_LOGGER);
    }

    public Boolean getAppStartedOnInit() {
        return this.getBoolean(APP_STARTED_ON_INIT);
    }

    public String getServerConfigURL() {
        return this.get(SERVER_CONFIG_URL);
    }

    public String getCobolProgramName() {
        return this.get(COBOL_PROGRAM_NAME);
    }

    public Integer getMaxCobolStringLength() {
        return this.getInteger(MAX_COBOL_STRING_LENGTH);
    }

    public String getCobolSubprogramPrefix() {
        return this.get(COBOL_SUBPROGRAM_PREFIX);
    }

    public Boolean getNestedCobol() {
        return this.getBoolean(NESTED_COBOL);
    }

    public Boolean getSplitCobolCode() {
        return this.getBoolean(SPLIT_COBOL_CODE);
    }

    public Boolean getSplitCobolCodeByProgram() {
        return this.getBoolean(SPLIT_COBOL_CODE_BY_PROGRAM);
    }

    public Integer getCobolLineLimit() {
        return this.getInteger(COBOL_LINE_LIMIT);
    }

    public String getCobolCopybookPrefix() {
        return this.get(COBOL_COPYBOOK_PREFIX);
    }

    public void setClassNamePrefix(String string) {
        this.set(CLASS_NAME_PREFIX, string);
    }

    public void setSourcePackageName(String string) {
        this.set(SOURCE_PACKAGE_NAME, string);
    }

    public void setDllName(String string) {
        this.set(DLL_NAME, string);
    }

    public void setKeepGeneratedFiles(Boolean bl) {
        this.setBoolean(KEEP_GENERATED_FILES, bl);
    }

    public void setUsingDebugLogger(Boolean bl) {
        this.setBoolean(USING_DEBUG_LOGGER, bl);
    }

    public void setAppStartedOnInit(Boolean bl) {
        this.setBoolean(APP_STARTED_ON_INIT, bl);
    }

    public void setServerConfigURL(String string) {
        this.set(SERVER_CONFIG_URL, string);
    }

    public void setServerConfigFileName(String string) {
        this.set(SERVER_CONFIG_FILE_NAME, string);
    }

    public void setCobolProgramName(String string) {
        this.set(COBOL_PROGRAM_NAME, string);
    }

    public void setMaxCobolStringLength(Integer n) {
        this.set(MAX_COBOL_STRING_LENGTH, n == null ? null : String.valueOf(n));
    }

    public void setCobolSubprogramPrefix(String string) {
        this.set(COBOL_SUBPROGRAM_PREFIX, string);
    }

    public void setNestedCobol(Boolean bl) {
        this.set(NESTED_COBOL, bl == null ? null : bl.toString());
    }

    public void setSplitCobolCode(Boolean bl) {
        this.set(SPLIT_COBOL_CODE, bl == null ? null : bl.toString());
    }

    public void setSplitCobolCodeByProgram(Boolean bl) {
        this.set(SPLIT_COBOL_CODE_BY_PROGRAM, bl == null ? null : bl.toString());
    }

    public void setCobolLineLimit(Integer n) {
        this.set(COBOL_LINE_LIMIT, n == null ? null : String.valueOf(n));
    }

    public void setCobolCopybookPrefix(String string) {
        this.set(COBOL_COPYBOOK_PREFIX, string);
    }

    public String getDllAbsolutePath(String string) {
        return new File(string, this.getDllName()).getAbsolutePath();
    }

    public String getCodePath(String string) {
        return new File(string, this.getPackagePath()).getAbsolutePath();
    }

    public String getPackagePath() {
        return this.getSourcePackageName() == null ? "" : this.getSourcePackageName().replace('.', File.separatorChar);
    }

    static {
        Arrays.sort(COBOL_OPTIONS);
    }
}

