/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdCodeGenerationOptions;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinitionWithDefaults;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerOptions;
import com.blazesoft.server.deploygen.definitions.NdRemoteDebuggingOptions;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironment;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentMgr;

public class NdDeploymentDefinition
extends NdDeploymentConfigDefinition {
    public static final String DESCRIPTION = "description";
    public static final String RULE_SERVER_NAME = "ruleServerName";
    public static final String SERVER_TYPE = "serverType";
    public static final String USING_ABSOLUTE_PATH = "usingAbsolutePath";
    public static final String USING_SOURCE_CODE_CONFIG = "usingSourceCodeConfig";
    public static final String RULE_AGENT_POOLING_POLICY = "ruleAgentPoolingPolicy";
    public static final String NUM_RULE_AGENTS = "numRuleAgents";
    public static final String RECYCLE_POLICY = "recyclePolicy";
    public static final String THREADED = "threaded";
    public static final String DEPLOYMENT_ENVIRONMENT = "deploymentEnvironment";
    public static final String CLIENT_TYPE = "clientType";
    public static final String TARGET_LANGUAGE = "targetLanguage";
    private NdCodeGenerationOptions SiPGejR;
    private NdDeploymentManagerOptions SiPGejS;
    private NdRemoteDebuggingOptions SiPGejT;

    public NdDeploymentDefinition() {
    }

    protected NdDeploymentDefinition(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdDeploymentDefinition ndDeploymentDefinition) {
        super(ndDeploymentEnvironmentMgr, null, ndDeploymentDefinition);
        if (ndDeploymentDefinition == null) {
            this.initResource(ndDeploymentEnvironmentMgr);
        }
    }

    protected void initResource(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr) {
        super.initResource(ndDeploymentEnvironmentMgr);
        this.setCodeGenerationOptions(new NdCodeGenerationOptions(ndDeploymentEnvironmentMgr, this));
        this.setDeploymentManagerOptions(new NdDeploymentManagerOptions(ndDeploymentEnvironmentMgr, this));
        this.setRemoteDebuggingOptions(new NdRemoteDebuggingOptions(ndDeploymentEnvironmentMgr, this));
    }

    public void copyFrom(NdConfigDefinition ndConfigDefinition) throws NdConfigurationException {
        super.copyFrom(ndConfigDefinition);
        NdDeploymentDefinition ndDeploymentDefinition = (NdDeploymentDefinition)ndConfigDefinition;
        this.setDescription(ndDeploymentDefinition.getDescription());
        this.setRuleServerName(ndDeploymentDefinition.getRuleServerName());
        this.setEnumServerType(ndDeploymentDefinition.getServerTypeEnum());
        this.setUsingAbsolutePath(ndDeploymentDefinition.getUsingAbsolutePath());
        this.setUsingSourceCodeConfig(ndDeploymentDefinition.getUsingSourceCodeConfig());
        this.setEnumRuleAgentPoolingPolicy(ndDeploymentDefinition.getRuleAgentPoolingPolicyEnum());
        this.setNumRuleAgents(ndDeploymentDefinition.getNumRuleAgents());
        this.setEnumRecyclePolicy(ndDeploymentDefinition.getRecyclePolicyEnum());
        this.setThreaded(ndDeploymentDefinition.getThreaded());
        this.setEnumDeploymentEnvironment(ndDeploymentDefinition.getDeploymentEnvironmentEnum());
        this.setClientType(ndDeploymentDefinition.getClientType());
        this.setEnumTargetLanguage(ndDeploymentDefinition.getTargetLanguageEnum());
        this.SiPGejR.copyFrom(ndDeploymentDefinition.getCodeGenerationOptions());
        this.SiPGejS.copyFrom(ndDeploymentDefinition.getDeploymentManagerOptions());
        this.SiPGejT.copyFrom(ndDeploymentDefinition.getRemoteDebuggingOptions());
    }

    public NdConfigDefinition createCopy() throws NdConfigurationException {
        NdDeploymentDefinition ndDeploymentDefinition = new NdDeploymentDefinition(this.getEnvironmentMgr(), null);
        ndDeploymentDefinition.setName(this.getName());
        ndDeploymentDefinition.copyFrom(this);
        return ndDeploymentDefinition;
    }

    public NdDeploymentDefinition createWithDefaults(NdConfigDefaultsContext ndConfigDefaultsContext) {
        return new NdDeploymentDefinitionWithDefaults(this.getEnvironmentMgr(), this, ndConfigDefaultsContext);
    }

    public void setName(String string) {
        this.set("name", string);
    }

    public String getName() {
        return this.get("name");
    }

    public int getPromSubType() {
        return 44;
    }

    public String getDescription() {
        return this.get(DESCRIPTION);
    }

    public void setDescription(String string) {
        this.set(DESCRIPTION, string);
    }

    public String getRuleServerName() {
        return this.get(RULE_SERVER_NAME);
    }

    public void setRuleServerName(String string) {
        this.set(RULE_SERVER_NAME, string);
    }

    public NdDeploymentConstants.ServerType getServerTypeEnum() {
        String string = this.get(SERVER_TYPE);
        return string == null ? null : NdDeploymentConstants.ServerType.valueOf(string);
    }

    public String getServerType() {
        return this.get(SERVER_TYPE);
    }

    public void setEnumServerType(NdDeploymentConstants.ServerType serverType) {
        this.set(SERVER_TYPE, serverType == null ? null : serverType.toString());
    }

    public void setServerType(String string) {
        this.setEnumServerType(string == null ? null : NdDeploymentConstants.ServerType.valueOf(string));
    }

    public String getClientType() {
        return this.get(CLIENT_TYPE);
    }

    public void setClientType(String string) {
        this.set(CLIENT_TYPE, string);
    }

    public NdDeploymentEnvironment getDeploymentEnvironmentEnum() {
        String string = this.get(DEPLOYMENT_ENVIRONMENT);
        return string == null ? null : this.getEnvironmentMgr().getEnvironment(string);
    }

    public void setEnumDeploymentEnvironment(NdDeploymentEnvironment ndDeploymentEnvironment) {
        this.set(DEPLOYMENT_ENVIRONMENT, ndDeploymentEnvironment == null ? null : ndDeploymentEnvironment.getName());
    }

    public String getDeploymentEnvironment() {
        return this.get(DEPLOYMENT_ENVIRONMENT);
    }

    public void setDeploymentEnvironment(String string) {
        this.setEnumDeploymentEnvironment(this.getEnvironmentMgr().getEnvironment(string));
    }

    public NdDeploymentConstants.TargetLanguage getTargetLanguageEnum() {
        String string = this.get(TARGET_LANGUAGE);
        return string == null ? null : NdDeploymentConstants.TargetLanguage.valueOf(string);
    }

    public void setEnumTargetLanguage(NdDeploymentConstants.TargetLanguage targetLanguage) {
        this.set(TARGET_LANGUAGE, targetLanguage == null ? null : targetLanguage.toString());
    }

    public String getTargetLanguage() {
        return this.get(TARGET_LANGUAGE);
    }

    public void setTargetLanguage(String string) {
        this.set(TARGET_LANGUAGE, string);
    }

    public Integer getNumRuleAgents() {
        return this.getInteger(NUM_RULE_AGENTS);
    }

    public void setNumRuleAgents(Integer n) {
        this.set(NUM_RULE_AGENTS, n == null ? null : n.toString());
    }

    public NdDeploymentConstants.RecyclePolicy getRecyclePolicyEnum() {
        String string = this.get(RECYCLE_POLICY);
        return string == null ? null : NdDeploymentConstants.RecyclePolicy.valueOf(string);
    }

    public String getRecyclePolicy() {
        return this.get(RECYCLE_POLICY);
    }

    public void setEnumRecyclePolicy(NdDeploymentConstants.RecyclePolicy recyclePolicy) {
        this.set(RECYCLE_POLICY, recyclePolicy == null ? null : recyclePolicy.toString());
    }

    public void setRecyclePolicy(String string) {
        this.set(RECYCLE_POLICY, string);
    }

    public NdDeploymentConstants.RuleAgentPoolingPolicy getRuleAgentPoolingPolicyEnum() {
        String string = this.get(RULE_AGENT_POOLING_POLICY);
        return string == null ? null : NdDeploymentConstants.RuleAgentPoolingPolicy.valueOf(string);
    }

    public String getRuleAgentPoolingPolicy() {
        return this.get(RULE_AGENT_POOLING_POLICY);
    }

    public void setEnumRuleAgentPoolingPolicy(NdDeploymentConstants.RuleAgentPoolingPolicy ruleAgentPoolingPolicy) {
        this.set(RULE_AGENT_POOLING_POLICY, ruleAgentPoolingPolicy == null ? null : ruleAgentPoolingPolicy.toString());
    }

    public void setRuleAgentPoolingPolicy(String string) {
        this.set(RULE_AGENT_POOLING_POLICY, string);
    }

    public Boolean getThreaded() {
        return this.getBoolean(THREADED);
    }

    public void setThreaded(Boolean bl) {
        this.set(THREADED, bl == null ? null : bl.toString());
    }

    public Boolean getUsingSourceCodeConfig() {
        return this.getBoolean(USING_SOURCE_CODE_CONFIG);
    }

    public void setUsingSourceCodeConfig(Boolean bl) {
        this.set(USING_SOURCE_CODE_CONFIG, bl == null ? null : bl.toString());
    }

    public Boolean getUsingAbsolutePath() {
        return this.getBoolean(USING_ABSOLUTE_PATH);
    }

    public void setUsingAbsolutePath(Boolean bl) {
        this.set(USING_ABSOLUTE_PATH, bl == null ? null : bl.toString());
    }

    public NdCodeGenerationOptions getCodeGenerationOptions() {
        return this.SiPGejR;
    }

    public void setCodeGenerationOptions(NdCodeGenerationOptions ndCodeGenerationOptions) {
        this.SiPGejR = (NdCodeGenerationOptions)this.adopt(ndCodeGenerationOptions);
    }

    public NdDeploymentManagerOptions getDeploymentManagerOptions() {
        return this.SiPGejS;
    }

    public void setDeploymentManagerOptions(NdDeploymentManagerOptions ndDeploymentManagerOptions) {
        this.SiPGejS = (NdDeploymentManagerOptions)this.adopt(ndDeploymentManagerOptions);
    }

    public NdRemoteDebuggingOptions getRemoteDebuggingOptions() {
        return this.SiPGejT;
    }

    public void setRemoteDebuggingOptions(NdRemoteDebuggingOptions ndRemoteDebuggingOptions) {
        this.SiPGejT = (NdRemoteDebuggingOptions)this.adopt(ndRemoteDebuggingOptions);
    }

    public boolean useInConfig(String string) {
        String[] stringArray = new String[]{TARGET_LANGUAGE, DEPLOYMENT_ENVIRONMENT, SERVER_TYPE, RULE_AGENT_POOLING_POLICY, RECYCLE_POLICY};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i] + "Enum";
            if (!string2.equals(string)) continue;
            return false;
        }
        return super.useInConfig(string);
    }
}

