/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.deploy.rules.NdSrlInvocationFunctional;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinitionWithDefaults;
import com.blazesoft.server.deploygen.definitions.NdStrings;
import com.blazesoft.server.deploygen.definitions.NdValueMapperOptions;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentMgr;
import java.util.ArrayList;

public class NdRuleServiceDefinition
extends NdDeploymentConfigDefinition {
    public static final String DESCRIPTION = "description";
    public static final String RULE_SERVICE_NAME = "ruleServiceName";
    public static final String MAX_ITERATIONS = "maxIterations";
    public static final String ENTRY_POINT = "entryPoint";
    public static final String COBOL_COMPATIBLE = "cobolCompatible";
    private static final NdDeployRulesServiceEntryPointConfig[] SiPGgGF = new NdDeployRulesServiceEntryPointConfig[0];
    private NdValueMapperOptions SiPGgGG;
    private NdDeployRulesServiceEntryPointConfig[] SiPGgGH;

    public NdRuleServiceDefinition() {
    }

    protected NdRuleServiceDefinition(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdRuleServiceDefinition ndRuleServiceDefinition) {
        super(ndDeploymentEnvironmentMgr, null, ndRuleServiceDefinition);
        if (ndRuleServiceDefinition == null) {
            this.initResource(ndDeploymentEnvironmentMgr);
        }
    }

    protected void initResource(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr) {
        super.initResource(ndDeploymentEnvironmentMgr);
        this.SiPGgGG = new NdValueMapperOptions(ndDeploymentEnvironmentMgr, this);
        this.SiPGgGH = SiPGgGF;
    }

    public void copyFrom(NdConfigDefinition ndConfigDefinition) throws NdConfigurationException {
        super.copyFrom(ndConfigDefinition);
        NdRuleServiceDefinition ndRuleServiceDefinition = (NdRuleServiceDefinition)ndConfigDefinition;
        this.setDescription(ndRuleServiceDefinition.getDescription());
        this.setRuleServiceName(ndRuleServiceDefinition.getRuleServiceName());
        this.setMaxIterations(ndRuleServiceDefinition.getMaxIterations());
        this.setEntryPoint(ndRuleServiceDefinition.getEntryPoints());
        this.setCobolCompatible(ndRuleServiceDefinition.getCobolCompatible());
        this.SiPGgGG.copyFrom(ndRuleServiceDefinition.getValueMapperOptions());
    }

    public NdConfigDefinition createCopy() throws NdConfigurationException {
        NdRuleServiceDefinition ndRuleServiceDefinition = new NdRuleServiceDefinition(this.getEnvironmentMgr(), null);
        ndRuleServiceDefinition.setName(this.getName());
        ndRuleServiceDefinition.copyFrom(this);
        return ndRuleServiceDefinition;
    }

    public NdRuleServiceDefinition createWithDefaults(NdConfigDefaultsContext ndConfigDefaultsContext) {
        return new NdRuleServiceDefinitionWithDefaults(this.getEnvironmentMgr(), this, ndConfigDefaultsContext);
    }

    public void setName(String string) {
        this.set("name", string);
    }

    public String getName() {
        return this.get("name");
    }

    public int getPromSubType() {
        return 43;
    }

    public String getDescription() {
        return this.get(DESCRIPTION);
    }

    public void setDescription(String string) {
        this.set(DESCRIPTION, string);
    }

    public String getRuleServiceName() {
        return this.get(RULE_SERVICE_NAME);
    }

    public void setRuleServiceName(String string) {
        this.set(RULE_SERVICE_NAME, string);
    }

    public Integer getMaxIterations() {
        return this.getInteger(MAX_ITERATIONS);
    }

    public void setMaxIterations(Integer n) {
        this.set(MAX_ITERATIONS, n == null ? null : n.toString());
    }

    public Boolean getCobolCompatible() {
        return this.getBoolean(COBOL_COMPATIBLE);
    }

    public void setCobolCompatible(Boolean bl) {
        this.set(COBOL_COMPATIBLE, bl == null ? null : bl.toString());
    }

    public NdDeployRulesServiceEntryPointConfig[] getEntryPoint() {
        return this.SiPGgGH;
    }

    public void setEntryPoint(NdDeployRulesServiceEntryPointConfig[] ndDeployRulesServiceEntryPointConfigArray) {
        this.SiPGgGH = ndDeployRulesServiceEntryPointConfigArray;
    }

    public NdDeployRulesServiceEntryPointConfig getEntryPoint(int n) {
        return this.SiPGgGH[n];
    }

    public void setEntryPoint(int n, NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig) {
        this.SiPGgGH[n] = ndDeployRulesServiceEntryPointConfig;
    }

    public NdDeployRulesServiceEntryPointConfig[] getEntryPoints() {
        return this.SiPGgGH;
    }

    public NdDeployRulesServiceEntryPointConfig getEntryPoint(String string) throws NdConfigurationException {
        for (int i = 0; i < this.SiPGgGH.length; ++i) {
            if (!string.equals(this.SiPGgGH[i].getEntryPointId())) continue;
            return this.SiPGgGH[i];
        }
        throw new NdConfigurationException(NdStrings.SiPGefE("NoSuchEntryPoint", string));
    }

    public void addEntryPoint(NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig) {
        ArrayList<NdDeployRulesServiceEntryPointConfig> arrayList = new ArrayList<NdDeployRulesServiceEntryPointConfig>();
        for (int i = 0; i < this.SiPGgGH.length; ++i) {
            NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig2 = this.SiPGgGH[i];
            if (ndDeployRulesServiceEntryPointConfig2.getEntryPointId().equals(ndDeployRulesServiceEntryPointConfig.getEntryPointId())) continue;
            arrayList.add(ndDeployRulesServiceEntryPointConfig2);
        }
        arrayList.add(ndDeployRulesServiceEntryPointConfig);
        NdDeployRulesServiceEntryPointConfig[] ndDeployRulesServiceEntryPointConfigArray = arrayList.toArray(new NdDeployRulesServiceEntryPointConfig[arrayList.size()]);
        this.notifyPropertyAboutToChange(ENTRY_POINT, ndDeployRulesServiceEntryPointConfigArray);
        this.SiPGgGH = ndDeployRulesServiceEntryPointConfigArray;
        this.notifyPropertyChange(ENTRY_POINT, this.SiPGgGH);
    }

    public void removeEntryPoint(String string) {
        ArrayList<NdDeployRulesServiceEntryPointConfig> arrayList = new ArrayList<NdDeployRulesServiceEntryPointConfig>();
        int n = this.SiPGgGH.length;
        for (int i = 0; i < n; ++i) {
            NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = this.SiPGgGH[i];
            if (ndDeployRulesServiceEntryPointConfig.getEntryPointId().equals(string)) continue;
            arrayList.add(ndDeployRulesServiceEntryPointConfig);
        }
        if (arrayList.size() < n) {
            this.SiPGgGH = arrayList.toArray(new NdDeployRulesServiceEntryPointConfig[arrayList.size()]);
            this.notifyPropertyChange(ENTRY_POINT, this.SiPGgGH);
        }
    }

    public void addEntryPoint(String string, String string2, String string3, String[] stringArray) {
        NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = new NdDeployRulesServiceEntryPointConfig(string);
        NdSrlInvocationFunctional ndSrlInvocationFunctional = new NdSrlInvocationFunctional();
        ndSrlInvocationFunctional.setSrlName(string2);
        ndSrlInvocationFunctional.setSrlReturnType(string3);
        ndSrlInvocationFunctional.setSrlArgumentType(stringArray);
        ndDeployRulesServiceEntryPointConfig.setSrlInvocationFunctional(ndSrlInvocationFunctional);
        this.addEntryPoint(ndDeployRulesServiceEntryPointConfig);
    }

    public NdValueMapperOptions getValueMapperOptions() {
        return this.SiPGgGG;
    }

    public void setValueMapperOptions(NdValueMapperOptions ndValueMapperOptions) {
        this.SiPGgGG = (NdValueMapperOptions)this.adopt(ndValueMapperOptions);
    }
}

