/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions;

import com.blazesoft.dynobj.NdDynObjConfigLoader;
import com.blazesoft.dynobj.NdDynObjObject;
import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.NdDeploymentRuntimeException;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerSystemOptions;
import com.blazesoft.server.deploygen.definitions.NdRemoteDebuggingSystemOptions;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinitionWithDefaults;
import com.blazesoft.server.deploygen.definitions.NdSystemEnvironmentSettings;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironment;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentMgr;

public class NdSystemDefinition
extends NdDeploymentConfigDefinition {
    public static final String TARGET_DIRECTORY = "targetDirectory";
    public static final String TARGET_SOURCE_DIRECTORY = "targetSourceDirectory";
    public static final String DESCRIPTION = "description";
    public static final String VIRTUAL_DIRECTORY = "virtualDirectory";
    public static final String DEPLOYMENT_ENVIRONMENT = "deploymentEnvironment";
    public static final String SERVER_TYPE = "serverType";
    public static final String VENDOR = "vendor";
    public static final String ENVIRONMENT_SETTINGS = "environmentSettings";
    private NdSystemEnvironmentSettings SiPGflE;
    private boolean SiPGfmF;
    private NdDeploymentManagerSystemOptions SiPGfnG;
    private NdRemoteDebuggingSystemOptions SiPGfoH;

    public NdSystemDefinition() {
    }

    public void readResource(NdDynObjConfigLoader ndDynObjConfigLoader, NdDynObjObject ndDynObjObject) {
        super.readResource(ndDynObjConfigLoader, ndDynObjObject);
        NdSystemEnvironmentSettings ndSystemEnvironmentSettings = this.SiPGflE;
        if (ndSystemEnvironmentSettings != null) {
            try {
                this._updateSystemEnvironment();
                this.SiPGflE.copyFrom(ndSystemEnvironmentSettings);
                this.SiPGfmF = false;
            }
            catch (NdConfigurationException ndConfigurationException) {
                throw new NdDeploymentRuntimeException(ndConfigurationException);
            }
        }
    }

    protected NdSystemDefinition(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdSystemDefinition ndSystemDefinition) {
        super(ndDeploymentEnvironmentMgr, null, ndSystemDefinition);
        if (ndSystemDefinition == null) {
            this.initResource(ndDeploymentEnvironmentMgr);
        }
    }

    protected void initResource(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr) {
        super.initResource(ndDeploymentEnvironmentMgr);
        this.setEnvironmentSettings(null);
        this.SiPGfmF = false;
        this.SiPGfnG = new NdDeploymentManagerSystemOptions(ndDeploymentEnvironmentMgr, this);
        this.SiPGfoH = new NdRemoteDebuggingSystemOptions(ndDeploymentEnvironmentMgr, this);
    }

    public void copyFrom(NdConfigDefinition ndConfigDefinition) throws NdConfigurationException {
        super.copyFrom(ndConfigDefinition);
        NdSystemDefinition ndSystemDefinition = (NdSystemDefinition)ndConfigDefinition;
        this.setTargetDirectory(ndSystemDefinition.getTargetDirectory());
        this.setDescription(ndSystemDefinition.getDescription());
        this.setVirtualDirectory(ndSystemDefinition.getVirtualDirectory());
        this.setEnumDeploymentEnvironment(ndSystemDefinition.getDeploymentEnvironmentEnum());
        this.setEnumServerType(ndSystemDefinition.getServerTypeEnum());
        this.setVendor(ndSystemDefinition.getVendor());
        this._updateSystemEnvironment();
        if (this.SiPGflE != null) {
            this.SiPGflE.copyFrom(ndSystemDefinition.getEnvironmentSettings());
        }
        this.SiPGfnG.copyFrom(ndSystemDefinition.getDeploymentManagerSystemOptions());
        this.SiPGfoH.copyFrom(ndSystemDefinition.getRemoteDebuggingSystemOptions());
    }

    public NdConfigDefinition createCopy() throws NdConfigurationException {
        NdSystemDefinition ndSystemDefinition = new NdSystemDefinition(this.getEnvironmentMgr(), null);
        ndSystemDefinition.setName(this.getName());
        ndSystemDefinition.copyFrom(this);
        return ndSystemDefinition;
    }

    public NdSystemDefinition createWithDefaults(NdConfigDefaultsContext ndConfigDefaultsContext) {
        return new NdSystemDefinitionWithDefaults(this.getEnvironmentMgr(), this, ndConfigDefaultsContext);
    }

    public void setName(String string) {
        this.set("name", string);
    }

    public String getName() {
        return this.get("name");
    }

    public int getPromSubType() {
        return 45;
    }

    public String getDescription() {
        return this.get(DESCRIPTION);
    }

    public void setDescription(String string) {
        this.set(DESCRIPTION, string);
    }

    public String getTargetDirectory() {
        return this.get(TARGET_DIRECTORY);
    }

    public void setTargetDirectory(String string) {
        this.set(TARGET_DIRECTORY, string);
    }

    public String getTargetSourceDirectory() {
        return this.get(TARGET_SOURCE_DIRECTORY);
    }

    public void setTargetSourceDirectory(String string) {
        this.set(TARGET_SOURCE_DIRECTORY, string);
    }

    public NdDeploymentManagerSystemOptions getDeploymentManagerSystemOptions() {
        return this.SiPGfnG;
    }

    public void setDeploymentManagerSystemOptions(NdDeploymentManagerSystemOptions ndDeploymentManagerSystemOptions) {
        this.SiPGfnG = (NdDeploymentManagerSystemOptions)this.adopt(ndDeploymentManagerSystemOptions);
    }

    public NdRemoteDebuggingSystemOptions getRemoteDebuggingSystemOptions() {
        return this.SiPGfoH;
    }

    public void setRemoteDebuggingSystemOptions(NdRemoteDebuggingSystemOptions ndRemoteDebuggingSystemOptions) {
        this.SiPGfoH = (NdRemoteDebuggingSystemOptions)this.adopt(ndRemoteDebuggingSystemOptions);
    }

    public String getVirtualDirectory() {
        return this.get(VIRTUAL_DIRECTORY);
    }

    public void setVirtualDirectory(String string) {
        this.set(VIRTUAL_DIRECTORY, string);
    }

    public String getVendor() {
        return this.get(VENDOR);
    }

    public void setVendor(String string) {
        this.set(VENDOR, string);
    }

    protected void internalSet(String string, String string2) {
        super.internalSet(string, string2);
        if (VENDOR.equals(string) || DEPLOYMENT_ENVIRONMENT.equals(string) || SERVER_TYPE.equals(string)) {
            this.SiPGfmF = true;
        }
    }

    public NdDeploymentEnvironment getDeploymentEnvironmentEnum() {
        String string = this.get(DEPLOYMENT_ENVIRONMENT);
        return string == null ? null : this.getEnvironmentMgr().getEnvironment(string);
    }

    public void setEnumDeploymentEnvironment(NdDeploymentEnvironment ndDeploymentEnvironment) {
        this.set(DEPLOYMENT_ENVIRONMENT, ndDeploymentEnvironment == null ? null : ndDeploymentEnvironment.getName());
    }

    public String getDeploymentEnvironment() {
        return this.get(DEPLOYMENT_ENVIRONMENT);
    }

    public void setDeploymentEnvironment(String string) {
        this.setEnumDeploymentEnvironment(this.getEnvironmentMgr().getEnvironment(string));
    }

    public NdDeploymentConstants.ServerType getServerTypeEnum() {
        String string = this.get(SERVER_TYPE);
        return string == null ? null : NdDeploymentConstants.ServerType.valueOf(string);
    }

    public String getServerType() {
        return this.get(SERVER_TYPE);
    }

    public void setEnumServerType(NdDeploymentConstants.ServerType serverType) {
        this.set(SERVER_TYPE, serverType == null ? null : serverType.toString());
    }

    public void setServerType(String string) {
        this.setEnumServerType(string == null ? null : NdDeploymentConstants.ServerType.valueOf(string));
    }

    public NdSystemEnvironmentSettings getEnvironmentSettings() throws NdConfigurationException {
        if (this.isEnvironmentSettingsDirty()) {
            this._updateSystemEnvironment();
        }
        return this.SiPGflE;
    }

    protected boolean isEnvironmentSettingsDirty() {
        return this.SiPGfmF;
    }

    public void setEnvironmentSettings(NdSystemEnvironmentSettings ndSystemEnvironmentSettings) {
        this.SiPGflE = (NdSystemEnvironmentSettings)this.adopt(ndSystemEnvironmentSettings);
    }

    protected void _updateSystemEnvironment() throws NdConfigurationException {
        NdSystemDefinition ndSystemDefinition = this.createWithDefaults(null);
        NdDeploymentConstants.ServerType serverType = ndSystemDefinition.getServerTypeEnum();
        NdDeploymentEnvironment ndDeploymentEnvironment = ndSystemDefinition.getDeploymentEnvironmentEnum();
        String string = ndSystemDefinition.getVendor();
        this.setEnvironmentSettings(ndDeploymentEnvironment == null || serverType == null || string == null ? null : ndDeploymentEnvironment.createSystemEnvironmentSettings(this.getEnvironmentMgr(), serverType, string));
        this.SiPGfmF = false;
    }

    NdSystemDefinition SiPGfpI() {
        return this;
    }
}

