/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions.defaults;

import com.blazesoft.server.deploygen.NdDeploymentUtil;
import com.blazesoft.server.deploygen.definitions.NdCodeGenerationOptions;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import java.util.Arrays;

public class NdCodeGenerationCommonDefaults
extends NdConfigDefinitionDefaultsImpl {
    public static final String DEFAULT_PROGRAM_NAME = "CBLPGM";
    public static final String DEFAULT_MAX_STRING_LENGTH = "500";
    public static final String DEFAULT_SUBPROGRAM_PREFIX = "BA";
    public static final String DEFAULT_LINE_LIMIT = "100000";
    public static final String DEFAULT_COPYBOOK_PREFIX = "CBL";
    private static final String SiPGaRH = "";
    private static final String SiPGaRI = "qd";
    private static final String SiPGaRJ = ".";

    public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        if ("classNamePrefix".equals(string)) {
            return SiPGaRH;
        }
        if ("serverConfigFileName".equals(string)) {
            String string2 = this.SiPGhoX(ndConfigDefaultsContext);
            if (string2 != null) {
                return NdDeploymentUtil.makeFileNameValid(string2) + SiPGaRJ + "server";
            }
        } else if ("sourcePackageName".equals(string)) {
            String string3 = this.SiPGhoX(ndConfigDefaultsContext);
            if (string3 != null) {
                return SiPGaRI + NdDeploymentUtil.makeNameValidForJava(string3);
            }
        } else if ("dllName".equals(string)) {
            String string4 = this.SiPGhoX(ndConfigDefaultsContext);
            if (string4 != null) {
                return string4 + SiPGaRJ + "dll";
            }
        } else {
            if ("keepGeneratedFiles".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("usingDebugLogger".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("appStartedOnInit".equals(string)) {
                return Boolean.FALSE.toString();
            }
        }
        return super.getDefaultValue(string, ndConfigDefaultsContext);
    }

    private String SiPGhoX(NdConfigDefaultsContext ndConfigDefaultsContext) {
        NdRuleServiceDefinition ndRuleServiceDefinition;
        String string = null;
        NdDeploymentConfigDefaultsContext ndDeploymentConfigDefaultsContext = (NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext;
        NdDeploymentDefinition ndDeploymentDefinition = ndDeploymentConfigDefaultsContext.getDeploymentDefinition();
        if (ndDeploymentDefinition != null) {
            string = ndDeploymentDefinition.getRuleServerName();
        }
        if (string == null && (ndRuleServiceDefinition = ndDeploymentConfigDefaultsContext.getRuleServiceDefinition()) != null) {
            string = ndRuleServiceDefinition.getRuleServiceName();
        }
        return string;
    }

    public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        if (Arrays.binarySearch(NdCodeGenerationOptions.COBOL_OPTIONS, string) >= 0) {
            return Boolean.FALSE;
        }
        if ("serverConfigURL".equals(string)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean requiresValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        if ("serverConfigURL".equals(string)) {
            return Boolean.FALSE;
        }
        return super.requiresValue(string, ndConfigDefaultsContext);
    }
}

