/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions.defaults;

import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentTemplatesMgr;
import com.blazesoft.util.NdWrappedRuntimeException;

public class NdDeploymentDefinitionCommonDefaults
extends NdConfigDefinitionDefaultsImpl {
    private static final String SiPGcMJ = "10";
    private static final String SiPGcMK = NdDeploymentConstants.RuleAgentPoolingPolicy.FIXED.toString();
    private static final String SiPGcML = NdDeploymentConstants.ServerType.STATELESS.toString();
    private static final String SiPGcMM = Boolean.FALSE.toString();
    private static final String SiPGcMN = Boolean.FALSE.toString();
    private static final String SiPGcMO = Boolean.FALSE.toString();
    private static final String SiPGcMP = NdDeploymentConstants.RecyclePolicy.REINITIALIZE.toString();
    private static final String[] SiPGcMQ = new String[]{String.valueOf(false)};
    private static final String[] SiPGcMR = new String[]{NdDeploymentConstants.TargetLanguage.JAVA.getName()};

    public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        if ("deploymentEnvironment".equals(string)) {
            return "Java";
        }
        if ("recyclePolicy".equals(string)) {
            return SiPGcMP;
        }
        if ("ruleServerName".equals(string)) {
            NdRuleServiceDefinition ndRuleServiceDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getRuleServiceDefinition();
            if (ndRuleServiceDefinition != null && ndRuleServiceDefinition.getRuleServiceName() != null) {
                return ndRuleServiceDefinition.getRuleServiceName();
            }
        } else {
            if ("targetLanguage".equals(string)) {
                return NdDeploymentConstants.TargetLanguage.JAVA.toString();
            }
            if ("clientType".equals(string)) {
                return "Java";
            }
            if ("ruleAgentPoolingPolicy".equals(string)) {
                return NdDeploymentConstants.RuleAgentPoolingPolicy.DYNAMIC.toString();
            }
            if ("usingSourceCodeConfig".equals(string)) {
                return SiPGcMO;
            }
            if ("usingAbsolutePath".equals(string)) {
                return SiPGcMN;
            }
            if ("threaded".equals(string)) {
                return SiPGcMM;
            }
            if ("serverType".equals(string)) {
                return SiPGcML;
            }
            if ("recyclePolicy".equals(string)) {
                return NdDeploymentConstants.RecyclePolicy.REINITIALIZE.toString();
            }
            if ("ruleAgentPoolingPolicy".equals(string)) {
                return SiPGcMK;
            }
            if ("numRuleAgents".equals(string)) {
                return SiPGcMJ;
            }
        }
        return super.getDefaultValue(string, ndConfigDefaultsContext);
    }

    public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        NdDeploymentConfigDefaultsContext ndDeploymentConfigDefaultsContext = (NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext;
        if ("serverType".equals(string)) {
            return NdDeploymentConstants.ServerType.ALL_SERVER_TYPES;
        }
        if ("threaded".equals(string)) {
            return SiPGcMQ;
        }
        if ("ruleAgentPoolingPolicy".equals(string)) {
            return NdDeploymentConstants.RuleAgentPoolingPolicy.ALL_POLICIES;
        }
        if ("recyclePolicy".equals(string)) {
            return NdDeploymentConstants.RecyclePolicy.ALL_POLICIES;
        }
        if ("targetLanguage".equals(string)) {
            return SiPGcMR;
        }
        if ("clientType".equals(string)) {
            try {
                return NdDeploymentTemplatesMgr.getClientTypeList(ndDeploymentConfigDefaultsContext.getDeploymentDefinition());
            }
            catch (NdServerException ndServerException) {
                throw new NdWrappedRuntimeException((Throwable)((Object)ndServerException));
            }
        }
        if ("deploymentEnvironment".equals(string)) {
            return ndDeploymentConfigDefaultsContext.getEnvironmentMgr().getSupportedEnvironments();
        }
        return super.getValidValues(string, ndConfigDefaultsContext);
    }

    public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        NdDeploymentDefinition ndDeploymentDefinition;
        if ("numRuleAgents".equals(string) && (ndDeploymentDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getDeploymentDefinition()) != null) {
            return NdDeploymentConstants.RuleAgentPoolingPolicy.FIXED.equals(ndDeploymentDefinition.getRuleAgentPoolingPolicyEnum()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

