/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions.defaults;

import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironment;
import com.blazesoft.server.deploygen.environments.NdDeploymentTemplatesMgr;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.File;

public class NdSystemDefinitionCommonDefaults
extends NdConfigDefinitionDefaultsImpl {
    private static final String SiPGcZY = ".";
    private static final String SiPGdaZ = NdDeploymentConstants.ServerType.STATELESS.toString();

    public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        NdDeploymentConfigDefaultsContext ndDeploymentConfigDefaultsContext = (NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext;
        if ("serverType".equals(string)) {
            return SiPGdaZ;
        }
        if ("targetDirectory".equals(string)) {
            NdDeploymentDefinition ndDeploymentDefinition;
            String string2;
            File file = ndDeploymentConfigDefaultsContext.getWorkingDir();
            if (file == null) {
                file = new File(SiPGcZY);
            }
            String string3 = string2 = (ndDeploymentDefinition = ndDeploymentConfigDefaultsContext.getDeploymentDefinition()) == null ? null : ndDeploymentDefinition.getRuleServerName();
            if (string2 != null) {
                file = new File(file, string2);
            }
            return file.getPath();
        }
        if ("targetSourceDirectory".equals(string)) {
            NdSystemDefinition ndSystemDefinition = ndDeploymentConfigDefaultsContext.getSystemDefinition();
            return ndSystemDefinition.getTargetDirectory();
        }
        return super.getDefaultValue(string, ndConfigDefaultsContext);
    }

    public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        NdSystemDefinition ndSystemDefinition;
        NdDeploymentConfigDefaultsContext ndDeploymentConfigDefaultsContext = (NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext;
        if ("serverType".equals(string)) {
            return NdDeploymentConstants.ServerType.ALL_SERVER_TYPES;
        }
        if ("deploymentEnvironment".equals(string)) {
            return ndDeploymentConfigDefaultsContext.getEnvironmentMgr().getSupportedEnvironments();
        }
        if ("vendor".equals(string) && (ndSystemDefinition = ndDeploymentConfigDefaultsContext.getSystemDefinition()) != null) {
            try {
                NdDeploymentEnvironment ndDeploymentEnvironment = ndSystemDefinition.getDeploymentEnvironmentEnum();
                NdDeploymentConstants.ServerType serverType = ndSystemDefinition.getServerTypeEnum();
                String[] stringArray = ndDeploymentEnvironment == null || serverType == null ? null : NdDeploymentTemplatesMgr.getVendorList(ndDeploymentEnvironment, serverType);
                return stringArray == null ? new String[]{} : stringArray;
            }
            catch (NdServerException ndServerException) {
                throw new NdWrappedRuntimeException((Throwable)((Object)ndServerException));
            }
        }
        return super.getValidValues(string, ndConfigDefaultsContext);
    }

    public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
        return Boolean.TRUE;
    }
}

