/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.environments;

import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentImpl;
import com.blazesoft.server.qdeployer.NdQDeployerModel;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerFileGeneratorImpl;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerJSR94FileGeneratorImpl;
import java.rmi.server.UID;
import java.util.Vector;

public class NdJSR94DeploymentEnvironment
extends NdDeploymentEnvironmentImpl {
    private static final NdConfigDefinitionDefaults SiPGciF = new SiPGbQA();
    private static final NdConfigDefinitionDefaults SiPGciG = new SiPGbgD();
    private static final NdConfigDefinitionDefaults SiPGciH = new SiPGdLT();

    NdJSR94DeploymentEnvironment() {
        super("JSR 94 API");
    }

    public boolean hasRequiredTemplates(NdQDeployerModel ndQDeployerModel, Vector vector) {
        boolean bl = super.hasRequiredTemplates(ndQDeployerModel, vector);
        if (bl) {
            bl = vector.contains("PrefixServer.java") && vector.contains("PrefixClient.java");
        }
        return bl;
    }

    public NdConfigDefinitionDefaults getDeploymentDefinitionDefaults() {
        return SiPGciF;
    }

    public NdConfigDefinitionDefaults getSystemDefinitionDefaults() {
        return SiPGciH;
    }

    public NdConfigDefinitionDefaults getDeploymentManagerDefaults() {
        return SiPGciG;
    }

    public String getTemplateSubdir(NdDeploymentConstants.TargetLanguage targetLanguage) {
        return "jsr94";
    }

    public NdQDeployerFileGeneratorImpl createFileGenerator() {
        return new NdQDeployerJSR94FileGeneratorImpl();
    }

    public String createRmiUid() {
        return new UID().toString();
    }

    protected static class SiPGbgD
    extends NdConfigDefinitionDefaultsImpl {
        private static final String[] SiPGbgC = new String[]{NdDeploymentConstants.ServerManagerType.RMI.toString(), NdDeploymentConstants.ServerManagerType.JAVA.toString()};

        protected SiPGbgD() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverManagerType".equals(string)) {
                return SiPGbgC[0];
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverManagerType".equals(string)) {
                return SiPGbgC;
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGdLT
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGdLT() {
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverType".equals(string)) {
                return new String[]{NdDeploymentConstants.ServerType.STATELESS.toString(), NdDeploymentConstants.ServerType.SYNCHRONOUS_STATEFUL.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGbQA
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGbQA() {
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverType".equals(string)) {
                return new String[]{NdDeploymentConstants.ServerType.STATELESS.toString(), NdDeploymentConstants.ServerType.SYNCHRONOUS_STATEFUL.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }
}

