/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.generation;

import com.blazesoft.objects.base.NdDeploymentValueMapperConfig;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.server.config.NdDeploymentManagerConfig;
import com.blazesoft.server.config.NdServerAsyncExceptionMulticasterFactory;
import com.blazesoft.server.config.NdServiceAgentReloaderFactory;
import com.blazesoft.server.config.NdServiceAgentResetterFactory;
import com.blazesoft.server.config.NdServiceAgentValueMapperFactory;
import com.blazesoft.server.config.NdServiceConfig;
import com.blazesoft.server.config.NdServiceRuntimeExceptionMulticasterFactory;
import com.blazesoft.server.config.NdServiceThreadGroupsExceptionMulticasterFactory;
import com.blazesoft.server.deploy.NdDeployServiceSessionConfig;
import com.blazesoft.server.deploy.NdServiceExceptionEventsEnabler;
import com.blazesoft.server.deploy.NdServiceQuestionsEventsEnabler;
import com.blazesoft.server.deploy.rules.NdDeployRulesServerConfig;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceConfig;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.NdDeploymentRuntimeException;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import com.blazesoft.server.deploygen.definitions.NdValueMapperOptions;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironment;
import com.blazesoft.server.deploygen.generation.NdDeploymentGenerationException;
import com.blazesoft.server.deploygen.generation.NdStrings;
import com.blazesoft.server.innovator.NdInnovatorRepositoryAccessorFactory;
import com.blazesoft.server.rules.NdRulesProjectInnovatorLoaderFactory;
import com.blazesoft.server.rules.NdSerializedRulesProjectLoaderFactory;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomConnectionException;
import com.blazesoft.template.repository.NdRomFactory;
import com.blazesoft.util.NdClassLoadingContext;
import java.io.File;
import java.util.Hashtable;

public class NdServerConfigGenerator {
    private final NdPromProject SiPGvSR;
    private NdRuleServiceDefinition SiPGeGY;
    private NdDeploymentDefinition SiPGeHZ;
    private final NdSystemDefinition SiPPjnW;
    private NdRepositoryConnection SiPTghR;

    public NdServerConfigGenerator(NdPromProject ndPromProject, NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        this.SiPGvSR = ndPromProject;
        NdRepositoryConnection ndRepositoryConnection = this.SiPGvSR.getRomConnectionContext().getRepositoryConnection();
        try {
            this.SiPTghR = NdRomFactory.newRepositoryConnection((Hashtable)ndRepositoryConnection.getConnectionArgs(), (NdClassLoadingContext)ndRepositoryConnection.getClassLoadingContext());
        }
        catch (NdRomConnectionException ndRomConnectionException) {
            throw new NdDeploymentRuntimeException(NdStrings.SiPQKxW("CouldNotCloneRepositoryConnection"), ndRomConnectionException);
        }
        this.SiPGeGY = ndRuleServiceDefinition;
        this.SiPGeHZ = ndDeploymentDefinition;
        this.SiPPjnW = ndSystemDefinition;
    }

    protected NdDeploymentDefinition getDeploymentDefinition() {
        return this.SiPGeHZ;
    }

    protected NdRuleServiceDefinition getRuleServiceDefinition() {
        return this.SiPGeGY;
    }

    protected NdSystemDefinition getSystemDefinition() {
        return this.SiPPjnW;
    }

    public NdDeployRulesServerConfig createServerConfig(NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentGenerationException {
        NdDeployRulesServerConfig ndDeployRulesServerConfig = new NdDeployRulesServerConfig(this.SiPGeHZ.getRuleServerName(), new NdDeployRulesServiceConfig[0]);
        this.initConfig(ndDeployRulesServerConfig, ndDeploymentManagerConfig);
        return ndDeployRulesServerConfig;
    }

    protected void initConfig(NdDeployRulesServerConfig ndDeployRulesServerConfig, NdDeploymentManagerConfig ndDeploymentManagerConfig) throws NdDeploymentGenerationException {
        ndDeployRulesServerConfig.setDeploymentEnvironment(this.getConfigDeploymentEnvironment());
        ndDeployRulesServerConfig.setServerAsyncExceptionMulticasterFactory(new NdServerAsyncExceptionMulticasterFactory(this.SiPGeHZ.getThreaded() != false ? "com.blazesoft.system.NdAsyncExceptionMulticaster" : "com.blazesoft.system.NdAsyncNonThreadedExceptionMulticaster"));
        ndDeployRulesServerConfig.setDeployRulesServiceConfig(new NdDeployRulesServiceConfig[]{this.createServiceConfig(this.SiPGeGY)});
        ndDeployRulesServerConfig.getServerFactory().setJavaName(this.SiPGeHZ.getServerTypeEnum().getServerSuperClass());
    }

    protected String getConfigDeploymentEnvironment() {
        return this.SiPGeHZ.getDeploymentEnvironment();
    }

    protected NdDeployRulesServiceConfig createServiceConfig(NdRuleServiceDefinition ndRuleServiceDefinition) throws NdDeploymentGenerationException {
        NdDeployRulesServiceConfig ndDeployRulesServiceConfig = new NdDeployRulesServiceConfig(this.SiPGeGY.getRuleServiceName(), "com.blazesoft.server.rules.NdScriptRulesServiceAgentFactory", null, "com.blazesoft.server.deploy.rules.NdDeployInvokerMapperRulesServiceClientContext", null, null, this.SiPGeIC(), null, 0);
        this.initConfig(ndDeployRulesServiceConfig, ndRuleServiceDefinition);
        return ndDeployRulesServiceConfig;
    }

    protected void initConfig(NdDeployRulesServiceConfig ndDeployRulesServiceConfig, NdRuleServiceDefinition ndRuleServiceDefinition) throws NdDeploymentGenerationException {
        NdDeployRulesServiceEntryPointConfig[] ndDeployRulesServiceEntryPointConfigArray = ndRuleServiceDefinition.getEntryPoints();
        ndDeployRulesServiceConfig.getDeployRulesServiceClientContextFactory().setDeployRulesServiceEntryPointConfig(ndDeployRulesServiceEntryPointConfigArray);
        Integer n = ndRuleServiceDefinition.getMaxIterations();
        if (n != null) {
            ndDeployRulesServiceConfig.getDeployRulesServiceClientContextFactory().setMaxServiceInvocationCount(n);
        }
        if (this.SiPGeHZ.getServerTypeEnum() == NdDeploymentConstants.ServerType.STATEFUL) {
            ndDeployRulesServiceConfig.setDeployServiceSessionConfig(this.SiPGeIA());
        }
        this.SiPGvSS(ndDeployRulesServiceConfig);
        this.SiPGeIB(ndDeployRulesServiceConfig);
        String string = this.SiPGeHZ.getDeploymentEnvironmentEnum().getServiceAgentValueMapperFactoryClass();
        if (string != null) {
            ndDeployRulesServiceConfig.setServiceAgentValueMapperFactory(new NdServiceAgentValueMapperFactory(string));
        }
        NdValueMapperOptions ndValueMapperOptions = this.SiPGeGY.getValueMapperOptions();
        NdDeploymentValueMapperConfig ndDeploymentValueMapperConfig = new NdDeploymentValueMapperConfig(ndValueMapperOptions.getUsingNativeTypesForCalendarValues().booleanValue(), ndValueMapperOptions.getUsingNativeTypesForMoneyValues().booleanValue(), ndValueMapperOptions.getUsingNativeTypesForPrimitiveValues().booleanValue(), ndValueMapperOptions.getUsingNativeTypesForArrayAndAssociation().booleanValue());
        ndDeployRulesServiceConfig.getServiceAgentValueMapperFactory().setDeploymentValueMapperConfig(ndDeploymentValueMapperConfig);
        NdDeploymentEnvironment ndDeploymentEnvironment = this.SiPGeHZ.getDeploymentEnvironmentEnum();
        ndDeployRulesServiceConfig.setUseDeploymentClassLoadingContext(ndDeploymentEnvironment.getUseDeploymentClassLoadingContext());
        NdDeploymentConstants.RecyclePolicy recyclePolicy = this.SiPGeHZ.getRecyclePolicyEnum();
        if (recyclePolicy != null) {
            ndDeployRulesServiceConfig.setRecyclePolicy(recyclePolicy.getIntValue());
        }
    }

    private void SiPGvSS(NdDeployRulesServiceConfig ndDeployRulesServiceConfig) throws NdDeploymentGenerationException {
        Object object;
        NdRulesProjectInnovatorLoaderFactory ndRulesProjectInnovatorLoaderFactory = new NdRulesProjectInnovatorLoaderFactory();
        ndRulesProjectInnovatorLoaderFactory.setProject(this.SiPGvSR.getLocation().toString());
        NdRulesProjectInnovatorLoaderFactory ndRulesProjectInnovatorLoaderFactory2 = ndDeployRulesServiceConfig.getRulesServiceAgentFactoryFactory().getRulesProjectInnovatorLoaderFactory();
        if (ndRulesProjectInnovatorLoaderFactory2 != null) {
            ndRulesProjectInnovatorLoaderFactory.setMapAllPropertiesEnabled(ndRulesProjectInnovatorLoaderFactory2.isMapAllPropertiesEnabled());
        }
        if (this.SiPTghR instanceof NdFileRepositoryConnection) {
            object = (NdFileRepositoryConnection)this.SiPTghR;
            NdSerializedRulesProjectLoaderFactory ndSerializedRulesProjectLoaderFactory = ndDeployRulesServiceConfig.getRulesServiceAgentFactoryFactory().getSerializedRulesProjectLoaderFactory();
            if (ndSerializedRulesProjectLoaderFactory == null) {
                boolean bl;
                String string = object.getRepositoryFolder();
                boolean bl2 = new File(string).isAbsolute();
                String string2 = new File(this.getSystemDefinition().getTargetDirectory()).getAbsolutePath();
                boolean bl3 = bl = this.getDeploymentDefinition().getUsingAbsolutePath() != null && this.getDeploymentDefinition().getUsingAbsolutePath() != false;
                if (bl && !bl2) {
                    String string3 = NdServiceConfig.createAbsoluteFileName(string, string2);
                    object.setRepositoryFolder(string3);
                } else if (!bl && bl2) {
                    String string4 = NdServiceConfig.createRelativePath(string2, string);
                    if (string4 == null) {
                        throw new NdDeploymentGenerationException(0);
                    }
                    object.setRepositoryFolder(string4);
                }
            }
        }
        object = new NdInnovatorRepositoryAccessorFactory();
        ((NdInnovatorRepositoryAccessorFactory)object).setWorkspaceConnection((NdWorkspaceConnection)this.SiPTghR);
        ndRulesProjectInnovatorLoaderFactory.setInnovatorRepositoryAccessorFactory((NdInnovatorRepositoryAccessorFactory)object);
        ndDeployRulesServiceConfig.getRulesServiceAgentFactoryFactory().setRulesProjectLoaderFactory(ndRulesProjectInnovatorLoaderFactory);
    }

    private NdDeployServiceSessionConfig SiPGeIA() {
        NdDeployServiceSessionConfig ndDeployServiceSessionConfig = new NdDeployServiceSessionConfig();
        ndDeployServiceSessionConfig.setServiceExceptionEventsEnabler(new NdServiceExceptionEventsEnabler());
        if (this.SiPGeHZ.getServerTypeEnum() == NdDeploymentConstants.ServerType.STATEFUL) {
            ndDeployServiceSessionConfig.setServiceQuestionsEventsEnabler(new NdServiceQuestionsEventsEnabler());
        }
        return ndDeployServiceSessionConfig;
    }

    private void SiPGeIB(NdDeployRulesServiceConfig ndDeployRulesServiceConfig) {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            boolean bl = this.SiPGeHZ.getThreaded();
            if (bl) {
                string5 = "com.blazesoft.server.rules.NdScriptRulesServiceAgentFactory";
                string4 = "com.blazesoft.server.local.NdLocalServiceAgentDispenserResetterThread";
                string3 = "com.blazesoft.server.local.NdLocalServiceAgentDispenserReloaderThread";
                string2 = "com.blazesoft.server.local.NdServiceExceptionMulticaster";
                string = "com.blazesoft.server.local.NdServiceThreadGroupsExceptionMulticaster";
            } else {
                string5 = "com.blazesoft.server.rules.NdNonThreadedScriptRulesServiceAgentFactory";
                string4 = "com.blazesoft.server.local.NdLocalServiceAgentDispenserResetterBase";
                string3 = "com.blazesoft.server.local.NdLocalServiceAgentDispenserReloaderBase";
                string2 = "com.blazesoft.server.local.NdServiceNonThreadedExceptionMulticaster";
                string = "com.blazesoft.server.local.NdServiceNonThreadedThreadGroupsExceptionMulticaster";
            }
            ndDeployRulesServiceConfig.getServiceAgentFactoryFactory().setJavaName(string5);
            ndDeployRulesServiceConfig.setServiceAgentResetterFactory(new NdServiceAgentResetterFactory(string4));
            ndDeployRulesServiceConfig.setServiceAgentReloaderFactory(new NdServiceAgentReloaderFactory(string3));
            ndDeployRulesServiceConfig.setServiceRuntimeExceptionMulticasterFactory(new NdServiceRuntimeExceptionMulticasterFactory(string2));
            ndDeployRulesServiceConfig.setServiceThreadGroupsExceptionMulticasterFactory(new NdServiceThreadGroupsExceptionMulticasterFactory(string));
        }
        catch (NdDeploymentRuntimeException ndDeploymentRuntimeException) {
            // empty catch block
        }
    }

    private int SiPGeIC() {
        NdDeploymentConstants.RuleAgentPoolingPolicy ruleAgentPoolingPolicy = this.SiPGeHZ.getRuleAgentPoolingPolicyEnum();
        if (ruleAgentPoolingPolicy == NdDeploymentConstants.RuleAgentPoolingPolicy.CONTAINER_MANAGED) {
            return -2;
        }
        if (ruleAgentPoolingPolicy == NdDeploymentConstants.RuleAgentPoolingPolicy.DYNAMIC) {
            return -1;
        }
        return this.SiPGeHZ.getNumRuleAgents();
    }
}

