/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.local;

import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdManagedServiceManager;
import com.blazesoft.server.base.NdMonitoredServiceManager;
import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdServerThreadGroup;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceId;
import com.blazesoft.server.base.NdServiceManager;
import com.blazesoft.server.base.NdServiceManagerEvent;
import com.blazesoft.server.base.NdServiceManagerException;
import com.blazesoft.server.base.NdServiceManagerListener;
import com.blazesoft.server.base.NdServiceStatistics;
import com.blazesoft.server.config.NdServiceConfig;
import com.blazesoft.server.local.NdLocalService;
import com.blazesoft.server.local.NdLocalServiceManagerEventDispatcher;
import com.blazesoft.server.local.NdStrings;
import com.blazesoft.system.NdExceptionListener;
import com.blazesoft.system.NdRuntimeExceptionHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NdLocalServiceManager
implements NdServiceManager,
NdManagedServiceManager,
NdMonitoredServiceManager,
NdLocalServiceManagerEventDispatcher {
    private Hashtable SiPoVHI = new Hashtable();
    private Vector SiPoVHJ;
    private NdServerId SiPoVHK;
    private NdServerThreadGroup SiPoVHL;
    private NdRuntimeExceptionHandler SiPoVHM;
    private NdExceptionListener SiPoVHN;

    public NdLocalServiceManager(NdServerId ndServerId) {
        this.SiPoVHK = ndServerId;
        this.SiPoVHL = null;
    }

    protected void checkManageable(NdService ndService) throws NdServiceManagerException {
        if (!(ndService instanceof NdLocalService)) {
            throw new NdServiceManagerException(this.SiPoVHK, NdStrings.SiPpjFA("CouldNotManageService", ndService.getServiceId().getDescription()));
        }
    }

    protected NdService newService(NdServiceId ndServiceId, NdServiceConfig ndServiceConfig) {
        NdLocalService ndLocalService = null;
        if (ndServiceConfig.usesThreads()) {
            ndLocalService = new NdLocalService(ndServiceId, ndServiceConfig, this.getServerThreadGroup(), this.getServerExceptionListener(), this);
            ndLocalService.getServiceThreadGroup().setMaxPriority(ndServiceConfig.getServiceThreadGroupMaxPriority());
            ndLocalService.getServiceThreadGroup().getServiceMonitorThreadGroup().setMaxPriority(ndServiceConfig.getServiceMonitorThreadGroupMaxPriority());
        } else {
            ndLocalService = new NdLocalService(ndServiceId, ndServiceConfig, null, this.getServerExceptionListener(), this);
        }
        return ndLocalService;
    }

    public NdService createService(NdServiceConfig ndServiceConfig) {
        NdServiceId ndServiceId = new NdServiceId(this.SiPoVHK, ndServiceConfig.getName());
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 0, ndServiceId));
        NdService ndService = this.newService(ndServiceId, ndServiceConfig);
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 1, ndServiceId));
        this.SiPoVHO(ndServiceId, ndService);
        return ndService;
    }

    public void resetService(NdService ndService) throws NdServiceException, NdServiceManagerException {
        this.checkManageable(ndService);
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 4, ndService.getServiceId()));
        ((NdLocalService)ndService).resetService();
    }

    public void stopService(NdService ndService) throws NdServiceException, NdServiceManagerException {
        this.checkManageable(ndService);
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 2, ndService.getServiceId()));
        ((NdLocalService)ndService).stopService();
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 3, ndService.getServiceId()));
        this.SiPoVHP(ndService);
    }

    public void abortService(NdService ndService) throws NdServiceException, NdServiceManagerException {
        this.checkManageable(ndService);
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 6, ndService.getServiceId()));
        ((NdLocalService)ndService).abortService();
        this.SiPoVHT(new NdServiceManagerEvent(this.SiPoVHK, 7, ndService.getServiceId()));
        this.SiPoVHP(ndService);
    }

    public void stopAllServices() throws NdServiceException, NdServiceManagerException {
        Hashtable hashtable = (Hashtable)this.SiPoVHI.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            NdService ndService = (NdService)enumeration.nextElement();
            this.stopService(ndService);
        }
    }

    public void addNdExceptionListener(NdService ndService, NdExceptionListener ndExceptionListener) throws NdServiceManagerException {
        this.checkManageable(ndService);
        ((NdLocalService)ndService).addNdExceptionListener(ndExceptionListener);
    }

    public void removeNdExceptionListener(NdService ndService, NdExceptionListener ndExceptionListener) throws NdServiceManagerException {
        this.checkManageable(ndService);
        ((NdLocalService)ndService).removeNdExceptionListener(ndExceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPoVHO(NdServiceId ndServiceId, NdService ndService) {
        Hashtable hashtable = this.SiPoVHI;
        synchronized (hashtable) {
            this.SiPoVHI.put(ndServiceId, ndService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPoVHP(NdService ndService) {
        Hashtable hashtable = this.SiPoVHI;
        synchronized (hashtable) {
            this.SiPoVHI.remove(((NdLocalService)ndService).getServiceId());
        }
    }

    synchronized NdServiceStatistics[] SiPoVHQ() {
        Object[] objectArray;
        Vector<NdServiceStatistics> vector = new Vector<NdServiceStatistics>();
        Hashtable hashtable = (Hashtable)this.SiPoVHI.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!(objectArray instanceof NdManagedService)) continue;
            vector.addElement(((NdManagedService)objectArray).getStatistics());
        }
        objectArray = new NdServiceStatistics[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NdServerId getServerId() {
        return this.SiPoVHK;
    }

    public NdService getService(NdServiceId ndServiceId) {
        return (NdService)this.SiPoVHI.get(ndServiceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdServiceId[] getServiceIds() {
        NdServiceId[] ndServiceIdArray;
        Hashtable hashtable = this.SiPoVHI;
        synchronized (hashtable) {
            Enumeration enumeration = this.SiPoVHI.keys();
            int n = this.SiPoVHI.size();
            ndServiceIdArray = new NdServiceId[n];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                ndServiceIdArray[n2] = (NdServiceId)enumeration.nextElement();
                ++n2;
            }
        }
        return ndServiceIdArray;
    }

    public void releaseService(NdService ndService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNdServiceManagerListener(NdServiceManagerListener ndServiceManagerListener) {
        Object object;
        Vector vector = this.SiPoVHJ;
        if (vector == null) {
            object = this;
            synchronized (object) {
                if (vector == null) {
                    this.SiPoVHJ = new Vector();
                    vector = this.SiPoVHJ;
                }
            }
        }
        object = vector;
        synchronized (object) {
            vector.addElement(ndServiceManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNdServiceManagerListener(NdServiceManagerListener ndServiceManagerListener) {
        Vector vector = this.SiPoVHJ;
        if (vector == null) {
            return;
        }
        Vector vector2 = vector;
        synchronized (vector2) {
            vector.removeElement(ndServiceManagerListener);
        }
    }

    public NdServerThreadGroup getServerThreadGroup() {
        if (this.SiPoVHL == null) {
            this.SiPoVHL = new NdServerThreadGroup(this.SiPoVHK);
        }
        return this.SiPoVHL;
    }

    protected NdRuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.SiPoVHM;
    }

    void SiPoVHR(NdRuntimeExceptionHandler ndRuntimeExceptionHandler) {
        this.SiPoVHM = ndRuntimeExceptionHandler;
    }

    protected NdExceptionListener getServerExceptionListener() {
        return this.SiPoVHN;
    }

    void SiPoVHS(NdExceptionListener ndExceptionListener) {
        this.SiPoVHN = ndExceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SiPoVHT(NdServiceManagerEvent ndServiceManagerEvent) {
        Object[] objectArray;
        Vector vector = this.SiPoVHJ;
        if (vector == null) {
            return;
        }
        Vector vector2 = vector;
        synchronized (vector2) {
            objectArray = new NdServiceManagerListener[vector.size()];
            vector.copyInto(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].onServiceManagerEvent(ndServiceManagerEvent);
        }
    }

    public void onServiceManagerEvent(NdServiceManagerEvent ndServiceManagerEvent) {
        this.SiPoVHT(ndServiceManagerEvent);
    }
}

